"""Remove compute manager log

Revision ID: 75b80763e901
Revises: f31c7897345f
Create Date: 2024-05-06 10:08:30.711531

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "75b80763e901"
down_revision = "f31c7897345f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_compute_manager_log_manager_id", table_name="compute_manager_log")
    op.drop_table("compute_manager_log")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "compute_manager_log",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("manager_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("timestamp", postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=False),
        sa.Column("successes", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("claimed", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("failures", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("total_cpu_hours", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("active_tasks", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("active_cores", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("active_memory", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("rejected", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(
            ["manager_id"], ["compute_manager.id"], name="compute_manager_log_manager_id_fkey", ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id", name="compute_manager_log_pkey"),
    )
    op.create_index("ix_compute_manager_log_manager_id", "compute_manager_log", ["manager_id"], unique=False)
    # ### end Alembic commands ###
