# codepoint: codepage, hex
chars = {

    # IBM-437 Europe
    # (x00-x20 missing...)
    0x00A1: (0x00, 0xAD), # ¡
    0x00A2: (0x00, 0x9B), # ¢
    0x00A3: (0x00, 0x9C), # £
    0x00A5: (0x00, 0x9D), # ¥
    0x00AA: (0x00, 0xA6), # ª
    0x00AB: (0x00, 0xAE), # «
    0x00AC: (0x00, 0xAA), # ¬
    0x00B0: (0x00, 0xF8), # °
    0x00B1: (0x00, 0xF1), # ±
    0x00B2: (0x00, 0xFD), # ²
    0x00B7: (0x00, 0xFA), # ·
    0x00BA: (0x00, 0xA7), # º
    0x00BB: (0x00, 0xAF), # »
    0x00BC: (0x00, 0xAC), # ¼
    0x00BD: (0x00, 0xAB), # ½
    0x00BF: (0x00, 0xA8), # ¿
    0x00C4: (0x00, 0x8E), # Ä
    0x00C5: (0x00, 0x8F), # Å
    0x00C6: (0x00, 0x92), # Æ
    0x00C7: (0x00, 0x80), # Ç
    0x00C9: (0x00, 0x90), # É
    0x00D1: (0x00, 0xA5), # Ñ
    0x00D6: (0x00, 0x99), # Ö
    0x00DC: (0x00, 0x9A), # Ü
    0x00DF: (0x00, 0xE1), # ß
    0x00E0: (0x00, 0x85), # à
    0x00E1: (0x00, 0xA0), # á
    0x00E2: (0x00, 0x83), # â
    0x00E4: (0x00, 0x84), # ä
    0x00E5: (0x00, 0x86), # å
    0x00E6: (0x00, 0x91), # æ
    0x00E7: (0x00, 0x87), # ç
    0x00E8: (0x00, 0x8A), # è
    0x00E9: (0x00, 0x82), # é
    0x00EA: (0x00, 0x88), # ê
    0x00EB: (0x00, 0x89), # ë
    0x00EC: (0x00, 0x8D), # ì
    0x00ED: (0x00, 0xA1), # í
    0x00EE: (0x00, 0x8C), # î
    0x00EF: (0x00, 0x8B), # ï
    0x00F1: (0x00, 0xA4), # ñ
    0x00F2: (0x00, 0x95), # ò
    0x00F3: (0x00, 0xA2), # ó
    0x00F4: (0x00, 0x93), # ô
    0x00F6: (0x00, 0x94), # ö
    0x00F7: (0x00, 0xF6), # ÷
    0x00F9: (0x00, 0x97), # ù
    0x00FA: (0x00, 0xA3), # ú
    0x00FB: (0x00, 0x96), # û
    0x00FC: (0x00, 0x81), # ü
    0x00FF: (0x00, 0x98), # ÿ
    0x0192: (0x00, 0x9F), # ƒ
    0x0393: (0x00, 0xE2), # Γ
    0x0398: (0x00, 0xE9), # Θ
    0x03A3: (0x00, 0xE4), # Σ
    0x03A6: (0x00, 0xE8), # Φ
    0x03A9: (0x00, 0xEA), # Ω
    0x03B1: (0x00, 0xE0), # α
    0x03B4: (0x00, 0xEB), # δ
    0x03B5: (0x00, 0xEE), # ε
    0x03BC: (0x00, 0xE6), # μ
    0x03C0: (0x00, 0xE3), # π
    0x03C3: (0x00, 0xE5), # σ
    0x03C4: (0x00, 0xE7), # τ
    0x03C6: (0x00, 0xED), # φ
    0x207F: (0x00, 0xFC), # ⁿ
    0x20A7: (0x00, 0x9E), # ₧
    0x2219: (0x00, 0xF9), # ∙
    0x221A: (0x00, 0xFB), # √
    0x221E: (0x00, 0xEC), # ∞
    0x2229: (0x00, 0xEF), # ∩
    0x2248: (0x00, 0xF7), # ≈
    0x2261: (0x00, 0xF0), # ≡
    0x2264: (0x00, 0xF3), # ≤
    0x2265: (0x00, 0xF2), # ≥
    0x2310: (0x00, 0xA9), # ⌐
    0x2320: (0x00, 0xF4), # ⌠
    0x2321: (0x00, 0xF5), # ⌡
    0x2500: (0x00, 0xC4), # ─
    0xFFE8: (0x00, 0xB3), # ￨
    0x2502: (0x00, 0xB3), # │
    0x250C: (0x00, 0xDA), # ┌
    0x2510: (0x00, 0xBF), # ┐
    0x2514: (0x00, 0xC0), # └
    0x2518: (0x00, 0xD9), # ┘
    0x251C: (0x00, 0xC3), # ├
    0x2524: (0x00, 0xB4), # ┤
    0x252C: (0x00, 0xC2), # ┬
    0x2534: (0x00, 0xC1), # ┴
    0x253C: (0x00, 0xC5), # ┼
    0x2550: (0x00, 0xCD), # ═
    0x2551: (0x00, 0xBA), # ║
    0x2552: (0x00, 0xD5), # ╒
    0x2553: (0x00, 0xD6), # ╓
    0x2554: (0x00, 0xC9), # ╔
    0x2555: (0x00, 0xB8), # ╕
    0x2556: (0x00, 0xB7), # ╖
    0x2557: (0x00, 0xBB), # ╗
    0x2558: (0x00, 0xD4), # ╘
    0x2559: (0x00, 0xD3), # ╙
    0x255A: (0x00, 0xC8), # ╚
    0x255B: (0x00, 0xBE), # ╛
    0x255C: (0x00, 0xBD), # ╜
    0x255D: (0x00, 0xBC), # ╝
    0x255E: (0x00, 0xC6), # ╞
    0x255F: (0x00, 0xC7), # ╟
    0x2560: (0x00, 0xCC), # ╠
    0x2561: (0x00, 0xB5), # ╡
    0x2562: (0x00, 0xB6), # ╢
    0x2563: (0x00, 0xB9), # ╣
    0x2564: (0x00, 0xD1), # ╤
    0x2565: (0x00, 0xD2), # ╥
    0x2566: (0x00, 0xCB), # ╦
    0x2567: (0x00, 0xCF), # ╧
    0x2568: (0x00, 0xD0), # ╨
    0x2569: (0x00, 0xCA), # ╩
    0x256A: (0x00, 0xD8), # ╪
    0x256B: (0x00, 0xD7), # ╫
    0x256C: (0x00, 0xCE), # ╬
    0x2580: (0x00, 0xDF), # ▀
    0x2584: (0x00, 0xDC), # ▄
    0x2588: (0x00, 0xDB), # █
    0x258C: (0x00, 0xDD), # ▌
    0x2590: (0x00, 0xDE), # ▐
    0x2591: (0x00, 0xB0), # ░
    0x2592: (0x00, 0xB1), # ▒
    0x2593: (0x00, 0xB2), # ▓
    0xFFED: (0x00, 0xFE), # ￭
    0x25A0: (0x00, 0xFE), # ■

    # CP 01139
    # Katakana
    0x2581: (0x01, 0x80), # ▁
    0x2582: (0x01, 0x81), # ▂
    0x2583: (0x01, 0x82), # ▃
    0x2584: (0x01, 0x83), # ▄
    0x2585: (0x01, 0x84), # ▅
    0x2586: (0x01, 0x85), # ▆
    0x2587: (0x01, 0x86), # ▇
    0x2589: (0x01, 0x8E), # ▉
    0x258A: (0x01, 0x8D), # ▊
    0x258B: (0x01, 0x8C), # ▋
    0x258C: (0x01, 0x8B), # ▌
    0x258D: (0x01, 0x8A), # ▍
    0x258E: (0x01, 0x89), # ▎
    0x258F: (0x01, 0x88), # ▏
    0x2595: (0x01, 0x98), # ▕
    0x2594: (0x01, 0x94), # ▔
    0x256D: (0x01, 0x9C), # ╭
    0x256E: (0x01, 0x9D), # ╮
    0x2570: (0x01, 0x9E), # ╰
    0x256F: (0x01, 0x9F), # ╯
    0x2571: (0x01, 0xEE), # ╱
    0x2572: (0x01, 0xEF), # ╲
    0x25CF: (0x01, 0xEC), # ●
    0x25CB: (0x01, 0xED), # ○
    0x2660: (0x01, 0xE8), # ♠
    0x2665: (0x01, 0xE9), # ♥
    0x2666: (0x01, 0xEA), # ♦
    0x2663: (0x01, 0xEB), # ♣
    0x300C: (0x01, 0xA2), # 「
    0x300D: (0x01, 0xA3), # 」
    0x2573: (0x01, 0xF0), # ╳
    0x25E2: (0x01, 0xF4), # ◢
    0x25E3: (0x01, 0xF5), # ◣
    0x25E4: (0x01, 0xF6), # ◤
    0x25E5: (0x01, 0xF7), # ◥
    # FULL / half-widTH
    0xFF61: (0x01, 0xA1), # ｡
    0xFF62: (0x01, 0xA2), # ｢
    0xFF63: (0x01, 0xA3), # ｣
    0xFF64: (0x01, 0xA4), # ､
    0xFF65: (0x01, 0xA5), # ･
    0xFF66: (0x01, 0xA6), # ｦ
    0xFF67: (0x01, 0xA7), # ｧ
    0xFF68: (0x01, 0xA8), # ｨ
    0xFF69: (0x01, 0xA9), # ｩ
    0xFF6A: (0x01, 0xAA), # ｪ
    0xFF6B: (0x01, 0xAB), # ｫ
    0xFF6C: (0x01, 0xAC), # ｬ
    0xFF6D: (0x01, 0xAD), # ｭ
    0xFF6E: (0x01, 0xAE), # ｮ
    0xFF6F: (0x01, 0xAF), # ｯ
    0xFF70: (0x01, 0xB0), # ｰ
    0xFF71: (0x01, 0xB1), # ｱ
    0xFF72: (0x01, 0xB2), # ｲ
    0xFF73: (0x01, 0xB3), # ｳ
    0xFF74: (0x01, 0xB4), # ｴ
    0xFF75: (0x01, 0xB5), # ｵ
    0xFF76: (0x01, 0xB6), # ｶ
    0xFF77: (0x01, 0xB7), # ｷ
    0xFF78: (0x01, 0xB8), # ｸ
    0xFF79: (0x01, 0xB9), # ｹ
    0xFF7A: (0x01, 0xBA), # ｺ
    0xFF7B: (0x01, 0xBB), # ｻ
    0xFF7C: (0x01, 0xBC), # ｼ
    0xFF7D: (0x01, 0xBD), # ｽ
    0xFF7E: (0x01, 0xBE), # ｾ
    0xFF7F: (0x01, 0xBF), # ｿ
    0xFF80: (0x01, 0xC0), # ﾀ
    0xFF81: (0x01, 0xC1), # ﾁ
    0xFF82: (0x01, 0xC2), # ﾂ
    0xFF83: (0x01, 0xC3), # ﾃ
    0xFF84: (0x01, 0xC4), # ﾄ
    0xFF85: (0x01, 0xC5), # ﾅ
    0xFF86: (0x01, 0xC6), # ﾆ
    0xFF87: (0x01, 0xC7), # ﾇ
    0xFF88: (0x01, 0xC8), # ﾈ
    0xFF89: (0x01, 0xC9), # ﾉ
    0xFF8A: (0x01, 0xCA), # ﾊ
    0xFF8B: (0x01, 0xCB), # ﾋ
    0xFF8C: (0x01, 0xCC), # ﾌ
    0xFF8D: (0x01, 0xCD), # ﾍ
    0xFF8E: (0x01, 0xCE), # ﾎ
    0xFF8F: (0x01, 0xCF), # ﾏ
    0xFF90: (0x01, 0xD0), # ﾐ
    0xFF91: (0x01, 0xD1), # ﾑ
    0xFF92: (0x01, 0xD2), # ﾒ
    0xFF93: (0x01, 0xD3), # ﾓ
    0xFF94: (0x01, 0xD4), # ﾔ
    0xFF95: (0x01, 0xD5), # ﾕ
    0xFF96: (0x01, 0xD6), # ﾖ
    0xFF97: (0x01, 0xD7), # ﾗ
    0xFF98: (0x01, 0xD8), # ﾘ
    0xFF99: (0x01, 0xD9), # ﾙ
    0xFF9A: (0x01, 0xDA), # ﾚ
    0xFF9B: (0x01, 0xDB), # ﾛ
    0xFF9C: (0x01, 0xDC), # ﾜ
    0xFF9D: (0x01, 0xDD), # ﾝ
    0xFF9E: (0x01, 0xDE), # ﾞ
    0xFF9F: (0x01, 0xDF), # ﾟ

    0xFF62: (0x01, 0xA2), #｢
    0xFF63: (0x01, 0xA3), #｣
    0xFFE0: (0x5F, 0x96), #￠
    0xFFE1: (0x5F, 0x9C), #￡
    0xFFE2: (0x5F, 0xAA), #￢
    0xFFE4: (0x5F, 0xA7), #￤
    0xFFE5: (0x5E, 0xA5), #￥
    0xFFE8: (0x5F, 0xB3), #￨
    0xFFE9: (0x60, 0x8C), #￩
    0xFFEA: (0x60, 0x8D), #￪
    0xFFEB: (0x60, 0x8E), #￫
    0xFFEC: (0x60, 0x8F), #￬
    0xFFED: (0x5F, 0xFE), #￭
    0xFFEE: (0x01, 0xED), #￮

    # regular
    0x3002: (0x01, 0xA1), # 。
    0x300C: (0x01, 0xA2), # 「
    0x300D: (0x01, 0xA3), # 」
    0x3001: (0x01, 0xA4), # 、
    0x30FB: (0x01, 0xA5), # ・
    0x30F2: (0x01, 0xA6), # ヲ
    0x30A1: (0x01, 0xA7), # ァ
    0x30A3: (0x01, 0xA8), # ィ
    0x30A5: (0x01, 0xA9), # ゥ
    0x30A7: (0x01, 0xAA), # ェ
    0x30A9: (0x01, 0xAB), # ォ
    0x30E3: (0x01, 0xAC), # ャ
    0x30E5: (0x01, 0xAD), # ュ
    0x30E7: (0x01, 0xAE), # ョ
    0x30C3: (0x01, 0xAF), # ッ
    0x30FC: (0x01, 0xB0), # ー
    0x30A2: (0x01, 0xB1), # ア
    0x30A4: (0x01, 0xB2), # イ
    0x30A6: (0x01, 0xB3), # ウ
    0x30A8: (0x01, 0xB4), # エ
    0x30AA: (0x01, 0xB5), # オ
    0x30E6: (0x01, 0xD5), # ユ
    0x30E8: (0x01, 0xD6), # ヨ
    0x30E9: (0x01, 0xD7), # ラ
    0x30EA: (0x01, 0xD8), # リ
    0x30EB: (0x01, 0xD9), # ル
    0x30EC: (0x01, 0xDA), # レ
    0x30ED: (0x01, 0xDB), # ロ
    0x30EF: (0x01, 0xDC), # ワ
    0x30F3: (0x01, 0xDD), # ン
    0x3099: (0x01, 0xDE), #゙ 
    0x309A: (0x01, 0xDF), #゚ 
    0x30AB: (0x01, 0xB6), # カ
    0x30AD: (0x01, 0xB7), # キ
    0x30AF: (0x01, 0xB8), # ク
    0x30B1: (0x01, 0xB9), # ケ
    0x30B3: (0x01, 0xBA), # コ
    0x30B5: (0x01, 0xBB), # サ
    0x30B7: (0x01, 0xBC), # シ
    0x30B9: (0x01, 0xBD), # ス
    0x30BB: (0x01, 0xBE), # セ
    0x30BD: (0x01, 0xBF), # ソ
    0x30BF: (0x01, 0xC0), # タ
    0x30C1: (0x01, 0xC1), # チ
    0x30C4: (0x01, 0xC2), # ツ
    0x30C6: (0x01, 0xC3), # テ
    0x30C8: (0x01, 0xC4), # ト
    0x30CA: (0x01, 0xC5), # ナ
    0x30CB: (0x01, 0xC6), # ニ
    0x30CC: (0x01, 0xC7), # ヌ
    0x30CD: (0x01, 0xC8), # ネ
    0x30CE: (0x01, 0xC9), # ノ
    0x30CF: (0x01, 0xCA), # ハ
    0x30D2: (0x01, 0xCB), # ヒ
    0x30D5: (0x01, 0xCC), # フ
    0x30D8: (0x01, 0xCD), # ヘ
    0x30DB: (0x01, 0xCE), # ホ
    0x30DE: (0x01, 0xCF), # マ
    0x30DF: (0x01, 0xD0), # ミ
    0x30E0: (0x01, 0xD1), # ム
    0x30E1: (0x01, 0xD2), # メ
    0x30E2: (0x01, 0xD3), # モ
    0x30E4: (0x01, 0xD4), # ヤ
    0x2502: (0x5F, 0xB3), # │
    0x25A0: (0x5F, 0xFE), # ■

    # IBM-850 Europe
    0x00A1: (0x02, 0xAD), # ¡
    0x00A2: (0x02, 0xBD), # ¢
    0x00A3: (0x02, 0x9C), # £
    0x00A4: (0x02, 0xCF), # ¤
    0x00A5: (0x02, 0xBE), # ¥
    0x00A6: (0x02, 0xDD), # ¦
    0x00A8: (0x02, 0xF9), # ¨
    0x00A9: (0x02, 0xB8), # ©
    0x00AA: (0x02, 0xA6), # ª
    0x00AB: (0x02, 0xAE), # «
    0x00AC: (0x02, 0xAA), # ¬
    0x00AD: (0x02, 0xF0), # ­
    0x00AE: (0x02, 0xA9), # ®
    0x203E: (0x02, 0xEE), # ‾
    0x00AF: (0x02, 0xEE), # ¯
    0x00B0: (0x02, 0xF8), # °
    0x00B1: (0x02, 0xF1), # ±
    0x00B2: (0x02, 0xFD), # ²
    0x00B3: (0x02, 0xFC), # ³
    0x00B4: (0x02, 0xEF), # ´
    0x00B5: (0x02, 0xE6), # µ
    0x00B7: (0x02, 0xFA), # ·
    0x00B8: (0x02, 0xF7), # ¸
    0x00B9: (0x02, 0xFB), # ¹
    0x00BA: (0x02, 0xA7), # º
    0x00BB: (0x02, 0xAF), # »
    0x00BC: (0x02, 0xAC), # ¼
    0x00BD: (0x02, 0xAB), # ½
    0x00BE: (0x02, 0xF3), # ¾
    0x00BF: (0x02, 0xA8), # ¿
    0x00C0: (0x02, 0xB7), # À
    0x00C1: (0x02, 0xB5), # Á
    0x00C2: (0x02, 0xB6), # Â
    0x00C3: (0x02, 0xC7), # Ã
    0x00C4: (0x02, 0x8E), # Ä
    0x00C5: (0x02, 0x8F), # Å
    0x00C6: (0x02, 0x92), # Æ
    0x00C7: (0x02, 0x80), # Ç
    0x00C8: (0x02, 0xD4), # È
    0x00C9: (0x02, 0x90), # É
    0x00CA: (0x02, 0xD2), # Ê
    0x00CB: (0x02, 0xD3), # Ë
    0x00CC: (0x02, 0xDE), # Ì
    0x00CD: (0x02, 0xD6), # Í
    0x00CE: (0x02, 0xD7), # Î
    0x00CF: (0x02, 0xD8), # Ï
    0x0110: (0x02, 0xD1), # Đ
    0x00D0: (0x02, 0xD1), # Ð
    0x00D1: (0x02, 0xA5), # Ñ
    0x00D2: (0x02, 0xE3), # Ò
    0x00D3: (0x02, 0xE0), # Ó
    0x00D4: (0x02, 0xE2), # Ô
    0x00D5: (0x02, 0xE5), # Õ
    0x00D6: (0x02, 0x99), # Ö
    0x00D7: (0x02, 0x9E), # ×
    0x00D8: (0x02, 0x9D), # Ø
    0x00D9: (0x02, 0xEB), # Ù
    0x00DA: (0x02, 0xE9), # Ú
    0x00DB: (0x02, 0xEA), # Û
    0x00DC: (0x02, 0x9A), # Ü
    0x00DD: (0x02, 0xED), # Ý
    0x00DE: (0x02, 0xE8), # Þ
    0x00DF: (0x02, 0xE1), # ß
    0x00E0: (0x02, 0x85), # à
    0x00E1: (0x02, 0xA0), # á
    0x00E2: (0x02, 0x83), # â
    0x00E3: (0x02, 0xC6), # ã
    0x00E4: (0x02, 0x84), # ä
    0x00E5: (0x02, 0x86), # å
    0x00E6: (0x02, 0x91), # æ
    0x00E7: (0x02, 0x87), # ç
    0x00E8: (0x02, 0x8A), # è
    0x00E9: (0x02, 0x82), # é
    0x00EA: (0x02, 0x88), # ê
    0x00EB: (0x02, 0x89), # ë
    0x00EC: (0x02, 0x8D), # ì
    0x00ED: (0x02, 0xA1), # í
    0x00EE: (0x02, 0x8C), # î
    0x00EF: (0x02, 0x8B), # ï
    0x00F0: (0x02, 0xD0), # ð
    0x00F1: (0x02, 0xA4), # ñ
    0x00F2: (0x02, 0x95), # ò
    0x00F3: (0x02, 0xA2), # ó
    0x00F4: (0x02, 0x93), # ô
    0x00F5: (0x02, 0xE4), # õ
    0x00F6: (0x02, 0x94), # ö
    0x00F7: (0x02, 0xF6), # ÷
    0x00F8: (0x02, 0x9B), # ø
    0x00F9: (0x02, 0x97), # ù
    0x00FA: (0x02, 0xA3), # ú
    0x00FB: (0x02, 0x96), # û
    0x00FC: (0x02, 0x81), # ü
    0x00FD: (0x02, 0xEC), # ý
    0x00FE: (0x02, 0xE7), # þ
    0x00FF: (0x02, 0x98), # ÿ
    0x0131: (0x02, 0xD5), # ı
    0x0192: (0x02, 0x9F), # ƒ
    0x2017: (0x02, 0xF2), # ‗
    0x2500: (0x02, 0xC4), # ─
    0xFFE8: (0x02, 0xB3), # ￨
    0x2502: (0x02, 0xB3), # │
    0x250C: (0x02, 0xDA), # ┌
    0x2510: (0x02, 0xBF), # ┐
    0x2514: (0x02, 0xC0), # └
    0x2518: (0x02, 0xD9), # ┘
    0x251C: (0x02, 0xC3), # ├
    0x2524: (0x02, 0xB4), # ┤
    0x252C: (0x02, 0xC2), # ┬
    0x2534: (0x02, 0xC1), # ┴
    0x253C: (0x02, 0xC5), # ┼
    0x2550: (0x02, 0xCD), # ═
    0x2551: (0x02, 0xBA), # ║
    0x2554: (0x02, 0xC9), # ╔
    0x2557: (0x02, 0xBB), # ╗
    0x255A: (0x02, 0xC8), # ╚
    0x255D: (0x02, 0xBC), # ╝
    0x2560: (0x02, 0xCC), # ╠
    0x2563: (0x02, 0xB9), # ╣
    0x2566: (0x02, 0xCB), # ╦
    0x2569: (0x02, 0xCA), # ╩
    0x256C: (0x02, 0xCE), # ╬
    0x2580: (0x02, 0xDF), # ▀
    0x2584: (0x02, 0xDC), # ▄
    0x2588: (0x02, 0xDB), # █
    0x2591: (0x02, 0xB0), # ░
    0x2592: (0x02, 0xB1), # ▒
    0x2593: (0x02, 0xB2), # ▓
    0xFFED: (0x02, 0xFE), # ￭
    0x25A0: (0x02, 0xFE), # ■
    0x00A1: (0x03, 0xAD), # ¡
    0x00A2: (0x03, 0x9B), # ¢
    0x00A3: (0x03, 0x9C), # £
    0x00AA: (0x03, 0xA6), # ª
    0x00AB: (0x03, 0xAE), # «
    0x00AC: (0x03, 0xAA), # ¬
    0x00B0: (0x03, 0xF8), # °
    0x00B1: (0x03, 0xF1), # ±
    0x00B2: (0x03, 0xFD), # ²
    0x00B7: (0x03, 0xFA), # ·
    0x00BA: (0x03, 0xA7), # º
    0x00BB: (0x03, 0xAF), # »
    0x00BC: (0x03, 0xAC), # ¼
    0x00BD: (0x03, 0xAB), # ½
    0x00BF: (0x03, 0xA8), # ¿
    0x00C0: (0x03, 0x91), # À
    0x00C1: (0x03, 0x86), # Á
    0x00C2: (0x03, 0x8F), # Â
    0x00C3: (0x03, 0x8E), # Ã
    0x00C7: (0x03, 0x80), # Ç
    0x00C8: (0x03, 0x92), # È
    0x00C9: (0x03, 0x90), # É
    0x00CA: (0x03, 0x89), # Ê
    0x00CC: (0x03, 0x98), # Ì
    0x00CD: (0x03, 0x8B), # Í
    0x00D1: (0x03, 0xA5), # Ñ
    0x00D2: (0x03, 0xA9), # Ò
    0x00D3: (0x03, 0x9F), # Ó
    0x00D4: (0x03, 0x8C), # Ô
    0x00D5: (0x03, 0x99), # Õ
    0x00D9: (0x03, 0x9D), # Ù
    0x00DA: (0x03, 0x96), # Ú
    0x00DC: (0x03, 0x9A), # Ü
    0x00DF: (0x03, 0xE1), # ß
    0x00E0: (0x03, 0x85), # à
    0x00E1: (0x03, 0xA0), # á
    0x00E2: (0x03, 0x83), # â
    0x00E3: (0x03, 0x84), # ã
    0x00E7: (0x03, 0x87), # ç
    0x00E8: (0x03, 0x8A), # è
    0x00E9: (0x03, 0x82), # é
    0x00EA: (0x03, 0x88), # ê
    0x00EC: (0x03, 0x8D), # ì
    0x00ED: (0x03, 0xA1), # í
    0x00F1: (0x03, 0xA4), # ñ
    0x00F2: (0x03, 0x95), # ò
    0x00F3: (0x03, 0xA2), # ó
    0x00F4: (0x03, 0x93), # ô
    0x00F5: (0x03, 0x94), # õ
    0x00F7: (0x03, 0xF6), # ÷
    0x00F9: (0x03, 0x97), # ù
    0x00FA: (0x03, 0xA3), # ú
    0x00FC: (0x03, 0x81), # ü
    0x0393: (0x03, 0xE2), # Γ
    0x0398: (0x03, 0xE9), # Θ
    0x03A3: (0x03, 0xE4), # Σ
    0x03A6: (0x03, 0xE8), # Φ
    0x03A9: (0x03, 0xEA), # Ω
    0x03B1: (0x03, 0xE0), # α
    0x03B4: (0x03, 0xEB), # δ
    0x03B5: (0x03, 0xEE), # ε
    0x03BC: (0x03, 0xE6), # μ
    0x03C0: (0x03, 0xE3), # π
    0x03C3: (0x03, 0xE5), # σ
    0x03C4: (0x03, 0xE7), # τ
    0x03C6: (0x03, 0xED), # φ
    0x207F: (0x03, 0xFC), # ⁿ
    0x20A7: (0x03, 0x9E), # ₧
    0x2219: (0x03, 0xF9), # ∙
    0x221A: (0x03, 0xFB), # √
    0x221E: (0x03, 0xEC), # ∞
    0x2229: (0x03, 0xEF), # ∩
    0x2248: (0x03, 0xF7), # ≈
    0x2261: (0x03, 0xF0), # ≡
    0x2264: (0x03, 0xF3), # ≤
    0x2265: (0x03, 0xF2), # ≥
    0x2320: (0x03, 0xF4), # ⌠
    0x2321: (0x03, 0xF5), # ⌡
    0x2500: (0x03, 0xC4), # ─
    0xFFE8: (0x03, 0xB3), # ￨
    0x2502: (0x03, 0xB3), # │
    0x250C: (0x03, 0xDA), # ┌
    0x2510: (0x03, 0xBF), # ┐
    0x2514: (0x03, 0xC0), # └
    0x2518: (0x03, 0xD9), # ┘
    0x251C: (0x03, 0xC3), # ├
    0x2524: (0x03, 0xB4), # ┤
    0x252C: (0x03, 0xC2), # ┬
    0x2534: (0x03, 0xC1), # ┴
    0x253C: (0x03, 0xC5), # ┼
    0x2550: (0x03, 0xCD), # ═
    0x2551: (0x03, 0xBA), # ║
    0x2552: (0x03, 0xD5), # ╒
    0x2553: (0x03, 0xD6), # ╓
    0x2554: (0x03, 0xC9), # ╔
    0x2555: (0x03, 0xB8), # ╕
    0x2556: (0x03, 0xB7), # ╖
    0x2557: (0x03, 0xBB), # ╗
    0x2558: (0x03, 0xD4), # ╘
    0x2559: (0x03, 0xD3), # ╙
    0x255A: (0x03, 0xC8), # ╚
    0x255B: (0x03, 0xBE), # ╛
    0x255C: (0x03, 0xBD), # ╜
    0x255D: (0x03, 0xBC), # ╝
    0x255E: (0x03, 0xC6), # ╞
    0x255F: (0x03, 0xC7), # ╟
    0x2560: (0x03, 0xCC), # ╠
    0x2561: (0x03, 0xB5), # ╡
    0x2562: (0x03, 0xB6), # ╢
    0x2563: (0x03, 0xB9), # ╣
    0x2564: (0x03, 0xD1), # ╤
    0x2565: (0x03, 0xD2), # ╥
    0x2566: (0x03, 0xCB), # ╦
    0x2567: (0x03, 0xCF), # ╧
    0x2568: (0x03, 0xD0), # ╨
    0x2569: (0x03, 0xCA), # ╩
    0x256A: (0x03, 0xD8), # ╪
    0x256B: (0x03, 0xD7), # ╫
    0x256C: (0x03, 0xCE), # ╬
    0x2580: (0x03, 0xDF), # ▀
    0x2584: (0x03, 0xDC), # ▄
    0x2588: (0x03, 0xDB), # █
    0x258C: (0x03, 0xDD), # ▌
    0x2590: (0x03, 0xDE), # ▐
    0x2591: (0x03, 0xB0), # ░
    0x2592: (0x03, 0xB1), # ▒
    0x2593: (0x03, 0xB2), # ▓
    0xFFED: (0x03, 0xFE), # ￭
    0x25A0: (0x03, 0xFE), # ■

    # “western europe”, apparently. doesn’t seem to correspond to anything
    0x2160: (0x06, 0x49), # I (not really Ⅰ but kinda)
    0x2161: (0x06, 0x82), # Ⅱ
    0x2162: (0x06, 0x83), # Ⅲ
    0x2163: (0x06, 0x84), # Ⅳ
    0x2164: (0x06, 0x95), # Ⅴ
    0x2165: (0x06, 0x96), # Ⅵ
    0x212F: (0x06, 0x9C), # ℯ

    # Windows-1252 Europe
    0x20AC: (0x10, 0x80), # €
    0x201A: (0x10, 0x82), # ‚
    0x0192: (0x10, 0x83), # ƒ
    0x201E: (0x10, 0x84), # „
    0x2026: (0x10, 0x85), # …
    0x2020: (0x10, 0x86), # †
    0x2021: (0x10, 0x87), # ‡
    0x02C6: (0x10, 0x88), # ˆ
    0x2030: (0x10, 0x89), # ‰
    0x0160: (0x10, 0x8A), # Š
    0x2039: (0x10, 0x8B), # ‹
    0x0152: (0x10, 0x8C), # Œ
    0x017D: (0x10, 0x8E), # Ž
    0x2018: (0x10, 0x91), # ‘
    0x2019: (0x10, 0x92), # ’
    0x201C: (0x10, 0x93), # “
    0x201D: (0x10, 0x94), # ”
    0x2022: (0x10, 0x95), # •
    0x2013: (0x10, 0x96), # –
    0x2014: (0x10, 0x97), # —
    0x02DC: (0x10, 0x98), # ˜
    0x2122: (0x10, 0x99), # ™
    0x0161: (0x10, 0x9A), # š
    0x203A: (0x10, 0x9B), # ›
    0x0153: (0x10, 0x9C), # œ
    0x017E: (0x10, 0x9E), # ž
    0x0178: (0x10, 0x9F), # Ÿ
    0x00A0: (0x10, 0xA0), #  
    0x00A1: (0x10, 0xA1), # ¡
    0x00A2: (0x10, 0xA2), # ¢
    0x00A3: (0x10, 0xA3), # £
    0x00A4: (0x10, 0xA4), # ¤
    0x00A5: (0x10, 0xA5), # ¥
    0x00A6: (0x10, 0xA6), # ¦
    0x00A7: (0x10, 0xA7), # §
    0x00A8: (0x10, 0xA8), # ¨
    0x00A9: (0x10, 0xA9), # ©
    0x00AA: (0x10, 0xAA), # ª
    0x00AB: (0x10, 0xAB), # «
    0x00AC: (0x10, 0xAC), # ¬
    0x00AD: (0x10, 0xAD), # ­
    0x00AE: (0x10, 0xAE), # ®
    0x00AF: (0x10, 0xAF), # ¯
    0x00B0: (0x10, 0xB0), # °
    0x00B1: (0x10, 0xB1), # ±
    0x00B2: (0x10, 0xB2), # ²
    0x00B3: (0x10, 0xB3), # ³
    0x00B4: (0x10, 0xB4), # ´
    0x00B5: (0x10, 0xB5), # µ
    0x00B6: (0x10, 0xB6), # ¶
    0x00B7: (0x10, 0xB7), # ·
    0x00B8: (0x10, 0xB8), # ¸
    0x00B9: (0x10, 0xB9), # ¹
    0x00BA: (0x10, 0xBA), # º
    0x00BB: (0x10, 0xBB), # »
    0x00BC: (0x10, 0xBC), # ¼
    0x00BD: (0x10, 0xBD), # ½
    0x00BE: (0x10, 0xBE), # ¾
    0x00BF: (0x10, 0xBF), # ¿
    0x00C0: (0x10, 0xC0), # À
    0x00C1: (0x10, 0xC1), # Á
    0x00C2: (0x10, 0xC2), # Â
    0x00C3: (0x10, 0xC3), # Ã
    0x00C4: (0x10, 0xC4), # Ä
    0x00C5: (0x10, 0xC5), # Å
    0x00C6: (0x10, 0xC6), # Æ
    0x00C7: (0x10, 0xC7), # Ç
    0x00C8: (0x10, 0xC8), # È
    0x00C9: (0x10, 0xC9), # É
    0x00CA: (0x10, 0xCA), # Ê
    0x00CB: (0x10, 0xCB), # Ë
    0x00CC: (0x10, 0xCC), # Ì
    0x00CD: (0x10, 0xCD), # Í
    0x00CE: (0x10, 0xCE), # Î
    0x00CF: (0x10, 0xCF), # Ï
    0x00D0: (0x10, 0xD0), # Ð
    0x00D1: (0x10, 0xD1), # Ñ
    0x00D2: (0x10, 0xD2), # Ò
    0x00D3: (0x10, 0xD3), # Ó
    0x00D4: (0x10, 0xD4), # Ô
    0x00D5: (0x10, 0xD5), # Õ
    0x00D6: (0x10, 0xD6), # Ö
    0x00D7: (0x10, 0xD7), # ×
    0x00D8: (0x10, 0xD8), # Ø
    0x00D9: (0x10, 0xD9), # Ù
    0x00DA: (0x10, 0xDA), # Ú
    0x00DB: (0x10, 0xDB), # Û
    0x00DC: (0x10, 0xDC), # Ü
    0x00DD: (0x10, 0xDD), # Ý
    0x00DE: (0x10, 0xDE), # Þ
    0x00DF: (0x10, 0xDF), # ß
    0x00E0: (0x10, 0xE0), # à
    0x00E1: (0x10, 0xE1), # á
    0x00E2: (0x10, 0xE2), # â
    0x00E3: (0x10, 0xE3), # ã
    0x00E4: (0x10, 0xE4), # ä
    0x00E5: (0x10, 0xE5), # å
    0x00E6: (0x10, 0xE6), # æ
    0x00E7: (0x10, 0xE7), # ç
    0x00E8: (0x10, 0xE8), # è
    0x00E9: (0x10, 0xE9), # é
    0x00EA: (0x10, 0xEA), # ê
    0x00EB: (0x10, 0xEB), # ë
    0x00EC: (0x10, 0xEC), # ì
    0x00ED: (0x10, 0xED), # í
    0x00EE: (0x10, 0xEE), # î
    0x00EF: (0x10, 0xEF), # ï
    0x00F0: (0x10, 0xF0), # ð
    0x00F1: (0x10, 0xF1), # ñ
    0x00F2: (0x10, 0xF2), # ò
    0x00F3: (0x10, 0xF3), # ó
    0x00F4: (0x10, 0xF4), # ô
    0x00F5: (0x10, 0xF5), # õ
    0x00F6: (0x10, 0xF6), # ö
    0x00F7: (0x10, 0xF7), # ÷
    0x00F8: (0x10, 0xF8), # ø
    0x00F9: (0x10, 0xF9), # ù
    0x00FA: (0x10, 0xFA), # ú
    0x00FB: (0x10, 0xFB), # û
    0x00FC: (0x10, 0xFC), # ü
    0x00FD: (0x10, 0xFD), # ý
    0x00FE: (0x10, 0xFE), # þ
    0x00FF: (0x10, 0xFF), # ÿ

    # IBM-866 Cyrillic
    0x00A4: (0x11, 0xFD), # ¤
    0x00B0: (0x11, 0xF8), # °
    0x00B7: (0x11, 0xFA), # ·
    0x0401: (0x11, 0xF0), # Ё
    0x0404: (0x11, 0xF2), # Є
    0x0407: (0x11, 0xF4), # Ї
    0x040E: (0x11, 0xF6), # Ў
    0x0410: (0x11, 0x80), # А
    0x0411: (0x11, 0x81), # Б
    0x0412: (0x11, 0x82), # В
    0x0413: (0x11, 0x83), # Г
    0x0414: (0x11, 0x84), # Д
    0x0415: (0x11, 0x85), # Е
    0x0416: (0x11, 0x86), # Ж
    0x0417: (0x11, 0x87), # З
    0x0418: (0x11, 0x88), # И
    0x0419: (0x11, 0x89), # Й
    0x041A: (0x11, 0x8A), # К
    0x041B: (0x11, 0x8B), # Л
    0x041C: (0x11, 0x8C), # М
    0x041D: (0x11, 0x8D), # Н
    0x041E: (0x11, 0x8E), # О
    0x041F: (0x11, 0x8F), # П
    0x0420: (0x11, 0x90), # Р
    0x0421: (0x11, 0x91), # С
    0x0422: (0x11, 0x92), # Т
    0x0423: (0x11, 0x93), # У
    0x0424: (0x11, 0x94), # Ф
    0x0425: (0x11, 0x95), # Х
    0x0426: (0x11, 0x96), # Ц
    0x0427: (0x11, 0x97), # Ч
    0x0428: (0x11, 0x98), # Ш
    0x0429: (0x11, 0x99), # Щ
    0x042A: (0x11, 0x9A), # Ъ
    0x042B: (0x11, 0x9B), # Ы
    0x042C: (0x11, 0x9C), # Ь
    0x042D: (0x11, 0x9D), # Э
    0x042E: (0x11, 0x9E), # Ю
    0x042F: (0x11, 0x9F), # Я
    0x0430: (0x11, 0xA0), # а
    0x0431: (0x11, 0xA1), # б
    0x0432: (0x11, 0xA2), # в
    0x0433: (0x11, 0xA3), # г
    0x0434: (0x11, 0xA4), # д
    0x0435: (0x11, 0xA5), # е
    0x0436: (0x11, 0xA6), # ж
    0x0437: (0x11, 0xA7), # з
    0x0438: (0x11, 0xA8), # и
    0x0439: (0x11, 0xA9), # й
    0x043A: (0x11, 0xAA), # к
    0x043B: (0x11, 0xAB), # л
    0x043C: (0x11, 0xAC), # м
    0x043D: (0x11, 0xAD), # н
    0x043E: (0x11, 0xAE), # о
    0x043F: (0x11, 0xAF), # п
    0x0440: (0x11, 0xE0), # р
    0x0441: (0x11, 0xE1), # с
    0x0442: (0x11, 0xE2), # т
    0x0443: (0x11, 0xE3), # у
    0x0444: (0x11, 0xE4), # ф
    0x0445: (0x11, 0xE5), # х
    0x0446: (0x11, 0xE6), # ц
    0x0447: (0x11, 0xE7), # ч
    0x0448: (0x11, 0xE8), # ш
    0x0449: (0x11, 0xE9), # щ
    0x044A: (0x11, 0xEA), # ъ
    0x044B: (0x11, 0xEB), # ы
    0x044C: (0x11, 0xEC), # ь
    0x044D: (0x11, 0xED), # э
    0x044E: (0x11, 0xEE), # ю
    0x044F: (0x11, 0xEF), # я
    0x0451: (0x11, 0xF1), # ё
    0x0454: (0x11, 0xF3), # є
    0x0457: (0x11, 0xF5), # ї
    0x045E: (0x11, 0xF7), # ў
    0x2116: (0x11, 0xFC), # №
    0x2219: (0x11, 0xF9), # ∙
    0x221A: (0x11, 0xFB), # √
    0x2500: (0x11, 0xC4), # ─
    0xFFE8: (0x11, 0xB3), # ￨
    0x2502: (0x11, 0xB3), # │
    0x250C: (0x11, 0xDA), # ┌
    0x2510: (0x11, 0xBF), # ┐
    0x2514: (0x11, 0xC0), # └
    0x2518: (0x11, 0xD9), # ┘
    0x251C: (0x11, 0xC3), # ├
    0x2524: (0x11, 0xB4), # ┤
    0x252C: (0x11, 0xC2), # ┬
    0x2534: (0x11, 0xC1), # ┴
    0x253C: (0x11, 0xC5), # ┼
    0x2550: (0x11, 0xCD), # ═
    0x2551: (0x11, 0xBA), # ║
    0x2552: (0x11, 0xD5), # ╒
    0x2553: (0x11, 0xD6), # ╓
    0x2554: (0x11, 0xC9), # ╔
    0x2555: (0x11, 0xB8), # ╕
    0x2556: (0x11, 0xB7), # ╖
    0x2557: (0x11, 0xBB), # ╗
    0x2558: (0x11, 0xD4), # ╘
    0x2559: (0x11, 0xD3), # ╙
    0x255A: (0x11, 0xC8), # ╚
    0x255B: (0x11, 0xBE), # ╛
    0x255C: (0x11, 0xBD), # ╜
    0x255D: (0x11, 0xBC), # ╝
    0x255E: (0x11, 0xC6), # ╞
    0x255F: (0x11, 0xC7), # ╟
    0x2560: (0x11, 0xCC), # ╠
    0x2561: (0x11, 0xB5), # ╡
    0x2562: (0x11, 0xB6), # ╢
    0x2563: (0x11, 0xB9), # ╣
    0x2564: (0x11, 0xD1), # ╤
    0x2565: (0x11, 0xD2), # ╥
    0x2566: (0x11, 0xCB), # ╦
    0x2567: (0x11, 0xCF), # ╧
    0x2568: (0x11, 0xD0), # ╨
    0x2569: (0x11, 0xCA), # ╩
    0x256A: (0x11, 0xD8), # ╪
    0x256B: (0x11, 0xD7), # ╫
    0x256C: (0x11, 0xCE), # ╬
    0x2580: (0x11, 0xDF), # ▀
    0x2584: (0x11, 0xDC), # ▄
    0x2588: (0x11, 0xDB), # █
    0x258C: (0x11, 0xDD), # ▌
    0x2590: (0x11, 0xDE), # ▐
    0x2591: (0x11, 0xB0), # ░
    0x2592: (0x11, 0xB1), # ▒
    0x2593: (0x11, 0xB2), # ▓
    0xFFED: (0x11, 0xFE), # ￭
    0x25A0: (0x11, 0xFE), # ■

    # IBM-852 Latin 2
    0x00A4: (0x12, 0xCF), # ¤
    0x00A8: (0x12, 0xF9), # ¨
    0x00AB: (0x12, 0xAE), # «
    0x00AD: (0x12, 0xF0), # ­
    0x00B0: (0x12, 0xF8), # °
    0x00B4: (0x12, 0xEF), # ´
    0x00B8: (0x12, 0xF7), # ¸
    0x00BB: (0x12, 0xAF), # »
    0x00C1: (0x12, 0xB5), # Á
    0x00C2: (0x12, 0xB6), # Â
    0x00C4: (0x12, 0x8E), # Ä
    0x00C7: (0x12, 0x80), # Ç
    0x00C9: (0x12, 0x90), # É
    0x00CB: (0x12, 0xD3), # Ë
    0x00CD: (0x12, 0xD6), # Í
    0x00CE: (0x12, 0xD7), # Î
    0x00D0: (0x12, 0xD1), # Ð
    0x0110: (0x12, 0xD1), # Đ
    0x00D3: (0x12, 0xE0), # Ó
    0x00D4: (0x12, 0xE2), # Ô
    0x00D6: (0x12, 0x99), # Ö
    0x00D7: (0x12, 0x9E), # ×
    0x00DA: (0x12, 0xE9), # Ú
    0x00DC: (0x12, 0x9A), # Ü
    0x00DD: (0x12, 0xED), # Ý
    0x00DF: (0x12, 0xE1), # ß
    0x00E1: (0x12, 0xA0), # á
    0x00E2: (0x12, 0x83), # â
    0x00E4: (0x12, 0x84), # ä
    0x00E7: (0x12, 0x87), # ç
    0x00E9: (0x12, 0x82), # é
    0x00EB: (0x12, 0x89), # ë
    0x00ED: (0x12, 0xA1), # í
    0x00EE: (0x12, 0x8C), # î
    0x00F3: (0x12, 0xA2), # ó
    0x00F4: (0x12, 0x93), # ô
    0x00F6: (0x12, 0x94), # ö
    0x00F7: (0x12, 0xF6), # ÷
    0x00FA: (0x12, 0xA3), # ú
    0x00FC: (0x12, 0x81), # ü
    0x00FD: (0x12, 0xEC), # ý
    0x0102: (0x12, 0xC6), # Ă
    0x0103: (0x12, 0xC7), # ă
    0x0104: (0x12, 0xA4), # Ą
    0x0105: (0x12, 0xA5), # ą
    0x0106: (0x12, 0x8F), # Ć
    0x0107: (0x12, 0x86), # ć
    0x010C: (0x12, 0xAC), # Č
    0x010D: (0x12, 0x9F), # č
    0x010E: (0x12, 0xD2), # Ď
    0x010F: (0x12, 0xD4), # ď
    0x0111: (0x12, 0xD0), # đ
    0x0118: (0x12, 0xA8), # Ę
    0x0119: (0x12, 0xA9), # ę
    0x011A: (0x12, 0xB7), # Ě
    0x011B: (0x12, 0xD8), # ě
    0x0139: (0x12, 0x91), # Ĺ
    0x013A: (0x12, 0x92), # ĺ
    0x013D: (0x12, 0x95), # Ľ
    0x013E: (0x12, 0x96), # ľ
    0x0141: (0x12, 0x9D), # Ł
    0x0142: (0x12, 0x88), # ł
    0x0143: (0x12, 0xE3), # Ń
    0x0144: (0x12, 0xE4), # ń
    0x0147: (0x12, 0xD5), # Ň
    0x0148: (0x12, 0xE5), # ň
    0x0150: (0x12, 0x8A), # Ő
    0x0151: (0x12, 0x8B), # ő
    0x0154: (0x12, 0xE8), # Ŕ
    0x0155: (0x12, 0xEA), # ŕ
    0x0158: (0x12, 0xFC), # Ř
    0x0159: (0x12, 0xFD), # ř
    0x015A: (0x12, 0x97), # Ś
    0x015B: (0x12, 0x98), # ś
    0x015E: (0x12, 0xB8), # Ş
    0x015F: (0x12, 0xAD), # ş
    0x0160: (0x12, 0xE6), # Š
    0x0161: (0x12, 0xE7), # š
    0x0162: (0x12, 0xDD), # Ţ
    0x0163: (0x12, 0xEE), # ţ
    0x0164: (0x12, 0x9B), # Ť
    0x0165: (0x12, 0x9C), # ť
    0x016E: (0x12, 0xDE), # Ů
    0x016F: (0x12, 0x85), # ů
    0x0170: (0x12, 0xEB), # Ű
    0x0171: (0x12, 0xFB), # ű
    0x0179: (0x12, 0x8D), # Ź
    0x017A: (0x12, 0xAB), # ź
    0x017B: (0x12, 0xBD), # Ż
    0x017C: (0x12, 0xBE), # ż
    0x017D: (0x12, 0xA6), # Ž
    0x017E: (0x12, 0xA7), # ž
    0x02C7: (0x12, 0xF3), # ˇ
    0x02D8: (0x12, 0xF4), # ˘
    0x02D9: (0x12, 0xFA), # ˙
    0x02DB: (0x12, 0xF2), # ˛
    0x02DD: (0x12, 0xF1), # ˝
    0x2500: (0x12, 0xC4), # ─
    0xFFE8: (0x12, 0xB3), # ￨
    0x2502: (0x12, 0xB3), # │
    0x250C: (0x12, 0xDA), # ┌
    0x2510: (0x12, 0xBF), # ┐
    0x2514: (0x12, 0xC0), # └
    0x2518: (0x12, 0xD9), # ┘
    0x251C: (0x12, 0xC3), # ├
    0x2524: (0x12, 0xB4), # ┤
    0x252C: (0x12, 0xC2), # ┬
    0x2534: (0x12, 0xC1), # ┴
    0x253C: (0x12, 0xC5), # ┼
    0x2550: (0x12, 0xCD), # ═
    0x2551: (0x12, 0xBA), # ║
    0x2554: (0x12, 0xC9), # ╔
    0x2557: (0x12, 0xBB), # ╗
    0x255A: (0x12, 0xC8), # ╚
    0x255D: (0x12, 0xBC), # ╝
    0x2560: (0x12, 0xCC), # ╠
    0x2563: (0x12, 0xB9), # ╣
    0x2566: (0x12, 0xCB), # ╦
    0x2569: (0x12, 0xCA), # ╩
    0x256C: (0x12, 0xCE), # ╬
    0x2580: (0x12, 0xDF), # ▀
    0x2584: (0x12, 0xDC), # ▄
    0x2588: (0x12, 0xDB), # █
    0x2591: (0x12, 0xB0), # ░
    0x2592: (0x12, 0xB1), # ▒
    0x2593: (0x12, 0xB2), # ▓
    0xFFED: (0x12, 0xFE), # ￭
    0x25A0: (0x12, 0xFE), # ■

    # IBM-858 Europe
    0x00A1: (0x13, 0xAD), # ¡
    0x00A2: (0x13, 0xBD), # ¢
    0x00A3: (0x13, 0x9C), # £
    0x00A4: (0x13, 0xCF), # ¤
    0x00A5: (0x13, 0xBE), # ¥
    0x00A6: (0x13, 0xDD), # ¦
    0x00A8: (0x13, 0xF9), # ¨
    0x00A9: (0x13, 0xB8), # ©
    0x00AA: (0x13, 0xA6), # ª
    0x00AB: (0x13, 0xAE), # «
    0x00AC: (0x13, 0xAA), # ¬
    0x00AD: (0x13, 0xF0), # ­
    0x00AE: (0x13, 0xA9), # ®
    0x203E: (0x13, 0xEE), # ‾
    0x00AF: (0x13, 0xEE), # ¯
    0x00B0: (0x13, 0xF8), # °
    0x00B1: (0x13, 0xF1), # ±
    0x00B2: (0x13, 0xFD), # ²
    0x00B3: (0x13, 0xFC), # ³
    0x00B4: (0x13, 0xEF), # ´
    0x00B5: (0x13, 0xE6), # µ
    0x00B7: (0x13, 0xFA), # ·
    0x00B8: (0x13, 0xF7), # ¸
    0x00B9: (0x13, 0xFB), # ¹
    0x00BA: (0x13, 0xA7), # º
    0x00BB: (0x13, 0xAF), # »
    0x00BC: (0x13, 0xAC), # ¼
    0x00BD: (0x13, 0xAB), # ½
    0x00BE: (0x13, 0xF3), # ¾
    0x00BF: (0x13, 0xA8), # ¿
    0x00C0: (0x13, 0xB7), # À
    0x00C1: (0x13, 0xB5), # Á
    0x00C2: (0x13, 0xB6), # Â
    0x00C3: (0x13, 0xC7), # Ã
    0x00C4: (0x13, 0x8E), # Ä
    0x00C5: (0x13, 0x8F), # Å
    0x00C6: (0x13, 0x92), # Æ
    0x00C7: (0x13, 0x80), # Ç
    0x00C8: (0x13, 0xD4), # È
    0x00C9: (0x13, 0x90), # É
    0x00CA: (0x13, 0xD2), # Ê
    0x00CB: (0x13, 0xD3), # Ë
    0x00CC: (0x13, 0xDE), # Ì
    0x00CD: (0x13, 0xD6), # Í
    0x00CE: (0x13, 0xD7), # Î
    0x00CF: (0x13, 0xD8), # Ï
    0x00D0: (0x13, 0xD1), # Ð
    0x00D1: (0x13, 0xA5), # Ñ
    0x00D2: (0x13, 0xE3), # Ò
    0x00D3: (0x13, 0xE0), # Ó
    0x00D4: (0x13, 0xE2), # Ô
    0x00D5: (0x13, 0xE5), # Õ
    0x00D6: (0x13, 0x99), # Ö
    0x00D7: (0x13, 0x9E), # ×
    0x00D8: (0x13, 0x9D), # Ø
    0x00D9: (0x13, 0xEB), # Ù
    0x00DA: (0x13, 0xE9), # Ú
    0x00DB: (0x13, 0xEA), # Û
    0x00DC: (0x13, 0x9A), # Ü
    0x00DD: (0x13, 0xED), # Ý
    0x00DE: (0x13, 0xE8), # Þ
    0x00DF: (0x13, 0xE1), # ß
    0x00E0: (0x13, 0x85), # à
    0x00E1: (0x13, 0xA0), # á
    0x00E2: (0x13, 0x83), # â
    0x00E3: (0x13, 0xC6), # ã
    0x00E4: (0x13, 0x84), # ä
    0x00E5: (0x13, 0x86), # å
    0x00E6: (0x13, 0x91), # æ
    0x00E7: (0x13, 0x87), # ç
    0x00E8: (0x13, 0x8A), # è
    0x00E9: (0x13, 0x82), # é
    0x00EA: (0x13, 0x88), # ê
    0x00EB: (0x13, 0x89), # ë
    0x00EC: (0x13, 0x8D), # ì
    0x00ED: (0x13, 0xA1), # í
    0x00EE: (0x13, 0x8C), # î
    0x00EF: (0x13, 0x8B), # ï
    0x00F0: (0x13, 0xD0), # ð
    0x00F1: (0x13, 0xA4), # ñ
    0x00F2: (0x13, 0x95), # ò
    0x00F3: (0x13, 0xA2), # ó
    0x00F4: (0x13, 0x93), # ô
    0x00F5: (0x13, 0xE4), # õ
    0x00F6: (0x13, 0x94), # ö
    0x00F7: (0x13, 0xF6), # ÷
    0x00F8: (0x13, 0x9B), # ø
    0x00F9: (0x13, 0x97), # ù
    0x00FA: (0x13, 0xA3), # ú
    0x00FB: (0x13, 0x96), # û
    0x00FC: (0x13, 0x81), # ü
    0x00FD: (0x13, 0xEC), # ý
    0x00FE: (0x13, 0xE7), # þ
    0x00FF: (0x13, 0x98), # ÿ
    0x0192: (0x13, 0x9F), # ƒ
    0x2017: (0x13, 0xF2), # ‗
    0x20AC: (0x13, 0xD5), # €
    0x2500: (0x13, 0xC4), # ─
    0xFFE8: (0x13, 0xB3), # ￨
    0x2502: (0x13, 0xB3), # │
    0x250C: (0x13, 0xDA), # ┌
    0x2510: (0x13, 0xBF), # ┐
    0x2514: (0x13, 0xC0), # └
    0x2518: (0x13, 0xD9), # ┘
    0x251C: (0x13, 0xC3), # ├
    0x2524: (0x13, 0xB4), # ┤
    0x252C: (0x13, 0xC2), # ┬
    0x2534: (0x13, 0xC1), # ┴
    0x253C: (0x13, 0xC5), # ┼
    0x2550: (0x13, 0xCD), # ═
    0x2551: (0x13, 0xBA), # ║
    0x2554: (0x13, 0xC9), # ╔
    0x2557: (0x13, 0xBB), # ╗
    0x255A: (0x13, 0xC8), # ╚
    0x255D: (0x13, 0xBC), # ╝
    0x2560: (0x13, 0xCC), # ╠
    0x2563: (0x13, 0xB9), # ╣
    0x2566: (0x13, 0xCB), # ╦
    0x2569: (0x13, 0xCA), # ╩
    0x256C: (0x13, 0xCE), # ╬
    0x2580: (0x13, 0xDF), # ▀
    0x2584: (0x13, 0xDC), # ▄
    0x2588: (0x13, 0xDB), # █
    0x2591: (0x13, 0xB0), # ░
    0x2592: (0x13, 0xB1), # ▒
    0x2593: (0x13, 0xB2), # ▓
    0xFFED: (0x13, 0xFE), # ￭
    0x25A0: (0x13, 0xFE), # ■

    # IBM-865 Nordic
    0x00A1: (0x05, 0xAD), # ¡
    0x00A3: (0x05, 0x9C), # £
    0x00A4: (0x05, 0xAF), # ¤
    0x00AA: (0x05, 0xA6), # ª
    0x00AB: (0x05, 0xAE), # «
    0x00AC: (0x05, 0xAA), # ¬
    0x00B0: (0x05, 0xF8), # °
    0x00B1: (0x05, 0xF1), # ±
    0x00B2: (0x05, 0xFD), # ²
    0x00B7: (0x05, 0xFA), # ·
    0x00BA: (0x05, 0xA7), # º
    0x00BC: (0x05, 0xAC), # ¼
    0x00BD: (0x05, 0xAB), # ½
    0x00BF: (0x05, 0xA8), # ¿
    0x00C4: (0x05, 0x8E), # Ä
    0x00C5: (0x05, 0x8F), # Å
    0x00C6: (0x05, 0x92), # Æ
    0x00C7: (0x05, 0x80), # Ç
    0x00C9: (0x05, 0x90), # É
    0x00D1: (0x05, 0xA5), # Ñ
    0x00D6: (0x05, 0x99), # Ö
    0x00D8: (0x05, 0x9D), # Ø
    0x00DC: (0x05, 0x9A), # Ü
    0x00DF: (0x05, 0xE1), # ß
    0x00E0: (0x05, 0x85), # à
    0x00E1: (0x05, 0xA0), # á
    0x00E2: (0x05, 0x83), # â
    0x00E4: (0x05, 0x84), # ä
    0x00E5: (0x05, 0x86), # å
    0x00E6: (0x05, 0x91), # æ
    0x00E7: (0x05, 0x87), # ç
    0x00E8: (0x05, 0x8A), # è
    0x00E9: (0x05, 0x82), # é
    0x00EA: (0x05, 0x88), # ê
    0x00EB: (0x05, 0x89), # ë
    0x00EC: (0x05, 0x8D), # ì
    0x00ED: (0x05, 0xA1), # í
    0x00EE: (0x05, 0x8C), # î
    0x00EF: (0x05, 0x8B), # ï
    0x00F1: (0x05, 0xA4), # ñ
    0x00F2: (0x05, 0x95), # ò
    0x00F3: (0x05, 0xA2), # ó
    0x00F4: (0x05, 0x93), # ô
    0x00F6: (0x05, 0x94), # ö
    0x00F7: (0x05, 0xF6), # ÷
    0x00F8: (0x05, 0x9B), # ø
    0x00F9: (0x05, 0x97), # ù
    0x00FA: (0x05, 0xA3), # ú
    0x00FB: (0x05, 0x96), # û
    0x00FC: (0x05, 0x81), # ü
    0x00FF: (0x05, 0x98), # ÿ
    0x0192: (0x05, 0x9F), # ƒ
    0x0393: (0x05, 0xE2), # Γ
    0x0398: (0x05, 0xE9), # Θ
    0x03A3: (0x05, 0xE4), # Σ
    0x03A6: (0x05, 0xE8), # Φ
    0x03A9: (0x05, 0xEA), # Ω
    0x03B1: (0x05, 0xE0), # α
    0x03B4: (0x05, 0xEB), # δ
    0x03B5: (0x05, 0xEE), # ε
    0x03BC: (0x05, 0xE6), # μ
    0x03C0: (0x05, 0xE3), # π
    0x03C3: (0x05, 0xE5), # σ
    0x03C4: (0x05, 0xE7), # τ
    0x03C6: (0x05, 0xED), # φ
    0x207F: (0x05, 0xFC), # ⁿ
    0x20A7: (0x05, 0x9E), # ₧
    0x2219: (0x05, 0xF9), # ∙
    0x221A: (0x05, 0xFB), # √
    0x221E: (0x05, 0xEC), # ∞
    0x2229: (0x05, 0xEF), # ∩
    0x2248: (0x05, 0xF7), # ≈
    0x2261: (0x05, 0xF0), # ≡
    0x2264: (0x05, 0xF3), # ≤
    0x2265: (0x05, 0xF2), # ≥
    0x2310: (0x05, 0xA9), # ⌐
    0x2320: (0x05, 0xF4), # ⌠
    0x2321: (0x05, 0xF5), # ⌡
    0x2500: (0x05, 0xC4), # ─
    0xFFE8: (0x05, 0xB3), # ￨
    0x2502: (0x05, 0xB3), # │
    0x250C: (0x05, 0xDA), # ┌
    0x2510: (0x05, 0xBF), # ┐
    0x2514: (0x05, 0xC0), # └
    0x2518: (0x05, 0xD9), # ┘
    0x251C: (0x05, 0xC3), # ├
    0x2524: (0x05, 0xB4), # ┤
    0x252C: (0x05, 0xC2), # ┬
    0x2534: (0x05, 0xC1), # ┴
    0x253C: (0x05, 0xC5), # ┼
    0x2550: (0x05, 0xCD), # ═
    0x2551: (0x05, 0xBA), # ║
    0x2552: (0x05, 0xD5), # ╒
    0x2553: (0x05, 0xD6), # ╓
    0x2554: (0x05, 0xC9), # ╔
    0x2555: (0x05, 0xB8), # ╕
    0x2556: (0x05, 0xB7), # ╖
    0x2557: (0x05, 0xBB), # ╗
    0x2558: (0x05, 0xD4), # ╘
    0x2559: (0x05, 0xD3), # ╙
    0x255A: (0x05, 0xC8), # ╚
    0x255B: (0x05, 0xBE), # ╛
    0x255C: (0x05, 0xBD), # ╜
    0x255D: (0x05, 0xBC), # ╝
    0x255E: (0x05, 0xC6), # ╞
    0x255F: (0x05, 0xC7), # ╟
    0x2560: (0x05, 0xCC), # ╠
    0x2561: (0x05, 0xB5), # ╡
    0x2562: (0x05, 0xB6), # ╢
    0x2563: (0x05, 0xB9), # ╣
    0x2564: (0x05, 0xD1), # ╤
    0x2565: (0x05, 0xD2), # ╥
    0x2566: (0x05, 0xCB), # ╦
    0x2567: (0x05, 0xCF), # ╧
    0x2568: (0x05, 0xD0), # ╨
    0x2569: (0x05, 0xCA), # ╩
    0x256A: (0x05, 0xD8), # ╪
    0x256B: (0x05, 0xD7), # ╫
    0x256C: (0x05, 0xCE), # ╬
    0x2580: (0x05, 0xDF), # ▀
    0x2584: (0x05, 0xDC), # ▄
    0x2588: (0x05, 0xDB), # █
    0x258C: (0x05, 0xDD), # ▌
    0x2590: (0x05, 0xDE), # ▐
    0x2591: (0x05, 0xB0), # ░
    0x2592: (0x05, 0xB1), # ▒
    0x2593: (0x05, 0xB2), # ▓
    0xFFED: (0x05, 0xFE), # ￭
    0x25A0: (0x05, 0xFE), # ■

    # IBM-864 Arabic
    0x00A2: (0x1C, 0xC0), # ¢
    0x00A3: (0x1C, 0xA3), # £
    0x00A4: (0x1C, 0xA4), # ¤
    0x00A6: (0x1C, 0xDB), # ¦
    0x00AB: (0x1C, 0x97), # «
    0x00AC: (0x1C, 0xDC), # ¬
    0x00AD: (0x1C, 0xA1), # ­
    0x00B0: (0x1C, 0x80), # °
    0x00B1: (0x1C, 0x93), # ±
    0x00B7: (0x1C, 0x81), # ·
    0x00BB: (0x1C, 0x98), # »
    0x00BC: (0x1C, 0x95), # ¼
    0x00BD: (0x1C, 0x94), # ½
    0x00D7: (0x1C, 0xDE), # ×
    0x00F7: (0x1C, 0xDD), # ÷
    0x03B2: (0x1C, 0x90), # β
    0x03C6: (0x1C, 0x92), # φ
    0x060C: (0x1C, 0xAC), # ،
    0x061B: (0x1C, 0xBB), # ؛
    0x061F: (0x1C, 0xBF), # ؟
    0x0621: (0x1C, 0xC1), # ء
    0xFE80: (0x1C, 0xC1), # ﺀ
    0x0622: (0x1C, 0xC2), # آ
    0xFE81: (0x1C, 0xC2), # ﺁ
    0x0623: (0x1C, 0xC3), # أ
    0xFE83: (0x1C, 0xC3), # ﺃ
    0x0624: (0x1C, 0xC4), # ؤ
    0xFE86: (0x1C, 0xC4), # ﺆ
    0xFE85: (0x1C, 0xC4), # ﺅ
    0x0625: (0x1C, 0xC7), # إ
    0xFE87: (0x1C, 0xC7), # ﺇ
    0x0627: (0x1C, 0xC7), # ا
    0xFE8D: (0x1C, 0xC7), # ﺍ
    0x0626: (0x1C, 0xC6), # ئ
    0xFE8C: (0x1C, 0xC6), # ﺌ
    0xFE8A: (0x1C, 0xC6), # ﺊ
    0xFE89: (0x1C, 0xC6), # ﺉ
    0xFE8B: (0x1C, 0xC6), # ﺋ
    0x0628: (0x1C, 0xC8), # ب
    0xFE92: (0x1C, 0xC8), # ﺒ
    0xFE91: (0x1C, 0xC8), # ﺑ
    0x0629: (0x1C, 0xC9), # ة
    0xFE94: (0x1C, 0xC9), # ﺔ
    0xFE93: (0x1C, 0xC9), # ﺓ
    0x062A: (0x1C, 0xCA), # ت
    0xFE98: (0x1C, 0xCA), # ﺘ
    0xFE97: (0x1C, 0xCA), # ﺗ
    0x062B: (0x1C, 0xCB), # ث
    0xFE9C: (0x1C, 0xCB), # ﺜ
    0xFE9B: (0x1C, 0xCB), # ﺛ
    0x062C: (0x1C, 0xCC), # ج
    0xFEA0: (0x1C, 0xCC), # ﺠ
    0xFE9F: (0x1C, 0xCC), # ﺟ
    0x062D: (0x1C, 0xCD), # ح
    0xFEA4: (0x1C, 0xCD), # ﺤ
    0xFEA3: (0x1C, 0xCD), # ﺣ
    0x062E: (0x1C, 0xCE), # خ
    0xFEA8: (0x1C, 0xCE), # ﺨ
    0xFEA7: (0x1C, 0xCE), # ﺧ
    0x062F: (0x1C, 0xCF), # د
    0xFEAA: (0x1C, 0xCF), # ﺪ
    0xFEA9: (0x1C, 0xCF), # ﺩ
    0x0630: (0x1C, 0xD0), # ذ
    0xFEAC: (0x1C, 0xD0), # ﺬ
    0xFEAB: (0x1C, 0xD0), # ﺫ
    0x0631: (0x1C, 0xD1), # ر
    0xFEAE: (0x1C, 0xD1), # ﺮ
    0xFEAD: (0x1C, 0xD1), # ﺭ
    0x0632: (0x1C, 0xD2), # ز
    0xFEB0: (0x1C, 0xD2), # ﺰ
    0xFEAF: (0x1C, 0xD2), # ﺯ
    0x0633: (0x1C, 0xD3), # س
    0xFEB4: (0x1C, 0xD3), # ﺴ
    0xFEB3: (0x1C, 0xD3), # ﺳ
    0x0634: (0x1C, 0xD4), # ش
    0xFEB8: (0x1C, 0xD4), # ﺸ
    0xFEB7: (0x1C, 0xD4), # ﺷ
    0x0635: (0x1C, 0xD5), # ص
    0xFEBC: (0x1C, 0xD5), # ﺼ
    0xFEBB: (0x1C, 0xD5), # ﺻ
    0x0636: (0x1C, 0xD6), # ض
    0xFEC0: (0x1C, 0xD6), # ﻀ
    0xFEBF: (0x1C, 0xD6), # ﺿ
    0x0637: (0x1C, 0xD7), # ط
    0xFEC4: (0x1C, 0xD7), # ﻄ
    0xFEC2: (0x1C, 0xD7), # ﻂ
    0xFEC1: (0x1C, 0xD7), # ﻁ
    0xFEC3: (0x1C, 0xD7), # ﻃ
    0x0638: (0x1C, 0xD8), # ظ
    0xFEC8: (0x1C, 0xD8), # ﻈ
    0xFEC6: (0x1C, 0xD8), # ﻆ
    0xFEC5: (0x1C, 0xD8), # ﻅ
    0xFEC7: (0x1C, 0xD8), # ﻇ
    0x0639: (0x1C, 0xD9), # ع
    0xFECB: (0x1C, 0xD9), # ﻋ
    0x063A: (0x1C, 0xDA), # غ
    0xFECF: (0x1C, 0xDA), # ﻏ
    0x0640: (0x1C, 0xE0), # ـ
    0x0641: (0x1C, 0xE1), # ف
    0xFED4: (0x1C, 0xE1), # ﻔ
    0xFED3: (0x1C, 0xE1), # ﻓ
    0x0642: (0x1C, 0xE2), # ق
    0xFED8: (0x1C, 0xE2), # ﻘ
    0xFED7: (0x1C, 0xE2), # ﻗ
    0x0643: (0x1C, 0xE3), # ك
    0xFEDC: (0x1C, 0xE3), # ﻜ
    0xFEDB: (0x1C, 0xE3), # ﻛ
    0x0644: (0x1C, 0xE4), # ل
    0xFEE0: (0x1C, 0xE4), # ﻠ
    0xFEDF: (0x1C, 0xE4), # ﻟ
    0x0645: (0x1C, 0xE5), # م
    0xFEE4: (0x1C, 0xE5), # ﻤ
    0xFEE3: (0x1C, 0xE5), # ﻣ
    0x0646: (0x1C, 0xE6), # ن
    0xFEE8: (0x1C, 0xE6), # ﻨ
    0xFEE7: (0x1C, 0xE6), # ﻧ
    0x0647: (0x1C, 0xE7), # ه
    0xFEEB: (0x1C, 0xE7), # ﻫ
    0x0648: (0x1C, 0xE8), # و
    0xFEEE: (0x1C, 0xE8), # ﻮ
    0xFEED: (0x1C, 0xE8), # ﻭ
    0x0649: (0x1C, 0xE9), # ى
    0xFEEF: (0x1C, 0xE9), # ﻯ
    0x064A: (0x1C, 0xFD), # ي
    0xFEF1: (0x1C, 0xFD), # ﻱ
    0x0651: (0x1C, 0xF1), #
    0xFE7C: (0x1C, 0xF1), # ﹼ
    0x0660: (0x1C, 0xB0), # ٠
    0x0661: (0x1C, 0xB1), # ١
    0x0662: (0x1C, 0xB2), # ٢
    0x0663: (0x1C, 0xB3), # ٣
    0x0664: (0x1C, 0xB4), # ٤
    0x0665: (0x1C, 0xB5), # ٥
    0x0666: (0x1C, 0xB6), # ٦
    0x0667: (0x1C, 0xB7), # ٧
    0x0668: (0x1C, 0xB8), # ٨
    0x0669: (0x1C, 0xB9), # ٩
    0x200B: (0x1C, 0x9F), # ​
    0x2219: (0x1C, 0x82), # ∙
    0x221A: (0x1C, 0x83), # √
    0x221E: (0x1C, 0x91), # ∞
    0x2248: (0x1C, 0x96), # ≈
    0x2500: (0x1C, 0x85), # ─
    0xFFE8: (0x1C, 0x86), # ￨
    0x2502: (0x1C, 0x86), # │
    0x250C: (0x1C, 0x8D), # ┌
    0x2510: (0x1C, 0x8C), # ┐
    0x2514: (0x1C, 0x8E), # └
    0x2518: (0x1C, 0x8F), # ┘
    0x251C: (0x1C, 0x8A), # ├
    0x2524: (0x1C, 0x88), # ┤
    0x252C: (0x1C, 0x89), # ┬
    0x2534: (0x1C, 0x8B), # ┴
    0x253C: (0x1C, 0x87), # ┼
    0x2592: (0x1C, 0x84), # ▒
    0xFFED: (0x1C, 0xFE), # ￭
    0x25A0: (0x1C, 0xFE), # ■
    0xFE7D: (0x1C, 0xF0), # ﹽ
    0xFE82: (0x1C, 0xA2), # ﺂ
    0xFE84: (0x1C, 0xA5), # ﺄ
    0xFE88: (0x1C, 0xA8), # ﺈ
    0xFE8E: (0x1C, 0xA8), # ﺎ
    0xFE90: (0x1C, 0xA9), # ﺐ
    0xFE8F: (0x1C, 0xA9), # ﺏ
    0xFE96: (0x1C, 0xAA), # ﺖ
    0xFE95: (0x1C, 0xAA), # ﺕ
    0xFE9A: (0x1C, 0xAB), # ﺚ
    0xFE99: (0x1C, 0xAB), # ﺙ
    0xFE9E: (0x1C, 0xAD), # ﺞ
    0xFE9D: (0x1C, 0xAD), # ﺝ
    0xFEA2: (0x1C, 0xAE), # ﺢ
    0xFEA1: (0x1C, 0xAE), # ﺡ
    0xFEA6: (0x1C, 0xAF), # ﺦ
    0xFEA5: (0x1C, 0xAF), # ﺥ
    0xFEB2: (0x1C, 0xBC), # ﺲ
    0xFEB1: (0x1C, 0xBC), # ﺱ
    0xFEB6: (0x1C, 0xBD), # ﺶ
    0xFEB5: (0x1C, 0xBD), # ﺵ
    0xFEBA: (0x1C, 0xBE), # ﺺ
    0xFEB9: (0x1C, 0xBE), # ﺹ
    0xFEBE: (0x1C, 0xEB), # ﺾ
    0xFEBD: (0x1C, 0xEB), # ﺽ
    0xFEC9: (0x1C, 0xDF), # ﻉ
    0xFECA: (0x1C, 0xC5), # ﻊ
    0xFECC: (0x1C, 0xEC), # ﻌ
    0xFECD: (0x1C, 0xEE), # ﻍ
    0xFECE: (0x1C, 0xED), # ﻎ
    0xFED0: (0x1C, 0xF7), # ﻐ
    0xFED2: (0x1C, 0xBA), # ﻒ
    0xFED1: (0x1C, 0xBA), # ﻑ
    0xFED6: (0x1C, 0xF8), # ﻖ
    0xFED5: (0x1C, 0xF8), # ﻕ
    0xFEDA: (0x1C, 0xFC), # ﻚ
    0xFED9: (0x1C, 0xFC), # ﻙ
    0xFEDE: (0x1C, 0xFB), # ﻞ
    0xFEDD: (0x1C, 0xFB), # ﻝ
    0xFEE2: (0x1C, 0xEF), # ﻢ
    0xFEE1: (0x1C, 0xEF), # ﻡ
    0xFEE6: (0x1C, 0xF2), # ﻦ
    0xFEE5: (0x1C, 0xF2), # ﻥ
    0xFEEA: (0x1C, 0xF3), # ﻪ
    0xFEE9: (0x1C, 0xF3), # ﻩ
    0xFEEC: (0x1C, 0xF4), # ﻬ
    0xFEF0: (0x1C, 0xF5), # ﻰ
    0xFEF2: (0x1C, 0xF6), # ﻲ
    0xFEF4: (0x1C, 0xEA), # ﻴ
    0xFEF3: (0x1C, 0xEA), # ﻳ
    0xFEF5: (0x1C, 0xF9), # ﻵ
    0xFEF6: (0x1C, 0xFA), # ﻶ
    0xFEF7: (0x1C, 0x99), # ﻷ
    0xFEF8: (0x1C, 0x9A), # ﻸ
    0xFEF9: (0x1C, 0x9D), # ﻹ
    0xFEFB: (0x1C, 0x9D), # ﻻ
    0xFEFA: (0x1C, 0x9E), # ﻺ
    0xFEFC: (0x1C, 0x9E), # ﻼ

    # Windows-1257 Estonian, Latvian and Lithuanian
    0x00A2: (0x19, 0xA2), # ¢
    0x00A3: (0x19, 0xA3), # £
    0x00A4: (0x19, 0xA4), # ¤
    0x00A6: (0x19, 0xA6), # ¦
    0x00A7: (0x19, 0xA7), # §
    0x00A9: (0x19, 0xA9), # ©
    0x00AB: (0x19, 0xAB), # «
    0x00AC: (0x19, 0xAC), # ¬
    0x00AD: (0x19, 0xAD), # ­
    0x00AE: (0x19, 0xAE), # ®
    0x00B0: (0x19, 0xB0), # °
    0x00B1: (0x19, 0xB1), # ±
    0x00B2: (0x19, 0xB2), # ²
    0x00B3: (0x19, 0xB3), # ³
    0x00B5: (0x19, 0xB5), # µ
    0x00B6: (0x19, 0xB6), # ¶
    0x00B7: (0x19, 0xB7), # ·
    0x00B9: (0x19, 0xB9), # ¹
    0x00BB: (0x19, 0xBB), # »
    0x00BC: (0x19, 0xBC), # ¼
    0x00BD: (0x19, 0xBD), # ½
    0x00BE: (0x19, 0xBE), # ¾
    0x00C4: (0x19, 0xC4), # Ä
    0x00C5: (0x19, 0xC5), # Å
    0x00C6: (0x19, 0xAF), # Æ
    0x00C9: (0x19, 0xC9), # É
    0x00D3: (0x19, 0xD3), # Ó
    0x00D5: (0x19, 0xD5), # Õ
    0x00D6: (0x19, 0xD6), # Ö
    0x00D7: (0x19, 0xD7), # ×
    0x00D8: (0x19, 0xA8), # Ø
    0x00DC: (0x19, 0xDC), # Ü
    0x00DF: (0x19, 0xDF), # ß
    0x00E4: (0x19, 0xE4), # ä
    0x00E5: (0x19, 0xE5), # å
    0x00E6: (0x19, 0xBF), # æ
    0x00E9: (0x19, 0xE9), # é
    0x00F3: (0x19, 0xF3), # ó
    0x00F5: (0x19, 0xF5), # õ
    0x00F6: (0x19, 0xF6), # ö
    0x00F7: (0x19, 0xF7), # ÷
    0x00F8: (0x19, 0xB8), # ø
    0x00FC: (0x19, 0xFC), # ü
    0x0100: (0x19, 0xC2), # Ā
    0x0101: (0x19, 0xE2), # ā
    0x0104: (0x19, 0xC0), # Ą
    0x0105: (0x19, 0xE0), # ą
    0x0106: (0x19, 0xC3), # Ć
    0x0107: (0x19, 0xE3), # ć
    0x010C: (0x19, 0xC8), # Č
    0x010D: (0x19, 0xE8), # č
    0x0112: (0x19, 0xC7), # Ē
    0x0113: (0x19, 0xE7), # ē
    0x0116: (0x19, 0xCB), # Ė
    0x0117: (0x19, 0xEB), # ė
    0x0118: (0x19, 0xC6), # Ę
    0x0119: (0x19, 0xE6), # ę
    0x0122: (0x19, 0xCC), # Ģ
    0x0123: (0x19, 0xEC), # ģ
    0x012A: (0x19, 0xCE), # Ī
    0x012B: (0x19, 0xEE), # ī
    0x012E: (0x19, 0xC1), # Į
    0x012F: (0x19, 0xE1), # į
    0x0136: (0x19, 0xCD), # Ķ
    0x0137: (0x19, 0xED), # ķ
    0x013B: (0x19, 0xCF), # Ļ
    0x013C: (0x19, 0xEF), # ļ
    0x0141: (0x19, 0xD9), # Ł
    0x0142: (0x19, 0xF9), # ł
    0x0143: (0x19, 0xD1), # Ń
    0x0144: (0x19, 0xF1), # ń
    0x0145: (0x19, 0xD2), # Ņ
    0x0146: (0x19, 0xF2), # ņ
    0x014C: (0x19, 0xD4), # Ō
    0x014D: (0x19, 0xF4), # ō
    0x0156: (0x19, 0xAA), # Ŗ
    0x0157: (0x19, 0xBA), # ŗ
    0x015A: (0x19, 0xDA), # Ś
    0x015B: (0x19, 0xFA), # ś
    0x0160: (0x19, 0xD0), # Š
    0x0161: (0x19, 0xF0), # š
    0x016A: (0x19, 0xDB), # Ū
    0x016B: (0x19, 0xFB), # ū
    0x0172: (0x19, 0xD8), # Ų
    0x0173: (0x19, 0xF8), # ų
    0x0179: (0x19, 0xCA), # Ź
    0x017A: (0x19, 0xEA), # ź
    0x017B: (0x19, 0xDD), # Ż
    0x017C: (0x19, 0xFD), # ż
    0x017D: (0x19, 0xDE), # Ž
    0x017E: (0x19, 0xFE), # ž
    # 0x2013: (0x19, 0x96), # –
    # 0x2014: (0x19, 0x97), # —
    0x2018: (0x19, 0x91), # ‘
    0x2019: (0x19, 0x92), # ’
    0x201A: (0x19, 0x82), # ‚
    0x201C: (0x19, 0x93), # “
    0x201D: (0x19, 0x94), # ”
    0x201E: (0x19, 0x84), # „
    0x2020: (0x19, 0x86), # †
    0x2021: (0x19, 0x87), # ‡
    0x2022: (0x19, 0x95), # •
    0x2026: (0x19, 0x85), # …
    0x2030: (0x19, 0x89), # ‰
    0x2039: (0x19, 0x8B), # ‹
    0x203A: (0x19, 0x9B), # ›
    0x2122: (0x19, 0x99), # ™

    # IBM-737 Greek (Typo on test paper says 747)
    0x00B0: (0x40, 0xF8), # °
    0x00B1: (0x40, 0xF1), # ±
    0x00B2: (0x40, 0xFD), # ²
    0x00B7: (0x40, 0xFA), # ·
    0x00F7: (0x40, 0xF6), # ÷
    0x0386: (0x40, 0xEA), # Ά
    0x0388: (0x40, 0xEB), # Έ
    0x0389: (0x40, 0xEC), # Ή
    0x038A: (0x40, 0xED), # Ί
    0x038C: (0x40, 0xEE), # Ό
    0x038E: (0x40, 0xEF), # Ύ
    0x038F: (0x40, 0xF0), # Ώ
    0x0391: (0x40, 0x80), # Α
    0x0392: (0x40, 0x81), # Β
    0x0393: (0x40, 0x82), # Γ
    0x0394: (0x40, 0x83), # Δ
    0x0395: (0x40, 0x84), # Ε
    0x0396: (0x40, 0x85), # Ζ
    0x0397: (0x40, 0x86), # Η
    0x0398: (0x40, 0x87), # Θ
    0x0399: (0x40, 0x88), # Ι
    0x039A: (0x40, 0x89), # Κ
    0x039B: (0x40, 0x8A), # Λ
    0x039C: (0x40, 0x8B), # Μ
    0x039D: (0x40, 0x8C), # Ν
    0x039E: (0x40, 0x8D), # Ξ
    0x039F: (0x40, 0x8E), # Ο
    0x03A0: (0x40, 0x8F), # Π
    0x03A1: (0x40, 0x90), # Ρ
    0x03A3: (0x40, 0x91), # Σ
    0x03A4: (0x40, 0x92), # Τ
    0x03A5: (0x40, 0x93), # Υ
    0x03A6: (0x40, 0x94), # Φ
    0x03A7: (0x40, 0x95), # Χ
    0x03A8: (0x40, 0x96), # Ψ
    0x03A9: (0x40, 0x97), # Ω
    0x03AA: (0x40, 0xF4), # Ϊ
    0x03AB: (0x40, 0xF5), # Ϋ
    0x03AC: (0x40, 0xE1), # ά
    0x03AD: (0x40, 0xE2), # έ
    0x03AE: (0x40, 0xE3), # ή
    0x03AF: (0x40, 0xE5), # ί
    0x03B1: (0x40, 0x98), # α
    0x03B2: (0x40, 0x99), # β
    0x03B3: (0x40, 0x9A), # γ
    0x03B4: (0x40, 0x9B), # δ
    0x03B5: (0x40, 0x9C), # ε
    0x03B6: (0x40, 0x9D), # ζ
    0x03B7: (0x40, 0x9E), # η
    0x03B8: (0x40, 0x9F), # θ
    0x03B9: (0x40, 0xA0), # ι
    0x03BA: (0x40, 0xA1), # κ
    0x03BB: (0x40, 0xA2), # λ
    0x03BC: (0x40, 0xA3), # μ
    0x03BD: (0x40, 0xA4), # ν
    0x03BE: (0x40, 0xA5), # ξ
    0x03BF: (0x40, 0xA6), # ο
    0x03C0: (0x40, 0xA7), # π
    0x03C1: (0x40, 0xA8), # ρ
    0x03C2: (0x40, 0xAA), # ς
    0x03C3: (0x40, 0xA9), # σ
    0x03C4: (0x40, 0xAB), # τ
    0x03C5: (0x40, 0xAC), # υ
    0x03D5: (0x40, 0xAD), # ϕ
    0x03C6: (0x40, 0xAD), # φ
    0x03C7: (0x40, 0xAE), # χ
    0x03C8: (0x40, 0xAF), # ψ
    0x03C9: (0x40, 0xE0), # ω
    0x03CA: (0x40, 0xE4), # ϊ
    0x03CB: (0x40, 0xE8), # ϋ
    0x03CC: (0x40, 0xE6), # ό
    0x03CD: (0x40, 0xE7), # ύ
    0x03CE: (0x40, 0xE9), # ώ
    0x207F: (0x40, 0xFC), # ⁿ
    0x2219: (0x40, 0xF9), # ∙
    0x221A: (0x40, 0xFB), # √
    0x2248: (0x40, 0xF7), # ≈
    0x2264: (0x40, 0xF3), # ≤
    0x2265: (0x40, 0xF2), # ≥
    0x2500: (0x40, 0xC4), # ─
    0xFFE8: (0x40, 0xB3), # ￨
    0x2502: (0x40, 0xB3), # │
    0x250C: (0x40, 0xDA), # ┌
    0x2510: (0x40, 0xBF), # ┐
    0x2514: (0x40, 0xC0), # └
    0x2518: (0x40, 0xD9), # ┘
    0x251C: (0x40, 0xC3), # ├
    0x2524: (0x40, 0xB4), # ┤
    0x252C: (0x40, 0xC2), # ┬
    0x2534: (0x40, 0xC1), # ┴
    0x253C: (0x40, 0xC5), # ┼
    0x2550: (0x40, 0xCD), # ═
    0x2551: (0x40, 0xBA), # ║
    0x2552: (0x40, 0xD5), # ╒
    0x2553: (0x40, 0xD6), # ╓
    0x2554: (0x40, 0xC9), # ╔
    0x2555: (0x40, 0xB8), # ╕
    0x2556: (0x40, 0xB7), # ╖
    0x2557: (0x40, 0xBB), # ╗
    0x2558: (0x40, 0xD4), # ╘
    0x2559: (0x40, 0xD3), # ╙
    0x255A: (0x40, 0xC8), # ╚
    0x255B: (0x40, 0xBE), # ╛
    0x255C: (0x40, 0xBD), # ╜
    0x255D: (0x40, 0xBC), # ╝
    0x255E: (0x40, 0xC6), # ╞
    0x255F: (0x40, 0xC7), # ╟
    0x2560: (0x40, 0xCC), # ╠
    0x2561: (0x40, 0xB5), # ╡
    0x2562: (0x40, 0xB6), # ╢
    0x2563: (0x40, 0xB9), # ╣
    0x2564: (0x40, 0xD1), # ╤
    0x2565: (0x40, 0xD2), # ╥
    0x2566: (0x40, 0xCB), # ╦
    0x2567: (0x40, 0xCF), # ╧
    0x2568: (0x40, 0xD0), # ╨
    0x2569: (0x40, 0xCA), # ╩
    0x256A: (0x40, 0xD8), # ╪
    0x256B: (0x40, 0xD7), # ╫
    0x256C: (0x40, 0xCE), # ╬
    0x2580: (0x40, 0xDF), # ▀
    0x2584: (0x40, 0xDC), # ▄
    0x2588: (0x40, 0xDB), # █
    0x258C: (0x40, 0xDD), # ▌
    0x2590: (0x40, 0xDE), # ▐
    0x2591: (0x40, 0xB0), # ░
    0x2592: (0x40, 0xB1), # ▒
    0x2593: (0x40, 0xB2), # ▓
    0xFFED: (0x40, 0xFE), # ￭
    0x25A0: (0x40, 0xFE), # ■

    # Windows-1250 Latin-2
    0x00A4: (0x48, 0xA4), # ¤
    0x00A6: (0x48, 0xA6), # ¦
    0x00A7: (0x48, 0xA7), # §
    0x00A8: (0x48, 0xA8), # ¨
    0x00A9: (0x48, 0xA9), # ©
    0x00AB: (0x48, 0xAB), # «
    0x00AC: (0x48, 0xAC), # ¬
    0x00AD: (0x48, 0xAD), # ­
    0x00AE: (0x48, 0xAE), # ®
    0x00B0: (0x48, 0xB0), # °
    0x00B1: (0x48, 0xB1), # ±
    0x00B4: (0x48, 0xB4), # ´
    0x00B5: (0x48, 0xB5), # µ
    0x00B6: (0x48, 0xB6), # ¶
    0x00B7: (0x48, 0xB7), # ·
    0x00B8: (0x48, 0xB8), # ¸
    0x00BB: (0x48, 0xBB), # »
    0x00C1: (0x48, 0xC1), # Á
    0x00C2: (0x48, 0xC2), # Â
    0x00C4: (0x48, 0xC4), # Ä
    0x00C7: (0x48, 0xC7), # Ç
    0x00C9: (0x48, 0xC9), # É
    0x00CB: (0x48, 0xCB), # Ë
    0x00CD: (0x48, 0xCD), # Í
    0x00CE: (0x48, 0xCE), # Î
    0x00D0: (0x48, 0xD0), # Ð
    0x0110: (0x48, 0xD0), # Đ
    0x00D3: (0x48, 0xD3), # Ó
    0x00D4: (0x48, 0xD4), # Ô
    0x00D6: (0x48, 0xD6), # Ö
    0x00D7: (0x48, 0xD7), # ×
    0x00DA: (0x48, 0xDA), # Ú
    0x00DC: (0x48, 0xDC), # Ü
    0x00DD: (0x48, 0xDD), # Ý
    0x00DF: (0x48, 0xDF), # ß
    0x00E1: (0x48, 0xE1), # á
    0x00E2: (0x48, 0xE2), # â
    0x00E4: (0x48, 0xE4), # ä
    0x00E7: (0x48, 0xE7), # ç
    0x00E9: (0x48, 0xE9), # é
    0x00EB: (0x48, 0xEB), # ë
    0x00ED: (0x48, 0xED), # í
    0x00EE: (0x48, 0xEE), # î
    0x00F3: (0x48, 0xF3), # ó
    0x00F4: (0x48, 0xF4), # ô
    0x00F6: (0x48, 0xF6), # ö
    0x00F7: (0x48, 0xF7), # ÷
    0x00FA: (0x48, 0xFA), # ú
    0x00FC: (0x48, 0xFC), # ü
    0x00FD: (0x48, 0xFD), # ý
    0x0102: (0x48, 0xC3), # Ă
    0x0103: (0x48, 0xE3), # ă
    0x0104: (0x48, 0xA5), # Ą
    0x0105: (0x48, 0xB9), # ą
    0x0106: (0x48, 0xC6), # Ć
    0x0107: (0x48, 0xE6), # ć
    0x010C: (0x48, 0xC8), # Č
    0x010D: (0x48, 0xE8), # č
    0x010E: (0x48, 0xCF), # Ď
    0x010F: (0x48, 0xEF), # ď
    0x0111: (0x48, 0xF0), # đ
    0x0118: (0x48, 0xCA), # Ę
    0x0119: (0x48, 0xEA), # ę
    0x011A: (0x48, 0xCC), # Ě
    0x011B: (0x48, 0xEC), # ě
    0x0139: (0x48, 0xC5), # Ĺ
    0x013A: (0x48, 0xE5), # ĺ
    0x013D: (0x48, 0xBC), # Ľ
    0x013E: (0x48, 0xBE), # ľ
    0x0141: (0x48, 0xA3), # Ł
    0x0142: (0x48, 0xB3), # ł
    0x0143: (0x48, 0xD1), # Ń
    0x0144: (0x48, 0xF1), # ń
    0x0147: (0x48, 0xD2), # Ň
    0x0148: (0x48, 0xF2), # ň
    0x0150: (0x48, 0xD5), # Ő
    0x0151: (0x48, 0xF5), # ő
    0x0154: (0x48, 0xC0), # Ŕ
    0x0155: (0x48, 0xE0), # ŕ
    0x0158: (0x48, 0xD8), # Ř
    0x0159: (0x48, 0xF8), # ř
    0x015A: (0x48, 0x8C), # Ś
    0x015B: (0x48, 0x9C), # ś
    0x015E: (0x48, 0xAA), # Ş
    0x015F: (0x48, 0xBA), # ş
    0x0160: (0x48, 0x8A), # Š
    0x0161: (0x48, 0x9A), # š
    0x0162: (0x48, 0xDE), # Ţ
    0x0163: (0x48, 0xFE), # ţ
    0x0164: (0x48, 0x8D), # Ť
    0x0165: (0x48, 0x9D), # ť
    0x016E: (0x48, 0xD9), # Ů
    0x016F: (0x48, 0xF9), # ů
    0x0170: (0x48, 0xDB), # Ű
    0x0171: (0x48, 0xFB), # ű
    0x0179: (0x48, 0x8F), # Ź
    0x017A: (0x48, 0x9F), # ź
    0x017B: (0x48, 0xAF), # Ż
    0x017C: (0x48, 0xBF), # ż
    0x017D: (0x48, 0x8E), # Ž
    0x017E: (0x48, 0x9E), # ž
    0x02C7: (0x48, 0xA1), # ˇ
    0x02D8: (0x48, 0xA2), # ˘
    0x02D9: (0x48, 0xFF), # ˙
    0x02DB: (0x48, 0xB2), # ˛
    0x02DD: (0x48, 0xBD), # ˝
    # 0x2013: (0x48, 0x96), # –
    # 0x2014: (0x48, 0x97), # —
    0x2018: (0x48, 0x91), # ‘
    0x2019: (0x48, 0x92), # ’
    0x201A: (0x48, 0x82), # ‚
    0x201C: (0x48, 0x93), # “
    0x201D: (0x48, 0x94), # ”
    0x201E: (0x48, 0x84), # „
    0x2020: (0x48, 0x86), # †
    0x2021: (0x48, 0x87), # ‡
    0x2022: (0x48, 0x95), # •
    0x2026: (0x48, 0x85), # …
    0x2030: (0x48, 0x89), # ‰
    0x2039: (0x48, 0x8B), # ‹
    0x203A: (0x48, 0x9B), # ›
    0x20AC: (0x48, 0x80), # €
    0x2122: (0x48, 0x99), # ™

    # Windows-1251 Cyrillic
    0x00A4: (0x49, 0xA4), # ¤
    0x00A6: (0x49, 0xA6), # ¦
    0x00A7: (0x49, 0xA7), # §
    0x00A9: (0x49, 0xA9), # ©
    0x00AB: (0x49, 0xAB), # «
    0x00AC: (0x49, 0xAC), # ¬
    0x00AD: (0x49, 0xAD), # ­
    0x00AE: (0x49, 0xAE), # ®
    0x00B0: (0x49, 0xB0), # °
    0x00B1: (0x49, 0xB1), # ±
    0x00B5: (0x49, 0xB5), # µ
    0x00B6: (0x49, 0xB6), # ¶
    0x00B7: (0x49, 0xB7), # ·
    0x00BB: (0x49, 0xBB), # »
    0x0401: (0x49, 0xA8), # Ё
    0x0402: (0x49, 0x80), # Ђ
    0x0403: (0x49, 0x81), # Ѓ
    0x0404: (0x49, 0xAA), # Є
    0x0405: (0x49, 0xBD), # Ѕ
    0x0406: (0x49, 0xB2), # І
    0x0407: (0x49, 0xAF), # Ї
    0x0408: (0x49, 0xA3), # Ј
    0x0409: (0x49, 0x8A), # Љ
    0x040A: (0x49, 0x8C), # Њ
    0x040B: (0x49, 0x8E), # Ћ
    0x040C: (0x49, 0x8D), # Ќ
    0x040E: (0x49, 0xA1), # Ў
    0x040F: (0x49, 0x8F), # Џ
    0x0410: (0x49, 0xC0), # А
    0x0411: (0x49, 0xC1), # Б
    0x0412: (0x49, 0xC2), # В
    0x0413: (0x49, 0xC3), # Г
    0x0414: (0x49, 0xC4), # Д
    0x0415: (0x49, 0xC5), # Е
    0x0416: (0x49, 0xC6), # Ж
    0x0417: (0x49, 0xC7), # З
    0x0418: (0x49, 0xC8), # И
    0x0419: (0x49, 0xC9), # Й
    0x041A: (0x49, 0xCA), # К
    0x041B: (0x49, 0xCB), # Л
    0x041C: (0x49, 0xCC), # М
    0x041D: (0x49, 0xCD), # Н
    0x041E: (0x49, 0xCE), # О
    0x041F: (0x49, 0xCF), # П
    0x0420: (0x49, 0xD0), # Р
    0x0421: (0x49, 0xD1), # С
    0x0422: (0x49, 0xD2), # Т
    0x0423: (0x49, 0xD3), # У
    0x0424: (0x49, 0xD4), # Ф
    0x0425: (0x49, 0xD5), # Х
    0x0426: (0x49, 0xD6), # Ц
    0x0427: (0x49, 0xD7), # Ч
    0x0428: (0x49, 0xD8), # Ш
    0x0429: (0x49, 0xD9), # Щ
    0x042A: (0x49, 0xDA), # Ъ
    0x042B: (0x49, 0xDB), # Ы
    0x042C: (0x49, 0xDC), # Ь
    0x042D: (0x49, 0xDD), # Э
    0x042E: (0x49, 0xDE), # Ю
    0x042F: (0x49, 0xDF), # Я
    0x0430: (0x49, 0xE0), # а
    0x0431: (0x49, 0xE1), # б
    0x0432: (0x49, 0xE2), # в
    0x0433: (0x49, 0xE3), # г
    0x0434: (0x49, 0xE4), # д
    0x0435: (0x49, 0xE5), # е
    0x0436: (0x49, 0xE6), # ж
    0x0437: (0x49, 0xE7), # з
    0x0438: (0x49, 0xE8), # и
    0x0439: (0x49, 0xE9), # й
    0x043A: (0x49, 0xEA), # к
    0x043B: (0x49, 0xEB), # л
    0x043C: (0x49, 0xEC), # м
    0x043D: (0x49, 0xED), # н
    0x043E: (0x49, 0xEE), # о
    0x043F: (0x49, 0xEF), # п
    0x0440: (0x49, 0xF0), # р
    0x0441: (0x49, 0xF1), # с
    0x0442: (0x49, 0xF2), # т
    0x0443: (0x49, 0xF3), # у
    0x0444: (0x49, 0xF4), # ф
    0x0445: (0x49, 0xF5), # х
    0x0446: (0x49, 0xF6), # ц
    0x0447: (0x49, 0xF7), # ч
    0x0448: (0x49, 0xF8), # ш
    0x0449: (0x49, 0xF9), # щ
    0x044A: (0x49, 0xFA), # ъ
    0x044B: (0x49, 0xFB), # ы
    0x044C: (0x49, 0xFC), # ь
    0x044D: (0x49, 0xFD), # э
    0x044E: (0x49, 0xFE), # ю
    0x044F: (0x49, 0xFF), # я
    0x0451: (0x49, 0xB8), # ё
    0x0452: (0x49, 0x90), # ђ
    0x0453: (0x49, 0x83), # ѓ
    0x0454: (0x49, 0xBA), # є
    0x0455: (0x49, 0xBE), # ѕ
    0x0456: (0x49, 0xB3), # і
    0x0457: (0x49, 0xBF), # ї
    0x0458: (0x49, 0xBC), # ј
    0x0459: (0x49, 0x9A), # љ
    0x045A: (0x49, 0x9C), # њ
    0x045B: (0x49, 0x9E), # ћ
    0x045C: (0x49, 0x9D), # ќ
    0x045E: (0x49, 0xA2), # ў
    0x045F: (0x49, 0x9F), # џ
    0x0490: (0x49, 0xA5), # Ґ
    0x0491: (0x49, 0xB4), # ґ
    # 0x2013: (0x49, 0x96), # –
    # 0x2014: (0x49, 0x97), # —
    0x2018: (0x49, 0x91), # ‘
    0x2019: (0x49, 0x92), # ’
    0x201A: (0x49, 0x82), # ‚
    0x201C: (0x49, 0x93), # “
    0x201D: (0x49, 0x94), # ”
    0x201E: (0x49, 0x84), # „
    0x2020: (0x49, 0x86), # †
    0x2021: (0x49, 0x87), # ‡
    0x2022: (0x49, 0x95), # •
    0x2026: (0x49, 0x85), # …
    0x2030: (0x49, 0x89), # ‰
    0x2039: (0x49, 0x8B), # ‹
    0x203A: (0x49, 0x9B), # ›
    0x2116: (0x49, 0xB9), # №
    0x2122: (0x49, 0x99), # ™

    # IBM-1255 Hebrew
    0x00A2: (0x20, 0xA2), # ¢
    0x00A3: (0x20, 0xA3), # £
    0x00A5: (0x20, 0xA5), # ¥
    0x00A6: (0x20, 0xA6), # ¦
    0x00A7: (0x20, 0xA7), # §
    0x00A8: (0x20, 0xA8), # ¨
    0x00A9: (0x20, 0xA9), # ©
    0x00AB: (0x20, 0xAB), # «
    0x00AC: (0x20, 0xAC), # ¬
    0x00AD: (0x20, 0xAD), # ­
    0x00AE: (0x20, 0xAE), # ®
    0x00AF: (0x20, 0xAF), # ¯
    0x00B0: (0x20, 0xB0), # °
    0x00B1: (0x20, 0xB1), # ±
    0x00B2: (0x20, 0xB2), # ²
    0x00B3: (0x20, 0xB3), # ³
    0x00B4: (0x20, 0xB4), # ´
    0x00B5: (0x20, 0xB5), # µ
    0x00B6: (0x20, 0xB6), # ¶
    0x00B7: (0x20, 0xB7), # ·
    0x00B9: (0x20, 0xB9), # ¹
    0x00BB: (0x20, 0xBB), # »
    0x00BC: (0x20, 0xBC), # ¼
    0x00BD: (0x20, 0xBD), # ½
    0x00BE: (0x20, 0xBE), # ¾
    0x0192: (0x20, 0x83), # ƒ
    0x02C6: (0x20, 0x88), # ˆ
    0x02DC: (0x20, 0x98), # ˜
    0x05B0: (0x20, 0xC0), #
    0x05B1: (0x20, 0xC1), #
    0x05B2: (0x20, 0xC2), #
    0x05B3: (0x20, 0xC3), #
    0x05B4: (0x20, 0xC4), #
    0x05B5: (0x20, 0xC5), #
    0x05B6: (0x20, 0xC6), #
    0x05B7: (0x20, 0xC7), #
    0x05B8: (0x20, 0xC8), #
    0x05B9: (0x20, 0xC9), #
    0x05BB: (0x20, 0xCB), #
    0x05BC: (0x20, 0xCC), #
    0x05BD: (0x20, 0xCD), #
    0x05BE: (0x20, 0xCE), # ־
    0x05BF: (0x20, 0xCF), #
    0x05C0: (0x20, 0xD0), # ׀
    0x05C1: (0x20, 0xD1), #
    0x05C2: (0x20, 0xD2), #
    0x05C3: (0x20, 0xD3), # ׃
    0x05D0: (0x20, 0xE0), # א
    0x05D1: (0x20, 0xE1), # ב
    0x05D2: (0x20, 0xE2), # ג
    0x05D3: (0x20, 0xE3), # ד
    0x05D4: (0x20, 0xE4), # ה
    0x05D5: (0x20, 0xE5), # ו
    0x05D6: (0x20, 0xE6), # ז
    0x05D7: (0x20, 0xE7), # ח
    0x05D8: (0x20, 0xE8), # ט
    0x05D9: (0x20, 0xE9), # י
    0x05DA: (0x20, 0xEA), # ך
    0x05DB: (0x20, 0xEB), # כ
    0x05DC: (0x20, 0xEC), # ל
    0x05DD: (0x20, 0xED), # ם
    0x05DE: (0x20, 0xEE), # מ
    0x05DF: (0x20, 0xEF), # ן
    0x05E0: (0x20, 0xF0), # נ
    0x05E1: (0x20, 0xF1), # ס
    0x05E2: (0x20, 0xF2), # ע
    0x05E3: (0x20, 0xF3), # ף
    0x05E4: (0x20, 0xF4), # פ
    0x05E5: (0x20, 0xF5), # ץ
    0x05E6: (0x20, 0xF6), # צ
    0x05E7: (0x20, 0xF7), # ק
    0x05E8: (0x20, 0xF8), # ר
    0x05E9: (0x20, 0xF9), # ש
    0x05EA: (0x20, 0xFA), # ת
    0x05F0: (0x20, 0xD4), # װ
    0x05F1: (0x20, 0xD5), # ױ
    0x05F2: (0x20, 0xD6), # ײ
    0x200E: (0x20, 0xFD), # ltr mark
    0x200F: (0x20, 0xFE), # rtl mark (?????????????)
    # 0x2013: (0x20, 0x96), # –
    # 0x2014: (0x20, 0x97), # —
    0x2018: (0x20, 0x91), # ‘
    0x2019: (0x20, 0x92), # ’
    0x201A: (0x20, 0x82), # ‚
    0x201C: (0x20, 0x93), # “
    0x201D: (0x20, 0x94), # ”
    0x201E: (0x20, 0x84), # „
    0x2020: (0x20, 0x86), # †
    0x2021: (0x20, 0x87), # ‡
    0x2022: (0x20, 0x95), # •
    0x2026: (0x20, 0x85), # …
    0x2030: (0x20, 0x89), # ‰
    0x2039: (0x20, 0x8B), # ‹
    0x203A: (0x20, 0x9B), # ›
    0x20AA: (0x20, 0xA4), # ₪
    0x2122: (0x20, 0x99), # ™

    # IBM-862 Hebrew
    0x00A1: (0x3E, 0xAD), # ¡
    0x00A2: (0x3E, 0x9B), # ¢
    0x00A3: (0x3E, 0x9C), # £
    0x00A5: (0x3E, 0x9D), # ¥
    0x00AA: (0x3E, 0xA6), # ª
    0x00AB: (0x3E, 0xAE), # «
    0x00AC: (0x3E, 0xAA), # ¬
    0x00B0: (0x3E, 0xF8), # °
    0x00B1: (0x3E, 0xF1), # ±
    0x00B2: (0x3E, 0xFD), # ²
    0x00B7: (0x3E, 0xFA), # ·
    0x00BA: (0x3E, 0xA7), # º
    0x00BB: (0x3E, 0xAF), # »
    0x00BC: (0x3E, 0xAC), # ¼
    0x00BD: (0x3E, 0xAB), # ½
    0x00BF: (0x3E, 0xA8), # ¿
    0x00D1: (0x3E, 0xA5), # Ñ
    0x00DF: (0x3E, 0xE1), # ß
    0x00E1: (0x3E, 0xA0), # á
    0x00ED: (0x3E, 0xA1), # í
    0x00F1: (0x3E, 0xA4), # ñ
    0x00F3: (0x3E, 0xA2), # ó
    0x00F7: (0x3E, 0xF6), # ÷
    0x00FA: (0x3E, 0xA3), # ú
    0x0192: (0x3E, 0x9F), # ƒ
    0x0393: (0x3E, 0xE2), # Γ
    0x0398: (0x3E, 0xE9), # Θ
    0x03A3: (0x3E, 0xE4), # Σ
    0x03A6: (0x3E, 0xE8), # Φ
    0x03A9: (0x3E, 0xEA), # Ω
    0x03B1: (0x3E, 0xE0), # α
    0x03B4: (0x3E, 0xEB), # δ
    0x03B5: (0x3E, 0xEE), # ε
    0x03BC: (0x3E, 0xE6), # μ
    0x03C0: (0x3E, 0xE3), # π
    0x03C3: (0x3E, 0xE5), # σ
    0x03C4: (0x3E, 0xE7), # τ
    0x03C6: (0x3E, 0xED), # φ
    0x05D0: (0x3E, 0x80), # א
    0x05D1: (0x3E, 0x81), # ב
    0x05D2: (0x3E, 0x82), # ג
    0x05D3: (0x3E, 0x83), # ד
    0x05D4: (0x3E, 0x84), # ה
    0x05D5: (0x3E, 0x85), # ו
    0x05D6: (0x3E, 0x86), # ז
    0x05D7: (0x3E, 0x87), # ח
    0x05D8: (0x3E, 0x88), # ט
    0x05D9: (0x3E, 0x89), # י
    0x05DA: (0x3E, 0x8A), # ך
    0x05DB: (0x3E, 0x8B), # כ
    0x05DC: (0x3E, 0x8C), # ל
    0x05DD: (0x3E, 0x8D), # ם
    0x05DE: (0x3E, 0x8E), # מ
    0x05DF: (0x3E, 0x8F), # ן
    0x05E0: (0x3E, 0x90), # נ
    0x05E1: (0x3E, 0x91), # ס
    0x05E2: (0x3E, 0x92), # ע
    0x05E3: (0x3E, 0x93), # ף
    0x05E4: (0x3E, 0x94), # פ
    0x05E5: (0x3E, 0x95), # ץ
    0x05E6: (0x3E, 0x96), # צ
    0x05E7: (0x3E, 0x97), # ק
    0x05E8: (0x3E, 0x98), # ר
    0x05E9: (0x3E, 0x99), # ש
    0x05EA: (0x3E, 0x9A), # ת
    0x207F: (0x3E, 0xFC), # ⁿ
    0x20A7: (0x3E, 0x9E), # ₧
    0x2219: (0x3E, 0xF9), # ∙
    0x221A: (0x3E, 0xFB), # √
    0x221E: (0x3E, 0xEC), # ∞
    0x2229: (0x3E, 0xEF), # ∩
    0x2248: (0x3E, 0xF7), # ≈
    0x2261: (0x3E, 0xF0), # ≡
    0x2264: (0x3E, 0xF3), # ≤
    0x2265: (0x3E, 0xF2), # ≥
    0x2310: (0x3E, 0xA9), # ⌐
    0x2320: (0x3E, 0xF4), # ⌠
    0x2321: (0x3E, 0xF5), # ⌡
    0x2500: (0x3E, 0xC4), # ─
    0xFFE8: (0x3E, 0xB3), # ￨
    0x2502: (0x3E, 0xB3), # │
    0x250C: (0x3E, 0xDA), # ┌
    0x2510: (0x3E, 0xBF), # ┐
    0x2514: (0x3E, 0xC0), # └
    0x2518: (0x3E, 0xD9), # ┘
    0x251C: (0x3E, 0xC3), # ├
    0x2524: (0x3E, 0xB4), # ┤
    0x252C: (0x3E, 0xC2), # ┬
    0x2534: (0x3E, 0xC1), # ┴
    0x253C: (0x3E, 0xC5), # ┼
    0x2550: (0x3E, 0xCD), # ═
    0x2551: (0x3E, 0xBA), # ║
    0x2552: (0x3E, 0xD5), # ╒
    0x2553: (0x3E, 0xD6), # ╓
    0x2554: (0x3E, 0xC9), # ╔
    0x2555: (0x3E, 0xB8), # ╕
    0x2556: (0x3E, 0xB7), # ╖
    0x2557: (0x3E, 0xBB), # ╗
    0x2558: (0x3E, 0xD4), # ╘
    0x2559: (0x3E, 0xD3), # ╙
    0x255A: (0x3E, 0xC8), # ╚
    0x255B: (0x3E, 0xBE), # ╛
    0x255C: (0x3E, 0xBD), # ╜
    0x255D: (0x3E, 0xBC), # ╝
    0x255E: (0x3E, 0xC6), # ╞
    0x255F: (0x3E, 0xC7), # ╟
    0x2560: (0x3E, 0xCC), # ╠
    0x2561: (0x3E, 0xB5), # ╡
    0x2562: (0x3E, 0xB6), # ╢
    0x2563: (0x3E, 0xB9), # ╣
    0x2564: (0x3E, 0xD1), # ╤
    0x2565: (0x3E, 0xD2), # ╥
    0x2566: (0x3E, 0xCB), # ╦
    0x2567: (0x3E, 0xCF), # ╧
    0x2568: (0x3E, 0xD0), # ╨
    0x2569: (0x3E, 0xCA), # ╩
    0x256A: (0x3E, 0xD8), # ╪
    0x256B: (0x3E, 0xD7), # ╫
    0x256C: (0x3E, 0xCE), # ╬
    0x2580: (0x3E, 0xDF), # ▀
    0x2584: (0x3E, 0xDC), # ▄
    0x2588: (0x3E, 0xDB), # █
    0x258C: (0x3E, 0xDD), # ▌
    0x2590: (0x3E, 0xDE), # ▐
    0x2591: (0x3E, 0xB0), # ░
    0x2592: (0x3E, 0xB1), # ▒
    0x2593: (0x3E, 0xB2), # ▓
    0xFFED: (0x3E, 0xFE), # ￭
    0x25A0: (0x3E, 0xFE), # ■

    # IBM-860 Portugese
    0x00A1: (0x3E, 0xAD), # ¡
    0x00A2: (0x3E, 0x9B), # ¢
    0x00A3: (0x3E, 0x9C), # £
    0x00AA: (0x3E, 0xA6), # ª
    0x00AB: (0x3E, 0xAE), # «
    0x00AC: (0x3E, 0xAA), # ¬
    0x00B0: (0x3E, 0xF8), # °
    0x00B1: (0x3E, 0xF1), # ±
    0x00B2: (0x3E, 0xFD), # ²
    0x00B7: (0x3E, 0xFA), # ·
    0x00BA: (0x3E, 0xA7), # º
    0x00BB: (0x3E, 0xAF), # »
    0x00BC: (0x3E, 0xAC), # ¼
    0x00BD: (0x3E, 0xAB), # ½
    0x00BF: (0x3E, 0xA8), # ¿
    0x00C0: (0x3E, 0x91), # À
    0x00C1: (0x3E, 0x86), # Á
    0x00C2: (0x3E, 0x8F), # Â
    0x00C3: (0x3E, 0x8E), # Ã
    0x00C7: (0x3E, 0x80), # Ç
    0x00C8: (0x3E, 0x92), # È
    0x00C9: (0x3E, 0x90), # É
    0x00CA: (0x3E, 0x89), # Ê
    0x00CC: (0x3E, 0x98), # Ì
    0x00CD: (0x3E, 0x8B), # Í
    0x00D1: (0x3E, 0xA5), # Ñ
    0x00D2: (0x3E, 0xA9), # Ò
    0x00D3: (0x3E, 0x9F), # Ó
    0x00D4: (0x3E, 0x8C), # Ô
    0x00D5: (0x3E, 0x99), # Õ
    0x00D9: (0x3E, 0x9D), # Ù
    0x00DA: (0x3E, 0x96), # Ú
    0x00DC: (0x3E, 0x9A), # Ü
    0x00DF: (0x3E, 0xE1), # ß
    0x00E0: (0x3E, 0x85), # à
    0x00E1: (0x3E, 0xA0), # á
    0x00E2: (0x3E, 0x83), # â
    0x00E3: (0x3E, 0x84), # ã
    0x00E7: (0x3E, 0x87), # ç
    0x00E8: (0x3E, 0x8A), # è
    0x00E9: (0x3E, 0x82), # é
    0x00EA: (0x3E, 0x88), # ê
    0x00EC: (0x3E, 0x8D), # ì
    0x00ED: (0x3E, 0xA1), # í
    0x00F1: (0x3E, 0xA4), # ñ
    0x00F2: (0x3E, 0x95), # ò
    0x00F3: (0x3E, 0xA2), # ó
    0x00F4: (0x3E, 0x93), # ô
    0x00F5: (0x3E, 0x94), # õ
    0x00F7: (0x3E, 0xF6), # ÷
    0x00F9: (0x3E, 0x97), # ù
    0x00FA: (0x3E, 0xA3), # ú
    0x00FC: (0x3E, 0x81), # ü
    0x0393: (0x3E, 0xE2), # Γ
    0x0398: (0x3E, 0xE9), # Θ
    0x03A3: (0x3E, 0xE4), # Σ
    0x03A6: (0x3E, 0xE8), # Φ
    0x03A9: (0x3E, 0xEA), # Ω
    0x03B1: (0x3E, 0xE0), # α
    0x03B4: (0x3E, 0xEB), # δ
    0x03B5: (0x3E, 0xEE), # ε
    0x03BC: (0x3E, 0xE6), # μ
    0x03C0: (0x3E, 0xE3), # π
    0x03C3: (0x3E, 0xE5), # σ
    0x03C4: (0x3E, 0xE7), # τ
    0x03C6: (0x3E, 0xED), # φ
    0x207F: (0x3E, 0xFC), # ⁿ
    0x20A7: (0x3E, 0x9E), # ₧
    0x2219: (0x3E, 0xF9), # ∙
    0x221A: (0x3E, 0xFB), # √
    0x221E: (0x3E, 0xEC), # ∞
    0x2229: (0x3E, 0xEF), # ∩
    0x2248: (0x3E, 0xF7), # ≈
    0x2261: (0x3E, 0xF0), # ≡
    0x2264: (0x3E, 0xF3), # ≤
    0x2265: (0x3E, 0xF2), # ≥
    0x2320: (0x3E, 0xF4), # ⌠
    0x2321: (0x3E, 0xF5), # ⌡
    0x2500: (0x3E, 0xC4), # ─
    0xFFE8: (0x3E, 0xB3), # ￨
    0x2502: (0x3E, 0xB3), # │
    0x250C: (0x3E, 0xDA), # ┌
    0x2510: (0x3E, 0xBF), # ┐
    0x2514: (0x3E, 0xC0), # └
    0x2518: (0x3E, 0xD9), # ┘
    0x251C: (0x3E, 0xC3), # ├
    0x2524: (0x3E, 0xB4), # ┤
    0x252C: (0x3E, 0xC2), # ┬
    0x2534: (0x3E, 0xC1), # ┴
    0x253C: (0x3E, 0xC5), # ┼
    0x2550: (0x3E, 0xCD), # ═
    0x2551: (0x3E, 0xBA), # ║
    0x2552: (0x3E, 0xD5), # ╒
    0x2553: (0x3E, 0xD6), # ╓
    0x2554: (0x3E, 0xC9), # ╔
    0x2555: (0x3E, 0xB8), # ╕
    0x2556: (0x3E, 0xB7), # ╖
    0x2557: (0x3E, 0xBB), # ╗
    0x2558: (0x3E, 0xD4), # ╘
    0x2559: (0x3E, 0xD3), # ╙
    0x255A: (0x3E, 0xC8), # ╚
    0x255B: (0x3E, 0xBE), # ╛
    0x255C: (0x3E, 0xBD), # ╜
    0x255D: (0x3E, 0xBC), # ╝
    0x255E: (0x3E, 0xC6), # ╞
    0x255F: (0x3E, 0xC7), # ╟
    0x2560: (0x3E, 0xCC), # ╠
    0x2561: (0x3E, 0xB5), # ╡
    0x2562: (0x3E, 0xB6), # ╢
    0x2563: (0x3E, 0xB9), # ╣
    0x2564: (0x3E, 0xD1), # ╤
    0x2565: (0x3E, 0xD2), # ╥
    0x2566: (0x3E, 0xCB), # ╦
    0x2567: (0x3E, 0xCF), # ╧
    0x2568: (0x3E, 0xD0), # ╨
    0x2569: (0x3E, 0xCA), # ╩
    0x256A: (0x3E, 0xD8), # ╪
    0x256B: (0x3E, 0xD7), # ╫
    0x256C: (0x3E, 0xCE), # ╬
    0x2580: (0x3E, 0xDF), # ▀
    0x2584: (0x3E, 0xDC), # ▄
    0x2588: (0x3E, 0xDB), # █
    0x258C: (0x3E, 0xDD), # ▌
    0x2590: (0x3E, 0xDE), # ▐
    0x2591: (0x3E, 0xB0), # ░
    0x2592: (0x3E, 0xB1), # ▒
    0x2593: (0x3E, 0xB2), # ▓
    0xFFED: (0x3E, 0xFE), # ￭
    0x25A0: (0x3E, 0xFE), # ■

    # IBM-861 Icelandic
    0x00A0: (0x38, 0xFF), #  
    0x00A1: (0x38, 0xAD), # ¡
    0x00A3: (0x38, 0x9C), # £
    0x00AB: (0x38, 0xAE), # «
    0x00AC: (0x38, 0xAA), # ¬
    0x00B0: (0x38, 0xF8), # °
    0x00B1: (0x38, 0xF1), # ±
    0x00B2: (0x38, 0xFD), # ²
    0x00B7: (0x38, 0xFA), # ·
    0x00BB: (0x38, 0xAF), # »
    0x00BC: (0x38, 0xAC), # ¼
    0x00BD: (0x38, 0xAB), # ½
    0x00BF: (0x38, 0xA8), # ¿
    0x00C1: (0x38, 0xA4), # Á
    0x00C4: (0x38, 0x8E), # Ä
    0x00C5: (0x38, 0x8F), # Å
    0x00C6: (0x38, 0x92), # Æ
    0x00C7: (0x38, 0x80), # Ç
    0x00C9: (0x38, 0x90), # É
    0x00CD: (0x38, 0xA5), # Í
    0x00D0: (0x38, 0x8B), # Ð
    0x00D3: (0x38, 0xA6), # Ó
    0x00D6: (0x38, 0x99), # Ö
    0x00D8: (0x38, 0x9D), # Ø
    0x00DA: (0x38, 0xA7), # Ú
    0x00DC: (0x38, 0x9A), # Ü
    0x00DD: (0x38, 0x97), # Ý
    0x00DE: (0x38, 0x8D), # Þ
    0x00DF: (0x38, 0xE1), # ß
    0x00E0: (0x38, 0x85), # à
    0x00E1: (0x38, 0xA0), # á
    0x00E2: (0x38, 0x83), # â
    0x00E4: (0x38, 0x84), # ä
    0x00E5: (0x38, 0x86), # å
    0x00E6: (0x38, 0x91), # æ
    0x00E7: (0x38, 0x87), # ç
    0x00E8: (0x38, 0x8A), # è
    0x00E9: (0x38, 0x82), # é
    0x00EA: (0x38, 0x88), # ê
    0x00EB: (0x38, 0x89), # ë
    0x00ED: (0x38, 0xA1), # í
    0x00F0: (0x38, 0x8C), # ð
    0x00F3: (0x38, 0xA2), # ó
    0x00F4: (0x38, 0x93), # ô
    0x00F6: (0x38, 0x94), # ö
    0x00F7: (0x38, 0xF6), # ÷
    0x00F8: (0x38, 0x9B), # ø
    0x00FA: (0x38, 0xA3), # ú
    0x00FB: (0x38, 0x96), # û
    0x00FC: (0x38, 0x81), # ü
    0x00FD: (0x38, 0x98), # ý
    0x00FE: (0x38, 0x95), # þ
    0x0192: (0x38, 0x9F), # ƒ
    0x0393: (0x38, 0xE2), # Γ
    0x0398: (0x38, 0xE9), # Θ
    0x03A3: (0x38, 0xE4), # Σ
    0x03A6: (0x38, 0xE8), # Φ
    0x03A9: (0x38, 0xEA), # Ω
    0x03B1: (0x38, 0xE0), # α
    0x03B4: (0x38, 0xEB), # δ
    0x03B5: (0x38, 0xEE), # ε
    0x03BC: (0x38, 0xE6), # μ
    0x03C0: (0x38, 0xE3), # π
    0x03C3: (0x38, 0xE5), # σ
    0x03C4: (0x38, 0xE7), # τ
    0x03C6: (0x38, 0xED), # φ
    0x207F: (0x38, 0xFC), # ⁿ
    0x20A7: (0x38, 0x9E), # ₧
    0x2219: (0x38, 0xF9), # ∙
    0x221A: (0x38, 0xFB), # √
    0x221E: (0x38, 0xEC), # ∞
    0x2229: (0x38, 0xEF), # ∩
    0x2248: (0x38, 0xF7), # ≈
    0x2261: (0x38, 0xF0), # ≡
    0x2264: (0x38, 0xF3), # ≤
    0x2265: (0x38, 0xF2), # ≥
    0x2310: (0x38, 0xA9), # ⌐
    0x2320: (0x38, 0xF4), # ⌠
    0x2321: (0x38, 0xF5), # ⌡
    0x2500: (0x38, 0xC4), # ─
    0xFFE8: (0x38, 0xB3), # ￨
    0x2502: (0x38, 0xB3), # │
    0x250C: (0x38, 0xDA), # ┌
    0x2510: (0x38, 0xBF), # ┐
    0x2514: (0x38, 0xC0), # └
    0x2518: (0x38, 0xD9), # ┘
    0x251C: (0x38, 0xC3), # ├
    0x2524: (0x38, 0xB4), # ┤
    0x252C: (0x38, 0xC2), # ┬
    0x2534: (0x38, 0xC1), # ┴
    0x253C: (0x38, 0xC5), # ┼
    0x2550: (0x38, 0xCD), # ═
    0x2551: (0x38, 0xBA), # ║
    0x2552: (0x38, 0xD5), # ╒
    0x2553: (0x38, 0xD6), # ╓
    0x2554: (0x38, 0xC9), # ╔
    0x2555: (0x38, 0xB8), # ╕
    0x2556: (0x38, 0xB7), # ╖
    0x2557: (0x38, 0xBB), # ╗
    0x2558: (0x38, 0xD4), # ╘
    0x2559: (0x38, 0xD3), # ╙
    0x255A: (0x38, 0xC8), # ╚
    0x255B: (0x38, 0xBE), # ╛
    0x255C: (0x38, 0xBD), # ╜
    0x255D: (0x38, 0xBC), # ╝
    0x255E: (0x38, 0xC6), # ╞
    0x255F: (0x38, 0xC7), # ╟
    0x2560: (0x38, 0xCC), # ╠
    0x2561: (0x38, 0xB5), # ╡
    0x2562: (0x38, 0xB6), # ╢
    0x2563: (0x38, 0xB9), # ╣
    0x2564: (0x38, 0xD1), # ╤
    0x2565: (0x38, 0xD2), # ╥
    0x2566: (0x38, 0xCB), # ╦
    0x2567: (0x38, 0xCF), # ╧
    0x2568: (0x38, 0xD0), # ╨
    0x2569: (0x38, 0xCA), # ╩
    0x256A: (0x38, 0xD8), # ╪
    0x256B: (0x38, 0xD7), # ╫
    0x256C: (0x38, 0xCE), # ╬
    0x2580: (0x38, 0xDF), # ▀
    0x2584: (0x38, 0xDC), # ▄
    0x2588: (0x38, 0xDB), # █
    0x258C: (0x38, 0xDD), # ▌
    0x2590: (0x38, 0xDE), # ▐
    0x2591: (0x38, 0xB0), # ░
    0x2592: (0x38, 0xB1), # ▒
    0x2593: (0x38, 0xB2), # ▓
    0xFFED: (0x38, 0xFE), # ￭
    0x25A0: (0x38, 0xFE), # ■

    # IBM-863 Canadian
    0x00B6: (0x04, 0x86), # ¶
    0x00A7: (0x04, 0x8F), # §
    0x00A0: (0x04, 0xFF), #  
    0x00A2: (0x04, 0x9B), # ¢
    0x00A3: (0x04, 0x9C), # £
    0x00A4: (0x04, 0x98), # ¤
    0x00A6: (0x04, 0xA0), # ¦
    0x00A8: (0x04, 0xA4), # ¨
    0x00AB: (0x04, 0xAE), # «
    0x00AC: (0x04, 0xAA), # ¬
    0x203E: (0x04, 0xA7), # ‾
    0x00AF: (0x04, 0xA7), # ¯
    0x00B0: (0x04, 0xF8), # °
    0x00B1: (0x04, 0xF1), # ±
    0x00B2: (0x04, 0xFD), # ²
    0x00B3: (0x04, 0xA6), # ³
    0x00B4: (0x04, 0xA1), # ´
    0x00B7: (0x04, 0xFA), # ·
    0x00B8: (0x04, 0xA5), # ¸
    0x00BB: (0x04, 0xAF), # »
    0x00BC: (0x04, 0xAC), # ¼
    0x00BD: (0x04, 0xAB), # ½
    0x00BE: (0x04, 0xAD), # ¾
    0x00C0: (0x04, 0x8E), # À
    0x00C2: (0x04, 0x84), # Â
    0x00C7: (0x04, 0x80), # Ç
    0x00C8: (0x04, 0x91), # È
    0x00C9: (0x04, 0x90), # É
    0x00CA: (0x04, 0x92), # Ê
    0x00CB: (0x04, 0x94), # Ë
    0x00CE: (0x04, 0xA8), # Î
    0x00CF: (0x04, 0x95), # Ï
    0x00D4: (0x04, 0x99), # Ô
    0x00D9: (0x04, 0x9D), # Ù
    0x00DB: (0x04, 0x9E), # Û
    0x00DC: (0x04, 0x9A), # Ü
    0x00DF: (0x04, 0xE1), # ß
    0x00E0: (0x04, 0x85), # à
    0x00E2: (0x04, 0x83), # â
    0x00E7: (0x04, 0x87), # ç
    0x00E8: (0x04, 0x8A), # è
    0x00E9: (0x04, 0x82), # é
    0x00EA: (0x04, 0x88), # ê
    0x00EB: (0x04, 0x89), # ë
    0x00EE: (0x04, 0x8C), # î
    0x00EF: (0x04, 0x8B), # ï
    0x00F3: (0x04, 0xA2), # ó
    0x00F4: (0x04, 0x93), # ô
    0x00F7: (0x04, 0xF6), # ÷
    0x00F9: (0x04, 0x97), # ù
    0x00FA: (0x04, 0xA3), # ú
    0x00FB: (0x04, 0x96), # û
    0x00FC: (0x04, 0x81), # ü
    0x0192: (0x04, 0x9F), # ƒ
    0x0393: (0x04, 0xE2), # Γ
    0x0398: (0x04, 0xE9), # Θ
    0x03A3: (0x04, 0xE4), # Σ
    0x03A6: (0x04, 0xE8), # Φ
    0x03A9: (0x04, 0xEA), # Ω
    0x03B1: (0x04, 0xE0), # α
    0x03B4: (0x04, 0xEB), # δ
    0x03B5: (0x04, 0xEE), # ε
    0x03BC: (0x04, 0xE6), # μ
    0x03C0: (0x04, 0xE3), # π
    0x03C3: (0x04, 0xE5), # σ
    0x03C4: (0x04, 0xE7), # τ
    0x03C6: (0x04, 0xED), # φ
    0x2017: (0x04, 0x8D), # ‗
    0x207F: (0x04, 0xFC), # ⁿ
    0x2219: (0x04, 0xF9), # ∙
    0x221A: (0x04, 0xFB), # √
    0x221E: (0x04, 0xEC), # ∞
    0x2229: (0x04, 0xEF), # ∩
    0x2248: (0x04, 0xF7), # ≈
    0x2261: (0x04, 0xF0), # ≡
    0x2264: (0x04, 0xF3), # ≤
    0x2265: (0x04, 0xF2), # ≥
    0x2310: (0x04, 0xA9), # ⌐
    0x2320: (0x04, 0xF4), # ⌠
    0x2321: (0x04, 0xF5), # ⌡
    0x2500: (0x04, 0xC4), # ─
    0xFFE8: (0x04, 0xB3), # ￨
    0x2502: (0x04, 0xB3), # │
    0x250C: (0x04, 0xDA), # ┌
    0x2510: (0x04, 0xBF), # ┐
    0x2514: (0x04, 0xC0), # └
    0x2518: (0x04, 0xD9), # ┘
    0x251C: (0x04, 0xC3), # ├
    0x2524: (0x04, 0xB4), # ┤
    0x252C: (0x04, 0xC2), # ┬
    0x2534: (0x04, 0xC1), # ┴
    0x253C: (0x04, 0xC5), # ┼
    0x2550: (0x04, 0xCD), # ═
    0x2551: (0x04, 0xBA), # ║
    0x2552: (0x04, 0xD5), # ╒
    0x2553: (0x04, 0xD6), # ╓
    0x2554: (0x04, 0xC9), # ╔
    0x2555: (0x04, 0xB8), # ╕
    0x2556: (0x04, 0xB7), # ╖
    0x2557: (0x04, 0xBB), # ╗
    0x2558: (0x04, 0xD4), # ╘
    0x2559: (0x04, 0xD3), # ╙
    0x255A: (0x04, 0xC8), # ╚
    0x255B: (0x04, 0xBE), # ╛
    0x255C: (0x04, 0xBD), # ╜
    0x255D: (0x04, 0xBC), # ╝
    0x255E: (0x04, 0xC6), # ╞
    0x255F: (0x04, 0xC7), # ╟
    0x2560: (0x04, 0xCC), # ╠
    0x2561: (0x04, 0xB5), # ╡
    0x2562: (0x04, 0xB6), # ╢
    0x2563: (0x04, 0xB9), # ╣
    0x2564: (0x04, 0xD1), # ╤
    0x2565: (0x04, 0xD2), # ╥
    0x2566: (0x04, 0xCB), # ╦
    0x2567: (0x04, 0xCF), # ╧
    0x2568: (0x04, 0xD0), # ╨
    0x2569: (0x04, 0xCA), # ╩
    0x256A: (0x04, 0xD8), # ╪
    0x256B: (0x04, 0xD7), # ╫
    0x256C: (0x04, 0xCE), # ╬
    0x2580: (0x04, 0xDF), # ▀
    0x2584: (0x04, 0xDC), # ▄
    0x2588: (0x04, 0xDB), # █
    0x258C: (0x04, 0xDD), # ▌
    0x2590: (0x04, 0xDE), # ▐
    0x2591: (0x04, 0xB0), # ░
    0x2592: (0x04, 0xB1), # ▒
    0x2593: (0x04, 0xB2), # ▓
    0xFFED: (0x04, 0xFE), # ￭
    0x25A0: (0x04, 0xFE), # ■

    # IBM-855 Bulgarian
    0x00A7: (0x3C, 0xFD), # §
    0x00A0: (0x3C, 0xFF), #  
    0x00A4: (0x3C, 0xCF), # ¤
    0x00AB: (0x3C, 0xAE), # «
    0x00AD: (0x3C, 0xF0), # ­
    0x00BB: (0x3C, 0xAF), # »
    0x0401: (0x3C, 0x85), # Ё
    0x0402: (0x3C, 0x81), # Ђ
    0x0403: (0x3C, 0x83), # Ѓ
    0x0404: (0x3C, 0x87), # Є
    0x0405: (0x3C, 0x89), # Ѕ
    0x0406: (0x3C, 0x8B), # І
    0x0407: (0x3C, 0x8D), # Ї
    0x0408: (0x3C, 0x8F), # Ј
    0x0409: (0x3C, 0x91), # Љ
    0x040A: (0x3C, 0x93), # Њ
    0x040B: (0x3C, 0x95), # Ћ
    0x040C: (0x3C, 0x97), # Ќ
    0x040E: (0x3C, 0x99), # Ў
    0x040F: (0x3C, 0x9B), # Џ
    0x0410: (0x3C, 0xA1), # А
    0x0411: (0x3C, 0xA3), # Б
    0x0412: (0x3C, 0xEC), # В
    0x0413: (0x3C, 0xAD), # Г
    0x0414: (0x3C, 0xA7), # Д
    0x0415: (0x3C, 0xA9), # Е
    0x0416: (0x3C, 0xEA), # Ж
    0x0417: (0x3C, 0xF4), # З
    0x0418: (0x3C, 0xB8), # И
    0x0419: (0x3C, 0xBE), # Й
    0x041A: (0x3C, 0xC7), # К
    0x041B: (0x3C, 0xD1), # Л
    0x041C: (0x3C, 0xD3), # М
    0x041D: (0x3C, 0xD5), # Н
    0x041E: (0x3C, 0xD7), # О
    0x041F: (0x3C, 0xDD), # П
    0x0420: (0x3C, 0xE2), # Р
    0x0421: (0x3C, 0xE4), # С
    0x0422: (0x3C, 0xE6), # Т
    0x0423: (0x3C, 0xE8), # У
    0x0424: (0x3C, 0xAB), # Ф
    0x0425: (0x3C, 0xB6), # Х
    0x0426: (0x3C, 0xA5), # Ц
    0x0427: (0x3C, 0xFC), # Ч
    0x0428: (0x3C, 0xF6), # Ш
    0x0429: (0x3C, 0xFA), # Щ
    0x042A: (0x3C, 0x9F), # Ъ
    0x042B: (0x3C, 0xF2), # Ы
    0x042C: (0x3C, 0xEE), # Ь
    0x042D: (0x3C, 0xF8), # Э
    0x042E: (0x3C, 0x9D), # Ю
    0x042F: (0x3C, 0xE0), # Я
    0x0430: (0x3C, 0xA0), # а
    0x0431: (0x3C, 0xA2), # б
    0x0432: (0x3C, 0xEB), # в
    0x0433: (0x3C, 0xAC), # г
    0x0434: (0x3C, 0xA6), # д
    0x0435: (0x3C, 0xA8), # е
    0x0436: (0x3C, 0xE9), # ж
    0x0437: (0x3C, 0xF3), # з
    0x0438: (0x3C, 0xB7), # и
    0x0439: (0x3C, 0xBD), # й
    0x043A: (0x3C, 0xC6), # к
    0x043B: (0x3C, 0xD0), # л
    0x043C: (0x3C, 0xD2), # м
    0x043D: (0x3C, 0xD4), # н
    0x043E: (0x3C, 0xD6), # о
    0x043F: (0x3C, 0xD8), # п
    0x0440: (0x3C, 0xE1), # р
    0x0441: (0x3C, 0xE3), # с
    0x0442: (0x3C, 0xE5), # т
    0x0443: (0x3C, 0xE7), # у
    0x0444: (0x3C, 0xAA), # ф
    0x0445: (0x3C, 0xB5), # х
    0x0446: (0x3C, 0xA4), # ц
    0x0447: (0x3C, 0xFB), # ч
    0x0448: (0x3C, 0xF5), # ш
    0x0449: (0x3C, 0xF9), # щ
    0x044A: (0x3C, 0x9E), # ъ
    0x044B: (0x3C, 0xF1), # ы
    0x044C: (0x3C, 0xED), # ь
    0x044D: (0x3C, 0xF7), # э
    0x044E: (0x3C, 0x9C), # ю
    0x044F: (0x3C, 0xDE), # я
    0x0451: (0x3C, 0x84), # ё
    0x0452: (0x3C, 0x80), # ђ
    0x0453: (0x3C, 0x82), # ѓ
    0x0454: (0x3C, 0x86), # є
    0x0455: (0x3C, 0x88), # ѕ
    0x0456: (0x3C, 0x8A), # і
    0x0457: (0x3C, 0x8C), # ї
    0x0458: (0x3C, 0x8E), # ј
    0x0459: (0x3C, 0x90), # љ
    0x045A: (0x3C, 0x92), # њ
    0x045B: (0x3C, 0x94), # ћ
    0x045C: (0x3C, 0x96), # ќ
    0x045E: (0x3C, 0x98), # ў
    0x045F: (0x3C, 0x9A), # џ
    0x2116: (0x3C, 0xEF), # №
    0x2500: (0x3C, 0xC4), # ─
    0xFFE8: (0x3C, 0xB3), # ￨
    0x2502: (0x3C, 0xB3), # │
    0x250C: (0x3C, 0xDA), # ┌
    0x2510: (0x3C, 0xBF), # ┐
    0x2514: (0x3C, 0xC0), # └
    0x2518: (0x3C, 0xD9), # ┘
    0x251C: (0x3C, 0xC3), # ├
    0x2524: (0x3C, 0xB4), # ┤
    0x252C: (0x3C, 0xC2), # ┬
    0x2534: (0x3C, 0xC1), # ┴
    0x253C: (0x3C, 0xC5), # ┼
    0x2550: (0x3C, 0xCD), # ═
    0x2551: (0x3C, 0xBA), # ║
    0x2554: (0x3C, 0xC9), # ╔
    0x2557: (0x3C, 0xBB), # ╗
    0x255A: (0x3C, 0xC8), # ╚
    0x255D: (0x3C, 0xBC), # ╝
    0x2560: (0x3C, 0xCC), # ╠
    0x2563: (0x3C, 0xB9), # ╣
    0x2566: (0x3C, 0xCB), # ╦
    0x2569: (0x3C, 0xCA), # ╩
    0x256C: (0x3C, 0xCE), # ╬
    0x2580: (0x3C, 0xDF), # ▀
    0x2584: (0x3C, 0xDC), # ▄
    0x2588: (0x3C, 0xDB), # █
    0x2591: (0x3C, 0xB0), # ░
    0x2592: (0x3C, 0xB1), # ▒
    0x2593: (0x3C, 0xB2), # ▓
    0xFFED: (0x3C, 0xFE), # ￭
    0x25A0: (0x3C, 0xFE), # ■

    # IBM-857 Turkey
    0x00B6: (0x3D, 0xF4), # ¶
    0x00A7: (0x3D, 0xF5), # §
    0x00A0: (0x3D, 0xFF), #  
    0x00A1: (0x3D, 0xAD), # ¡
    0x00A2: (0x3D, 0xBD), # ¢
    0x00A3: (0x3D, 0x9C), # £
    0x00A4: (0x3D, 0xCF), # ¤
    0x00A5: (0x3D, 0xBE), # ¥
    0x00A6: (0x3D, 0xDD), # ¦
    0x00A8: (0x3D, 0xF9), # ¨
    0x00A9: (0x3D, 0xB8), # ©
    0x00AA: (0x3D, 0xD1), # ª
    0x00AB: (0x3D, 0xAE), # «
    0x00AC: (0x3D, 0xAA), # ¬
    0x00AD: (0x3D, 0xF0), # ­
    0x00AE: (0x3D, 0xA9), # ®
    0x203E: (0x3D, 0xEE), # ‾
    0x00AF: (0x3D, 0xEE), # ¯
    0x00B0: (0x3D, 0xF8), # °
    0x00B1: (0x3D, 0xF1), # ±
    0x00B2: (0x3D, 0xFD), # ²
    0x00B3: (0x3D, 0xFC), # ³
    0x00B4: (0x3D, 0xEF), # ´
    0x00B5: (0x3D, 0xE6), # µ
    0x00B7: (0x3D, 0xFA), # ·
    0x00B8: (0x3D, 0xF7), # ¸
    0x00B9: (0x3D, 0xFB), # ¹
    0x00BA: (0x3D, 0xD0), # º
    0x00BB: (0x3D, 0xAF), # »
    0x00BC: (0x3D, 0xAC), # ¼
    0x00BD: (0x3D, 0xAB), # ½
    0x00BE: (0x3D, 0xF3), # ¾
    0x00BF: (0x3D, 0xA8), # ¿
    0x00C0: (0x3D, 0xB7), # À
    0x00C1: (0x3D, 0xB5), # Á
    0x00C2: (0x3D, 0xB6), # Â
    0x00C3: (0x3D, 0xC7), # Ã
    0x00C4: (0x3D, 0x8E), # Ä
    0x00C5: (0x3D, 0x8F), # Å
    0x00C6: (0x3D, 0x92), # Æ
    0x00C7: (0x3D, 0x80), # Ç
    0x00C8: (0x3D, 0xD4), # È
    0x00C9: (0x3D, 0x90), # É
    0x00CA: (0x3D, 0xD2), # Ê
    0x00CB: (0x3D, 0xD3), # Ë
    0x00CC: (0x3D, 0xDE), # Ì
    0x00CD: (0x3D, 0xD6), # Í
    0x00CE: (0x3D, 0xD7), # Î
    0x00CF: (0x3D, 0xD8), # Ï
    0x00D1: (0x3D, 0xA5), # Ñ
    0x00D2: (0x3D, 0xE3), # Ò
    0x00D3: (0x3D, 0xE0), # Ó
    0x00D4: (0x3D, 0xE2), # Ô
    0x00D5: (0x3D, 0xE5), # Õ
    0x00D6: (0x3D, 0x99), # Ö
    0x00D7: (0x3D, 0xE8), # ×
    0x00D8: (0x3D, 0x9D), # Ø
    0x00D9: (0x3D, 0xEB), # Ù
    0x00DA: (0x3D, 0xE9), # Ú
    0x00DB: (0x3D, 0xEA), # Û
    0x00DC: (0x3D, 0x9A), # Ü
    0x00DF: (0x3D, 0xE1), # ß
    0x00E0: (0x3D, 0x85), # à
    0x00E1: (0x3D, 0xA0), # á
    0x00E2: (0x3D, 0x83), # â
    0x00E3: (0x3D, 0xC6), # ã
    0x00E4: (0x3D, 0x84), # ä
    0x00E5: (0x3D, 0x86), # å
    0x00E6: (0x3D, 0x91), # æ
    0x00E7: (0x3D, 0x87), # ç
    0x00E8: (0x3D, 0x8A), # è
    0x00E9: (0x3D, 0x82), # é
    0x00EA: (0x3D, 0x88), # ê
    0x00EB: (0x3D, 0x89), # ë
    0x00EC: (0x3D, 0xEC), # ì
    0x00ED: (0x3D, 0xA1), # í
    0x00EE: (0x3D, 0x8C), # î
    0x00EF: (0x3D, 0x8B), # ï
    0x00F1: (0x3D, 0xA4), # ñ
    0x00F2: (0x3D, 0x95), # ò
    0x00F3: (0x3D, 0xA2), # ó
    0x00F4: (0x3D, 0x93), # ô
    0x00F5: (0x3D, 0xE4), # õ
    0x00F6: (0x3D, 0x94), # ö
    0x00F7: (0x3D, 0xF6), # ÷
    0x00F8: (0x3D, 0x9B), # ø
    0x00F9: (0x3D, 0x97), # ù
    0x00FA: (0x3D, 0xA3), # ú
    0x00FB: (0x3D, 0x96), # û
    0x00FC: (0x3D, 0x81), # ü
    0x00FF: (0x3D, 0xED), # ÿ
    0x011E: (0x3D, 0xA6), # Ğ
    0x011F: (0x3D, 0xA7), # ğ
    0x0130: (0x3D, 0x98), # İ
    0x0131: (0x3D, 0x8D), # ı
    0x015E: (0x3D, 0x9E), # Ş
    0x015F: (0x3D, 0x9F), # ş
    0x2500: (0x3D, 0xC4), # ─
    0xFFE8: (0x3D, 0xB3), # ￨
    0x2502: (0x3D, 0xB3), # │
    0x250C: (0x3D, 0xDA), # ┌
    0x2510: (0x3D, 0xBF), # ┐
    0x2514: (0x3D, 0xC0), # └
    0x2518: (0x3D, 0xD9), # ┘
    0x251C: (0x3D, 0xC3), # ├
    0x2524: (0x3D, 0xB4), # ┤
    0x252C: (0x3D, 0xC2), # ┬
    0x2534: (0x3D, 0xC1), # ┴
    0x253C: (0x3D, 0xC5), # ┼
    0x2550: (0x3D, 0xCD), # ═
    0x2551: (0x3D, 0xBA), # ║
    0x2554: (0x3D, 0xC9), # ╔
    0x2557: (0x3D, 0xBB), # ╗
    0x255A: (0x3D, 0xC8), # ╚
    0x255D: (0x3D, 0xBC), # ╝
    0x2560: (0x3D, 0xCC), # ╠
    0x2563: (0x3D, 0xB9), # ╣
    0x2566: (0x3D, 0xCB), # ╦
    0x2569: (0x3D, 0xCA), # ╩
    0x256C: (0x3D, 0xCE), # ╬
    0x2580: (0x3D, 0xDF), # ▀
    0x2584: (0x3D, 0xDC), # ▄
    0x2588: (0x3D, 0xDB), # █
    0x2591: (0x3D, 0xB0), # ░
    0x2592: (0x3D, 0xB1), # ▒
    0x2593: (0x3D, 0xB2), # ▓
    0xFFED: (0x3D, 0xFE), # ￭
    0x25A0: (0x3D, 0xFE), # ■

    # IBM-851 Greek
    0x00A7: (0x41, 0xF5), # §
    0x00A0: (0x41, 0xFF), #  
    0x00A3: (0x41, 0x9C), # £
    0x00A8: (0x41, 0xF9), # ¨
    0x00AB: (0x41, 0xAE), # «
    0x00AD: (0x41, 0xF0), # ­
    0x00B0: (0x41, 0xF8), # °
    0x00B1: (0x41, 0xF1), # ±
    0x00B4: (0x41, 0xEF), # ´
    0x00B8: (0x41, 0xF7), # ¸
    0x00BB: (0x41, 0xAF), # »
    0x00BD: (0x41, 0xAB), # ½
    0x00C4: (0x41, 0x8E), # Ä
    0x00C7: (0x41, 0x80), # Ç
    0x00D6: (0x41, 0x99), # Ö
    0x00DC: (0x41, 0x9A), # Ü
    0x00E0: (0x41, 0x85), # à
    0x00E2: (0x41, 0x83), # â
    0x00E4: (0x41, 0x84), # ä
    0x00E7: (0x41, 0x87), # ç
    0x00E8: (0x41, 0x8A), # è
    0x00E9: (0x41, 0x82), # é
    0x00EA: (0x41, 0x88), # ê
    0x00EB: (0x41, 0x89), # ë
    0x00EE: (0x41, 0x8C), # î
    0x00EF: (0x41, 0x8B), # ï
    0x00F4: (0x41, 0x93), # ô
    0x00F6: (0x41, 0x94), # ö
    0x00F9: (0x41, 0x97), # ù
    0x00FB: (0x41, 0x96), # û
    0x00FC: (0x41, 0x81), # ü
    0x0386: (0x41, 0x86), # Ά
    0x0388: (0x41, 0x8D), # Έ
    0x0389: (0x41, 0x8F), # Ή
    0x038A: (0x41, 0x90), # Ί
    0x038C: (0x41, 0x92), # Ό
    0x038E: (0x41, 0x95), # Ύ
    0x038F: (0x41, 0x98), # Ώ
    0x0390: (0x41, 0xA1), # ΐ
    0x0391: (0x41, 0xA4), # Α
    0x0392: (0x41, 0xA5), # Β
    0x0393: (0x41, 0xA6), # Γ
    0x0394: (0x41, 0xA7), # Δ
    0x0395: (0x41, 0xA8), # Ε
    0x0396: (0x41, 0xA9), # Ζ
    0x0397: (0x41, 0xAA), # Η
    0x0398: (0x41, 0xAC), # Θ
    0x0399: (0x41, 0xAD), # Ι
    0x039A: (0x41, 0xB5), # Κ
    0x039B: (0x41, 0xB6), # Λ
    0x039C: (0x41, 0xB7), # Μ
    0x039D: (0x41, 0xB8), # Ν
    0x039E: (0x41, 0xBD), # Ξ
    0x039F: (0x41, 0xBE), # Ο
    0x03A0: (0x41, 0xC6), # Π
    0x03A1: (0x41, 0xC7), # Ρ
    0x03A3: (0x41, 0xCF), # Σ
    0x03A4: (0x41, 0xD0), # Τ
    0x03A5: (0x41, 0xD1), # Υ
    0x03A6: (0x41, 0xD2), # Φ
    0x03A7: (0x41, 0xD3), # Χ
    0x03A8: (0x41, 0xD4), # Ψ
    0x03A9: (0x41, 0xD5), # Ω
    0x03AC: (0x41, 0x9B), # ά
    0x03AD: (0x41, 0x9D), # έ
    0x03AE: (0x41, 0x9E), # ή
    0x03AF: (0x41, 0x9F), # ί
    0x03B0: (0x41, 0xFC), # ΰ
    0x03B1: (0x41, 0xD6), # α
    0x03B2: (0x41, 0xD7), # β
    0x03B3: (0x41, 0xD8), # γ
    0x03B4: (0x41, 0xDD), # δ
    0x03B5: (0x41, 0xDE), # ε
    0x03B6: (0x41, 0xE0), # ζ
    0x03B7: (0x41, 0xE1), # η
    0x03B8: (0x41, 0xE2), # θ
    0x03B9: (0x41, 0xE3), # ι
    0x03BA: (0x41, 0xE4), # κ
    0x03BB: (0x41, 0xE5), # λ
    0x03BC: (0x41, 0xE6), # μ
    0x03BD: (0x41, 0xE7), # ν
    0x03BE: (0x41, 0xE8), # ξ
    0x03BF: (0x41, 0xE9), # ο
    0x03C0: (0x41, 0xEA), # π
    0x03C1: (0x41, 0xEB), # ρ
    0x03C2: (0x41, 0xED), # ς
    0x03C3: (0x41, 0xEC), # σ
    0x03C4: (0x41, 0xEE), # τ
    0x03C5: (0x41, 0xF2), # υ
    0x03D5: (0x41, 0xF3), # ϕ
    0x03C6: (0x41, 0xF3), # φ
    0x03C7: (0x41, 0xF4), # χ
    0x03C8: (0x41, 0xF6), # ψ
    0x03C9: (0x41, 0xFA), # ω
    0x03CA: (0x41, 0xA0), # ϊ
    0x03CB: (0x41, 0xFB), # ϋ
    0x03CC: (0x41, 0xA2), # ό
    0x03CD: (0x41, 0xA3), # ύ
    0x03CE: (0x41, 0xFD), # ώ
    0x2500: (0x41, 0xC4), # ─
    0xFFE8: (0x41, 0xB3), # ￨
    0x2502: (0x41, 0xB3), # │
    0x250C: (0x41, 0xDA), # ┌
    0x2510: (0x41, 0xBF), # ┐
    0x2514: (0x41, 0xC0), # └
    0x2518: (0x41, 0xD9), # ┘
    0x251C: (0x41, 0xC3), # ├
    0x2524: (0x41, 0xB4), # ┤
    0x252C: (0x41, 0xC2), # ┬
    0x2534: (0x41, 0xC1), # ┴
    0x253C: (0x41, 0xC5), # ┼
    0x2550: (0x41, 0xCD), # ═
    0x2551: (0x41, 0xBA), # ║
    0x2554: (0x41, 0xC9), # ╔
    0x2557: (0x41, 0xBB), # ╗
    0x255A: (0x41, 0xC8), # ╚
    0x255D: (0x41, 0xBC), # ╝
    0x2560: (0x41, 0xCC), # ╠
    0x2563: (0x41, 0xB9), # ╣
    0x2566: (0x41, 0xCB), # ╦
    0x2569: (0x41, 0xCA), # ╩
    0x256C: (0x41, 0xCE), # ╬
    0x2580: (0x41, 0xDF), # ▀
    0x2584: (0x41, 0xDC), # ▄
    0x2588: (0x41, 0xDB), # █
    0x2591: (0x41, 0xB0), # ░
    0x2592: (0x41, 0xB1), # ▒
    0x2593: (0x41, 0xB2), # ▓
    0xFFED: (0x41, 0xFE), # ￭
    0x25A0: (0x41, 0xFE), # ■

    # IBM-869 Greek
    0x00A7: (0x42, 0xF5), # §
    0x00A0: (0x42, 0xFF), #  
    0x00A3: (0x42, 0x9C), # £
    0x00A6: (0x42, 0x8A), # ¦
    0x00A8: (0x42, 0xF9), # ¨
    0x00A9: (0x42, 0x97), # ©
    0x00AB: (0x42, 0xAE), # «
    0x00AC: (0x42, 0x89), # ¬
    0x00AD: (0x42, 0xF0), # ­
    0x00B0: (0x42, 0xF8), # °
    0x00B1: (0x42, 0xF1), # ±
    0x00B2: (0x42, 0x99), # ²
    0x00B3: (0x42, 0x9A), # ³
    0x00B4: (0x42, 0xEF), # ´
    0x00B7: (0x42, 0x88), # ·
    0x0387: (0x42, 0x88), # ·
    0x00BB: (0x42, 0xAF), # »
    0x00BD: (0x42, 0xAB), # ½
    0x0385: (0x42, 0xF7), # ΅
    0x0386: (0x42, 0x86), # Ά
    0x0388: (0x42, 0x8D), # Έ
    0x0389: (0x42, 0x8F), # Ή
    0x038A: (0x42, 0x90), # Ί
    0x038C: (0x42, 0x92), # Ό
    0x038E: (0x42, 0x95), # Ύ
    0x038F: (0x42, 0x98), # Ώ
    0x0390: (0x42, 0xA1), # ΐ
    0x0391: (0x42, 0xA4), # Α
    0x0392: (0x42, 0xA5), # Β
    0x0393: (0x42, 0xA6), # Γ
    0x0394: (0x42, 0xA7), # Δ
    0x0395: (0x42, 0xA8), # Ε
    0x0396: (0x42, 0xA9), # Ζ
    0x0397: (0x42, 0xAA), # Η
    0x0398: (0x42, 0xAC), # Θ
    0x0399: (0x42, 0xAD), # Ι
    0x039A: (0x42, 0xB5), # Κ
    0x039B: (0x42, 0xB6), # Λ
    0x039C: (0x42, 0xB7), # Μ
    0x039D: (0x42, 0xB8), # Ν
    0x039E: (0x42, 0xBD), # Ξ
    0x039F: (0x42, 0xBE), # Ο
    0x03A0: (0x42, 0xC6), # Π
    0x03A1: (0x42, 0xC7), # Ρ
    0x03A3: (0x42, 0xCF), # Σ
    0x03A4: (0x42, 0xD0), # Τ
    0x03A5: (0x42, 0xD1), # Υ
    0x03A6: (0x42, 0xD2), # Φ
    0x03A7: (0x42, 0xD3), # Χ
    0x03A8: (0x42, 0xD4), # Ψ
    0x03A9: (0x42, 0xD5), # Ω
    0x03AA: (0x42, 0x91), # Ϊ
    0x03AB: (0x42, 0x96), # Ϋ
    0x03AC: (0x42, 0x9B), # ά
    0x03AD: (0x42, 0x9D), # έ
    0x03AE: (0x42, 0x9E), # ή
    0x03AF: (0x42, 0x9F), # ί
    0x03B0: (0x42, 0xFC), # ΰ
    0x03B1: (0x42, 0xD6), # α
    0x03B2: (0x42, 0xD7), # β
    0x03B3: (0x42, 0xD8), # γ
    0x03B4: (0x42, 0xDD), # δ
    0x03B5: (0x42, 0xDE), # ε
    0x03B6: (0x42, 0xE0), # ζ
    0x03B7: (0x42, 0xE1), # η
    0x03B8: (0x42, 0xE2), # θ
    0x03B9: (0x42, 0xE3), # ι
    0x03BA: (0x42, 0xE4), # κ
    0x03BB: (0x42, 0xE5), # λ
    0x03BC: (0x42, 0xE6), # μ
    0x03BD: (0x42, 0xE7), # ν
    0x03BE: (0x42, 0xE8), # ξ
    0x03BF: (0x42, 0xE9), # ο
    0x03C0: (0x42, 0xEA), # π
    0x03C1: (0x42, 0xEB), # ρ
    0x03C2: (0x42, 0xED), # ς
    0x03C3: (0x42, 0xEC), # σ
    0x03C4: (0x42, 0xEE), # τ
    0x03C5: (0x42, 0xF2), # υ
    0x03D5: (0x42, 0xF3), # ϕ
    0x03C6: (0x42, 0xF3), # φ
    0x03C7: (0x42, 0xF4), # χ
    0x03C8: (0x42, 0xF6), # ψ
    0x03C9: (0x42, 0xFA), # ω
    0x03CA: (0x42, 0xA0), # ϊ
    0x03CB: (0x42, 0xFB), # ϋ
    0x03CC: (0x42, 0xA2), # ό
    0x03CD: (0x42, 0xA3), # ύ
    0x03CE: (0x42, 0xFD), # ώ
    0x2015: (0x42, 0x8E), # ―
    0x2018: (0x42, 0x8B), # ‘
    0x2019: (0x42, 0x8C), # ’
    0x2500: (0x42, 0xC4), # ─
    0xFFE8: (0x42, 0xB3), # ￨
    0x2502: (0x42, 0xB3), # │
    0x250C: (0x42, 0xDA), # ┌
    0x2510: (0x42, 0xBF), # ┐
    0x2514: (0x42, 0xC0), # └
    0x2518: (0x42, 0xD9), # ┘
    0x251C: (0x42, 0xC3), # ├
    0x2524: (0x42, 0xB4), # ┤
    0x252C: (0x42, 0xC2), # ┬
    0x2534: (0x42, 0xC1), # ┴
    0x253C: (0x42, 0xC5), # ┼
    0x2550: (0x42, 0xCD), # ═
    0x2551: (0x42, 0xBA), # ║
    0x2554: (0x42, 0xC9), # ╔
    0x2557: (0x42, 0xBB), # ╗
    0x255A: (0x42, 0xC8), # ╚
    0x255D: (0x42, 0xBC), # ╝
    0x2560: (0x42, 0xCC), # ╠
    0x2563: (0x42, 0xB9), # ╣
    0x2566: (0x42, 0xCB), # ╦
    0x2569: (0x42, 0xCA), # ╩
    0x256C: (0x42, 0xCE), # ╬
    0x2580: (0x42, 0xDF), # ▀
    0x2584: (0x42, 0xDC), # ▄
    0x2588: (0x42, 0xDB), # █
    0x2591: (0x42, 0xB0), # ░
    0x2592: (0x42, 0xB1), # ▒
    0x2593: (0x42, 0xB2), # ▓
    0xFFED: (0x42, 0xFE), # ￭
    0x25A0: (0x42, 0xFE), # ■

    # IBM-1253 Greek
    0x00A0: (0x5A, 0xA0), #  
    0x00A3: (0x5A, 0xA3), # £
    0x00A4: (0x5A, 0xA4), # ¤
    0x00A5: (0x5A, 0xA5), # ¥
    0x00A6: (0x5A, 0xA6), # ¦
    0x00A7: (0x5A, 0xA7), # §
    0x00A8: (0x5A, 0xA8), # ¨
    0x00A9: (0x5A, 0xA9), # ©
    0x00AA: (0x5A, 0xAA), # ª
    0x00AB: (0x5A, 0xAB), # «
    0x00AC: (0x5A, 0xAC), # ¬
    0x00AD: (0x5A, 0xAD), # ­
    0x00AE: (0x5A, 0xAE), # ®
    0x00B0: (0x5A, 0xB0), # °
    0x00B1: (0x5A, 0xB1), # ±
    0x00B2: (0x5A, 0xB2), # ²
    0x00B3: (0x5A, 0xB3), # ³
    0x00B5: (0x5A, 0xB5), # µ
    0x00B6: (0x5A, 0xB6), # ¶
    0x00B7: (0x5A, 0xB7), # ·
    0x00BB: (0x5A, 0xBB), # »
    0x00BD: (0x5A, 0xBD), # ½
    0x0192: (0x5A, 0x83), # ƒ
    0x0384: (0x5A, 0xB4), # ΄
    0x0385: (0x5A, 0xA1), # ΅
    0x0386: (0x5A, 0xA2), # Ά
    0x0388: (0x5A, 0xB8), # Έ
    0x0389: (0x5A, 0xB9), # Ή
    0x038A: (0x5A, 0xBA), # Ί
    0x038C: (0x5A, 0xBC), # Ό
    0x038E: (0x5A, 0xBE), # Ύ
    0x038F: (0x5A, 0xBF), # Ώ
    0x0390: (0x5A, 0xC0), # ΐ
    0x0391: (0x5A, 0xC1), # Α
    0x0392: (0x5A, 0xC2), # Β
    0x0393: (0x5A, 0xC3), # Γ
    0x0394: (0x5A, 0xC4), # Δ
    0x0395: (0x5A, 0xC5), # Ε
    0x0396: (0x5A, 0xC6), # Ζ
    0x0397: (0x5A, 0xC7), # Η
    0x0398: (0x5A, 0xC8), # Θ
    0x0399: (0x5A, 0xC9), # Ι
    0x039A: (0x5A, 0xCA), # Κ
    0x039B: (0x5A, 0xCB), # Λ
    0x039C: (0x5A, 0xCC), # Μ
    0x039D: (0x5A, 0xCD), # Ν
    0x039E: (0x5A, 0xCE), # Ξ
    0x039F: (0x5A, 0xCF), # Ο
    0x03A0: (0x5A, 0xD0), # Π
    0x03A1: (0x5A, 0xD1), # Ρ
    0x03A3: (0x5A, 0xD3), # Σ
    0x03A4: (0x5A, 0xD4), # Τ
    0x03A5: (0x5A, 0xD5), # Υ
    0x03A6: (0x5A, 0xD6), # Φ
    0x03A7: (0x5A, 0xD7), # Χ
    0x03A8: (0x5A, 0xD8), # Ψ
    0x03A9: (0x5A, 0xD9), # Ω
    0x03AA: (0x5A, 0xDA), # Ϊ
    0x03AB: (0x5A, 0xDB), # Ϋ
    0x03AC: (0x5A, 0xDC), # ά
    0x03AD: (0x5A, 0xDD), # έ
    0x03AE: (0x5A, 0xDE), # ή
    0x03AF: (0x5A, 0xDF), # ί
    0x03B0: (0x5A, 0xE0), # ΰ
    0x03B1: (0x5A, 0xE1), # α
    0x03B2: (0x5A, 0xE2), # β
    0x03B3: (0x5A, 0xE3), # γ
    0x03B4: (0x5A, 0xE4), # δ
    0x03B5: (0x5A, 0xE5), # ε
    0x03B6: (0x5A, 0xE6), # ζ
    0x03B7: (0x5A, 0xE7), # η
    0x03B8: (0x5A, 0xE8), # θ
    0x03B9: (0x5A, 0xE9), # ι
    0x03BA: (0x5A, 0xEA), # κ
    0x03BB: (0x5A, 0xEB), # λ
    0x03BC: (0x5A, 0xEC), # μ
    0x03BD: (0x5A, 0xED), # ν
    0x03BE: (0x5A, 0xEE), # ξ
    0x03BF: (0x5A, 0xEF), # ο
    0x03C0: (0x5A, 0xF0), # π
    0x03C1: (0x5A, 0xF1), # ρ
    0x03C2: (0x5A, 0xF2), # ς
    0x03C3: (0x5A, 0xF3), # σ
    0x03C4: (0x5A, 0xF4), # τ
    0x03C5: (0x5A, 0xF5), # υ
    0x03D5: (0x5A, 0xF6), # ϕ
    0x03C6: (0x5A, 0xF6), # φ
    0x03C7: (0x5A, 0xF7), # χ
    0x03C8: (0x5A, 0xF8), # ψ
    0x03C9: (0x5A, 0xF9), # ω
    0x03CA: (0x5A, 0xFA), # ϊ
    0x03CB: (0x5A, 0xFB), # ϋ
    0x03CC: (0x5A, 0xFC), # ό
    0x03CD: (0x5A, 0xFD), # ύ
    0x03CE: (0x5A, 0xFE), # ώ
    # 0x2013: (0x5A, 0x96), # –
    # 0x2014: (0x5A, 0x97), # —
    0x2015: (0x5A, 0xAF), # ―
    0x2018: (0x5A, 0x91), # ‘
    0x2019: (0x5A, 0x92), # ’
    0x201A: (0x5A, 0x82), # ‚
    0x201C: (0x5A, 0x93), # “
    0x201D: (0x5A, 0x94), # ”
    0x201E: (0x5A, 0x84), # „
    0x2020: (0x5A, 0x86), # †
    0x2021: (0x5A, 0x87), # ‡
    0x2022: (0x5A, 0x95), # •
    0x2026: (0x5A, 0x85), # …
    0x2030: (0x5A, 0x89), # ‰
    0x2039: (0x5A, 0x8B), # ‹
    0x203A: (0x5A, 0x9B), # ›
    0x2329: (0x5A, 0x8B), # 〈
    0x232A: (0x5A, 0x9B), # 〉
    0x27E8: (0x5A, 0x8B), # ⟨
    0x27E9: (0x5A, 0x9B), # ⟩
    0x2122: (0x5A, 0x99), # ™


    # IBM-1254 Turkish
    0x00A1: (0x5B, 0xA1), # ¡
    0x00A2: (0x5B, 0xA2), # ¢
    0x00A3: (0x5B, 0xA3), # £
    0x00A4: (0x5B, 0xA4), # ¤
    0x00A5: (0x5B, 0xA5), # ¥
    0x00A6: (0x5B, 0xA6), # ¦
    0x00A7: (0x5B, 0xA7), # §
    0x00A8: (0x5B, 0xA8), # ¨
    0x00A9: (0x5B, 0xA9), # ©
    0x00AA: (0x5B, 0xAA), # ª
    0x00AB: (0x5B, 0xAB), # «
    0x00AC: (0x5B, 0xAC), # ¬
    0x00AD: (0x5B, 0xAD), # ­
    0x00AE: (0x5B, 0xAE), # ®
    0x00AF: (0x5B, 0xAF), # ¯
    0x00B0: (0x5B, 0xB0), # °
    0x00B1: (0x5B, 0xB1), # ±
    0x00B2: (0x5B, 0xB2), # ²
    0x00B3: (0x5B, 0xB3), # ³
    0x00B4: (0x5B, 0xB4), # ´
    0x00B5: (0x5B, 0xB5), # µ
    0x00B6: (0x5B, 0xB6), # ¶
    0x00B7: (0x5B, 0xB7), # ·
    0x00B8: (0x5B, 0xB8), # ¸
    0x00B9: (0x5B, 0xB9), # ¹
    0x00BA: (0x5B, 0xBA), # º
    0x00BB: (0x5B, 0xBB), # »
    0x00BC: (0x5B, 0xBC), # ¼
    0x00BD: (0x5B, 0xBD), # ½
    0x00BE: (0x5B, 0xBE), # ¾
    0x00BF: (0x5B, 0xBF), # ¿
    0x00C0: (0x5B, 0xC0), # À
    0x00C1: (0x5B, 0xC1), # Á
    0x00C2: (0x5B, 0xC2), # Â
    0x00C3: (0x5B, 0xC3), # Ã
    0x00C4: (0x5B, 0xC4), # Ä
    0x00C5: (0x5B, 0xC5), # Å
    0x00C6: (0x5B, 0xC6), # Æ
    0x00C7: (0x5B, 0xC7), # Ç
    0x00C8: (0x5B, 0xC8), # È
    0x00C9: (0x5B, 0xC9), # É
    0x00CA: (0x5B, 0xCA), # Ê
    0x00CB: (0x5B, 0xCB), # Ë
    0x00CC: (0x5B, 0xCC), # Ì
    0x00CD: (0x5B, 0xCD), # Í
    0x00CE: (0x5B, 0xCE), # Î
    0x00CF: (0x5B, 0xCF), # Ï
    0x00D1: (0x5B, 0xD1), # Ñ
    0x00D2: (0x5B, 0xD2), # Ò
    0x00D3: (0x5B, 0xD3), # Ó
    0x00D4: (0x5B, 0xD4), # Ô
    0x00D5: (0x5B, 0xD5), # Õ
    0x00D6: (0x5B, 0xD6), # Ö
    0x00D7: (0x5B, 0xD7), # ×
    0x00D8: (0x5B, 0xD8), # Ø
    0x00D9: (0x5B, 0xD9), # Ù
    0x00DA: (0x5B, 0xDA), # Ú
    0x00DB: (0x5B, 0xDB), # Û
    0x00DC: (0x5B, 0xDC), # Ü
    0x00DF: (0x5B, 0xDF), # ß
    0x00E0: (0x5B, 0xE0), # à
    0x00E1: (0x5B, 0xE1), # á
    0x00E2: (0x5B, 0xE2), # â
    0x00E3: (0x5B, 0xE3), # ã
    0x00E4: (0x5B, 0xE4), # ä
    0x00E5: (0x5B, 0xE5), # å
    0x00E6: (0x5B, 0xE6), # æ
    0x00E7: (0x5B, 0xE7), # ç
    0x00E8: (0x5B, 0xE8), # è
    0x00E9: (0x5B, 0xE9), # é
    0x00EA: (0x5B, 0xEA), # ê
    0x00EB: (0x5B, 0xEB), # ë
    0x00EC: (0x5B, 0xEC), # ì
    0x00ED: (0x5B, 0xED), # í
    0x00EE: (0x5B, 0xEE), # î
    0x00EF: (0x5B, 0xEF), # ï
    0x00F1: (0x5B, 0xF1), # ñ
    0x00F2: (0x5B, 0xF2), # ò
    0x00F3: (0x5B, 0xF3), # ó
    0x00F4: (0x5B, 0xF4), # ô
    0x00F5: (0x5B, 0xF5), # õ
    0x00F6: (0x5B, 0xF6), # ö
    0x00F7: (0x5B, 0xF7), # ÷
    0x00F8: (0x5B, 0xF8), # ø
    0x00F9: (0x5B, 0xF9), # ù
    0x00FA: (0x5B, 0xFA), # ú
    0x00FB: (0x5B, 0xFB), # û
    0x00FC: (0x5B, 0xFC), # ü
    0x00FF: (0x5B, 0xFF), # ÿ
    0x011E: (0x5B, 0xD0), # Ğ
    0x011F: (0x5B, 0xF0), # ğ
    0x0130: (0x5B, 0xDD), # İ
    0x0131: (0x5B, 0xFD), # ı
    0x0152: (0x5B, 0x8C), # Œ
    0x0153: (0x5B, 0x9C), # œ
    0x015E: (0x5B, 0xDE), # Ş
    0x015F: (0x5B, 0xFE), # ş
    0x0160: (0x5B, 0x8A), # Š
    0x0161: (0x5B, 0x9A), # š
    0x0178: (0x5B, 0x9F), # Ÿ
    0x0192: (0x5B, 0x83), # ƒ
    0x02C6: (0x5B, 0x88), # ˆ
    0x02DC: (0x5B, 0x98), # ˜
    # 0x2013: (0x5B, 0x96), # –
    # 0x2014: (0x5B, 0x97), # —
    0x2018: (0x5B, 0x91), # ‘
    0x2019: (0x5B, 0x92), # ’
    0x201A: (0x5B, 0x82), # ‚
    0x201C: (0x5B, 0x93), # “
    0x201D: (0x5B, 0x94), # ”
    0x201E: (0x5B, 0x84), # „
    0x2020: (0x5B, 0x86), # †
    0x2021: (0x5B, 0x87), # ‡
    0x2022: (0x5B, 0x95), # •
    0x2026: (0x5B, 0x85), # …
    0x2030: (0x5B, 0x89), # ‰
    0x2039: (0x5B, 0x8B), # ‹
    0x203A: (0x5B, 0x9B), # ›
    0x2122: (0x5B, 0x99), # ™

    # IBM-1256 Arabic
    # 0x2013: (0x5C, 0x96), # –
    # 0x2014: (0x5C, 0x97), # —
    0x2018: (0x5C, 0x91), # ‘
    0x2019: (0x5C, 0x92), # ’
    0x201A: (0x5C, 0x82), # ‚
    0x201C: (0x5C, 0x93), # “
    0x201D: (0x5C, 0x94), # ”
    0x201E: (0x5C, 0x84), # „
    0x2020: (0x5C, 0x86), # †
    0x2021: (0x5C, 0x87), # ‡
    0x2022: (0x5C, 0x95), # •
    0x2026: (0x5C, 0x85), # …
    0x2030: (0x5C, 0x89), # ‰
    0x2039: (0x5C, 0x8B), # ‹
    0x203A: (0x5C, 0x9B), # ›
    0x2122: (0x5C, 0x99), # ™
    0x00A2: (0x5C, 0xA2), # ¢
    0x00A3: (0x5C, 0xA3), # £
    0x00A4: (0x5C, 0xA4), # ¤
    0x00A5: (0x5C, 0xA5), # ¥
    0x00A6: (0x5C, 0xA6), # ¦
    0x00A7: (0x5C, 0xA7), # §
    0x00A8: (0x5C, 0xA8), # ¨
    0x00A9: (0x5C, 0xA9), # ©
    0x00AB: (0x5C, 0xAB), # «
    0x00AC: (0x5C, 0xAC), # ¬
    0x00AD: (0x5C, 0xAD), # ­
    0x00AE: (0x5C, 0xAE), # ®
    0x00AF: (0x5C, 0xAF), # ¯
    0x00B0: (0x5C, 0xB0), # °
    0x00B1: (0x5C, 0xB1), # ±
    0x00B2: (0x5C, 0xB2), # ²
    0x00B3: (0x5C, 0xB3), # ³
    0x00B4: (0x5C, 0xB4), # ´
    0x00B5: (0x5C, 0xB5), # µ
    0x00B6: (0x5C, 0xB6), # ¶
    0x00B7: (0x5C, 0xB7), # ·
    0x00B8: (0x5C, 0xB8), # ¸
    0x00B9: (0x5C, 0xB9), # ¹
    0x00BB: (0x5C, 0xBB), # »
    0x00BC: (0x5C, 0xBC), # ¼
    0x00BD: (0x5C, 0xBD), # ½
    0x00BE: (0x5C, 0xBE), # ¾
    0x00D7: (0x5C, 0xD7), # ×
    0x00E0: (0x5C, 0xE0), # à
    0x00E2: (0x5C, 0xE2), # â
    0x00E7: (0x5C, 0xE7), # ç
    0x00E8: (0x5C, 0xE8), # è
    0x00E9: (0x5C, 0xE9), # é
    0x00EA: (0x5C, 0xEA), # ê
    0x00EB: (0x5C, 0xEB), # ë
    0x00EE: (0x5C, 0xEE), # î
    0x00EF: (0x5C, 0xEF), # ï
    0x00F4: (0x5C, 0xF4), # ô
    0x00F7: (0x5C, 0xF7), # ÷
    0x00F9: (0x5C, 0xF9), # ù
    0x00FB: (0x5C, 0xFB), # û
    0x00FC: (0x5C, 0xFC), # ü
    0x0152: (0x5C, 0x8C), # Œ
    0x0153: (0x5C, 0x9C), # œ
    0x0192: (0x5C, 0x83), # ƒ
    0x02C6: (0x5C, 0x88), # ˆ
    0x060C: (0x5C, 0xA1), # ،
    0x061B: (0x5C, 0xBA), # ؛
    0x061F: (0x5C, 0xBF), # ؟
    0xFE80: (0x5C, 0xC1), # ﺀ
    0x0621: (0x5C, 0xC1), # ء
    0xFE82: (0x5C, 0xC2), # ﺂ
    0xFE81: (0x5C, 0xC2), # ﺁ
    0x0622: (0x5C, 0xC2), # آ
    0xFE84: (0x5C, 0xC3), # ﺄ
    0xFE83: (0x5C, 0xC3), # ﺃ
    0x0623: (0x5C, 0xC3), # أ
    0xFE86: (0x5C, 0xC4), # ﺆ
    0xFE85: (0x5C, 0xC4), # ﺅ
    0x0624: (0x5C, 0xC4), # ؤ
    0xFE88: (0x5C, 0xC5), # ﺈ
    0xFE87: (0x5C, 0xC5), # ﺇ
    0x0625: (0x5C, 0xC5), # إ
    0xFE8C: (0x5C, 0xC6), # ﺌ
    0xFE8B: (0x5C, 0xC6), # ﺋ
    0xFE8A: (0x5C, 0xC6), # ﺊ
    0xFE89: (0x5C, 0xC6), # ﺉ
    0x0626: (0x5C, 0xC6), # ئ
    0xFE8E: (0x5C, 0xC7), # ﺎ
    0xFE8D: (0x5C, 0xC7), # ﺍ
    0x0627: (0x5C, 0xC7), # ا
    0xFE92: (0x5C, 0xC8), # ﺒ
    0xFE91: (0x5C, 0xC8), # ﺑ
    0xFE90: (0x5C, 0xC8), # ﺐ
    0xFE8F: (0x5C, 0xC8), # ﺏ
    0x0628: (0x5C, 0xC8), # ب
    0xFE94: (0x5C, 0xC9), # ﺔ
    0xFE93: (0x5C, 0xC9), # ﺓ
    0x0629: (0x5C, 0xC9), # ة
    0xFE98: (0x5C, 0xCA), # ﺘ
    0xFE97: (0x5C, 0xCA), # ﺗ
    0xFE96: (0x5C, 0xCA), # ﺖ
    0xFE95: (0x5C, 0xCA), # ﺕ
    0x062A: (0x5C, 0xCA), # ت
    0xFE9C: (0x5C, 0xCB), # ﺜ
    0xFE9B: (0x5C, 0xCB), # ﺛ
    0xFE9A: (0x5C, 0xCB), # ﺚ
    0xFE99: (0x5C, 0xCB), # ﺙ
    0x062B: (0x5C, 0xCB), # ث
    0xFEA0: (0x5C, 0xCC), # ﺠ
    0xFE9F: (0x5C, 0xCC), # ﺟ
    0xFE9E: (0x5C, 0xCC), # ﺞ
    0xFE9D: (0x5C, 0xCC), # ﺝ
    0x062C: (0x5C, 0xCC), # ج
    0xFEA4: (0x5C, 0xCD), # ﺤ
    0xFEA3: (0x5C, 0xCD), # ﺣ
    0xFEA2: (0x5C, 0xCD), # ﺢ
    0xFEA1: (0x5C, 0xCD), # ﺡ
    0x062D: (0x5C, 0xCD), # ح
    0xFEA8: (0x5C, 0xCE), # ﺨ
    0xFEA7: (0x5C, 0xCE), # ﺧ
    0xFEA6: (0x5C, 0xCE), # ﺦ
    0xFEA5: (0x5C, 0xCE), # ﺥ
    0x062E: (0x5C, 0xCE), # خ
    0xFEAA: (0x5C, 0xCF), # ﺪ
    0xFEA9: (0x5C, 0xCF), # ﺩ
    0x062F: (0x5C, 0xCF), # د
    0xFEAC: (0x5C, 0xD0), # ﺬ
    0xFEAB: (0x5C, 0xD0), # ﺫ
    0x0630: (0x5C, 0xD0), # ذ
    0xFEAE: (0x5C, 0xD1), # ﺮ
    0xFEAD: (0x5C, 0xD1), # ﺭ
    0x0631: (0x5C, 0xD1), # ر
    0xFEB0: (0x5C, 0xD2), # ﺰ
    0xFEAF: (0x5C, 0xD2), # ﺯ
    0x0632: (0x5C, 0xD2), # ز
    0xFEB4: (0x5C, 0xD3), # ﺴ
    0xFEB3: (0x5C, 0xD3), # ﺳ
    0xFEB2: (0x5C, 0xD3), # ﺲ
    0xFEB1: (0x5C, 0xD3), # ﺱ
    0x0633: (0x5C, 0xD3), # س
    0xFEB8: (0x5C, 0xD4), # ﺸ
    0xFEB7: (0x5C, 0xD4), # ﺷ
    0xFEB6: (0x5C, 0xD4), # ﺶ
    0xFEB5: (0x5C, 0xD4), # ﺵ
    0x0634: (0x5C, 0xD4), # ش
    0xFEBC: (0x5C, 0xD5), # ﺼ
    0xFEBB: (0x5C, 0xD5), # ﺻ
    0xFEBA: (0x5C, 0xD5), # ﺺ
    0xFEB9: (0x5C, 0xD5), # ﺹ
    0x0635: (0x5C, 0xD5), # ص
    0xFEC0: (0x5C, 0xD6), # ﻀ
    0xFEBF: (0x5C, 0xD6), # ﺿ
    0xFEBE: (0x5C, 0xD6), # ﺾ
    0xFEBD: (0x5C, 0xD6), # ﺽ
    0x0636: (0x5C, 0xD6), # ض
    0xFEC4: (0x5C, 0xD8), # ﻄ
    0xFEC3: (0x5C, 0xD8), # ﻃ
    0xFEC2: (0x5C, 0xD8), # ﻂ
    0xFEC1: (0x5C, 0xD8), # ﻁ
    0x0637: (0x5C, 0xD8), # ط
    0xFEC8: (0x5C, 0xD9), # ﻈ
    0xFEC7: (0x5C, 0xD9), # ﻇ
    0xFEC6: (0x5C, 0xD9), # ﻆ
    0xFEC5: (0x5C, 0xD9), # ﻅ
    0x0638: (0x5C, 0xD9), # ظ
    0xFECC: (0x5C, 0xDA), # ﻌ
    0xFECB: (0x5C, 0xDA), # ﻋ
    0xFECA: (0x5C, 0xDA), # ﻊ
    0xFEC9: (0x5C, 0xDA), # ﻉ
    0x0639: (0x5C, 0xDA), # ع
    0xFED0: (0x5C, 0xDB), # ﻐ
    0xFECF: (0x5C, 0xDB), # ﻏ
    0xFECE: (0x5C, 0xDB), # ﻎ
    0xFECD: (0x5C, 0xDB), # ﻍ
    0x063A: (0x5C, 0xDB), # غ
    0x0640: (0x5C, 0xDC), # ـ
    0xFED4: (0x5C, 0xDD), # ﻔ
    0xFED3: (0x5C, 0xDD), # ﻓ
    0xFED2: (0x5C, 0xDD), # ﻒ
    0xFED1: (0x5C, 0xDD), # ﻑ
    0x0641: (0x5C, 0xDD), # ف
    0xFED8: (0x5C, 0xDE), # ﻘ
    0xFED7: (0x5C, 0xDE), # ﻗ
    0xFED6: (0x5C, 0xDE), # ﻖ
    0xFED5: (0x5C, 0xDE), # ﻕ
    0x0642: (0x5C, 0xDE), # ق
    0xFEDC: (0x5C, 0xDF), # ﻜ
    0xFEDB: (0x5C, 0xDF), # ﻛ
    0xFEDA: (0x5C, 0xDF), # ﻚ
    0xFED9: (0x5C, 0xDF), # ﻙ
    0x0643: (0x5C, 0xDF), # ك
    0xFEE0: (0x5C, 0xE1), # ﻠ
    0xFEDF: (0x5C, 0xE1), # ﻟ
    0xFEDE: (0x5C, 0xE1), # ﻞ
    0xFEDD: (0x5C, 0xE1), # ﻝ
    0x0644: (0x5C, 0xE1), # ل
    0xFEE4: (0x5C, 0xE3), # ﻤ
    0xFEE3: (0x5C, 0xE3), # ﻣ
    0xFEE2: (0x5C, 0xE3), # ﻢ
    0xFEE1: (0x5C, 0xE3), # ﻡ
    0x0645: (0x5C, 0xE3), # م
    0xFEE8: (0x5C, 0xE4), # ﻨ
    0xFEE7: (0x5C, 0xE4), # ﻧ
    0xFEE6: (0x5C, 0xE4), # ﻦ
    0xFEE5: (0x5C, 0xE4), # ﻥ
    0x0646: (0x5C, 0xE4), # ن
    0xFEEC: (0x5C, 0xE5), # ﻬ
    0xFEEB: (0x5C, 0xE5), # ﻫ
    0xFEEA: (0x5C, 0xE5), # ﻪ
    0xFEE9: (0x5C, 0xE5), # ﻩ
    0x0647: (0x5C, 0xE5), # ه
    0xFEEE: (0x5C, 0xE6), # ﻮ
    0xFEED: (0x5C, 0xE6), # ﻭ
    0x0648: (0x5C, 0xE6), # و
    0xFEF0: (0x5C, 0xEC), # ﻰ
    0xFEEF: (0x5C, 0xEC), # ﻯ
    0x0649: (0x5C, 0xEC), # ى
    0xFEF4: (0x5C, 0xED), # ﻴ
    0xFEF3: (0x5C, 0xED), # ﻳ
    0xFEF2: (0x5C, 0xED), # ﻲ
    0xFEF1: (0x5C, 0xED), # ﻱ
    0x064A: (0x5C, 0xED), # ي
    0xFE71: (0x5C, 0xF0), # ﹱ
    0xFE70: (0x5C, 0xF0), # ﹰ
    0x064B: (0x5C, 0xF0), #
    0xFE72: (0x5C, 0xF1), # ﹲ
    0x064C: (0x5C, 0xF1), #
    0xFE74: (0x5C, 0xF2), # ﹴ
    0x064D: (0x5C, 0xF2), #
    0xFE77: (0x5C, 0xF3), # ﹷ
    0xFE76: (0x5C, 0xF3), # ﹶ
    0x064E: (0x5C, 0xF3), #
    0xFE79: (0x5C, 0xF5), # ﹹ
    0xFE78: (0x5C, 0xF5), # ﹸ
    0x064F: (0x5C, 0xF5), #
    0xFE7B: (0x5C, 0xF6), # ﹻ
    0xFE7A: (0x5C, 0xF6), # ﹺ
    0x0650: (0x5C, 0xF6), #
    0xFE7D: (0x5C, 0xF8), # ﹽ
    0xFE7C: (0x5C, 0xF8), # ﹼ
    0x0651: (0x5C, 0xF8), #
    0xFE7F: (0x5C, 0xFA), # ﹿ
    0xFE7E: (0x5C, 0xFA), # ﹾ
    0x0652: (0x5C, 0xFA), #
    0xFB58: (0x5C, 0x81), # ﭘ
    0xFB56: (0x5C, 0x81), # ﭖ
    0x067E: (0x5C, 0x81), # پ
    0xFB7C: (0x5C, 0x8D), # ﭼ
    0xFB7A: (0x5C, 0x8D), # ﭺ
    0x0686: (0x5C, 0x8D), # چ
    0xFB8A: (0x5C, 0x8E), # ﮊ
    0x0698: (0x5C, 0x8E), # ژ
    0xFB94: (0x5C, 0x90), # ﮔ
    0xFB92: (0x5C, 0x90), # ﮒ
    0x06AF: (0x5C, 0x90), # گ
    0x200C: (0x5C, 0x9D), # ‌
    0x200D: (0x5C, 0x9E), # ‍
    0x200E: (0x5C, 0xFD), # ‎
    0x200F: (0x5C, 0xFE), # ‏

    # Iran System, kinda (???)
    # Arabic, but... really inconsistent with everything?
    # not labeled with a code page number for a reason, maybe
    # anyways these are a stretch but i'll take them
    0x29DA: (0x14, 0xB2), # ⧚
    0x29DB: (0x14, 0xB2), # ⧛
    0x2715: (0x14, 0x8B), # ✕

    # IBM-720 Arabic
    0x00A0: (0x5D, 0xFF), #  
    0x00A3: (0x5D, 0x9C), # £
    0x00A4: (0x5D, 0x94), # ¤
    0x00AB: (0x5D, 0xAE), # «
    0x00B0: (0x5D, 0xF8), # °
    0x00B2: (0x5D, 0xFD), # ²
    0x00B5: (0x5D, 0xE6), # µ
    0x00B7: (0x5D, 0xFA), # ·
    0x00BB: (0x5D, 0xAF), # »
    0x00E0: (0x5D, 0x85), # à
    0x00E2: (0x5D, 0x83), # â
    0x00E7: (0x5D, 0x87), # ç
    0x00E8: (0x5D, 0x8A), # è
    0x00E9: (0x5D, 0x82), # é
    0x00EA: (0x5D, 0x88), # ê
    0x00EB: (0x5D, 0x89), # ë
    0x00EE: (0x5D, 0x8C), # î
    0x00EF: (0x5D, 0x8B), # ï
    0x00F4: (0x5D, 0x93), # ô
    0x00F9: (0x5D, 0x97), # ù
    0x00FB: (0x5D, 0x96), # û
    0x0621: (0x5D, 0x98), # ء
    0x0622: (0x5D, 0x99), # آ
    0x0623: (0x5D, 0x9A), # أ
    0x0624: (0x5D, 0x9B), # ؤ
    0x0625: (0x5D, 0x9D), # إ
    0x0626: (0x5D, 0x9E), # ئ
    0x0627: (0x5D, 0x9F), # ا
    0x0628: (0x5D, 0xA0), # ب
    0x0629: (0x5D, 0xA1), # ة
    0x062A: (0x5D, 0xA2), # ت
    0x062B: (0x5D, 0xA3), # ث
    0x062C: (0x5D, 0xA4), # ج
    0x062D: (0x5D, 0xA5), # ح
    0x062E: (0x5D, 0xA6), # خ
    0x062F: (0x5D, 0xA7), # د
    0x0630: (0x5D, 0xA8), # ذ
    0x0631: (0x5D, 0xA9), # ر
    0x0632: (0x5D, 0xAA), # ز
    0x0633: (0x5D, 0xAB), # س
    0x0634: (0x5D, 0xAC), # ش
    0x0635: (0x5D, 0xAD), # ص
    0x0636: (0x5D, 0xE0), # ض
    0x0637: (0x5D, 0xE1), # ط
    0x0638: (0x5D, 0xE2), # ظ
    0x0639: (0x5D, 0xE3), # ع
    0x063A: (0x5D, 0xE4), # غ
    0x0640: (0x5D, 0x95), # ـ
    0x0641: (0x5D, 0xE5), # ف
    0x0642: (0x5D, 0xE7), # ق
    0x0643: (0x5D, 0xE8), # ك
    0x0644: (0x5D, 0xE9), # ل
    0x0645: (0x5D, 0xEA), # م
    0x0646: (0x5D, 0xEB), # ن
    0x0647: (0x5D, 0xEC), # ه
    0x0648: (0x5D, 0xED), # و
    0x0649: (0x5D, 0xEE), # ى
    0x064A: (0x5D, 0xEF), # ي
    0x064B: (0x5D, 0xF1), #
    0x064C: (0x5D, 0xF2), #
    0x064D: (0x5D, 0xF3), #
    0x064E: (0x5D, 0xF4), #
    0x064F: (0x5D, 0xF5), #
    0x0650: (0x5D, 0xF6), #
    0x0651: (0x5D, 0x91), #
    0x0652: (0x5D, 0x92), #
    0x207F: (0x5D, 0xFC), # ⁿ
    0x2219: (0x5D, 0xF9), # ∙
    0x221A: (0x5D, 0xFB), # √
    0x2248: (0x5D, 0xF7), # ≈
    0x2261: (0x5D, 0xF0), # ≡
    0x2500: (0x5D, 0xC4), # ─
    0xFFE8: (0x5D, 0xB3), # ￨
    0x2502: (0x5D, 0xB3), # │
    0x250C: (0x5D, 0xDA), # ┌
    0x2510: (0x5D, 0xBF), # ┐
    0x2514: (0x5D, 0xC0), # └
    0x2518: (0x5D, 0xD9), # ┘
    0x251C: (0x5D, 0xC3), # ├
    0x2524: (0x5D, 0xB4), # ┤
    0x252C: (0x5D, 0xC2), # ┬
    0x2534: (0x5D, 0xC1), # ┴
    0x253C: (0x5D, 0xC5), # ┼
    0x2550: (0x5D, 0xCD), # ═
    0x2551: (0x5D, 0xBA), # ║
    0x2552: (0x5D, 0xD5), # ╒
    0x2553: (0x5D, 0xD6), # ╓
    0x2554: (0x5D, 0xC9), # ╔
    0x2555: (0x5D, 0xB8), # ╕
    0x2556: (0x5D, 0xB7), # ╖
    0x2557: (0x5D, 0xBB), # ╗
    0x2558: (0x5D, 0xD4), # ╘
    0x2559: (0x5D, 0xD3), # ╙
    0x255A: (0x5D, 0xC8), # ╚
    0x255B: (0x5D, 0xBE), # ╛
    0x255C: (0x5D, 0xBD), # ╜
    0x255D: (0x5D, 0xBC), # ╝
    0x255E: (0x5D, 0xC6), # ╞
    0x255F: (0x5D, 0xC7), # ╟
    0x2560: (0x5D, 0xCC), # ╠
    0x2561: (0x5D, 0xB5), # ╡
    0x2562: (0x5D, 0xB6), # ╢
    0x2563: (0x5D, 0xB9), # ╣
    0x2564: (0x5D, 0xD1), # ╤
    0x2565: (0x5D, 0xD2), # ╥
    0x2566: (0x5D, 0xCB), # ╦
    0x2567: (0x5D, 0xCF), # ╧
    0x2568: (0x5D, 0xD0), # ╨
    0x2569: (0x5D, 0xCA), # ╩
    0x256A: (0x5D, 0xD8), # ╪
    0x256B: (0x5D, 0xD7), # ╫
    0x256C: (0x5D, 0xCE), # ╬
    0x2580: (0x5D, 0xDF), # ▀
    0x2584: (0x5D, 0xDC), # ▄
    0x2588: (0x5D, 0xDB), # █
    0x258C: (0x5D, 0xDD), # ▌
    0x2590: (0x5D, 0xDE), # ▐
    0x2591: (0x5D, 0xB0), # ░
    0x2592: (0x5D, 0xB1), # ▒
    0x2593: (0x5D, 0xB2), # ▓
    0xFFED: (0x5D, 0xFE), # ￭
    0x25A0: (0x5D, 0xFE), # ■

    # IBM-1258 Vietnam
    0x00A1: (0x5E, 0xA1), # ¡
    0x00A2: (0x5E, 0xA2), # ¢
    0x00A3: (0x5E, 0xA3), # £
    0x00A4: (0x5E, 0xA4), # ¤
    0x00A5: (0x5E, 0xA5), # ¥
    0x00A6: (0x5E, 0xA6), # ¦
    0x00A7: (0x5E, 0xA7), # §
    0x00A8: (0x5E, 0xA8), # ¨
    0x00A9: (0x5E, 0xA9), # ©
    0x00AA: (0x5E, 0xAA), # ª
    0x00AB: (0x5E, 0xAB), # «
    0x00AC: (0x5E, 0xAC), # ¬
    0x00AD: (0x5E, 0xAD), # ­
    0x00AE: (0x5E, 0xAE), # ®
    0x00AF: (0x5E, 0xAF), # ¯
    0x00B0: (0x5E, 0xB0), # °
    0x00B1: (0x5E, 0xB1), # ±
    0x00B2: (0x5E, 0xB2), # ²
    0x00B3: (0x5E, 0xB3), # ³
    0x00B4: (0x5E, 0xB4), # ´
    0x00B5: (0x5E, 0xB5), # µ
    0x00B6: (0x5E, 0xB6), # ¶
    0x00B7: (0x5E, 0xB7), # ·
    0x00B8: (0x5E, 0xB8), # ¸
    0x00B9: (0x5E, 0xB9), # ¹
    0x00BA: (0x5E, 0xBA), # º
    0x00BB: (0x5E, 0xBB), # »
    0x00BC: (0x5E, 0xBC), # ¼
    0x00BD: (0x5E, 0xBD), # ½
    0x00BE: (0x5E, 0xBE), # ¾
    0x00BF: (0x5E, 0xBF), # ¿
    0x00C0: (0x5E, 0xC0), # À
    0x00C1: (0x5E, 0xC1), # Á
    0x00C2: (0x5E, 0xC2), # Â
    0x00C4: (0x5E, 0xC4), # Ä
    0x00C5: (0x5E, 0xC5), # Å
    0x00C6: (0x5E, 0xC6), # Æ
    0x00C7: (0x5E, 0xC7), # Ç
    0x00C8: (0x5E, 0xC8), # È
    0x00C9: (0x5E, 0xC9), # É
    0x00CA: (0x5E, 0xCA), # Ê
    0x00CB: (0x5E, 0xCB), # Ë
    0x00CD: (0x5E, 0xCD), # Í
    0x00CE: (0x5E, 0xCE), # Î
    0x00CF: (0x5E, 0xCF), # Ï
    0x00D1: (0x5E, 0xD1), # Ñ
    0x00D3: (0x5E, 0xD3), # Ó
    0x00D4: (0x5E, 0xD4), # Ô
    0x00D6: (0x5E, 0xD6), # Ö
    0x00D7: (0x5E, 0xD7), # ×
    0x00D8: (0x5E, 0xD8), # Ø
    0x00D9: (0x5E, 0xD9), # Ù
    0x00DA: (0x5E, 0xDA), # Ú
    0x00DB: (0x5E, 0xDB), # Û
    0x00DC: (0x5E, 0xDC), # Ü
    0x00DF: (0x5E, 0xDF), # ß
    0x00E0: (0x5E, 0xE0), # à
    0x00E1: (0x5E, 0xE1), # á
    0x00E2: (0x5E, 0xE2), # â
    0x00E4: (0x5E, 0xE4), # ä
    0x00E5: (0x5E, 0xE5), # å
    0x00E6: (0x5E, 0xE6), # æ
    0x00E7: (0x5E, 0xE7), # ç
    0x00E8: (0x5E, 0xE8), # è
    0x00E9: (0x5E, 0xE9), # é
    0x00EA: (0x5E, 0xEA), # ê
    0x00EB: (0x5E, 0xEB), # ë
    0x00ED: (0x5E, 0xED), # í
    0x00EE: (0x5E, 0xEE), # î
    0x00EF: (0x5E, 0xEF), # ï
    0x00F1: (0x5E, 0xF1), # ñ
    0x00F3: (0x5E, 0xF3), # ó
    0x00F4: (0x5E, 0xF4), # ô
    0x00F6: (0x5E, 0xF6), # ö
    0x00F7: (0x5E, 0xF7), # ÷
    0x00F8: (0x5E, 0xF8), # ø
    0x00F9: (0x5E, 0xF9), # ù
    0x00FA: (0x5E, 0xFA), # ú
    0x00FB: (0x5E, 0xFB), # û
    0x00FC: (0x5E, 0xFC), # ü
    0x00FF: (0x5E, 0xFF), # ÿ
    0x0102: (0x5E, 0xC3), # Ă
    0x0103: (0x5E, 0xE3), # ă
    0x0110: (0x5E, 0xD0), # Đ
    0x0111: (0x5E, 0xF0), # đ
    0x0152: (0x5E, 0x8C), # Œ
    0x0153: (0x5E, 0x9C), # œ
    0x0178: (0x5E, 0x9F), # Ÿ
    0x0192: (0x5E, 0x83), # ƒ
    0x01A0: (0x5E, 0xD5), # Ơ
    0x01A1: (0x5E, 0xF5), # ơ
    0x01AF: (0x5E, 0xDD), # Ư
    0x01B0: (0x5E, 0xFD), # ư
    0x02C6: (0x5E, 0x88), # ˆ
    0x02DC: (0x5E, 0x98), # ˜
    0x0300: (0x5E, 0xCC), #
    0x0301: (0x5E, 0xEC), #
    0x0303: (0x5E, 0xDE), #
    0x0309: (0x5E, 0xD2), #
    0x0323: (0x5E, 0xF2), #
    # 0x2013: (0x5E, 0x96), # –
    # 0x2014: (0x5E, 0x97), # —
    0x2018: (0x5E, 0x91), # ‘
    0x2019: (0x5E, 0x92), # ’
    0x201A: (0x5E, 0x82), # ‚
    0x201C: (0x5E, 0x93), # “
    0x201D: (0x5E, 0x94), # ”
    0x201E: (0x5E, 0x84), # „
    0x2020: (0x5E, 0x86), # †
    0x2021: (0x5E, 0x87), # ‡
    0x2022: (0x5E, 0x95), # •
    0x2026: (0x5E, 0x85), # …
    0x2030: (0x5E, 0x89), # ‰
    0x2039: (0x5E, 0x8B), # ‹
    0x203A: (0x5E, 0x9B), # ›
    0x20AB: (0x5E, 0xFE), # ₫
    0x2122: (0x5E, 0x99), # ™

    # IBM-775 Latvian
    0x00B6: (0x5F, 0xF4), # ¶
    0x00A7: (0x5F, 0xF5), # §
    0x00A0: (0x5F, 0xFF), #  
    0x00A2: (0x5F, 0x96), # ¢
    0x00A3: (0x5F, 0x9C), # £
    0x00A4: (0x5F, 0x9F), # ¤
    0x00A6: (0x5F, 0xA7), # ¦
    0x00A9: (0x5F, 0xA8), # ©
    0x00AB: (0x5F, 0xAE), # «
    0x00AC: (0x5F, 0xAA), # ¬
    0x00AD: (0x5F, 0xF0), # ­
    0x00AE: (0x5F, 0xA9), # ®
    0x00B0: (0x5F, 0xF8), # °
    0x00B1: (0x5F, 0xF1), # ±
    0x00B2: (0x5F, 0xFD), # ²
    0x00B3: (0x5F, 0xFC), # ³
    0x00B5: (0x5F, 0xE6), # µ
    0x00B7: (0x5F, 0xFA), # ·
    0x00B9: (0x5F, 0xFB), # ¹
    0x00BB: (0x5F, 0xAF), # »
    0x00BC: (0x5F, 0xAC), # ¼
    0x00BD: (0x5F, 0xAB), # ½
    0x00BE: (0x5F, 0xF3), # ¾
    0x00C4: (0x5F, 0x8E), # Ä
    0x00C5: (0x5F, 0x8F), # Å
    0x00C6: (0x5F, 0x92), # Æ
    0x00C9: (0x5F, 0x90), # É
    0x00D3: (0x5F, 0xE0), # Ó
    0x00D5: (0x5F, 0xE5), # Õ
    0x00D6: (0x5F, 0x99), # Ö
    0x00D7: (0x5F, 0x9E), # ×
    0x00D8: (0x5F, 0x9D), # Ø
    0x00DC: (0x5F, 0x9A), # Ü
    0x00DF: (0x5F, 0xE1), # ß
    0x00E4: (0x5F, 0x84), # ä
    0x00E5: (0x5F, 0x86), # å
    0x00E6: (0x5F, 0x91), # æ
    0x00E9: (0x5F, 0x82), # é
    0x00F3: (0x5F, 0xA2), # ó
    0x00F5: (0x5F, 0xE4), # õ
    0x00F6: (0x5F, 0x94), # ö
    0x00F7: (0x5F, 0xF6), # ÷
    0x00F8: (0x5F, 0x9B), # ø
    0x00FC: (0x5F, 0x81), # ü
    0x0100: (0x5F, 0xA0), # Ā
    0x0101: (0x5F, 0x83), # ā
    0x0104: (0x5F, 0xB5), # Ą
    0x0105: (0x5F, 0xD0), # ą
    0x0106: (0x5F, 0x80), # Ć
    0x0107: (0x5F, 0x87), # ć
    0x010C: (0x5F, 0xB6), # Č
    0x010D: (0x5F, 0xD1), # č
    0x0112: (0x5F, 0xED), # Ē
    0x0113: (0x5F, 0x89), # ē
    0x0116: (0x5F, 0xB8), # Ė
    0x0117: (0x5F, 0xD3), # ė
    0x0118: (0x5F, 0xB7), # Ę
    0x0119: (0x5F, 0xD2), # ę
    0x0122: (0x5F, 0x95), # Ģ
    0x0123: (0x5F, 0x85), # ģ
    0x012A: (0x5F, 0xA1), # Ī
    0x012B: (0x5F, 0x8C), # ī
    0x012E: (0x5F, 0xBD), # Į
    0x012F: (0x5F, 0xD4), # į
    0x0136: (0x5F, 0xE8), # Ķ
    0x0137: (0x5F, 0xE9), # ķ
    0x013B: (0x5F, 0xEA), # Ļ
    0x013C: (0x5F, 0xEB), # ļ
    0x0141: (0x5F, 0xAD), # Ł
    0x0142: (0x5F, 0x88), # ł
    0x0143: (0x5F, 0xE3), # Ń
    0x0144: (0x5F, 0xE7), # ń
    0x0145: (0x5F, 0xEE), # Ņ
    0x0146: (0x5F, 0xEC), # ņ
    0x014C: (0x5F, 0xE2), # Ō
    0x014D: (0x5F, 0x93), # ō
    0x0156: (0x5F, 0x8A), # Ŗ
    0x0157: (0x5F, 0x8B), # ŗ
    0x015A: (0x5F, 0x97), # Ś
    0x015B: (0x5F, 0x98), # ś
    0x0160: (0x5F, 0xBE), # Š
    0x0161: (0x5F, 0xD5), # š
    0x016A: (0x5F, 0xC7), # Ū
    0x016B: (0x5F, 0xD7), # ū
    0x0172: (0x5F, 0xC6), # Ų
    0x0173: (0x5F, 0xD6), # ų
    0x0179: (0x5F, 0x8D), # Ź
    0x017A: (0x5F, 0xA5), # ź
    0x017B: (0x5F, 0xA3), # Ż
    0x017C: (0x5F, 0xA4), # ż
    0x017D: (0x5F, 0xCF), # Ž
    0x017E: (0x5F, 0xD8), # ž
    0x2019: (0x5F, 0xEF), # ’
    0x201C: (0x5F, 0xF2), # “
    0x201D: (0x5F, 0xA6), # ”
    0x201E: (0x5F, 0xF7), # „
    0x2219: (0x5F, 0xF9), # ∙
    0x2500: (0x5F, 0xC4), # ─
    0xFFE8: (0x5F, 0xB3), # ￨
    0x2502: (0x5F, 0xB3), # │
    0x250C: (0x5F, 0xDA), # ┌
    0x2510: (0x5F, 0xBF), # ┐
    0x2514: (0x5F, 0xC0), # └
    0x2518: (0x5F, 0xD9), # ┘
    0x251C: (0x5F, 0xC3), # ├
    0x2524: (0x5F, 0xB4), # ┤
    0x252C: (0x5F, 0xC2), # ┬
    0x2534: (0x5F, 0xC1), # ┴
    0x253C: (0x5F, 0xC5), # ┼
    0x2550: (0x5F, 0xCD), # ═
    0x2551: (0x5F, 0xBA), # ║
    0x2554: (0x5F, 0xC9), # ╔
    0x2557: (0x5F, 0xBB), # ╗
    0x255A: (0x5F, 0xC8), # ╚
    0x255D: (0x5F, 0xBC), # ╝
    0x2560: (0x5F, 0xCC), # ╠
    0x2563: (0x5F, 0xB9), # ╣
    0x2566: (0x5F, 0xCB), # ╦
    0x2569: (0x5F, 0xCA), # ╩
    0x256C: (0x5F, 0xCE), # ╬
    0x2580: (0x5F, 0xDF), # ▀
    0x2584: (0x5F, 0xDC), # ▄
    0x2588: (0x5F, 0xDB), # █
    0x258C: (0x5F, 0xDD), # ▌
    0x2590: (0x5F, 0xDE), # ▐
    0x2591: (0x5F, 0xB0), # ░
    0x2592: (0x5F, 0xB1), # ▒
    0x2593: (0x5F, 0xB2), # ▓
    0xFFED: (0x5F, 0xFE), # ￭
    0x25A0: (0x5F, 0xFE), # ■

    # TIS-620-2533
    0x2190: (0x60, 0x8c), # ←
    0x2191: (0x60, 0x8d), # ↑
    0x2192: (0x60, 0x8e), # →
    0x2193: (0x60, 0x8f), # ↓
    0x00A0: (0x60, 0xA0), #  
    0x0E01: (0x60, 0xA1), # ก
    0x0E02: (0x60, 0xA2), # ข
    0x0E03: (0x60, 0xA3), # ฃ
    0x0E04: (0x60, 0xA4), # ค
    0x0E05: (0x60, 0xA5), # ฅ
    0x0E06: (0x60, 0xA6), # ฆ
    0x0E07: (0x60, 0xA7), # ง
    0x0E08: (0x60, 0xA8), # จ
    0x0E09: (0x60, 0xA9), # ฉ
    0x0E0A: (0x60, 0xAA), # ช
    0x0E0B: (0x60, 0xAB), # ซ
    0x0E0C: (0x60, 0xAC), # ฌ
    0x0E0D: (0x60, 0xAD), # ญ
    0x0E0E: (0x60, 0xAE), # ฎ
    0x0E0F: (0x60, 0xAF), # ฏ
    0x0E10: (0x60, 0xB0), # ฐ
    0x0E11: (0x60, 0xB1), # ฑ
    0x0E12: (0x60, 0xB2), # ฒ
    0x0E13: (0x60, 0xB3), # ณ
    0x0E14: (0x60, 0xB4), # ด
    0x0E15: (0x60, 0xB5), # ต
    0x0E16: (0x60, 0xB6), # ถ
    0x0E17: (0x60, 0xB7), # ท
    0x0E18: (0x60, 0xB8), # ธ
    0x0E19: (0x60, 0xB9), # น
    0x0E1A: (0x60, 0xBA), # บ
    0x0E1B: (0x60, 0xBB), # ป
    0x0E1C: (0x60, 0xBC), # ผ
    0x0E1D: (0x60, 0xBD), # ฝ
    0x0E1E: (0x60, 0xBE), # พ
    0x0E1F: (0x60, 0xBF), # ฟ
    0x0E20: (0x60, 0xC0), # ภ
    0x0E21: (0x60, 0xC1), # ม
    0x0E22: (0x60, 0xC2), # ย
    0x0E23: (0x60, 0xC3), # ร
    0x0E24: (0x60, 0xC4), # ฤ
    0x0E25: (0x60, 0xC5), # ล
    0x0E26: (0x60, 0xC6), # ฦ
    0x0E27: (0x60, 0xC7), # ว
    0x0E28: (0x60, 0xC8), # ศ
    0x0E29: (0x60, 0xC9), # ษ
    0x0E2A: (0x60, 0xCA), # ส
    0x0E2B: (0x60, 0xCB), # ห
    0x0E2C: (0x60, 0xCC), # ฬ
    0x0E2D: (0x60, 0xCD), # อ
    0x0E2E: (0x60, 0xCE), # ฮ
    0x0E2F: (0x60, 0xCF), # ฯ
    0x0E30: (0x60, 0xD0), # ะ
    0x0E31: (0x60, 0xD1), # ั
    0x0E32: (0x60, 0xD2), # า
    0x0E33: (0x60, 0xD3), # ำ
    0x0E34: (0x60, 0xD4), # ิ
    0x0E35: (0x60, 0xD5), # ี
    0x0E36: (0x60, 0xD6), # ึ
    0x0E37: (0x60, 0xD7), # ื
    0x0E38: (0x60, 0xD8), # ุ
    0x0E39: (0x60, 0xD9), # ู
    0x0E3A: (0x60, 0xDA), # ฺ
    0x2060: (0x60, 0xDB), # ⁠
    0x200B: (0x60, 0xDC), # ​
    # 0x2013: (0x60, 0xDD), # –
    # 0x2014: (0x60, 0xDE), # —
    0x0E3F: (0x60, 0xDF), # ฿
    0x0E40: (0x60, 0xE0), # เ
    0x0E41: (0x60, 0xE1), # แ
    0x0E42: (0x60, 0xE2), # โ
    0x0E43: (0x60, 0xE3), # ใ
    0x0E44: (0x60, 0xE4), # ไ
    0x0E45: (0x60, 0xE5), # ๅ
    0x0E46: (0x60, 0xE6), # ๆ
    0x0E47: (0x60, 0xE7), # ็
    0x0E48: (0x60, 0xE8), # ่
    0x0E49: (0x60, 0xE9), # ้
    0x0E4A: (0x60, 0xEA), # ๊
    0x0E4B: (0x60, 0xEB), # ๋
    0x0E4C: (0x60, 0xEC), # ์
    0x0E4D: (0x60, 0xED), # ํ
    0x2122: (0x60, 0xEE), # ™
    0x0E4F: (0x60, 0xEF), # ๏
    0x0E50: (0x60, 0xF0), # ๐
    0x0E51: (0x60, 0xF1), # ๑
    0x0E52: (0x60, 0xF2), # ๒
    0x0E53: (0x60, 0xF3), # ๓
    0x0E54: (0x60, 0xF4), # ๔
    0x0E55: (0x60, 0xF5), # ๕
    0x0E56: (0x60, 0xF6), # ๖
    0x0E57: (0x60, 0xF7), # ๗
    0x0E58: (0x60, 0xF8), # ๘
    0x0E59: (0x60, 0xF9), # ๙
    0x0E5B: (0x60, 0xFA), # ๛

}
