"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.P6Namer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const lambdajs = require("aws-cdk-lib/aws-lambda-nodejs");
const cr = require("aws-cdk-lib/custom-resources");
const floyd = require("cdk-iam-floyd");
class P6Namer extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const policy = new floyd.Iam()
            .allow()
            .toCreateAccountAlias();
        const onEvent = new lambdajs.NodejsFunction(this, 'p6namer', {
            runtime: lambda.Runtime.NODEJS_14_X,
            timeout: cdk.Duration.seconds(2),
            tracing: lambda.Tracing.ACTIVE,
            bundling: {
                minify: true,
                externalModules: [
                    'aws-sdk',
                ],
            },
        });
        onEvent.addToRolePolicy(policy);
        const provider = new cr.Provider(this, 'P6Namer/Provider', {
            onEventHandler: onEvent,
        });
        new cdk.CustomResource(this, 'P6Namer/CR', {
            serviceToken: provider.serviceToken,
            properties: {
                AccountAlias: props.accountAlias,
            },
        });
    }
}
exports.P6Namer = P6Namer;
_a = JSII_RTTI_SYMBOL_1;
P6Namer[_a] = { fqn: "p6-namer.P6Namer", version: "0.7.175" };
//# sourceMappingURL=data:application/json;base64,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