"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Appstream = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [appstream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonappstream2.0.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Appstream extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [appstream](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonappstream2.0.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'appstream';
        this.accessLevelList = {
            Write: [
                'AssociateApplicationFleet',
                'AssociateApplicationToEntitlement',
                'AssociateFleet',
                'BatchAssociateUserStack',
                'BatchDisassociateUserStack',
                'CopyImage',
                'CreateAppBlock',
                'CreateApplication',
                'CreateDirectoryConfig',
                'CreateEntitlement',
                'CreateFleet',
                'CreateImageBuilder',
                'CreateImageBuilderStreamingURL',
                'CreateStack',
                'CreateStreamingURL',
                'CreateUpdatedImage',
                'CreateUsageReportSubscription',
                'CreateUser',
                'DeleteAppBlock',
                'DeleteApplication',
                'DeleteDirectoryConfig',
                'DeleteEntitlement',
                'DeleteFleet',
                'DeleteImage',
                'DeleteImageBuilder',
                'DeleteImagePermissions',
                'DeleteStack',
                'DeleteUsageReportSubscription',
                'DeleteUser',
                'DisableUser',
                'DisassociateApplicationFleet',
                'DisassociateApplicationFromEntitlement',
                'DisassociateFleet',
                'EnableUser',
                'ExpireSession',
                'StartFleet',
                'StartImageBuilder',
                'StopFleet',
                'StopImageBuilder',
                'Stream',
                'UpdateApplication',
                'UpdateDirectoryConfig',
                'UpdateEntitlement',
                'UpdateFleet',
                'UpdateImagePermissions',
                'UpdateStack'
            ],
            Read: [
                'DescribeAppBlocks',
                'DescribeApplicationFleetAssociations',
                'DescribeApplications',
                'DescribeDirectoryConfigs',
                'DescribeEntitlements',
                'DescribeFleets',
                'DescribeImageBuilders',
                'DescribeImagePermissions',
                'DescribeImages',
                'DescribeSessions',
                'DescribeStacks',
                'DescribeUsageReportSubscriptions',
                'DescribeUserStackAssociations',
                'DescribeUsers',
                'ListAssociatedFleets',
                'ListAssociatedStacks',
                'ListTagsForResource'
            ],
            List: [
                'ListEntitledApplications'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate the specified application with the fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AssociateApplicationFleet.html
     */
    toAssociateApplicationFleet() {
        return this.to('AssociateApplicationFleet');
    }
    /**
     * Grants permission to associate the specified application to the specified entitlement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AssociateApplicationToEntitlement.html
     */
    toAssociateApplicationToEntitlement() {
        return this.to('AssociateApplicationToEntitlement');
    }
    /**
     * Grants permission to associate the specified fleet with the specified stack
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AssociateFleet.html
     */
    toAssociateFleet() {
        return this.to('AssociateFleet');
    }
    /**
     * Grants permission to associate the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_BatchAssociateUserStack.html
     */
    toBatchAssociateUserStack() {
        return this.to('BatchAssociateUserStack');
    }
    /**
     * Grants permission to disassociate the specified users from the specified stacks
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_BatchDisassociateUserStack.html
     */
    toBatchDisassociateUserStack() {
        return this.to('BatchDisassociateUserStack');
    }
    /**
     * Grants permission to copy the specified image within the same Region or to a new Region within the same AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CopyImage.html
     */
    toCopyImage() {
        return this.to('CopyImage');
    }
    /**
     * Grants permission to create an app block. App blocks store details about the virtual hard disk that contains the files for the application in an S3 bucket. It also stores the setup script with details about how to mount the virtual hard disk. App blocks are only supported for Elastic fleets
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateAppBlock.html
     */
    toCreateAppBlock() {
        return this.to('CreateAppBlock');
    }
    /**
     * Grants permission to create an application within customer account. Applications store the details about how to launch applications on streaming instances. This is only supported for Elastic fleets
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * Grants permission to create a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateDirectoryConfig.html
     */
    toCreateDirectoryConfig() {
        return this.to('CreateDirectoryConfig');
    }
    /**
     * Grants permission to create an entitlement to control access to applications based on user attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateEntitlement.html
     */
    toCreateEntitlement() {
        return this.to('CreateEntitlement');
    }
    /**
     * Grants permission to create a fleet. A fleet is a group of streaming instances from which applications are launched and streamed to users
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateFleet.html
     */
    toCreateFleet() {
        return this.to('CreateFleet');
    }
    /**
     * Grants permission to create an image builder. An image builder is a virtual machine that is used to create an image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateImageBuilder.html
     */
    toCreateImageBuilder() {
        return this.to('CreateImageBuilder');
    }
    /**
     * Grants permission to create a URL to start an image builder streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateImageBuilderStreamingURL.html
     */
    toCreateImageBuilderStreamingURL() {
        return this.to('CreateImageBuilderStreamingURL');
    }
    /**
     * Grants permission to create a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateStack.html
     */
    toCreateStack() {
        return this.to('CreateStack');
    }
    /**
     * Grants permission to create a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateStreamingURL.html
     */
    toCreateStreamingURL() {
        return this.to('CreateStreamingURL');
    }
    /**
     * Grants permission to update an existing image within customer account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateUpdatedImage.html
     */
    toCreateUpdatedImage() {
        return this.to('CreateUpdatedImage');
    }
    /**
     * Grants permission to create a usage report subscription. Usage reports are generated daily
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateUsageReportSubscription.html
     */
    toCreateUsageReportSubscription() {
        return this.to('CreateUsageReportSubscription');
    }
    /**
     * Grants permission to create a new user in the user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to delete the specified app block
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteAppBlock.html
     */
    toDeleteAppBlock() {
        return this.to('DeleteAppBlock');
    }
    /**
     * Grants permission to delete the specified application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication() {
        return this.to('DeleteApplication');
    }
    /**
     * Grants permission to delete the specified Directory Config object from AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteDirectoryConfig.html
     */
    toDeleteDirectoryConfig() {
        return this.to('DeleteDirectoryConfig');
    }
    /**
     * Grants permission to delete the specified entitlement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteEntitlement.html
     */
    toDeleteEntitlement() {
        return this.to('DeleteEntitlement');
    }
    /**
     * Grants permission to delete the specified fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteFleet.html
     */
    toDeleteFleet() {
        return this.to('DeleteFleet');
    }
    /**
     * Grants permission to delete the specified image. An image cannot be deleted when it is in use
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteImage.html
     */
    toDeleteImage() {
        return this.to('DeleteImage');
    }
    /**
     * Grants permission to delete the specified image builder and release capacity
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteImageBuilder.html
     */
    toDeleteImageBuilder() {
        return this.to('DeleteImageBuilder');
    }
    /**
     * Grants permission to delete permissions for the specified private image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteImagePermissions.html
     */
    toDeleteImagePermissions() {
        return this.to('DeleteImagePermissions');
    }
    /**
     * Grants permission to delete the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteStack.html
     */
    toDeleteStack() {
        return this.to('DeleteStack');
    }
    /**
     * Grants permission to disable usage report generation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteUsageReportSubscription.html
     */
    toDeleteUsageReportSubscription() {
        return this.to('DeleteUsageReportSubscription');
    }
    /**
     * Grants permission to delete a user from the user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to retrieve a list that describes one or more specified app blocks, if the app block arns are provided. Otherwise, all app blocks in the account are described
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeAppBlocks.html
     */
    toDescribeAppBlocks() {
        return this.to('DescribeAppBlocks');
    }
    /**
     * Grants permission to retrieve the associations that are associated with the specified application or fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeApplicationFleetAssociations.html
     */
    toDescribeApplicationFleetAssociations() {
        return this.to('DescribeApplicationFleetAssociations');
    }
    /**
     * Grants permission to retrieve a list that describes one or more specified applications, if the application arns are provided. Otherwise, all applications in the account are described
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeApplications.html
     */
    toDescribeApplications() {
        return this.to('DescribeApplications');
    }
    /**
     * Grants permission to retrieve a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeDirectoryConfigs.html
     */
    toDescribeDirectoryConfigs() {
        return this.to('DescribeDirectoryConfigs');
    }
    /**
     * Grants permission to retrieve one or all entitlements for the specified stack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeEntitlements.html
     */
    toDescribeEntitlements() {
        return this.to('DescribeEntitlements');
    }
    /**
     * Grants permission to retrieve a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeFleets.html
     */
    toDescribeFleets() {
        return this.to('DescribeFleets');
    }
    /**
     * Grants permission to retrieve a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeImageBuilders.html
     */
    toDescribeImageBuilders() {
        return this.to('DescribeImageBuilders');
    }
    /**
     * Grants permission to retrieve a list that describes the permissions for shared AWS account IDs on a private image that you own
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeImagePermissions.html
     */
    toDescribeImagePermissions() {
        return this.to('DescribeImagePermissions');
    }
    /**
     * Grants permission to retrieve a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeImages.html
     */
    toDescribeImages() {
        return this.to('DescribeImages');
    }
    /**
     * Grants permission to retrieve a list that describes the streaming sessions for the specified stack and fleet. If a user ID is provided for the stack and fleet, only the streaming sessions for that user are described
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeSessions.html
     */
    toDescribeSessions() {
        return this.to('DescribeSessions');
    }
    /**
     * Grants permission to retrieve a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeStacks.html
     */
    toDescribeStacks() {
        return this.to('DescribeStacks');
    }
    /**
     * Grants permission to retrieve a list that describes one or more usage report subscriptions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeUsageReportSubscriptions.html
     */
    toDescribeUsageReportSubscriptions() {
        return this.to('DescribeUsageReportSubscriptions');
    }
    /**
     * Grants permission to retrieve a list that describes the UserStackAssociation objects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeUserStackAssociations.html
     */
    toDescribeUserStackAssociations() {
        return this.to('DescribeUserStackAssociations');
    }
    /**
     * Grants permission to retrieve a list that describes users in the user pool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DescribeUsers.html
     */
    toDescribeUsers() {
        return this.to('DescribeUsers');
    }
    /**
     * Grants permission to disable the specified user in the user pool. This action does not delete the user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DisableUser.html
     */
    toDisableUser() {
        return this.to('DisableUser');
    }
    /**
     * Grants permission to disassociate the specified application from the specified fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DisassociateApplicationFleet.html
     */
    toDisassociateApplicationFleet() {
        return this.to('DisassociateApplicationFleet');
    }
    /**
     * Grants permission to disassociate the specified application from the specified entitlement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DisassociateApplicationFromEntitlement.html
     */
    toDisassociateApplicationFromEntitlement() {
        return this.to('DisassociateApplicationFromEntitlement');
    }
    /**
     * Grants permission to disassociate the specified fleet from the specified stack
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_DisassociateFleet.html
     */
    toDisassociateFleet() {
        return this.to('DisassociateFleet');
    }
    /**
     * Grants permission to enable a user in the user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_EnableUser.html
     */
    toEnableUser() {
        return this.to('EnableUser');
    }
    /**
     * Grants permission to immediately stop the specified streaming session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ExpireSession.html
     */
    toExpireSession() {
        return this.to('ExpireSession');
    }
    /**
     * Grants permission to retrieve the name of the fleet that is associated with the specified stack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ListAssociatedFleets.html
     */
    toListAssociatedFleets() {
        return this.to('ListAssociatedFleets');
    }
    /**
     * Grants permission to retrieve the name of the stack with which the specified fleet is associated
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ListAssociatedStacks.html
     */
    toListAssociatedStacks() {
        return this.to('ListAssociatedStacks');
    }
    /**
     * Grants permission to retrieve the applications that are associated with the specified entitlement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ListEntitledApplications.html
     */
    toListEntitledApplications() {
        return this.to('ListEntitledApplications');
    }
    /**
     * Grants permission to retrieve a list of all tags for the specified AppStream 2.0 resource. The following resources can be tagged: Image builders, images, fleets, and stacks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to start the specified fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_StartFleet.html
     */
    toStartFleet() {
        return this.to('StartFleet');
    }
    /**
     * Grants permission to start the specified image builder
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_StartImageBuilder.html
     */
    toStartImageBuilder() {
        return this.to('StartImageBuilder');
    }
    /**
     * Grants permission to stop the specified fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_StopFleet.html
     */
    toStopFleet() {
        return this.to('StopFleet');
    }
    /**
     * Grants permission to stop the specified image builder
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_StopImageBuilder.html
     */
    toStopImageBuilder() {
        return this.to('StopImageBuilder');
    }
    /**
     * Grants permission to federated users to sign in by using their existing credentials and stream applications from the specified stack
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserId()
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/external-identity-providers-setting-up-saml.html#external-identity-providers-embed-inline-policy-for-IAM-role
     */
    toStream() {
        return this.to('Stream');
    }
    /**
     * Grants permission to add or overwrite one or more tags for the specified AppStream 2.0 resource. The following resources can be tagged: Image builders, images, fleets, stacks, app blocks and applications
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to disassociate one or more tags from the specified AppStream 2.0 resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the specified fields for the specified application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
    /**
     * Grants permission to update the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_UpdateDirectoryConfig.html
     */
    toUpdateDirectoryConfig() {
        return this.to('UpdateDirectoryConfig');
    }
    /**
     * Grants permission to update the specified fields for the specified entitlement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_UpdateEntitlement.html
     */
    toUpdateEntitlement() {
        return this.to('UpdateEntitlement');
    }
    /**
     * Grants permission to update the specified fleet. All attributes except the fleet name can be updated when the fleet is in the STOPPED state
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_UpdateFleet.html
     */
    toUpdateFleet() {
        return this.to('UpdateFleet');
    }
    /**
     * Grants permission to add or update permissions for the specified private image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_UpdateImagePermissions.html
     */
    toUpdateImagePermissions() {
        return this.to('UpdateImagePermissions');
    }
    /**
     * Grants permission to update the specified fields for the specified stack
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appstream2/latest/APIReference/API_UpdateStack.html
     */
    toUpdateStack() {
        return this.to('UpdateStack');
    }
    /**
     * Adds a resource of type fleet to the statement
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/what-is-appstream.html#what-is-concepts
     *
     * @param fleetName - Identifier for the fleetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFleet(fleetName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:appstream:${region || '*'}:${account || '*'}:fleet/${fleetName}`);
    }
    /**
     * Adds a resource of type image to the statement
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/what-is-appstream.html#what-is-concepts
     *
     * @param imageName - Identifier for the imageName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImage(imageName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:appstream:${region || '*'}:${account || '*'}:image/${imageName}`);
    }
    /**
     * Adds a resource of type image-builder to the statement
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/what-is-appstream.html#what-is-concepts
     *
     * @param imageBuilderName - Identifier for the imageBuilderName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImageBuilder(imageBuilderName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:appstream:${region || '*'}:${account || '*'}:image-builder/${imageBuilderName}`);
    }
    /**
     * Adds a resource of type stack to the statement
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/what-is-appstream.html#what-is-concepts
     *
     * @param stackName - Identifier for the stackName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStack(stackName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:appstream:${region || '*'}:${account || '*'}:stack/${stackName}`);
    }
    /**
     * Adds a resource of type app-block to the statement
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/what-is-appstream.html#what-is-concepts
     *
     * @param appBlockName - Identifier for the appBlockName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppBlock(appBlockName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:appstream:${region || '*'}:${account || '*'}:app-block/${appBlockName}`);
    }
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/what-is-appstream.html#what-is-concepts
     *
     * @param applicationName - Identifier for the applicationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(applicationName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:appstream:${region || '*'}:${account || '*'}:application/${applicationName}`);
    }
    /**
     * Filters access by the ID of the AppStream 2.0 user
     *
     * https://docs.aws.amazon.com/appstream2/latest/developerguide/external-identity-providers-setting-up-saml.html#external-identity-providers-embed-inline-policy-for-IAM-role
     *
     * Applies to actions:
     * - .toStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserId(value, operator) {
        return this.if(`userId`, value, operator || 'StringLike');
    }
}
exports.Appstream = Appstream;
_a = JSII_RTTI_SYMBOL_1;
Appstream[_a] = { fqn: "cdk-iam-floyd.Appstream", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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