"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Clouddirectory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [clouddirectory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonclouddirectory.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Clouddirectory extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [clouddirectory](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonclouddirectory.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'clouddirectory';
        this.accessLevelList = {
            Write: [
                'AddFacetToObject',
                'ApplySchema',
                'AttachObject',
                'AttachPolicy',
                'AttachToIndex',
                'AttachTypedLink',
                'BatchWrite',
                'CreateDirectory',
                'CreateFacet',
                'CreateIndex',
                'CreateObject',
                'CreateSchema',
                'CreateTypedLinkFacet',
                'DeleteDirectory',
                'DeleteFacet',
                'DeleteObject',
                'DeleteSchema',
                'DeleteTypedLinkFacet',
                'DetachFromIndex',
                'DetachObject',
                'DetachPolicy',
                'DetachTypedLink',
                'DisableDirectory',
                'EnableDirectory',
                'PublishSchema',
                'PutSchemaFromJson',
                'RemoveFacetFromObject',
                'UpdateFacet',
                'UpdateLinkAttributes',
                'UpdateObjectAttributes',
                'UpdateSchema',
                'UpdateTypedLinkFacet'
            ],
            Read: [
                'BatchRead',
                'GetDirectory',
                'GetFacet',
                'GetLinkAttributes',
                'GetObjectAttributes',
                'GetObjectInformation',
                'GetSchemaAsJson',
                'GetTypedLinkFacetInformation',
                'ListAttachedIndices',
                'ListFacetAttributes',
                'ListFacetNames',
                'ListIncomingTypedLinks',
                'ListIndex',
                'ListObjectAttributes',
                'ListObjectChildren',
                'ListObjectParentPaths',
                'ListObjectParents',
                'ListObjectPolicies',
                'ListOutgoingTypedLinks',
                'ListPolicyAttachments',
                'ListTagsForResource',
                'ListTypedLinkFacetAttributes',
                'ListTypedLinkFacetNames',
                'LookupPolicy'
            ],
            List: [
                'ListAppliedSchemaArns',
                'ListDevelopmentSchemaArns',
                'ListDirectories',
                'ListManagedSchemaArns',
                'ListPublishedSchemaArns'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Adds a new Facet to an object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AddFacetToObject.html
     */
    toAddFacetToObject() {
        return this.to('AddFacetToObject');
    }
    /**
     * Copies input published schema into Directory with same name and version as that of published schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ApplySchema.html
     */
    toApplySchema() {
        return this.to('ApplySchema');
    }
    /**
     * Attaches an existing object to another existing object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachObject.html
     */
    toAttachObject() {
        return this.to('AttachObject');
    }
    /**
     * Attaches a policy object to any other object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachPolicy.html
     */
    toAttachPolicy() {
        return this.to('AttachPolicy');
    }
    /**
     * Attaches the specified object to the specified index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachToIndex.html
     */
    toAttachToIndex() {
        return this.to('AttachToIndex');
    }
    /**
     * Attaches a typed link b/w a source & target object reference.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_AttachTypedLink.html
     */
    toAttachTypedLink() {
        return this.to('AttachTypedLink');
    }
    /**
     * Performs all the read operations in a batch. Each individual operation inside BatchRead needs to be granted permissions explicitly.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_BatchRead.html
     */
    toBatchRead() {
        return this.to('BatchRead');
    }
    /**
     * Performs all the write operations in a batch. Each individual operation inside BatchWrite needs to be granted permissions explicitly.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_BatchWrite.html
     */
    toBatchWrite() {
        return this.to('BatchWrite');
    }
    /**
     * Creates a Directory by copying the published schema into the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateDirectory.html
     */
    toCreateDirectory() {
        return this.to('CreateDirectory');
    }
    /**
     * Creates a new Facet in a schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateFacet.html
     */
    toCreateFacet() {
        return this.to('CreateFacet');
    }
    /**
     * Creates an index object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateIndex.html
     */
    toCreateIndex() {
        return this.to('CreateIndex');
    }
    /**
     * Creates an object in a Directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateObject.html
     */
    toCreateObject() {
        return this.to('CreateObject');
    }
    /**
     * Creates a new schema in a development state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateSchema.html
     */
    toCreateSchema() {
        return this.to('CreateSchema');
    }
    /**
     * Creates a new Typed Link facet in a schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_CreateTypedLinkFacet.html
     */
    toCreateTypedLinkFacet() {
        return this.to('CreateTypedLinkFacet');
    }
    /**
     * Deletes a directory. Only disabled directories can be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteDirectory.html
     */
    toDeleteDirectory() {
        return this.to('DeleteDirectory');
    }
    /**
     * Deletes a given Facet. All attributes and Rules associated with the facet will be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteFacet.html
     */
    toDeleteFacet() {
        return this.to('DeleteFacet');
    }
    /**
     * Deletes an object and its associated attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteObject.html
     */
    toDeleteObject() {
        return this.to('DeleteObject');
    }
    /**
     * Deletes a given schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteSchema.html
     */
    toDeleteSchema() {
        return this.to('DeleteSchema');
    }
    /**
     * Deletes a given TypedLink Facet. All attributes and Rules associated with the facet will be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DeleteTypedLinkFacet.html
     */
    toDeleteTypedLinkFacet() {
        return this.to('DeleteTypedLinkFacet');
    }
    /**
     * Detaches the specified object from the specified index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachFromIndex.html
     */
    toDetachFromIndex() {
        return this.to('DetachFromIndex');
    }
    /**
     * Detaches a given object from the parent object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachObject.html
     */
    toDetachObject() {
        return this.to('DetachObject');
    }
    /**
     * Detaches a policy from an object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachPolicy.html
     */
    toDetachPolicy() {
        return this.to('DetachPolicy');
    }
    /**
     * Detaches a given typed link b/w given source and target object reference.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DetachTypedLink.html
     */
    toDetachTypedLink() {
        return this.to('DetachTypedLink');
    }
    /**
     * Disables the specified directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_DisableDirectory.html
     */
    toDisableDirectory() {
        return this.to('DisableDirectory');
    }
    /**
     * Enables the specified directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_EnableDirectory.html
     */
    toEnableDirectory() {
        return this.to('EnableDirectory');
    }
    /**
     * Retrieves metadata about a directory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetDirectory.html
     */
    toGetDirectory() {
        return this.to('GetDirectory');
    }
    /**
     * Gets details of the Facet, such as Facet Name, Attributes, Rules, or ObjectType.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetFacet.html
     */
    toGetFacet() {
        return this.to('GetFacet');
    }
    /**
     * Retrieves attributes that are associated with a typed link.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetLinkAttributes.html
     */
    toGetLinkAttributes() {
        return this.to('GetLinkAttributes');
    }
    /**
     * Retrieves attributes within a facet that are associated with an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetObjectAttributes.html
     */
    toGetObjectAttributes() {
        return this.to('GetObjectAttributes');
    }
    /**
     * Retrieves metadata about an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetObjectInformation.html
     */
    toGetObjectInformation() {
        return this.to('GetObjectInformation');
    }
    /**
     * Retrieves a JSON representation of the schema.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetSchemaAsJson.html
     */
    toGetSchemaAsJson() {
        return this.to('GetSchemaAsJson');
    }
    /**
     * Returns identity attributes order information associated with a given typed link facet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_GetTypedLinkFacetInformation.html
     */
    toGetTypedLinkFacetInformation() {
        return this.to('GetTypedLinkFacetInformation');
    }
    /**
     * Lists schemas applied to a directory.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListAppliedSchemaArns.html
     */
    toListAppliedSchemaArns() {
        return this.to('ListAppliedSchemaArns');
    }
    /**
     * Lists indices attached to an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListAttachedIndices.html
     */
    toListAttachedIndices() {
        return this.to('ListAttachedIndices');
    }
    /**
     * Retrieves the ARNs of schemas in the development state.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListDevelopmentSchemaArns.html
     */
    toListDevelopmentSchemaArns() {
        return this.to('ListDevelopmentSchemaArns');
    }
    /**
     * Lists directories created within an account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListDirectories.html
     */
    toListDirectories() {
        return this.to('ListDirectories');
    }
    /**
     * Retrieves attributes attached to the facet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListFacetAttributes.html
     */
    toListFacetAttributes() {
        return this.to('ListFacetAttributes');
    }
    /**
     * Retrieves the names of facets that exist in a schema.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListFacetNames.html
     */
    toListFacetNames() {
        return this.to('ListFacetNames');
    }
    /**
     * Returns a paginated list of all incoming TypedLinks for a given object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListIncomingTypedLinks.html
     */
    toListIncomingTypedLinks() {
        return this.to('ListIncomingTypedLinks');
    }
    /**
     * Lists objects attached to the specified index.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListIndex.html
     */
    toListIndex() {
        return this.to('ListIndex');
    }
    /**
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListManagedSchemaArns.html
     */
    toListManagedSchemaArns() {
        return this.to('ListManagedSchemaArns');
    }
    /**
     * Lists all attributes associated with an object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectAttributes.html
     */
    toListObjectAttributes() {
        return this.to('ListObjectAttributes');
    }
    /**
     * Returns a paginated list of child objects associated with a given object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectChildren.html
     */
    toListObjectChildren() {
        return this.to('ListObjectChildren');
    }
    /**
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectParentPaths.html
     */
    toListObjectParentPaths() {
        return this.to('ListObjectParentPaths');
    }
    /**
     * Lists parent objects associated with a given object in pagination fashion.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectParents.html
     */
    toListObjectParents() {
        return this.to('ListObjectParents');
    }
    /**
     * Returns policies attached to an object in pagination fashion.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListObjectPolicies.html
     */
    toListObjectPolicies() {
        return this.to('ListObjectPolicies');
    }
    /**
     * Returns a paginated list of all outgoing TypedLinks for a given object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListOutgoingTypedLinks.html
     */
    toListOutgoingTypedLinks() {
        return this.to('ListOutgoingTypedLinks');
    }
    /**
     * Returns all of the ObjectIdentifiers to which a given policy is attached.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListPolicyAttachments.html
     */
    toListPolicyAttachments() {
        return this.to('ListPolicyAttachments');
    }
    /**
     * Retrieves published schema ARNs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListPublishedSchemaArns.html
     */
    toListPublishedSchemaArns() {
        return this.to('ListPublishedSchemaArns');
    }
    /**
     * Returns tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Returns a paginated list of attributes associated with typed link facet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTypedLinkFacetAttributes.html
     */
    toListTypedLinkFacetAttributes() {
        return this.to('ListTypedLinkFacetAttributes');
    }
    /**
     * Returns a paginated list of typed link facet names that exist in a schema.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_ListTypedLinkFacetNames.html
     */
    toListTypedLinkFacetNames() {
        return this.to('ListTypedLinkFacetNames');
    }
    /**
     * Lists all policies from the root of the Directory to the object specified.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_LookupPolicy.html
     */
    toLookupPolicy() {
        return this.to('LookupPolicy');
    }
    /**
     * Publishes a development schema with a version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_PublishSchema.html
     */
    toPublishSchema() {
        return this.to('PublishSchema');
    }
    /**
     * Allows a schema to be updated using JSON upload. Only available for development schemas.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_PutSchemaFromJson.html
     */
    toPutSchemaFromJson() {
        return this.to('PutSchemaFromJson');
    }
    /**
     * Removes the specified facet from the specified object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_RemoveFacetFromObject.html
     */
    toRemoveFacetFromObject() {
        return this.to('RemoveFacetFromObject');
    }
    /**
     * Adds tags to a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Removes tags from a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Adds/Updates/Deletes existing Attributes, Rules, or ObjectType of a Facet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateFacet.html
     */
    toUpdateFacet() {
        return this.to('UpdateFacet');
    }
    /**
     * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its IdentityAttributeOrder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateLinkAttributes.html
     */
    toUpdateLinkAttributes() {
        return this.to('UpdateLinkAttributes');
    }
    /**
     * Updates a given object's attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateObjectAttributes.html
     */
    toUpdateObjectAttributes() {
        return this.to('UpdateObjectAttributes');
    }
    /**
     * Updates the schema name with a new name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateSchema.html
     */
    toUpdateSchema() {
        return this.to('UpdateSchema');
    }
    /**
     * Adds/Updates/Deletes existing Attributes, Rules, identity attribute order of a TypedLink Facet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directoryservice/latest/APIReference/API_UpdateTypedLinkFacet.html
     */
    toUpdateTypedLinkFacet() {
        return this.to('UpdateTypedLinkFacet');
    }
    /**
     * Adds a resource of type appliedSchema to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param directoryId - Identifier for the directoryId.
     * @param schemaName - Identifier for the schemaName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAppliedSchema(directoryId, schemaName, version, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:clouddirectory:${region || '*'}:${account || '*'}:directory/${directoryId}/schema/${schemaName}/${version}`);
    }
    /**
     * Adds a resource of type developmentSchema to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDevelopmentSchema(schemaName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:clouddirectory:${region || '*'}:${account || '*'}:schema/development/${schemaName}`);
    }
    /**
     * Adds a resource of type directory to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDirectory(directoryId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:clouddirectory:${region || '*'}:${account || '*'}:directory/${directoryId}`);
    }
    /**
     * Adds a resource of type publishedSchema to the statement
     *
     * https://docs.aws.amazon.com/directoryservice/latest/admin-guide/cd_key_concepts.html#whatisdirectory
     *
     * @param schemaName - Identifier for the schemaName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onPublishedSchema(schemaName, version, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:clouddirectory:${region || '*'}:${account || '*'}:schema/published/${schemaName}/${version}`);
    }
}
exports.Clouddirectory = Clouddirectory;
_a = JSII_RTTI_SYMBOL_1;
Clouddirectory[_a] = { fqn: "cdk-iam-floyd.Clouddirectory", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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