"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Codedeploy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [codedeploy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploy.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Codedeploy extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [codedeploy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploy.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'codedeploy';
        this.accessLevelList = {
            Tagging: [
                'AddTagsToOnPremisesInstances',
                'RemoveTagsFromOnPremisesInstances',
                'TagResource',
                'UntagResource'
            ],
            Read: [
                'BatchGetApplicationRevisions',
                'BatchGetApplications',
                'BatchGetDeploymentGroups',
                'BatchGetDeploymentInstances',
                'BatchGetDeploymentTargets',
                'BatchGetDeployments',
                'BatchGetOnPremisesInstances',
                'GetDeploymentTarget'
            ],
            Write: [
                'ContinueDeployment',
                'CreateApplication',
                'CreateCloudFormationDeployment',
                'CreateDeployment',
                'CreateDeploymentConfig',
                'CreateDeploymentGroup',
                'DeleteApplication',
                'DeleteDeploymentConfig',
                'DeleteDeploymentGroup',
                'DeleteGitHubAccountToken',
                'DeleteResourcesByExternalId',
                'DeregisterOnPremisesInstance',
                'PutLifecycleEventHookExecutionStatus',
                'RegisterApplicationRevision',
                'RegisterOnPremisesInstance',
                'SkipWaitTimeForInstanceTermination',
                'StopDeployment',
                'UpdateApplication',
                'UpdateDeploymentGroup'
            ],
            List: [
                'GetApplication',
                'GetApplicationRevision',
                'GetDeployment',
                'GetDeploymentConfig',
                'GetDeploymentGroup',
                'GetDeploymentInstance',
                'GetOnPremisesInstance',
                'ListApplicationRevisions',
                'ListApplications',
                'ListDeploymentConfigs',
                'ListDeploymentGroups',
                'ListDeploymentInstances',
                'ListDeploymentTargets',
                'ListDeployments',
                'ListGitHubAccountTokenNames',
                'ListOnPremisesInstances',
                'ListTagsForResource'
            ]
        };
    }
    /**
     * Add tags to one or more on-premises instances.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_AddTagsToOnPremisesInstances.html
     */
    toAddTagsToOnPremisesInstances() {
        return this.to('AddTagsToOnPremisesInstances');
    }
    /**
     * Gets information about one or more application revisions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_BatchGetApplicationRevisions.html
     */
    toBatchGetApplicationRevisions() {
        return this.to('BatchGetApplicationRevisions');
    }
    /**
     * Get information about multiple applications associated with the IAM user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_BatchGetApplications.html
     */
    toBatchGetApplications() {
        return this.to('BatchGetApplications');
    }
    /**
     * Get information about one or more deployment groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_BatchGetDeploymentGroups.html
     */
    toBatchGetDeploymentGroups() {
        return this.to('BatchGetDeploymentGroups');
    }
    /**
     * Gets information about one or more instance that are part of a deployment group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_BatchGetDeploymentInstances.html
     */
    toBatchGetDeploymentInstances() {
        return this.to('BatchGetDeploymentInstances');
    }
    /**
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated BatchGetDeploymentInstances. The maximum number of targets that can be returned is 25.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_BatchGetDeploymentTargets.html
     */
    toBatchGetDeploymentTargets() {
        return this.to('BatchGetDeploymentTargets');
    }
    /**
     * Get information about multiple deployments associated with the IAM user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_BatchGetDeployments.html
     */
    toBatchGetDeployments() {
        return this.to('BatchGetDeployments');
    }
    /**
     * Get information about one or more on-premises instances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_BatchGetOnPremisesInstances.html
     */
    toBatchGetOnPremisesInstances() {
        return this.to('BatchGetOnPremisesInstances');
    }
    /**
     * Starts the process of rerouting traffic from instances in the original environment to instances in thereplacement environment without waiting for a specified wait time to elapse.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ContinueDeployment.html
     */
    toContinueDeployment() {
        return this.to('ContinueDeployment');
    }
    /**
     * Create an application associated with the IAM user.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * Create CloudFormation deployment to cooperate ochestration for a CloudFormation stack update.
     *
     * Access Level: Write
     */
    toCreateCloudFormationDeployment() {
        return this.to('CreateCloudFormationDeployment');
    }
    /**
     * Create a deployment for an application associated with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html
     */
    toCreateDeployment() {
        return this.to('CreateDeployment');
    }
    /**
     * Create a custom deployment configuration associated with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeploymentConfig.html
     */
    toCreateDeploymentConfig() {
        return this.to('CreateDeploymentConfig');
    }
    /**
     * Create a deployment group for an application associated with the IAM user.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeploymentGroup.html
     */
    toCreateDeploymentGroup() {
        return this.to('CreateDeploymentGroup');
    }
    /**
     * Delete an application associated with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication() {
        return this.to('DeleteApplication');
    }
    /**
     * Delete a custom deployment configuration associated with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_DeleteDeploymentConfig.html
     */
    toDeleteDeploymentConfig() {
        return this.to('DeleteDeploymentConfig');
    }
    /**
     * Delete a deployment group for an application associated with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_DeleteDeploymentGroup.html
     */
    toDeleteDeploymentGroup() {
        return this.to('DeleteDeploymentGroup');
    }
    /**
     * Deletes a GitHub account connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_DeleteGitHubAccountToken.html
     */
    toDeleteGitHubAccountToken() {
        return this.to('DeleteGitHubAccountToken');
    }
    /**
     * Delete resources associated with the given external Id.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_DeleteResourcesByExternalId.html
     */
    toDeleteResourcesByExternalId() {
        return this.to('DeleteResourcesByExternalId');
    }
    /**
     * Deregister an on-premises instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_DeregisterOnPremisesInstance.html
     */
    toDeregisterOnPremisesInstance() {
        return this.to('DeregisterOnPremisesInstance');
    }
    /**
     * Get information about a single application associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetApplication.html
     */
    toGetApplication() {
        return this.to('GetApplication');
    }
    /**
     * Get information about a single application revision for an application associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetApplicationRevision.html
     */
    toGetApplicationRevision() {
        return this.to('GetApplicationRevision');
    }
    /**
     * Get information about a single deployment to a deployment group for an application associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetDeployment.html
     */
    toGetDeployment() {
        return this.to('GetDeployment');
    }
    /**
     * Get information about a single deployment configuration associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetDeploymentConfig.html
     */
    toGetDeploymentConfig() {
        return this.to('GetDeploymentConfig');
    }
    /**
     * Get information about a single deployment group for an application associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetDeploymentGroup.html
     */
    toGetDeploymentGroup() {
        return this.to('GetDeploymentGroup');
    }
    /**
     * Get information about a single instance in a deployment associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetDeploymentInstance.html
     */
    toGetDeploymentInstance() {
        return this.to('GetDeploymentInstance');
    }
    /**
     * Returns information about a deployment target.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetDeploymentTarget.html
     */
    toGetDeploymentTarget() {
        return this.to('GetDeploymentTarget');
    }
    /**
     * Get information about a single on-premises instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_GetOnPremisesInstance.html
     */
    toGetOnPremisesInstance() {
        return this.to('GetOnPremisesInstance');
    }
    /**
     * Get information about all application revisions for an application associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListApplicationRevisions.html
     */
    toListApplicationRevisions() {
        return this.to('ListApplicationRevisions');
    }
    /**
     * Get information about all applications associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListApplications.html
     */
    toListApplications() {
        return this.to('ListApplications');
    }
    /**
     * Get information about all deployment configurations associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListDeploymentConfigs.html
     */
    toListDeploymentConfigs() {
        return this.to('ListDeploymentConfigs');
    }
    /**
     * Get information about all deployment groups for an application associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListDeploymentGroups.html
     */
    toListDeploymentGroups() {
        return this.to('ListDeploymentGroups');
    }
    /**
     * Get information about all instances in a deployment associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListDeploymentInstances.html
     */
    toListDeploymentInstances() {
        return this.to('ListDeploymentInstances');
    }
    /**
     * Returns an array of target IDs that are associated a deployment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListDeploymentTargets.html
     */
    toListDeploymentTargets() {
        return this.to('ListDeploymentTargets');
    }
    /**
     * Get information about all deployments to a deployment group associated with the IAM user, or to get all deployments associated with the IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListDeployments.html
     */
    toListDeployments() {
        return this.to('ListDeployments');
    }
    /**
     * Lists the names of stored connections to GitHub accounts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ ListGitHubAccountTokenNames.html
     */
    toListGitHubAccountTokenNames() {
        return this.to('ListGitHubAccountTokenNames');
    }
    /**
     * Get a list of one or more on-premises instance names.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ListOnPremisesInstances.html
     */
    toListOnPremisesInstances() {
        return this.to('ListOnPremisesInstances');
    }
    /**
     * Returns a list of tags for the resource identified by a specified ARN. Tags are used to organize and categorize your CodeDeploy resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Notify a lifecycle event hook execution status for associated deployment with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_PutLifecycleEventHookExecutionStatus.html
     */
    toPutLifecycleEventHookExecutionStatus() {
        return this.to('PutLifecycleEventHookExecutionStatus');
    }
    /**
     * Register information about an application revision for an application associated with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_RegisterApplicationRevision.html
     */
    toRegisterApplicationRevision() {
        return this.to('RegisterApplicationRevision');
    }
    /**
     * Register an on-premises instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_RegisterOnPremisesInstance.html
     */
    toRegisterOnPremisesInstance() {
        return this.to('RegisterOnPremisesInstance');
    }
    /**
     * Remove tags from one or more on-premises instances.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_RemoveTagsFromOnPremisesInstances.html
     */
    toRemoveTagsFromOnPremisesInstances() {
        return this.to('RemoveTagsFromOnPremisesInstances');
    }
    /**
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_ SkipWaitTimeForInstanceTermination.html
     */
    toSkipWaitTimeForInstanceTermination() {
        return this.to('SkipWaitTimeForInstanceTermination');
    }
    /**
     * Description for StopDeployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_StopDeployment.html
     */
    toStopDeployment() {
        return this.to('StopDeployment');
    }
    /**
     * Associates the list of tags in the input Tags parameter with the resource identified by the ResourceArn input parameter.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Disassociates a resource from a list of tags. The resource is identified by the ResourceArn input parameter. The tags are identfied by the list of keys in the TagKeys input parameter.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Description for UpdateApplication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
    /**
     * Change information about a single deployment group for an application associated with the IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_UpdateDeploymentGroup.html
     */
    toUpdateDeploymentGroup() {
        return this.to('UpdateDeploymentGroup');
    }
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/auth-and-access-control-permissions-reference.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onApplication(applicationName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:codedeploy:${region || '*'}:${account || '*'}:application:${applicationName}`);
    }
    /**
     * Adds a resource of type deploymentconfig to the statement
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/auth-and-access-control-permissions-reference.html
     *
     * @param deploymentConfigurationName - Identifier for the deploymentConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDeploymentconfig(deploymentConfigurationName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:codedeploy:${region || '*'}:${account || '*'}:deploymentconfig:${deploymentConfigurationName}`);
    }
    /**
     * Adds a resource of type deploymentgroup to the statement
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/auth-and-access-control-permissions-reference.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param deploymentGroupName - Identifier for the deploymentGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDeploymentgroup(applicationName, deploymentGroupName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:codedeploy:${region || '*'}:${account || '*'}:deploymentgroup:${applicationName}/${deploymentGroupName}`);
    }
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/auth-and-access-control-permissions-reference.html
     *
     * @param instanceName - Identifier for the instanceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onInstance(instanceName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:codedeploy:${region || '*'}:${account || '*'}:instance:${instanceName}`);
    }
}
exports.Codedeploy = Codedeploy;
_a = JSII_RTTI_SYMBOL_1;
Codedeploy[_a] = { fqn: "cdk-iam-floyd.Codedeploy", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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