"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Awsconnector = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Awsconnector extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'awsconnector';
        this.accessLevelList = {
            Read: [
                'GetConnectorHealth',
                'ValidateConnectorId'
            ],
            Write: [
                'RegisterConnector'
            ]
        };
    }
    /**
     * Retrieves all health metrics that were published from the Server Migration Connector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toGetConnectorHealth() {
        return this.to('GetConnectorHealth');
    }
    /**
     * Registers AWS Connector with AWS Connector Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toRegisterConnector() {
        return this.to('RegisterConnector');
    }
    /**
     * Validates Server Migration Connector Id that was registered with AWS Connector Service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toValidateConnectorId() {
        return this.to('ValidateConnectorId');
    }
}
exports.Awsconnector = Awsconnector;
_a = JSII_RTTI_SYMBOL_1;
Awsconnector[_a] = { fqn: "cdk-iam-floyd.Awsconnector", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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