"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Drs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Drs extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'drs';
        this.accessLevelList = {
            Write: [
                'AssociateFailbackClientToRecoveryInstanceForDrs',
                'BatchCreateVolumeSnapshotGroupForDrs',
                'BatchDeleteSnapshotRequestForDrs',
                'CreateRecoveryInstanceForDrs',
                'CreateReplicationConfigurationTemplate',
                'CreateSessionForDrs',
                'CreateSourceServerForDrs',
                'DeleteJob',
                'DeleteRecoveryInstance',
                'DeleteReplicationConfigurationTemplate',
                'DeleteSourceServer',
                'DisconnectRecoveryInstance',
                'DisconnectSourceServer',
                'InitializeService',
                'IssueAgentCertificateForDrs',
                'NotifyAgentAuthenticationForDrs',
                'NotifyAgentConnectedForDrs',
                'NotifyAgentDisconnectedForDrs',
                'NotifyAgentReplicationProgressForDrs',
                'NotifyConsistencyAttainedForDrs',
                'NotifyReplicationServerAuthenticationForDrs',
                'RetryDataReplication',
                'SendAgentLogsForDrs',
                'SendAgentMetricsForDrs',
                'SendChannelCommandResultForDrs',
                'SendClientLogsForDrs',
                'SendClientMetricsForDrs',
                'StartFailbackLaunch',
                'StartRecovery',
                'StopFailback',
                'TerminateRecoveryInstances',
                'UpdateAgentBacklogForDrs',
                'UpdateAgentConversionInfoForDrs',
                'UpdateAgentReplicationInfoForDrs',
                'UpdateAgentReplicationProcessStateForDrs',
                'UpdateAgentSourcePropertiesForDrs',
                'UpdateFailbackClientDeviceMappingForDrs',
                'UpdateFailbackClientLastSeenForDrs',
                'UpdateFailbackReplicationConfiguration',
                'UpdateLaunchConfiguration',
                'UpdateReplicationCertificateForDrs',
                'UpdateReplicationConfiguration',
                'UpdateReplicationConfigurationTemplate'
            ],
            Read: [
                'DescribeJobLogItems',
                'DescribeJobs',
                'DescribeRecoveryInstances',
                'DescribeRecoverySnapshots',
                'DescribeReplicationConfigurationTemplates',
                'DescribeReplicationServerAssociationsForDrs',
                'DescribeSnapshotRequestsForDrs',
                'DescribeSourceServers',
                'GetAgentCommandForDrs',
                'GetAgentConfirmedResumeInfoForDrs',
                'GetAgentInstallationAssetsForDrs',
                'GetAgentReplicationInfoForDrs',
                'GetAgentRuntimeConfigurationForDrs',
                'GetAgentSnapshotCreditsForDrs',
                'GetChannelCommandsForDrs',
                'GetFailbackCommandForDrs',
                'GetFailbackLaunchRequestedForDrs',
                'GetFailbackReplicationConfiguration',
                'GetLaunchConfiguration',
                'GetReplicationConfiguration',
                'GetSuggestedFailbackClientDeviceMappingForDrs',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to get associate failback client to recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toAssociateFailbackClientToRecoveryInstanceForDrs() {
        return this.to('AssociateFailbackClientToRecoveryInstanceForDrs');
    }
    /**
     * Grants permission to batch create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForDrs() {
        return this.to('BatchCreateVolumeSnapshotGroupForDrs');
    }
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchDeleteSnapshotRequestForDrs() {
        return this.to('BatchDeleteSnapshotRequestForDrs');
    }
    /**
     * Grants permission to create recovery instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateRecoveryInstanceForDrs() {
        return this.to('CreateRecoveryInstanceForDrs');
    }
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate() {
        return this.to('CreateReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to create a session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateSessionForDrs() {
        return this.to('CreateSessionForDrs');
    }
    /**
     * Grants permission to create a source server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateSourceServerForDrs() {
        return this.to('CreateSourceServerForDrs');
    }
    /**
     * Grants permission to delete a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * Grants permission to delete recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteRecoveryInstance.html
     */
    toDeleteRecoveryInstance() {
        return this.to('DeleteRecoveryInstance');
    }
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate() {
        return this.to('DeleteReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer() {
        return this.to('DeleteSourceServer');
    }
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems() {
        return this.to('DescribeJobLogItems');
    }
    /**
     * Grants permission to describe jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs() {
        return this.to('DescribeJobs');
    }
    /**
     * Grants permission to describe recovery instances
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoveryInstances.html
     */
    toDescribeRecoveryInstances() {
        return this.to('DescribeRecoveryInstances');
    }
    /**
     * Grants permission to describe recovery snapshots
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoverySnapshots.html
     */
    toDescribeRecoverySnapshots() {
        return this.to('DescribeRecoverySnapshots');
    }
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates() {
        return this.to('DescribeReplicationConfigurationTemplates');
    }
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeReplicationServerAssociationsForDrs() {
        return this.to('DescribeReplicationServerAssociationsForDrs');
    }
    /**
     * Grants permission to describe snapshot requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeSnapshotRequestsForDrs() {
        return this.to('DescribeSnapshotRequestsForDrs');
    }
    /**
     * Grants permission to describe source servers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers() {
        return this.to('DescribeSourceServers');
    }
    /**
     * Grants permission to disconnect recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectRecoveryInstance.html
     */
    toDisconnectRecoveryInstance() {
        return this.to('DisconnectRecoveryInstance');
    }
    /**
     * Grants permission to disconnect source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectSourceServer.html
     */
    toDisconnectSourceServer() {
        return this.to('DisconnectSourceServer');
    }
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentCommandForDrs() {
        return this.to('GetAgentCommandForDrs');
    }
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentConfirmedResumeInfoForDrs() {
        return this.to('GetAgentConfirmedResumeInfoForDrs');
    }
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentInstallationAssetsForDrs() {
        return this.to('GetAgentInstallationAssetsForDrs');
    }
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentReplicationInfoForDrs() {
        return this.to('GetAgentReplicationInfoForDrs');
    }
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentRuntimeConfigurationForDrs() {
        return this.to('GetAgentRuntimeConfigurationForDrs');
    }
    /**
     * Grants permission to get agent snapshot credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentSnapshotCreditsForDrs() {
        return this.to('GetAgentSnapshotCreditsForDrs');
    }
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetChannelCommandsForDrs() {
        return this.to('GetChannelCommandsForDrs');
    }
    /**
     * Grants permission to get failback command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackCommandForDrs() {
        return this.to('GetFailbackCommandForDrs');
    }
    /**
     * Grants permission to get failback launch requested
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackLaunchRequestedForDrs() {
        return this.to('GetFailbackLaunchRequestedForDrs');
    }
    /**
     * Grants permission to get failback replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetFailbackReplicationConfiguration.html
     */
    toGetFailbackReplicationConfiguration() {
        return this.to('GetFailbackReplicationConfiguration');
    }
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration() {
        return this.to('GetLaunchConfiguration');
    }
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration() {
        return this.to('GetReplicationConfiguration');
    }
    /**
     * Grants permission to get suggested failback client device mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetSuggestedFailbackClientDeviceMappingForDrs() {
        return this.to('GetSuggestedFailbackClientDeviceMappingForDrs');
    }
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_InitializeService.html
     */
    toInitializeService() {
        return this.to('InitializeService');
    }
    /**
     * Grants permission to issue an agent certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toIssueAgentCertificateForDrs() {
        return this.to('IssueAgentCertificateForDrs');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentAuthenticationForDrs() {
        return this.to('NotifyAgentAuthenticationForDrs');
    }
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentConnectedForDrs() {
        return this.to('NotifyAgentConnectedForDrs');
    }
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentDisconnectedForDrs() {
        return this.to('NotifyAgentDisconnectedForDrs');
    }
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentReplicationProgressForDrs() {
        return this.to('NotifyAgentReplicationProgressForDrs');
    }
    /**
     * Grants permission to notify consistency attained
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyConsistencyAttainedForDrs() {
        return this.to('NotifyConsistencyAttainedForDrs');
    }
    /**
     * Grants permission to notify replication server authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyReplicationServerAuthenticationForDrs() {
        return this.to('NotifyReplicationServerAuthenticationForDrs');
    }
    /**
     * Grants permission to retry data replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication() {
        return this.to('RetryDataReplication');
    }
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentLogsForDrs() {
        return this.to('SendAgentLogsForDrs');
    }
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentMetricsForDrs() {
        return this.to('SendAgentMetricsForDrs');
    }
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendChannelCommandResultForDrs() {
        return this.to('SendChannelCommandResultForDrs');
    }
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientLogsForDrs() {
        return this.to('SendClientLogsForDrs');
    }
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientMetricsForDrs() {
        return this.to('SendClientMetricsForDrs');
    }
    /**
     * Grants permission to start failback launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartFailbackLaunch.html
     */
    toStartFailbackLaunch() {
        return this.to('StartFailbackLaunch');
    }
    /**
     * Grants permission to start recovery
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:CreateRecoveryInstanceForDrs
     * - drs:ListTagsForResource
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartRecovery.html
     */
    toStartRecovery() {
        return this.to('StartRecovery');
    }
    /**
     * Grants permission to stop failback
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StopFailback.html
     */
    toStopFailback() {
        return this.to('StopFailback');
    }
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate recovery instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TerminateRecoveryInstances.html
     */
    toTerminateRecoveryInstances() {
        return this.to('TerminateRecoveryInstances');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentBacklogForDrs() {
        return this.to('UpdateAgentBacklogForDrs');
    }
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentConversionInfoForDrs() {
        return this.to('UpdateAgentConversionInfoForDrs');
    }
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationInfoForDrs() {
        return this.to('UpdateAgentReplicationInfoForDrs');
    }
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationProcessStateForDrs() {
        return this.to('UpdateAgentReplicationProcessStateForDrs');
    }
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentSourcePropertiesForDrs() {
        return this.to('UpdateAgentSourcePropertiesForDrs');
    }
    /**
     * Grants permission to update failback client device mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientDeviceMappingForDrs() {
        return this.to('UpdateFailbackClientDeviceMappingForDrs');
    }
    /**
     * Grants permission to update failback client last seen
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientLastSeenForDrs() {
        return this.to('UpdateFailbackClientLastSeenForDrs');
    }
    /**
     * Grants permission to update failback replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateFailbackReplicationConfiguration.html
     */
    toUpdateFailbackReplicationConfiguration() {
        return this.to('UpdateFailbackReplicationConfiguration');
    }
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration() {
        return this.to('UpdateLaunchConfiguration');
    }
    /**
     * Grants permission to update a replication certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateReplicationCertificateForDrs() {
        return this.to('UpdateReplicationCertificateForDrs');
    }
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration() {
        return this.to('UpdateReplicationConfiguration');
    }
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate() {
        return this.to('UpdateReplicationConfigurationTemplate');
    }
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/failback-overview.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:job/${jobID}`);
    }
    /**
     * Adds a resource of type RecoveryInstanceResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/recovery-instances.html
     *
     * @param recoveryInstanceID - Identifier for the recoveryInstanceID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifEC2InstanceARN()
     */
    onRecoveryInstanceResource(recoveryInstanceID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:recovery-instance/${recoveryInstanceID}`);
    }
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:replication-configuration-template/${replicationConfigurationTemplateID}`);
    }
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:drs:${region || '*'}:${account || '*'}:source-server/${sourceServerID}`);
    }
    /**
     * Filters access by the EC2 instance the request originated from
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/security_iam_authentication.html
     *
     * Applies to resource types:
     * - RecoveryInstanceResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEC2InstanceARN(value, operator) {
        return this.if(`EC2InstanceARN`, value, operator || 'StringLike');
    }
}
exports.Drs = Drs;
_a = JSII_RTTI_SYMBOL_1;
Drs[_a] = { fqn: "cdk-iam-floyd.Drs", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWxhc3RpY2Rpc2FzdGVycmVjb3ZlcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbGFzdGljZGlzYXN0ZXJyZWNvdmVyeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUFzRDtBQUd0RDs7OztHQUlHO0FBQ0gsTUFBYSxHQUFJLFNBQVEsd0JBQWU7SUF1OUJ0Qzs7O09BR0c7SUFDSCxZQUFZLEtBQWdDO1FBQzFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQTM5QlIsa0JBQWEsR0FBRyxLQUFLLENBQUM7UUFzekJuQixvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsaURBQWlEO2dCQUNqRCxzQ0FBc0M7Z0JBQ3RDLGtDQUFrQztnQkFDbEMsOEJBQThCO2dCQUM5Qix3Q0FBd0M7Z0JBQ3hDLHFCQUFxQjtnQkFDckIsMEJBQTBCO2dCQUMxQixXQUFXO2dCQUNYLHdCQUF3QjtnQkFDeEIsd0NBQXdDO2dCQUN4QyxvQkFBb0I7Z0JBQ3BCLDRCQUE0QjtnQkFDNUIsd0JBQXdCO2dCQUN4QixtQkFBbUI7Z0JBQ25CLDZCQUE2QjtnQkFDN0IsaUNBQWlDO2dCQUNqQyw0QkFBNEI7Z0JBQzVCLCtCQUErQjtnQkFDL0Isc0NBQXNDO2dCQUN0QyxpQ0FBaUM7Z0JBQ2pDLDZDQUE2QztnQkFDN0Msc0JBQXNCO2dCQUN0QixxQkFBcUI7Z0JBQ3JCLHdCQUF3QjtnQkFDeEIsZ0NBQWdDO2dCQUNoQyxzQkFBc0I7Z0JBQ3RCLHlCQUF5QjtnQkFDekIscUJBQXFCO2dCQUNyQixlQUFlO2dCQUNmLGNBQWM7Z0JBQ2QsNEJBQTRCO2dCQUM1QiwwQkFBMEI7Z0JBQzFCLGlDQUFpQztnQkFDakMsa0NBQWtDO2dCQUNsQywwQ0FBMEM7Z0JBQzFDLG1DQUFtQztnQkFDbkMseUNBQXlDO2dCQUN6QyxvQ0FBb0M7Z0JBQ3BDLHdDQUF3QztnQkFDeEMsMkJBQTJCO2dCQUMzQixvQ0FBb0M7Z0JBQ3BDLGdDQUFnQztnQkFDaEMsd0NBQXdDO2FBQ3pDO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLHFCQUFxQjtnQkFDckIsY0FBYztnQkFDZCwyQkFBMkI7Z0JBQzNCLDJCQUEyQjtnQkFDM0IsMkNBQTJDO2dCQUMzQyw2Q0FBNkM7Z0JBQzdDLGdDQUFnQztnQkFDaEMsdUJBQXVCO2dCQUN2Qix1QkFBdUI7Z0JBQ3ZCLG1DQUFtQztnQkFDbkMsa0NBQWtDO2dCQUNsQywrQkFBK0I7Z0JBQy9CLG9DQUFvQztnQkFDcEMsK0JBQStCO2dCQUMvQiwwQkFBMEI7Z0JBQzFCLDBCQUEwQjtnQkFDMUIsa0NBQWtDO2dCQUNsQyxxQ0FBcUM7Z0JBQ3JDLHdCQUF3QjtnQkFDeEIsNkJBQTZCO2dCQUM3QiwrQ0FBK0M7Z0JBQy9DLHFCQUFxQjthQUN0QjtZQUNELE9BQU8sRUFBRTtnQkFDUCxhQUFhO2dCQUNiLGVBQWU7YUFDaEI7U0FDRixDQUFDO0lBNEZGLENBQUM7SUExOUJEOzs7Ozs7T0FNRztJQUNJLGlEQUFpRDtRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaURBQWlELENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0NBQXNDO1FBQzNDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSx3Q0FBd0M7UUFDN0MsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdDQUF3QyxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0NBQXdDO1FBQzdDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYztRQUNuQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQ0FBMkM7UUFDaEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJDQUEyQyxDQUFDLENBQUM7SUFDOUQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZDQUE2QztRQUNsRCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNkNBQTZDLENBQUMsQ0FBQztJQUNoRSxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0NBQWdDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDRCQUE0QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0NBQWtDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQ0FBa0MsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwrQkFBK0I7UUFDcEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9DQUFvQztRQUN6QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksK0JBQStCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0NBQWtDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQ0FBa0MsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQ0FBcUM7UUFDMUMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFDQUFxQyxDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwrQ0FBK0M7UUFDcEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtDQUErQyxDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlDQUFpQztRQUN0QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNEJBQTRCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwrQkFBK0I7UUFDcEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNDQUFzQztRQUMzQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0NBQXNDLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw2Q0FBNkM7UUFDbEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZDQUE2QyxDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdDQUFnQztRQUNyQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztPQStDRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7OztPQWdCRztJQUNJLDRCQUE0QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBDQUEwQztRQUMvQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMENBQTBDLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUNBQW1DO1FBQ3hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5Q0FBeUM7UUFDOUMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlDQUF5QyxDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9DQUFvQztRQUN6QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0NBQXdDO1FBQzdDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9DQUFvQztRQUN6QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0NBQWdDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3Q0FBd0M7UUFDN0MsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdDQUF3QyxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQThFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxhQUFhLENBQUMsS0FBYSxFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3ZGLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxLQUFNLFFBQVMsTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxRQUFTLEtBQU0sRUFBRSxDQUFDLENBQUM7SUFDMUcsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSwwQkFBMEIsQ0FBQyxrQkFBMEIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNqSCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksS0FBTSxRQUFTLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksc0JBQXVCLGtCQUFtQixFQUFFLENBQUMsQ0FBQztJQUNySSxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksMENBQTBDLENBQUMsa0NBQTBDLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDakosT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sUUFBUyxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLHVDQUF3QyxrQ0FBbUMsRUFBRSxDQUFDLENBQUM7SUFDdEssQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLHNCQUFzQixDQUFDLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDekcsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLEtBQU0sUUFBUyxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLGtCQUFtQixjQUFlLEVBQUUsQ0FBQyxDQUFDO0lBQzdILENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksZ0JBQWdCLENBQUMsS0FBd0IsRUFBRSxRQUE0QjtRQUM1RSxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUNwRSxDQUFDOztBQXI5Qkgsa0JBODlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBPcGVyYXRvciB9IGZyb20gJy4uL3NoYXJlZCc7XG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZHJzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3NlbGFzdGljZGlzYXN0ZXJyZWNvdmVyeS5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIERycyBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ2Rycyc7XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhc3NvY2lhdGUgZmFpbGJhY2sgY2xpZW50IHRvIHJlY292ZXJ5IGluc3RhbmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Fzc29jaWF0ZUZhaWxiYWNrQ2xpZW50VG9SZWNvdmVyeUluc3RhbmNlRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBc3NvY2lhdGVGYWlsYmFja0NsaWVudFRvUmVjb3ZlcnlJbnN0YW5jZUZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGJhdGNoIGNyZWF0ZSB2b2x1bWUgc25hcHNob3QgZ3JvdXBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQmF0Y2hDcmVhdGVWb2x1bWVTbmFwc2hvdEdyb3VwRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaENyZWF0ZVZvbHVtZVNuYXBzaG90R3JvdXBGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBiYXRjaCBkZWxldGUgc25hcHNob3QgcmVxdWVzdFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9CYXRjaERlbGV0ZVNuYXBzaG90UmVxdWVzdEZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQmF0Y2hEZWxldGVTbmFwc2hvdFJlcXVlc3RGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgcmVjb3ZlcnkgaW5zdGFuY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlUmVjb3ZlcnlJbnN0YW5jZUZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlUmVjb3ZlcnlJbnN0YW5jZUZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSByZXBsaWNhdGlvbiBjb25maWd1cmF0aW9uIHRlbXBsYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlUmVwbGljYXRpb25Db25maWd1cmF0aW9uVGVtcGxhdGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBzZXNzaW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNlc3Npb25Gb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVNlc3Npb25Gb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBzb3VyY2Ugc2VydmVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNvdXJjZVNlcnZlckZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlU291cmNlU2VydmVyRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgam9iXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVKb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVKb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgcmVjb3ZlcnkgaW5zdGFuY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZVJlY292ZXJ5SW5zdGFuY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUmVjb3ZlcnlJbnN0YW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlUmVjb3ZlcnlJbnN0YW5jZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSByZXBsaWNhdGlvbiBjb25maWd1cmF0aW9uIHRlbXBsYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlUmVwbGljYXRpb25Db25maWd1cmF0aW9uVGVtcGxhdGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgc291cmNlIHNlcnZlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlU291cmNlU2VydmVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVNvdXJjZVNlcnZlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlU291cmNlU2VydmVyJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgam9iIGxvZyBpdGVtc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZUpvYkxvZ0l0ZW1zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlSm9iTG9nSXRlbXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlSm9iTG9nSXRlbXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBqb2JzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlSm9icy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUpvYnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlSm9icycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHJlY292ZXJ5IGluc3RhbmNlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gZWMyOkRlc2NyaWJlSW5zdGFuY2VzXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVSZWNvdmVyeUluc3RhbmNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZVJlY292ZXJ5SW5zdGFuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZVJlY292ZXJ5SW5zdGFuY2VzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgcmVjb3Zlcnkgc25hcHNob3RzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlUmVjb3ZlcnlTbmFwc2hvdHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVSZWNvdmVyeVNuYXBzaG90cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVSZWNvdmVyeVNuYXBzaG90cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHJlcGxpY2F0aW9uIGNvbmZpZ3VyYXRpb24gdGVtcGxhdGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlUmVwbGljYXRpb25Db25maWd1cmF0aW9uVGVtcGxhdGVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgcmVwbGljYXRpb24gc2VydmVyIGFzc29jaWF0aW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUmVwbGljYXRpb25TZXJ2ZXJBc3NvY2lhdGlvbnNGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlUmVwbGljYXRpb25TZXJ2ZXJBc3NvY2lhdGlvbnNGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBzbmFwc2hvdCByZXF1ZXN0c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlU25hcHNob3RSZXF1ZXN0c0ZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVTbmFwc2hvdFJlcXVlc3RzRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgc291cmNlIHNlcnZlcnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVTb3VyY2VTZXJ2ZXJzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlU291cmNlU2VydmVycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVTb3VyY2VTZXJ2ZXJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGlzY29ubmVjdCByZWNvdmVyeSBpbnN0YW5jZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGlzY29ubmVjdFJlY292ZXJ5SW5zdGFuY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGlzY29ubmVjdFJlY292ZXJ5SW5zdGFuY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rpc2Nvbm5lY3RSZWNvdmVyeUluc3RhbmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGlzY29ubmVjdCBzb3VyY2Ugc2VydmVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EaXNjb25uZWN0U291cmNlU2VydmVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rpc2Nvbm5lY3RTb3VyY2VTZXJ2ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rpc2Nvbm5lY3RTb3VyY2VTZXJ2ZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYWdlbnQgY29tbWFuZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEFnZW50Q29tbWFuZEZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWdlbnRDb21tYW5kRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGFnZW50IGNvbmZpcm1lZCByZXN1bWUgaW5mb1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEFnZW50Q29uZmlybWVkUmVzdW1lSW5mb0ZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWdlbnRDb25maXJtZWRSZXN1bWVJbmZvRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGFnZW50IGluc3RhbGxhdGlvbiBhc3NldHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRBZ2VudEluc3RhbGxhdGlvbkFzc2V0c0ZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWdlbnRJbnN0YWxsYXRpb25Bc3NldHNGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYWdlbnQgcmVwbGljYXRpb24gaW5mb1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEFnZW50UmVwbGljYXRpb25JbmZvRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRBZ2VudFJlcGxpY2F0aW9uSW5mb0ZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhZ2VudCBydW50aW1lIGNvbmZpZ3VyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRBZ2VudFJ1bnRpbWVDb25maWd1cmF0aW9uRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRBZ2VudFJ1bnRpbWVDb25maWd1cmF0aW9uRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGFnZW50IHNuYXBzaG90IGNyZWRpdHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRBZ2VudFNuYXBzaG90Q3JlZGl0c0ZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWdlbnRTbmFwc2hvdENyZWRpdHNGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgY2hhbm5lbCBjb21tYW5kc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldENoYW5uZWxDb21tYW5kc0ZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0Q2hhbm5lbENvbW1hbmRzRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGZhaWxiYWNrIGNvbW1hbmRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRGYWlsYmFja0NvbW1hbmRGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEZhaWxiYWNrQ29tbWFuZEZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBmYWlsYmFjayBsYXVuY2ggcmVxdWVzdGVkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RmFpbGJhY2tMYXVuY2hSZXF1ZXN0ZWRGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEZhaWxiYWNrTGF1bmNoUmVxdWVzdGVkRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGZhaWxiYWNrIHJlcGxpY2F0aW9uIGNvbmZpZ3VyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RmFpbGJhY2tSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RmFpbGJhY2tSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEZhaWxiYWNrUmVwbGljYXRpb25Db25maWd1cmF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGxhdW5jaCBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldExhdW5jaENvbmZpZ3VyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TGF1bmNoQ29uZmlndXJhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0TGF1bmNoQ29uZmlndXJhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCByZXBsaWNhdGlvbiBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFJlcGxpY2F0aW9uQ29uZmlndXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlcGxpY2F0aW9uQ29uZmlndXJhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBzdWdnZXN0ZWQgZmFpbGJhY2sgY2xpZW50IGRldmljZSBtYXBwaW5nXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0U3VnZ2VzdGVkRmFpbGJhY2tDbGllbnREZXZpY2VNYXBwaW5nRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRTdWdnZXN0ZWRGYWlsYmFja0NsaWVudERldmljZU1hcHBpbmdGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBpbml0aWFsaXplIHNlcnZpY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBpYW06QWRkUm9sZVRvSW5zdGFuY2VQcm9maWxlXG4gICAqIC0gaWFtOkNyZWF0ZUluc3RhbmNlUHJvZmlsZVxuICAgKiAtIGlhbTpDcmVhdGVTZXJ2aWNlTGlua2VkUm9sZVxuICAgKiAtIGlhbTpHZXRJbnN0YW5jZVByb2ZpbGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Jbml0aWFsaXplU2VydmljZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Jbml0aWFsaXplU2VydmljZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnSW5pdGlhbGl6ZVNlcnZpY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBpc3N1ZSBhbiBhZ2VudCBjZXJ0aWZpY2F0ZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Jc3N1ZUFnZW50Q2VydGlmaWNhdGVGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0lzc3VlQWdlbnRDZXJ0aWZpY2F0ZUZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGFncyBmb3IgYSByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0VGFnc0ZvclJlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUYWdzRm9yUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RUYWdzRm9yUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBub3RpZnkgYWdlbnQgYXV0aGVudGljYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTm90aWZ5QWdlbnRBdXRoZW50aWNhdGlvbkZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTm90aWZ5QWdlbnRBdXRoZW50aWNhdGlvbkZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIG5vdGlmeSBhZ2VudCBpcyBjb25uZWN0ZWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTm90aWZ5QWdlbnRDb25uZWN0ZWRGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ05vdGlmeUFnZW50Q29ubmVjdGVkRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbm90aWZ5IGFnZW50IGlzIGRpc2Nvbm5lY3RlZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Ob3RpZnlBZ2VudERpc2Nvbm5lY3RlZEZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTm90aWZ5QWdlbnREaXNjb25uZWN0ZWRGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBub3RpZnkgYWdlbnQgcmVwbGljYXRpb24gcHJvZ3Jlc3NcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTm90aWZ5QWdlbnRSZXBsaWNhdGlvblByb2dyZXNzRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdOb3RpZnlBZ2VudFJlcGxpY2F0aW9uUHJvZ3Jlc3NGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBub3RpZnkgY29uc2lzdGVuY3kgYXR0YWluZWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTm90aWZ5Q29uc2lzdGVuY3lBdHRhaW5lZEZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTm90aWZ5Q29uc2lzdGVuY3lBdHRhaW5lZEZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIG5vdGlmeSByZXBsaWNhdGlvbiBzZXJ2ZXIgYXV0aGVudGljYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTm90aWZ5UmVwbGljYXRpb25TZXJ2ZXJBdXRoZW50aWNhdGlvbkZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTm90aWZ5UmVwbGljYXRpb25TZXJ2ZXJBdXRoZW50aWNhdGlvbkZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJldHJ5IGRhdGEgcmVwbGljYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1JldHJ5RGF0YVJlcGxpY2F0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1JldHJ5RGF0YVJlcGxpY2F0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdSZXRyeURhdGFSZXBsaWNhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHNlbmQgYWdlbnQgbG9nc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TZW5kQWdlbnRMb2dzRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTZW5kQWdlbnRMb2dzRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc2VuZCBhZ2VudCBtZXRyaWNzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1NlbmRBZ2VudE1ldHJpY3NGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRBZ2VudE1ldHJpY3NGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzZW5kIGNoYW5uZWwgY29tbWFuZCByZXN1bHRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU2VuZENoYW5uZWxDb21tYW5kUmVzdWx0Rm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTZW5kQ2hhbm5lbENvbW1hbmRSZXN1bHRGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzZW5kIGNsaWVudCBsb2dzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1NlbmRDbGllbnRMb2dzRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTZW5kQ2xpZW50TG9nc0ZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHNlbmQgY2xpZW50IG1ldHJpY3NcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU2VuZENsaWVudE1ldHJpY3NGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRDbGllbnRNZXRyaWNzRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgZmFpbGJhY2sgbGF1bmNoXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdGFydEZhaWxiYWNrTGF1bmNoLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0RmFpbGJhY2tMYXVuY2goKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0YXJ0RmFpbGJhY2tMYXVuY2gnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzdGFydCByZWNvdmVyeVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGRyczpDcmVhdGVSZWNvdmVyeUluc3RhbmNlRm9yRHJzXG4gICAqIC0gZHJzOkxpc3RUYWdzRm9yUmVzb3VyY2VcbiAgICogLSBlYzI6QXR0YWNoVm9sdW1lXG4gICAqIC0gZWMyOkF1dGhvcml6ZVNlY3VyaXR5R3JvdXBFZ3Jlc3NcbiAgICogLSBlYzI6QXV0aG9yaXplU2VjdXJpdHlHcm91cEluZ3Jlc3NcbiAgICogLSBlYzI6Q3JlYXRlTGF1bmNoVGVtcGxhdGVcbiAgICogLSBlYzI6Q3JlYXRlTGF1bmNoVGVtcGxhdGVWZXJzaW9uXG4gICAqIC0gZWMyOkNyZWF0ZVNuYXBzaG90XG4gICAqIC0gZWMyOkNyZWF0ZVRhZ3NcbiAgICogLSBlYzI6Q3JlYXRlVm9sdW1lXG4gICAqIC0gZWMyOkRlbGV0ZUxhdW5jaFRlbXBsYXRlVmVyc2lvbnNcbiAgICogLSBlYzI6RGVsZXRlU25hcHNob3RcbiAgICogLSBlYzI6RGVsZXRlVm9sdW1lXG4gICAqIC0gZWMyOkRlc2NyaWJlQWNjb3VudEF0dHJpYnV0ZXNcbiAgICogLSBlYzI6RGVzY3JpYmVBdmFpbGFiaWxpdHlab25lc1xuICAgKiAtIGVjMjpEZXNjcmliZUltYWdlc1xuICAgKiAtIGVjMjpEZXNjcmliZUluc3RhbmNlQXR0cmlidXRlXG4gICAqIC0gZWMyOkRlc2NyaWJlSW5zdGFuY2VTdGF0dXNcbiAgICogLSBlYzI6RGVzY3JpYmVJbnN0YW5jZVR5cGVzXG4gICAqIC0gZWMyOkRlc2NyaWJlSW5zdGFuY2VzXG4gICAqIC0gZWMyOkRlc2NyaWJlTGF1bmNoVGVtcGxhdGVWZXJzaW9uc1xuICAgKiAtIGVjMjpEZXNjcmliZUxhdW5jaFRlbXBsYXRlc1xuICAgKiAtIGVjMjpEZXNjcmliZVNlY3VyaXR5R3JvdXBzXG4gICAqIC0gZWMyOkRlc2NyaWJlU25hcHNob3RzXG4gICAqIC0gZWMyOkRlc2NyaWJlU3VibmV0c1xuICAgKiAtIGVjMjpEZXNjcmliZVZvbHVtZXNcbiAgICogLSBlYzI6RGV0YWNoVm9sdW1lXG4gICAqIC0gZWMyOk1vZGlmeUluc3RhbmNlQXR0cmlidXRlXG4gICAqIC0gZWMyOk1vZGlmeUxhdW5jaFRlbXBsYXRlXG4gICAqIC0gZWMyOlJldm9rZVNlY3VyaXR5R3JvdXBFZ3Jlc3NcbiAgICogLSBlYzI6UnVuSW5zdGFuY2VzXG4gICAqIC0gZWMyOlN0YXJ0SW5zdGFuY2VzXG4gICAqIC0gZWMyOlN0b3BJbnN0YW5jZXNcbiAgICogLSBlYzI6VGVybWluYXRlSW5zdGFuY2VzXG4gICAqIC0gaWFtOlBhc3NSb2xlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU3RhcnRSZWNvdmVyeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydFJlY292ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydFJlY292ZXJ5Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RvcCBmYWlsYmFja1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU3RvcEZhaWxiYWNrLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0b3BGYWlsYmFjaygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RvcEZhaWxiYWNrJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gYXNzaWduIGEgcmVzb3VyY2UgdGFnXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1RhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1RhZ1Jlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdUYWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHRlcm1pbmF0ZSByZWNvdmVyeSBpbnN0YW5jZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBlYzI6RGVsZXRlVm9sdW1lXG4gICAqIC0gZWMyOkRlc2NyaWJlSW5zdGFuY2VzXG4gICAqIC0gZWMyOkRlc2NyaWJlVm9sdW1lc1xuICAgKiAtIGVjMjpUZXJtaW5hdGVJbnN0YW5jZXNcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9UZXJtaW5hdGVSZWNvdmVyeUluc3RhbmNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9UZXJtaW5hdGVSZWNvdmVyeUluc3RhbmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVGVybWluYXRlUmVjb3ZlcnlJbnN0YW5jZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1bnRhZyBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VudGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVW50YWdSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVW50YWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhZ2VudCBiYWNrbG9nXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL2Rycy1hcGlzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUFnZW50QmFja2xvZ0ZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlQWdlbnRCYWNrbG9nRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFnZW50IGNvbnZlcnNpb24gaW5mb1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBZ2VudENvbnZlcnNpb25JbmZvRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVBZ2VudENvbnZlcnNpb25JbmZvRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFnZW50IHJlcGxpY2F0aW9uIGluZm9cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQWdlbnRSZXBsaWNhdGlvbkluZm9Gb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUFnZW50UmVwbGljYXRpb25JbmZvRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFnZW50IHJlcGxpY2F0aW9uIHByb2Nlc3Mgc3RhdGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQWdlbnRSZXBsaWNhdGlvblByb2Nlc3NTdGF0ZUZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlQWdlbnRSZXBsaWNhdGlvblByb2Nlc3NTdGF0ZUZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhZ2VudCBzb3VyY2UgcHJvcGVydGllc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBZ2VudFNvdXJjZVByb3BlcnRpZXNGb3JEcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUFnZW50U291cmNlUHJvcGVydGllc0ZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBmYWlsYmFjayBjbGllbnQgZGV2aWNlIG1hcHBpbmdcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRmFpbGJhY2tDbGllbnREZXZpY2VNYXBwaW5nRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVGYWlsYmFja0NsaWVudERldmljZU1hcHBpbmdGb3JEcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgZmFpbGJhY2sgY2xpZW50IGxhc3Qgc2VlblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9kcnMtYXBpcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVGYWlsYmFja0NsaWVudExhc3RTZWVuRm9yRHJzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVGYWlsYmFja0NsaWVudExhc3RTZWVuRm9yRHJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGZhaWxiYWNrIHJlcGxpY2F0aW9uIGNvbmZpZ3VyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUZhaWxiYWNrUmVwbGljYXRpb25Db25maWd1cmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUZhaWxiYWNrUmVwbGljYXRpb25Db25maWd1cmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVGYWlsYmFja1JlcGxpY2F0aW9uQ29uZmlndXJhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBsYXVuY2ggY29uZmlndXJhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlTGF1bmNoQ29uZmlndXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVMYXVuY2hDb25maWd1cmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVMYXVuY2hDb25maWd1cmF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgcmVwbGljYXRpb24gY2VydGlmaWNhdGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZHJzL2xhdGVzdC91c2VyZ3VpZGUvZHJzLWFwaXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUmVwbGljYXRpb25DZXJ0aWZpY2F0ZUZvckRycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlUmVwbGljYXRpb25DZXJ0aWZpY2F0ZUZvckRycycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSByZXBsaWNhdGlvbiBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUmVwbGljYXRpb25Db25maWd1cmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgcmVwbGljYXRpb24gY29uZmlndXJhdGlvbiB0ZW1wbGF0ZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlUmVwbGljYXRpb25Db25maWd1cmF0aW9uVGVtcGxhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUmVwbGljYXRpb25Db25maWd1cmF0aW9uVGVtcGxhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblRlbXBsYXRlJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgV3JpdGU6IFtcbiAgICAgICdBc3NvY2lhdGVGYWlsYmFja0NsaWVudFRvUmVjb3ZlcnlJbnN0YW5jZUZvckRycycsXG4gICAgICAnQmF0Y2hDcmVhdGVWb2x1bWVTbmFwc2hvdEdyb3VwRm9yRHJzJyxcbiAgICAgICdCYXRjaERlbGV0ZVNuYXBzaG90UmVxdWVzdEZvckRycycsXG4gICAgICAnQ3JlYXRlUmVjb3ZlcnlJbnN0YW5jZUZvckRycycsXG4gICAgICAnQ3JlYXRlUmVwbGljYXRpb25Db25maWd1cmF0aW9uVGVtcGxhdGUnLFxuICAgICAgJ0NyZWF0ZVNlc3Npb25Gb3JEcnMnLFxuICAgICAgJ0NyZWF0ZVNvdXJjZVNlcnZlckZvckRycycsXG4gICAgICAnRGVsZXRlSm9iJyxcbiAgICAgICdEZWxldGVSZWNvdmVyeUluc3RhbmNlJyxcbiAgICAgICdEZWxldGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZScsXG4gICAgICAnRGVsZXRlU291cmNlU2VydmVyJyxcbiAgICAgICdEaXNjb25uZWN0UmVjb3ZlcnlJbnN0YW5jZScsXG4gICAgICAnRGlzY29ubmVjdFNvdXJjZVNlcnZlcicsXG4gICAgICAnSW5pdGlhbGl6ZVNlcnZpY2UnLFxuICAgICAgJ0lzc3VlQWdlbnRDZXJ0aWZpY2F0ZUZvckRycycsXG4gICAgICAnTm90aWZ5QWdlbnRBdXRoZW50aWNhdGlvbkZvckRycycsXG4gICAgICAnTm90aWZ5QWdlbnRDb25uZWN0ZWRGb3JEcnMnLFxuICAgICAgJ05vdGlmeUFnZW50RGlzY29ubmVjdGVkRm9yRHJzJyxcbiAgICAgICdOb3RpZnlBZ2VudFJlcGxpY2F0aW9uUHJvZ3Jlc3NGb3JEcnMnLFxuICAgICAgJ05vdGlmeUNvbnNpc3RlbmN5QXR0YWluZWRGb3JEcnMnLFxuICAgICAgJ05vdGlmeVJlcGxpY2F0aW9uU2VydmVyQXV0aGVudGljYXRpb25Gb3JEcnMnLFxuICAgICAgJ1JldHJ5RGF0YVJlcGxpY2F0aW9uJyxcbiAgICAgICdTZW5kQWdlbnRMb2dzRm9yRHJzJyxcbiAgICAgICdTZW5kQWdlbnRNZXRyaWNzRm9yRHJzJyxcbiAgICAgICdTZW5kQ2hhbm5lbENvbW1hbmRSZXN1bHRGb3JEcnMnLFxuICAgICAgJ1NlbmRDbGllbnRMb2dzRm9yRHJzJyxcbiAgICAgICdTZW5kQ2xpZW50TWV0cmljc0ZvckRycycsXG4gICAgICAnU3RhcnRGYWlsYmFja0xhdW5jaCcsXG4gICAgICAnU3RhcnRSZWNvdmVyeScsXG4gICAgICAnU3RvcEZhaWxiYWNrJyxcbiAgICAgICdUZXJtaW5hdGVSZWNvdmVyeUluc3RhbmNlcycsXG4gICAgICAnVXBkYXRlQWdlbnRCYWNrbG9nRm9yRHJzJyxcbiAgICAgICdVcGRhdGVBZ2VudENvbnZlcnNpb25JbmZvRm9yRHJzJyxcbiAgICAgICdVcGRhdGVBZ2VudFJlcGxpY2F0aW9uSW5mb0ZvckRycycsXG4gICAgICAnVXBkYXRlQWdlbnRSZXBsaWNhdGlvblByb2Nlc3NTdGF0ZUZvckRycycsXG4gICAgICAnVXBkYXRlQWdlbnRTb3VyY2VQcm9wZXJ0aWVzRm9yRHJzJyxcbiAgICAgICdVcGRhdGVGYWlsYmFja0NsaWVudERldmljZU1hcHBpbmdGb3JEcnMnLFxuICAgICAgJ1VwZGF0ZUZhaWxiYWNrQ2xpZW50TGFzdFNlZW5Gb3JEcnMnLFxuICAgICAgJ1VwZGF0ZUZhaWxiYWNrUmVwbGljYXRpb25Db25maWd1cmF0aW9uJyxcbiAgICAgICdVcGRhdGVMYXVuY2hDb25maWd1cmF0aW9uJyxcbiAgICAgICdVcGRhdGVSZXBsaWNhdGlvbkNlcnRpZmljYXRlRm9yRHJzJyxcbiAgICAgICdVcGRhdGVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb24nLFxuICAgICAgJ1VwZGF0ZVJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblRlbXBsYXRlJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0Rlc2NyaWJlSm9iTG9nSXRlbXMnLFxuICAgICAgJ0Rlc2NyaWJlSm9icycsXG4gICAgICAnRGVzY3JpYmVSZWNvdmVyeUluc3RhbmNlcycsXG4gICAgICAnRGVzY3JpYmVSZWNvdmVyeVNuYXBzaG90cycsXG4gICAgICAnRGVzY3JpYmVSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZXMnLFxuICAgICAgJ0Rlc2NyaWJlUmVwbGljYXRpb25TZXJ2ZXJBc3NvY2lhdGlvbnNGb3JEcnMnLFxuICAgICAgJ0Rlc2NyaWJlU25hcHNob3RSZXF1ZXN0c0ZvckRycycsXG4gICAgICAnRGVzY3JpYmVTb3VyY2VTZXJ2ZXJzJyxcbiAgICAgICdHZXRBZ2VudENvbW1hbmRGb3JEcnMnLFxuICAgICAgJ0dldEFnZW50Q29uZmlybWVkUmVzdW1lSW5mb0ZvckRycycsXG4gICAgICAnR2V0QWdlbnRJbnN0YWxsYXRpb25Bc3NldHNGb3JEcnMnLFxuICAgICAgJ0dldEFnZW50UmVwbGljYXRpb25JbmZvRm9yRHJzJyxcbiAgICAgICdHZXRBZ2VudFJ1bnRpbWVDb25maWd1cmF0aW9uRm9yRHJzJyxcbiAgICAgICdHZXRBZ2VudFNuYXBzaG90Q3JlZGl0c0ZvckRycycsXG4gICAgICAnR2V0Q2hhbm5lbENvbW1hbmRzRm9yRHJzJyxcbiAgICAgICdHZXRGYWlsYmFja0NvbW1hbmRGb3JEcnMnLFxuICAgICAgJ0dldEZhaWxiYWNrTGF1bmNoUmVxdWVzdGVkRm9yRHJzJyxcbiAgICAgICdHZXRGYWlsYmFja1JlcGxpY2F0aW9uQ29uZmlndXJhdGlvbicsXG4gICAgICAnR2V0TGF1bmNoQ29uZmlndXJhdGlvbicsXG4gICAgICAnR2V0UmVwbGljYXRpb25Db25maWd1cmF0aW9uJyxcbiAgICAgICdHZXRTdWdnZXN0ZWRGYWlsYmFja0NsaWVudERldmljZU1hcHBpbmdGb3JEcnMnLFxuICAgICAgJ0xpc3RUYWdzRm9yUmVzb3VyY2UnXG4gICAgXSxcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnVGFnUmVzb3VyY2UnLFxuICAgICAgJ1VudGFnUmVzb3VyY2UnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBKb2JSZXNvdXJjZSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9kcnMvbGF0ZXN0L3VzZXJndWlkZS9mYWlsYmFjay1vdmVydmlldy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBqb2JJRCAtIElkZW50aWZpZXIgZm9yIHRoZSBqb2JJRC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25Kb2JSZXNvdXJjZShqb2JJRDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8ICdhd3MnIH06ZHJzOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmpvYi8keyBqb2JJRCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgUmVjb3ZlcnlJbnN0YW5jZVJlc291cmNlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL3JlY292ZXJ5LWluc3RhbmNlcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSByZWNvdmVyeUluc3RhbmNlSUQgLSBJZGVudGlmaWVyIGZvciB0aGUgcmVjb3ZlcnlJbnN0YW5jZUlELlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICogLSAuaWZFQzJJbnN0YW5jZUFSTigpXG4gICAqL1xuICBwdWJsaWMgb25SZWNvdmVyeUluc3RhbmNlUmVzb3VyY2UocmVjb3ZlcnlJbnN0YW5jZUlEOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTpkcnM6JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06cmVjb3ZlcnktaW5zdGFuY2UvJHsgcmVjb3ZlcnlJbnN0YW5jZUlEIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBSZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZVJlc291cmNlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL3JlcGxpY2F0aW9uLXNldHRpbmdzLXRlbXBsYXRlLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblRlbXBsYXRlSUQgLSBJZGVudGlmaWVyIGZvciB0aGUgcmVwbGljYXRpb25Db25maWd1cmF0aW9uVGVtcGxhdGVJRC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25SZXBsaWNhdGlvbkNvbmZpZ3VyYXRpb25UZW1wbGF0ZVJlc291cmNlKHJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblRlbXBsYXRlSUQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCAnYXdzJyB9OmRyczokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpyZXBsaWNhdGlvbi1jb25maWd1cmF0aW9uLXRlbXBsYXRlLyR7IHJlcGxpY2F0aW9uQ29uZmlndXJhdGlvblRlbXBsYXRlSUQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIFNvdXJjZVNlcnZlclJlc291cmNlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL3NvdXJjZS1zZXJ2ZXJzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHNvdXJjZVNlcnZlcklEIC0gSWRlbnRpZmllciBmb3IgdGhlIHNvdXJjZVNlcnZlcklELlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblNvdXJjZVNlcnZlclJlc291cmNlKHNvdXJjZVNlcnZlcklEOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgJ2F3cycgfTpkcnM6JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06c291cmNlLXNlcnZlci8keyBzb3VyY2VTZXJ2ZXJJRCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogRmlsdGVycyBhY2Nlc3MgYnkgdGhlIEVDMiBpbnN0YW5jZSB0aGUgcmVxdWVzdCBvcmlnaW5hdGVkIGZyb21cbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Rycy9sYXRlc3QvdXNlcmd1aWRlL3NlY3VyaXR5X2lhbV9hdXRoZW50aWNhdGlvbi5odG1sXG4gICAqXG4gICAqIEFwcGxpZXMgdG8gcmVzb3VyY2UgdHlwZXM6XG4gICAqIC0gUmVjb3ZlcnlJbnN0YW5jZVJlc291cmNlXG4gICAqXG4gICAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUocykgdG8gY2hlY2tcbiAgICogQHBhcmFtIG9wZXJhdG9yIFdvcmtzIHdpdGggW3N0cmluZyBvcGVyYXRvcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfY29uZGl0aW9uX29wZXJhdG9ycy5odG1sI0NvbmRpdGlvbnNfU3RyaW5nKS4gKipEZWZhdWx0OioqIGBTdHJpbmdMaWtlYFxuICAgKi9cbiAgcHVibGljIGlmRUMySW5zdGFuY2VBUk4odmFsdWU6IHN0cmluZyB8IHN0cmluZ1tdLCBvcGVyYXRvcj86IE9wZXJhdG9yIHwgc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMuaWYoYEVDMkluc3RhbmNlQVJOYCwgdmFsdWUsIG9wZXJhdG9yIHx8ICdTdHJpbmdMaWtlJyk7XG4gIH1cblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtkcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2VsYXN0aWNkaXNhc3RlcnJlY292ZXJ5Lmh0bWwpLlxuICAgKlxuICAgKi9cbiAgY29uc3RydWN0b3IocHJvcHM/OiBpYW0uUG9saWN5U3RhdGVtZW50UHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gIH1cbn1cbiJdfQ==