"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trustedadvisor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [trustedadvisor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstrustedadvisor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Trustedadvisor extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [trustedadvisor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstrustedadvisor.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'trustedadvisor';
        this.accessLevelList = {
            Read: [
                'DescribeAccount',
                'DescribeAccountAccess',
                'DescribeCheckItems',
                'DescribeCheckRefreshStatuses',
                'DescribeCheckSummaries',
                'DescribeChecks',
                'DescribeNotificationPreferences',
                'DescribeOrganization',
                'DescribeOrganizationAccounts',
                'DescribeReports',
                'DescribeRisk',
                'DescribeRiskResources',
                'DescribeRisks',
                'DescribeServiceMetadata',
                'DownloadRisk',
                'ListAccountsForParent',
                'ListOrganizationalUnitsForParent',
                'ListRoots'
            ],
            Write: [
                'ExcludeCheckItems',
                'GenerateReport',
                'IncludeCheckItems',
                'RefreshCheck',
                'SetAccountAccess',
                'SetOrganizationAccess',
                'UpdateNotificationPreferences',
                'UpdateRiskStatus'
            ]
        };
    }
    /**
     * Grants permission to view the AWS Support plan and various AWS Trusted Advisor preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeAccount() {
        return this.to('DescribeAccount');
    }
    /**
     * Grants permission to view if the AWS account has enabled or disabled AWS Trusted Advisor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeAccountAccess() {
        return this.to('DescribeAccountAccess');
    }
    /**
     * Grants permission to view details for the check items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeCheckItems() {
        return this.to('DescribeCheckItems');
    }
    /**
     * Grants permission to view the refresh statuses for AWS Trusted Advisor checks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeCheckRefreshStatuses() {
        return this.to('DescribeCheckRefreshStatuses');
    }
    /**
     * Grants permission to view AWS Trusted Advisor check summaries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeCheckSummaries() {
        return this.to('DescribeCheckSummaries');
    }
    /**
     * Grants permission to view details for AWS Trusted Advisor checks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeChecks() {
        return this.to('DescribeChecks');
    }
    /**
     * Grants permission to view the notification preferences for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeNotificationPreferences() {
        return this.to('DescribeNotificationPreferences');
    }
    /**
     * Grants permission to view if the AWS account meets the requirements to enable the organizational view feature
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeOrganization() {
        return this.to('DescribeOrganization');
    }
    /**
     * Grants permission to view the linked AWS accounts that are in the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeOrganizationAccounts() {
        return this.to('DescribeOrganizationAccounts');
    }
    /**
     * Grants permission to view details for organizational view reports, such as the report name, runtime, date created, status, and format
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeReports() {
        return this.to('DescribeReports');
    }
    /**
     * Grants permission to view risk details in AWS Trusted Advisor Priority
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeRisk() {
        return this.to('DescribeRisk');
    }
    /**
     * Grants permission to view affected resources for a risk in AWS Trusted Advisor Priority
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeRiskResources() {
        return this.to('DescribeRiskResources');
    }
    /**
     * Grants permission to view risks in AWS Trusted Advisor Priority
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeRisks() {
        return this.to('DescribeRisks');
    }
    /**
     * Grants permission to view information about organizational view reports, such as the AWS Regions, check categories, check names, and resource statuses
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDescribeServiceMetadata() {
        return this.to('DescribeServiceMetadata');
    }
    /**
     * Grants permission to download a file that contains details about the risk in AWS Trusted Advisor Priority
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toDownloadRisk() {
        return this.to('DownloadRisk');
    }
    /**
     * Grants permission to exclude recommendations for AWS Trusted Advisor checks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toExcludeCheckItems() {
        return this.to('ExcludeCheckItems');
    }
    /**
     * Grants permission to create a report for AWS Trusted Advisor checks in your organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toGenerateReport() {
        return this.to('GenerateReport');
    }
    /**
     * Grants permission to include recommendations for AWS Trusted Advisor checks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toIncludeCheckItems() {
        return this.to('IncludeCheckItems');
    }
    /**
     * Grants permission to view, in the Trusted Advisor console, all of the accounts in an AWS organization that are contained by a root or organizational unit (OU)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toListAccountsForParent() {
        return this.to('ListAccountsForParent');
    }
    /**
     * Grants permission to view, in the Trusted Advisor console, all of the organizational units (OUs) in a parent organizational unit or root
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toListOrganizationalUnitsForParent() {
        return this.to('ListOrganizationalUnitsForParent');
    }
    /**
     * Grants permission to view, in the Trusted Advisor console, all of the roots that are defined in an AWS organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toListRoots() {
        return this.to('ListRoots');
    }
    /**
     * Grants permission to refresh an AWS Trusted Advisor check
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toRefreshCheck() {
        return this.to('RefreshCheck');
    }
    /**
     * Grants permission to enable or disable AWS Trusted Advisor for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toSetAccountAccess() {
        return this.to('SetAccountAccess');
    }
    /**
     * Grants permission to enable the organizational view feature for AWS Trusted Advisor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toSetOrganizationAccess() {
        return this.to('SetOrganizationAccess');
    }
    /**
     * Grants permission to update notification preferences for AWS Trusted Advisor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toUpdateNotificationPreferences() {
        return this.to('UpdateNotificationPreferences');
    }
    /**
     * Grants permission to update the risk status in AWS Trusted Advisor Priority
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     */
    toUpdateRiskStatus() {
        return this.to('UpdateRiskStatus');
    }
    /**
     * Adds a resource of type checks to the statement
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_TrustedAdvisorCheckDescription.html
     *
     * @param categoryCode - Identifier for the categoryCode.
     * @param checkId - Identifier for the checkId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onChecks(categoryCode, checkId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:trustedadvisor:${region || '*'}:${account || '*'}:checks/${categoryCode}/${checkId}`);
    }
}
exports.Trustedadvisor = Trustedadvisor;
_a = JSII_RTTI_SYMBOL_1;
Trustedadvisor[_a] = { fqn: "cdk-iam-floyd.Trustedadvisor", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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