/**
 * Use condition operators in the `Condition` element to match the condition key and value in the policy against values in the request context. For more information about the `Condition` element, see [IAM JSON Policy Elements: Condition](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
 *
 * The condition operator that you can use in a policy depends on the condition key you choose. You can choose a global condition key or a service-specific condition key. To learn which condition operator you can use for a global condition key, see [AWS Global Condition Context Keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html). To learn which condition operator you can use for a service-specific condition key, see [Actions, Resources, and Condition Keys for AWS Services](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html) and choose the service that you want to view.
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html
 */
export declare class Operator {
    private base;
    private hasIfExists;
    private hasForAllValues;
    private hasForAnyValue;
    private setBase;
    toString(): string;
    /**
     * You can add `IfExists` to the end of any condition operator name except the `Null` condition. For example, `StringLikeIfExists`. You do this to say "If the policy key is present in the context of the request, process the key as specified in the policy. If the key is not present, evaluate the condition element as true." Other condition elements in the statement can still result in a nonmatch, but not a missing key when checked with `...IfExists`.
     */
    ifExists(): this;
    /**
     * Tests whether the value of every member of the request set is a subset of the condition key set. The condition returns true if every key value in the request matches at least one value in the policy. It also returns true if there are no keys in the request, or if the key values resolve to a null data set, such as an empty string.
     */
    forAllValues(): this;
    /**
     * Tests whether at least one member of the set of request values matches at least one member of the set of condition key values. The condition returns true if any one of the key values in the request matches any one of the condition values in the policy. For no matching key or a null dataset, the condition returns false.
     */
    forAnyValue(): this;
    /**
     * Exact match, case sensitive.
     */
    stringEquals(): this;
    /**
     * Negated exact match, case sensitive.
     */
    stringNotEquals(): this;
    /**
     * Exact match, ignore case.
     */
    stringEqualsIgnoreCase(): this;
    /**
     * Exact exact match, ignore case.
     */
    stringNotEqualsIgnoreCase(): this;
    /**
     * Case-sensitive match.
     *
     * The values can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`) anywhere in the string.
     */
    stringLike(): this;
    /**
     * Negated case-sensitive matching.
     *
     * The values can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`) anywhere in the string.
     */
    stringNotLike(): this;
    /**
     * Exact match.
     */
    numericEquals(): this;
    /**
     * Negated exact match.
     */
    numericNotEquals(): this;
    /**
     * Match numbers lower than value: `<`
     */
    numericLessThan(): this;
    /**
     * Match numbers lower or equal to value: `<=`
     */
    numericLessThanEquals(): this;
    /**
     * Match numbers higher than value: `>`
     */
    numericGreaterThan(): this;
    /**
     * Match numbers higher or equal value: `>=`
     */
    numericGreaterThanEquals(): this;
    /**
     * Match a specific date: `=`
     */
    dateEquals(): this;
    /**
     * Negated match for a specific date: `!=`
     */
    dateNotEquals(): this;
    /**
     * Match before a specific date and time: `<`
     */
    dateLessThan(): this;
    /**
     * Match at or before a specific date and time: `<=`
     */
    dateLessThanEquals(): this;
    /**
     * Match after a specific a date and time: `>`
     */
    dateGreaterThan(): this;
    /**
     * Match at or after a specific date and time: `>=`
     */
    dateGreaterThanEquals(): this;
    /**
     * Boolean match
     */
    bool(): this;
    /**
     * The BinaryEquals condition operator lets you construct Condition elements that test key values that are in binary format. It compares the value of the specified key byte for byte against a [base-64](https://en.wikipedia.org/wiki/Base64) encoded representation of the binary value in the policy.
     */
    binaryEquals(): this;
    /**
     * Match an IP address or range: `=`
     */
    ipAddress(): this;
    /**
     * All IP addresses except the specified IP address or range `!=`
     */
    notIpAddress(): this;
    /**
     * Match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnEquals` and `ArnLike` behave identical.
     */
    arnEquals(): this;
    /**
     * Negated match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnNotEquals` and `ArnNotLike` behave identical.
     */
    arnNotEquals(): this;
    /**
     * Match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     */
    arnLike(): this;
    /**
     * Negated match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnNotEquals` and `ArnNotLike` behave identical.
     */
    arnNotLike(): this;
    /**
     * Check if a key is present at the time of authorization. In the policy statement, use either true (the key doesn't exist — it is null) or false (the key exists and its value is not null).
     */
    null(): this;
}
