# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTlsPrivateKeyResult',
    'AwaitableGetTlsPrivateKeyResult',
    'get_tls_private_key',
    'get_tls_private_key_output',
]

@pulumi.output_type
class GetTlsPrivateKeyResult:
    """
    A collection of values returned by getTlsPrivateKey.
    """
    def __init__(__self__, created_at=None, id=None, key_length=None, key_type=None, name=None, public_key_sha1=None, replace=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_length and not isinstance(key_length, int):
            raise TypeError("Expected argument 'key_length' to be a int")
        pulumi.set(__self__, "key_length", key_length)
        if key_type and not isinstance(key_type, str):
            raise TypeError("Expected argument 'key_type' to be a str")
        pulumi.set(__self__, "key_type", key_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key_sha1 and not isinstance(public_key_sha1, str):
            raise TypeError("Expected argument 'public_key_sha1' to be a str")
        pulumi.set(__self__, "public_key_sha1", public_key_sha1)
        if replace and not isinstance(replace, bool):
            raise TypeError("Expected argument 'replace' to be a bool")
        pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Timestamp (GMT) when the private key was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fastly private key ID. Conflicts with all the other filters
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyLength")
    def key_length(self) -> int:
        """
        The key length used to generate the private key.
        """
        return pulumi.get(self, "key_length")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        The algorithm used to generate the private key. Must be RSA.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The human-readable name assigned to the private key when uploaded.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKeySha1")
    def public_key_sha1(self) -> str:
        """
        A hash of the associated public key, useful for safely identifying it.
        """
        return pulumi.get(self, "public_key_sha1")

    @property
    @pulumi.getter
    def replace(self) -> bool:
        """
        Whether Fastly recommends replacing this private key.
        """
        return pulumi.get(self, "replace")


class AwaitableGetTlsPrivateKeyResult(GetTlsPrivateKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTlsPrivateKeyResult(
            created_at=self.created_at,
            id=self.id,
            key_length=self.key_length,
            key_type=self.key_type,
            name=self.name,
            public_key_sha1=self.public_key_sha1,
            replace=self.replace)


def get_tls_private_key(created_at: Optional[str] = None,
                        id: Optional[str] = None,
                        key_length: Optional[int] = None,
                        key_type: Optional[str] = None,
                        name: Optional[str] = None,
                        public_key_sha1: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTlsPrivateKeyResult:
    """
    Use this data source to get information on a TLS Private Key uploaded to Fastly.

    > **Warning:** The data source's filters are applied using an **AND** boolean operator, so depending on the combination
     of filters, they may become mutually exclusive. The exception to this is `id` which must not be specified in combination
     with any of the others.

    > **Note:** If more or less than a single match is returned by the search, this provider will fail. Ensure that your search
     is specific enough to return a single key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    demo = fastly.get_tls_private_key(name="demo-private-key")
    pulumi.export("privateKeyNeedsReplacing", demo.replace)
    ```


    :param str created_at: Timestamp (GMT) when the private key was created.
    :param str id: Fastly private key ID. Conflicts with all the other filters
    :param int key_length: The key length used to generate the private key.
    :param str key_type: The algorithm used to generate the private key. Must be RSA.
    :param str name: The human-readable name assigned to the private key when uploaded.
    :param str public_key_sha1: A hash of the associated public key, useful for safely identifying it.
    """
    __args__ = dict()
    __args__['createdAt'] = created_at
    __args__['id'] = id
    __args__['keyLength'] = key_length
    __args__['keyType'] = key_type
    __args__['name'] = name
    __args__['publicKeySha1'] = public_key_sha1
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getTlsPrivateKey:getTlsPrivateKey', __args__, opts=opts, typ=GetTlsPrivateKeyResult).value

    return AwaitableGetTlsPrivateKeyResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        key_length=pulumi.get(__ret__, 'key_length'),
        key_type=pulumi.get(__ret__, 'key_type'),
        name=pulumi.get(__ret__, 'name'),
        public_key_sha1=pulumi.get(__ret__, 'public_key_sha1'),
        replace=pulumi.get(__ret__, 'replace'))
def get_tls_private_key_output(created_at: Optional[pulumi.Input[Optional[str]]] = None,
                               id: Optional[pulumi.Input[Optional[str]]] = None,
                               key_length: Optional[pulumi.Input[Optional[int]]] = None,
                               key_type: Optional[pulumi.Input[Optional[str]]] = None,
                               name: Optional[pulumi.Input[Optional[str]]] = None,
                               public_key_sha1: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTlsPrivateKeyResult]:
    """
    Use this data source to get information on a TLS Private Key uploaded to Fastly.

    > **Warning:** The data source's filters are applied using an **AND** boolean operator, so depending on the combination
     of filters, they may become mutually exclusive. The exception to this is `id` which must not be specified in combination
     with any of the others.

    > **Note:** If more or less than a single match is returned by the search, this provider will fail. Ensure that your search
     is specific enough to return a single key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    demo = fastly.get_tls_private_key(name="demo-private-key")
    pulumi.export("privateKeyNeedsReplacing", demo.replace)
    ```


    :param str created_at: Timestamp (GMT) when the private key was created.
    :param str id: Fastly private key ID. Conflicts with all the other filters
    :param int key_length: The key length used to generate the private key.
    :param str key_type: The algorithm used to generate the private key. Must be RSA.
    :param str name: The human-readable name assigned to the private key when uploaded.
    :param str public_key_sha1: A hash of the associated public key, useful for safely identifying it.
    """
    __args__ = dict()
    __args__['createdAt'] = created_at
    __args__['id'] = id
    __args__['keyLength'] = key_length
    __args__['keyType'] = key_type
    __args__['name'] = name
    __args__['publicKeySha1'] = public_key_sha1
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getTlsPrivateKey:getTlsPrivateKey', __args__, opts=opts, typ=GetTlsPrivateKeyResult)
    return __ret__.apply(lambda __response__: GetTlsPrivateKeyResult(
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        key_length=pulumi.get(__response__, 'key_length'),
        key_type=pulumi.get(__response__, 'key_type'),
        name=pulumi.get(__response__, 'name'),
        public_key_sha1=pulumi.get(__response__, 'public_key_sha1'),
        replace=pulumi.get(__response__, 'replace')))
