# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 strategy: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_domain_connection: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 options: Optional[pulumi.Input['ConnectionOptionsArgs']] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 show_as_button: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[str] name: Name of the connection.
        :param pulumi.Input[str] strategy: Type of the connection, which indicates the identity provider.
        :param pulumi.Input[str] display_name: Name used in login screen.
        :param pulumi.Input[bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars). Maximum of 10 metadata properties allowed.
        :param pulumi.Input['ConnectionOptionsArgs'] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "strategy", strategy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_domain_connection is not None:
            pulumi.set(__self__, "is_domain_connection", is_domain_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if realms is not None:
            pulumi.set(__self__, "realms", realms)
        if show_as_button is not None:
            pulumi.set(__self__, "show_as_button", show_as_button)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[str]:
        """
        Type of the connection, which indicates the identity provider.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name used in login screen.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isDomainConnection")
    def is_domain_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the connection is domain level.
        """
        return pulumi.get(self, "is_domain_connection")

    @is_domain_connection.setter
    def is_domain_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_domain_connection", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata associated with the connection, in the form of a map of string values (max 255 chars). Maximum of 10 metadata properties allowed.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['ConnectionOptionsArgs']]:
        """
        Configuration settings for connection options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['ConnectionOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def realms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        """
        return pulumi.get(self, "realms")

    @realms.setter
    def realms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "realms", value)

    @property
    @pulumi.getter(name="showAsButton")
    def show_as_button(self) -> Optional[pulumi.Input[bool]]:
        """
        Display connection as a button. Only available on enterprise connections.
        """
        return pulumi.get(self, "show_as_button")

    @show_as_button.setter
    def show_as_button(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_as_button", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_domain_connection: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['ConnectionOptionsArgs']] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 show_as_button: Optional[pulumi.Input[bool]] = None,
                 strategy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[str] display_name: Name used in login screen.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_clients: IDs of the clients for which the connection is enabled.
        :param pulumi.Input[bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars). Maximum of 10 metadata properties allowed.
        :param pulumi.Input[str] name: Name of the connection.
        :param pulumi.Input['ConnectionOptionsArgs'] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        :param pulumi.Input[str] strategy: Type of the connection, which indicates the identity provider.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled_clients is not None:
            pulumi.set(__self__, "enabled_clients", enabled_clients)
        if is_domain_connection is not None:
            pulumi.set(__self__, "is_domain_connection", is_domain_connection)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if realms is not None:
            pulumi.set(__self__, "realms", realms)
        if show_as_button is not None:
            pulumi.set(__self__, "show_as_button", show_as_button)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name used in login screen.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enabledClients")
    def enabled_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IDs of the clients for which the connection is enabled.
        """
        return pulumi.get(self, "enabled_clients")

    @enabled_clients.setter
    def enabled_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_clients", value)

    @property
    @pulumi.getter(name="isDomainConnection")
    def is_domain_connection(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the connection is domain level.
        """
        return pulumi.get(self, "is_domain_connection")

    @is_domain_connection.setter
    def is_domain_connection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_domain_connection", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata associated with the connection, in the form of a map of string values (max 255 chars). Maximum of 10 metadata properties allowed.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['ConnectionOptionsArgs']]:
        """
        Configuration settings for connection options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['ConnectionOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def realms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        """
        return pulumi.get(self, "realms")

    @realms.setter
    def realms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "realms", value)

    @property
    @pulumi.getter(name="showAsButton")
    def show_as_button(self) -> Optional[pulumi.Input[bool]]:
        """
        Display connection as a button. Only available on enterprise connections.
        """
        return pulumi.get(self, "show_as_button")

    @show_as_button.setter
    def show_as_button(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_as_button", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the connection, which indicates the identity provider.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_domain_connection: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 show_as_button: Optional[pulumi.Input[bool]] = None,
                 strategy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        With Auth0, you can define sources of users, otherwise known as connections, which may include identity providers (such as Google or LinkedIn), databases, or passwordless authentication methods. This resource allows you to configure and manage connections to be used with your clients and users.

        > The Auth0 dashboard displays only one connection per social provider. Although the Auth0 Management API allows the
        creation of multiple connections per strategy, the additional connections may not be visible in the Auth0 dashboard.

        ## Example Usage
        ### Google OAuth2 Connection

        > Your Auth0 account may be pre-configured with a `google-oauth2` connection.

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        google_oauth2 = auth0.Connection("googleOauth2",
            name="Google-OAuth2-Connection",
            options=auth0.ConnectionOptionsArgs(
                allowed_audiences=[
                    "example.com",
                    "api.example.com",
                ],
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "email",
                    "profile",
                    "gmail",
                    "youtube",
                ],
                set_user_root_attributes="on_each_login",
            ),
            strategy="google-oauth2")
        ```
        ### Facebook Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        facebook = auth0.Connection("facebook",
            name="Facebook-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "public_profile",
                    "email",
                    "groups_access_member_info",
                    "user_birthday",
                ],
                set_user_root_attributes="on_each_login",
            ),
            strategy="facebook")
        ```
        ### Apple Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        apple = auth0.Connection("apple",
            name="Apple-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret=\"\"\"-----BEGIN PRIVATE KEY-----
        MIHBAgEAMA0GCSqGSIb3DQEBAQUABIGsMIGpAgEAA
        -----END PRIVATE KEY-----
        \"\"\",
                key_id="<key-id>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "email",
                    "name",
                ],
                set_user_root_attributes="on_first_login",
                team_id="<team-id>",
            ),
            strategy="apple")
        ```
        ### LinkedIn Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        linkedin = auth0.Connection("linkedin",
            name="Linkedin-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "basic_profile",
                    "profile",
                    "email",
                ],
                set_user_root_attributes="on_each_login",
                strategy_version=2,
            ),
            strategy="linkedin")
        ```
        ### GitHub Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        github = auth0.Connection("github",
            name="GitHub-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "email",
                    "profile",
                    "public_repo",
                    "repo",
                ],
                set_user_root_attributes="on_each_login",
            ),
            strategy="github")
        ```
        ### SalesForce Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        salesforce = auth0.Connection("salesforce",
            name="Salesforce-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                community_base_url="https://salesforce.example.com",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "openid",
                    "email",
                ],
                set_user_root_attributes="on_first_login",
            ),
            strategy="salesforce")
        ```
        ### OAuth2 Connection

        Also applies to following connection strategies: `dropbox`, `bitbucket`, `paypal`, `twitter`, `amazon`, `yahoo`, `box`, `wordpress`, `discord`, `imgur`, `spotify`, `shopify`, `figma`, `slack-oauth-2`, `digitalocean`, `twitch`, `vimeo`, `custom`

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        oauth2 = auth0.Connection("oauth2",
            name="OAuth2-Connection",
            options=auth0.ConnectionOptionsArgs(
                authorization_endpoint="https://auth.example.com/oauth2/authorize",
                client_id="<client-id>",
                client_secret="<client-secret>",
                icon_url="https://auth.example.com/assets/logo.png",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                pkce_enabled=True,
                scopes=[
                    "basic_profile",
                    "profile",
                    "email",
                ],
                scripts={
                    "fetchUserProfile": \"\"\"        function fetchUserProfile(accessToken, context, callback) {
                  return callback(new Error("Whoops!"));
                }
              
        \"\"\",
                },
                set_user_root_attributes="on_each_login",
                token_endpoint="https://auth.example.com/oauth2/token",
            ),
            strategy="oauth2")
        ```
        ### SMS Connection

        > To be able to see this in the management dashboard as well, the name of the connection must be set to "sms".

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        sms = auth0.Connection("sms",
            is_domain_connection=False,
            name="custom-sms-gateway",
            options=auth0.ConnectionOptionsArgs(
                brute_force_protection=True,
                disable_signup=False,
                forward_request_info=True,
                from_="+15555555555",
                gateway_authentication=auth0.ConnectionOptionsGatewayAuthenticationArgs(
                    audience="https://somewhere.com/sms-gateway",
                    method="bearer",
                    secret="4e2680bb74ec2ae24736476dd37ed6c2",
                    secret_base64_encoded=False,
                    subject="test.us.auth0.com:sms",
                ),
                gateway_url="https://somewhere.com/sms-gateway",
                name="sms",
                provider="sms_gateway",
                syntax="md_with_macros",
                template="@@password@@",
                totp=auth0.ConnectionOptionsTotpArgs(
                    length=6,
                    time_step=300,
                ),
            ),
            strategy="sms")
        ```
        ### Email Connection

        > To be able to see this in the management dashboard as well, the name of the connection must be set to "email".

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        passwordless_email = auth0.Connection("passwordlessEmail",
            name="email",
            options=auth0.ConnectionOptionsArgs(
                auth_params={
                    "responseType": "code",
                    "scope": "openid email profile offline_access",
                },
                brute_force_protection=True,
                disable_signup=False,
                from_="{{ application.name }} <root@auth0.com>",
                name="email",
                non_persistent_attrs=[],
                set_user_root_attributes="on_each_login",
                subject="Welcome to {{ application.name }}",
                syntax="liquid",
                template="<html>This is the body of the email</html>",
                totp=auth0.ConnectionOptionsTotpArgs(
                    length=6,
                    time_step=300,
                ),
            ),
            strategy="email")
        ```
        ### WindowsLive Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        windowslive = auth0.Connection("windowslive",
            name="Windowslive-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "signin",
                    "graph_user",
                ],
                set_user_root_attributes="on_first_login",
                strategy_version=2,
            ),
            strategy="windowslive")
        ```
        ### OIDC Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        oidc = auth0.Connection("oidc",
            display_name="OIDC Connection",
            name="oidc-connection",
            options=auth0.ConnectionOptionsArgs(
                authorization_endpoint="https://www.paypal.com/signin/authorize",
                client_id="1234567",
                client_secret="1234567",
                discovery_url="https://www.paypalobjects.com/.well-known/openid-configuration",
                domain_aliases=["example.com"],
                icon_url="https://example.com/assets/logo.png",
                issuer="https://www.paypalobjects.com",
                jwks_uri="https://api.paypal.com/v1/oauth2/certs",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "openid",
                    "email",
                ],
                set_user_root_attributes="on_first_login",
                tenant_domain="",
                token_endpoint="https://api.paypal.com/v1/oauth2/token",
                type="front_channel",
                userinfo_endpoint="https://api.paypal.com/v1/oauth2/token/userinfo",
            ),
            show_as_button=False,
            strategy="oidc")
        ```

        ## Import

        Connections can be imported using their ID. # Example

        ```sh
         $ pulumi import auth0:index/connection:Connection google con_a17f21fdb24d48a0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Name used in login screen.
        :param pulumi.Input[bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars). Maximum of 10 metadata properties allowed.
        :param pulumi.Input[str] name: Name of the connection.
        :param pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        :param pulumi.Input[str] strategy: Type of the connection, which indicates the identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With Auth0, you can define sources of users, otherwise known as connections, which may include identity providers (such as Google or LinkedIn), databases, or passwordless authentication methods. This resource allows you to configure and manage connections to be used with your clients and users.

        > The Auth0 dashboard displays only one connection per social provider. Although the Auth0 Management API allows the
        creation of multiple connections per strategy, the additional connections may not be visible in the Auth0 dashboard.

        ## Example Usage
        ### Google OAuth2 Connection

        > Your Auth0 account may be pre-configured with a `google-oauth2` connection.

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        google_oauth2 = auth0.Connection("googleOauth2",
            name="Google-OAuth2-Connection",
            options=auth0.ConnectionOptionsArgs(
                allowed_audiences=[
                    "example.com",
                    "api.example.com",
                ],
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "email",
                    "profile",
                    "gmail",
                    "youtube",
                ],
                set_user_root_attributes="on_each_login",
            ),
            strategy="google-oauth2")
        ```
        ### Facebook Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        facebook = auth0.Connection("facebook",
            name="Facebook-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "public_profile",
                    "email",
                    "groups_access_member_info",
                    "user_birthday",
                ],
                set_user_root_attributes="on_each_login",
            ),
            strategy="facebook")
        ```
        ### Apple Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        apple = auth0.Connection("apple",
            name="Apple-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret=\"\"\"-----BEGIN PRIVATE KEY-----
        MIHBAgEAMA0GCSqGSIb3DQEBAQUABIGsMIGpAgEAA
        -----END PRIVATE KEY-----
        \"\"\",
                key_id="<key-id>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "email",
                    "name",
                ],
                set_user_root_attributes="on_first_login",
                team_id="<team-id>",
            ),
            strategy="apple")
        ```
        ### LinkedIn Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        linkedin = auth0.Connection("linkedin",
            name="Linkedin-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "basic_profile",
                    "profile",
                    "email",
                ],
                set_user_root_attributes="on_each_login",
                strategy_version=2,
            ),
            strategy="linkedin")
        ```
        ### GitHub Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        github = auth0.Connection("github",
            name="GitHub-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "email",
                    "profile",
                    "public_repo",
                    "repo",
                ],
                set_user_root_attributes="on_each_login",
            ),
            strategy="github")
        ```
        ### SalesForce Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        salesforce = auth0.Connection("salesforce",
            name="Salesforce-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                community_base_url="https://salesforce.example.com",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "openid",
                    "email",
                ],
                set_user_root_attributes="on_first_login",
            ),
            strategy="salesforce")
        ```
        ### OAuth2 Connection

        Also applies to following connection strategies: `dropbox`, `bitbucket`, `paypal`, `twitter`, `amazon`, `yahoo`, `box`, `wordpress`, `discord`, `imgur`, `spotify`, `shopify`, `figma`, `slack-oauth-2`, `digitalocean`, `twitch`, `vimeo`, `custom`

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        oauth2 = auth0.Connection("oauth2",
            name="OAuth2-Connection",
            options=auth0.ConnectionOptionsArgs(
                authorization_endpoint="https://auth.example.com/oauth2/authorize",
                client_id="<client-id>",
                client_secret="<client-secret>",
                icon_url="https://auth.example.com/assets/logo.png",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                pkce_enabled=True,
                scopes=[
                    "basic_profile",
                    "profile",
                    "email",
                ],
                scripts={
                    "fetchUserProfile": \"\"\"        function fetchUserProfile(accessToken, context, callback) {
                  return callback(new Error("Whoops!"));
                }
              
        \"\"\",
                },
                set_user_root_attributes="on_each_login",
                token_endpoint="https://auth.example.com/oauth2/token",
            ),
            strategy="oauth2")
        ```
        ### SMS Connection

        > To be able to see this in the management dashboard as well, the name of the connection must be set to "sms".

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        sms = auth0.Connection("sms",
            is_domain_connection=False,
            name="custom-sms-gateway",
            options=auth0.ConnectionOptionsArgs(
                brute_force_protection=True,
                disable_signup=False,
                forward_request_info=True,
                from_="+15555555555",
                gateway_authentication=auth0.ConnectionOptionsGatewayAuthenticationArgs(
                    audience="https://somewhere.com/sms-gateway",
                    method="bearer",
                    secret="4e2680bb74ec2ae24736476dd37ed6c2",
                    secret_base64_encoded=False,
                    subject="test.us.auth0.com:sms",
                ),
                gateway_url="https://somewhere.com/sms-gateway",
                name="sms",
                provider="sms_gateway",
                syntax="md_with_macros",
                template="@@password@@",
                totp=auth0.ConnectionOptionsTotpArgs(
                    length=6,
                    time_step=300,
                ),
            ),
            strategy="sms")
        ```
        ### Email Connection

        > To be able to see this in the management dashboard as well, the name of the connection must be set to "email".

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        passwordless_email = auth0.Connection("passwordlessEmail",
            name="email",
            options=auth0.ConnectionOptionsArgs(
                auth_params={
                    "responseType": "code",
                    "scope": "openid email profile offline_access",
                },
                brute_force_protection=True,
                disable_signup=False,
                from_="{{ application.name }} <root@auth0.com>",
                name="email",
                non_persistent_attrs=[],
                set_user_root_attributes="on_each_login",
                subject="Welcome to {{ application.name }}",
                syntax="liquid",
                template="<html>This is the body of the email</html>",
                totp=auth0.ConnectionOptionsTotpArgs(
                    length=6,
                    time_step=300,
                ),
            ),
            strategy="email")
        ```
        ### WindowsLive Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        windowslive = auth0.Connection("windowslive",
            name="Windowslive-Connection",
            options=auth0.ConnectionOptionsArgs(
                client_id="<client-id>",
                client_secret="<client-secret>",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "signin",
                    "graph_user",
                ],
                set_user_root_attributes="on_first_login",
                strategy_version=2,
            ),
            strategy="windowslive")
        ```
        ### OIDC Connection

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        oidc = auth0.Connection("oidc",
            display_name="OIDC Connection",
            name="oidc-connection",
            options=auth0.ConnectionOptionsArgs(
                authorization_endpoint="https://www.paypal.com/signin/authorize",
                client_id="1234567",
                client_secret="1234567",
                discovery_url="https://www.paypalobjects.com/.well-known/openid-configuration",
                domain_aliases=["example.com"],
                icon_url="https://example.com/assets/logo.png",
                issuer="https://www.paypalobjects.com",
                jwks_uri="https://api.paypal.com/v1/oauth2/certs",
                non_persistent_attrs=[
                    "ethnicity",
                    "gender",
                ],
                scopes=[
                    "openid",
                    "email",
                ],
                set_user_root_attributes="on_first_login",
                tenant_domain="",
                token_endpoint="https://api.paypal.com/v1/oauth2/token",
                type="front_channel",
                userinfo_endpoint="https://api.paypal.com/v1/oauth2/token/userinfo",
            ),
            show_as_button=False,
            strategy="oidc")
        ```

        ## Import

        Connections can be imported using their ID. # Example

        ```sh
         $ pulumi import auth0:index/connection:Connection google con_a17f21fdb24d48a0
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_domain_connection: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 show_as_button: Optional[pulumi.Input[bool]] = None,
                 strategy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["is_domain_connection"] = is_domain_connection
            __props__.__dict__["metadata"] = metadata
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["realms"] = realms
            __props__.__dict__["show_as_button"] = show_as_button
            if strategy is None and not opts.urn:
                raise TypeError("Missing required property 'strategy'")
            __props__.__dict__["strategy"] = strategy
            __props__.__dict__["enabled_clients"] = None
        super(Connection, __self__).__init__(
            'auth0:index/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enabled_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_domain_connection: Optional[pulumi.Input[bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']]] = None,
            realms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            show_as_button: Optional[pulumi.Input[bool]] = None,
            strategy: Optional[pulumi.Input[str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Name used in login screen.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_clients: IDs of the clients for which the connection is enabled.
        :param pulumi.Input[bool] is_domain_connection: Indicates whether the connection is domain level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata associated with the connection, in the form of a map of string values (max 255 chars). Maximum of 10 metadata properties allowed.
        :param pulumi.Input[str] name: Name of the connection.
        :param pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']] options: Configuration settings for connection options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] realms: Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[bool] show_as_button: Display connection as a button. Only available on enterprise connections.
        :param pulumi.Input[str] strategy: Type of the connection, which indicates the identity provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled_clients"] = enabled_clients
        __props__.__dict__["is_domain_connection"] = is_domain_connection
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["realms"] = realms
        __props__.__dict__["show_as_button"] = show_as_button
        __props__.__dict__["strategy"] = strategy
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name used in login screen.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enabledClients")
    def enabled_clients(self) -> pulumi.Output[Sequence[str]]:
        """
        IDs of the clients for which the connection is enabled.
        """
        return pulumi.get(self, "enabled_clients")

    @property
    @pulumi.getter(name="isDomainConnection")
    def is_domain_connection(self) -> pulumi.Output[bool]:
        """
        Indicates whether the connection is domain level.
        """
        return pulumi.get(self, "is_domain_connection")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Metadata associated with the connection, in the form of a map of string values (max 255 chars). Maximum of 10 metadata properties allowed.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.ConnectionOptions']:
        """
        Configuration settings for connection options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def realms(self) -> pulumi.Output[Sequence[str]]:
        """
        Defines the realms for which the connection will be used (e.g., email domains). If not specified, the connection name is added as the realm.
        """
        return pulumi.get(self, "realms")

    @property
    @pulumi.getter(name="showAsButton")
    def show_as_button(self) -> pulumi.Output[Optional[bool]]:
        """
        Display connection as a button. Only available on enterprise connections.
        """
        return pulumi.get(self, "show_as_button")

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[str]:
        """
        Type of the connection, which indicates the identity provider.
        """
        return pulumi.get(self, "strategy")

