"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assignRequiredPoliciesToRole = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
;
function assignRequiredPoliciesToRole(scope, props) {
    props.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'));
    props.role.addManagedPolicy(new aws_cdk_lib_1.aws_iam.ManagedPolicy(scope, 'snsPolicy', {
        description: 'Allow the Certbot function to notify an SNS topic upon completion.',
        statements: [
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: ['sns:Publish'],
                resources: [props.snsTopic.topicArn],
            }),
        ],
    }));
    props.role.addManagedPolicy(new aws_cdk_lib_1.aws_iam.ManagedPolicy(scope, 'r53Policy', {
        description: 'Allow the Certbot function to perform DNS verification.',
        statements: [
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: ['route53:ListHostedZones'],
                resources: ['*'],
            }),
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: [
                    'route53:GetChange',
                    'route53:ChangeResourceRecordSets',
                ],
                resources: ['arn:aws:route53:::change/*'].concat(props.hostedZones),
            }),
        ],
    }));
    props.role.addManagedPolicy(new aws_cdk_lib_1.aws_iam.ManagedPolicy(scope, 'acmPolicy', {
        description: 'Allow the Certbot function to import and list certificates.',
        statements: [
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: [
                    'acm:ListCertificates',
                    'acm:ImportCertificate',
                ],
                resources: ['*'],
            }),
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: ['acm:DescribeCertificate'],
                resources: ['arn:aws:acm:' + aws_cdk_lib_1.Stack.of(scope).region + ':' + aws_cdk_lib_1.Stack.of(scope).account + ':certificate/*'],
            }),
        ],
    }));
}
exports.assignRequiredPoliciesToRole = assignRequiredPoliciesToRole;
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVxdWlyZWQtcG9saWNpZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcmVxdWlyZWQtcG9saWNpZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkNBSXFCO0FBZ0JwQixDQUFDO0FBRUYsU0FBZ0IsNEJBQTRCLENBQUMsS0FBZ0IsRUFBRSxLQUE0QjtJQUN6RixLQUFLLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHFCQUFHLENBQUMsYUFBYSxDQUFDLHdCQUF3QixDQUFDLDBDQUEwQyxDQUFDLENBQUMsQ0FBQztJQUVwSCxLQUFLLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUkscUJBQUcsQ0FBQyxhQUFhLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtRQUNwRSxXQUFXLEVBQUUsb0VBQW9FO1FBQ2pGLFVBQVUsRUFBRTtZQUNWLElBQUkscUJBQUcsQ0FBQyxlQUFlLENBQUM7Z0JBQ3RCLE1BQU0sRUFBRSxxQkFBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLO2dCQUN4QixPQUFPLEVBQUUsQ0FBQyxhQUFhLENBQUM7Z0JBQ3hCLFNBQVMsRUFBRSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDO2FBQ3JDLENBQUM7U0FDSDtLQUNGLENBQUMsQ0FBQyxDQUFDO0lBRUosS0FBSyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLHFCQUFHLENBQUMsYUFBYSxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUU7UUFDcEUsV0FBVyxFQUFFLHlEQUF5RDtRQUN0RSxVQUFVLEVBQUU7WUFDVixJQUFJLHFCQUFHLENBQUMsZUFBZSxDQUFDO2dCQUN0QixNQUFNLEVBQUUscUJBQUcsQ0FBQyxNQUFNLENBQUMsS0FBSztnQkFDeEIsT0FBTyxFQUFFLENBQUMseUJBQXlCLENBQUM7Z0JBQ3BDLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQzthQUNqQixDQUFDO1lBQ0YsSUFBSSxxQkFBRyxDQUFDLGVBQWUsQ0FBQztnQkFDdEIsTUFBTSxFQUFFLHFCQUFHLENBQUMsTUFBTSxDQUFDLEtBQUs7Z0JBQ3hCLE9BQU8sRUFBRTtvQkFDUCxtQkFBbUI7b0JBQ25CLGtDQUFrQztpQkFDbkM7Z0JBQ0QsU0FBUyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQzthQUNwRSxDQUFDO1NBQ0g7S0FDRixDQUFDLENBQUMsQ0FBQztJQUVKLEtBQUssQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxxQkFBRyxDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO1FBQ3BFLFdBQVcsRUFBRSw2REFBNkQ7UUFDMUUsVUFBVSxFQUFFO1lBQ1YsSUFBSSxxQkFBRyxDQUFDLGVBQWUsQ0FBQztnQkFDdEIsTUFBTSxFQUFFLHFCQUFHLENBQUMsTUFBTSxDQUFDLEtBQUs7Z0JBQ3hCLE9BQU8sRUFBRTtvQkFDUCxzQkFBc0I7b0JBQ3RCLHVCQUF1QjtpQkFDeEI7Z0JBQ0QsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO2FBQ2pCLENBQUM7WUFDRixJQUFJLHFCQUFHLENBQUMsZUFBZSxDQUFDO2dCQUN0QixNQUFNLEVBQUUscUJBQUcsQ0FBQyxNQUFNLENBQUMsS0FBSztnQkFDeEIsT0FBTyxFQUFFLENBQUMseUJBQXlCLENBQUM7Z0JBQ3BDLFNBQVMsRUFBRSxDQUFDLGNBQWMsR0FBRyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEdBQUcsR0FBRyxHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sR0FBRyxnQkFBZ0IsQ0FBQzthQUN4RyxDQUFDO1NBQ0g7S0FDRixDQUFDLENBQUMsQ0FBQztBQUNOLENBQUM7QUFuREQsb0VBbURDO0FBQUEsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIGF3c19pYW0gYXMgaWFtLFxuICBhd3Nfc25zIGFzIHNucyxcbiAgU3RhY2ssXG59IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5pbnRlcmZhY2UgUmVxdWlyZWRQb2xpY2llc1Byb3BzIHtcbiAgLyoqXG4gICAqIFRoZSByb2xlIHRvIGFzc2lnbiBwb2xpY2llcyB0b1xuICAgKi9cbiAgcmVhZG9ubHkgcm9sZTogaWFtLlJvbGU7XG4gIC8qKlxuICAgKiBUaGUgU05TIHRvcGljIHRvIHNlbmQgbm90aWZpY2F0aW9ucyB0b1xuICAgKi9cbiAgcmVhZG9ubHkgc25zVG9waWM6IHNucy5Ub3BpYztcbiAgLyoqXG4gICAqIFRoZSBob3N0ZWRab25lcyB0aGF0IHdpbGwgYmUgcmVxdWlyZWQgZm9yIEROUyB2ZXJpZmljYXRpb24gd2l0aCBjZXJ0Ym90XG4gICAqL1xuICByZWFkb25seSBob3N0ZWRab25lczogc3RyaW5nW107XG59O1xuXG5leHBvcnQgZnVuY3Rpb24gYXNzaWduUmVxdWlyZWRQb2xpY2llc1RvUm9sZShzY29wZTogQ29uc3RydWN0LCBwcm9wczogUmVxdWlyZWRQb2xpY2llc1Byb3BzKTogdm9pZCB7XG4gIHByb3BzLnJvbGUuYWRkTWFuYWdlZFBvbGljeShpYW0uTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoJ3NlcnZpY2Utcm9sZS9BV1NMYW1iZGFCYXNpY0V4ZWN1dGlvblJvbGUnKSk7XG5cbiAgcHJvcHMucm9sZS5hZGRNYW5hZ2VkUG9saWN5KG5ldyBpYW0uTWFuYWdlZFBvbGljeShzY29wZSwgJ3Nuc1BvbGljeScsIHtcbiAgICBkZXNjcmlwdGlvbjogJ0FsbG93IHRoZSBDZXJ0Ym90IGZ1bmN0aW9uIHRvIG5vdGlmeSBhbiBTTlMgdG9waWMgdXBvbiBjb21wbGV0aW9uLicsXG4gICAgc3RhdGVtZW50czogW1xuICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBlZmZlY3Q6IGlhbS5FZmZlY3QuQUxMT1csXG4gICAgICAgIGFjdGlvbnM6IFsnc25zOlB1Ymxpc2gnXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbcHJvcHMuc25zVG9waWMudG9waWNBcm5dLFxuICAgICAgfSksXG4gICAgXSxcbiAgfSkpO1xuXG4gIHByb3BzLnJvbGUuYWRkTWFuYWdlZFBvbGljeShuZXcgaWFtLk1hbmFnZWRQb2xpY3koc2NvcGUsICdyNTNQb2xpY3knLCB7XG4gICAgZGVzY3JpcHRpb246ICdBbGxvdyB0aGUgQ2VydGJvdCBmdW5jdGlvbiB0byBwZXJmb3JtIEROUyB2ZXJpZmljYXRpb24uJyxcbiAgICBzdGF0ZW1lbnRzOiBbXG4gICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGVmZmVjdDogaWFtLkVmZmVjdC5BTExPVyxcbiAgICAgICAgYWN0aW9uczogWydyb3V0ZTUzOkxpc3RIb3N0ZWRab25lcyddLFxuICAgICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgICAgfSksXG4gICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGVmZmVjdDogaWFtLkVmZmVjdC5BTExPVyxcbiAgICAgICAgYWN0aW9uczogW1xuICAgICAgICAgICdyb3V0ZTUzOkdldENoYW5nZScsXG4gICAgICAgICAgJ3JvdXRlNTM6Q2hhbmdlUmVzb3VyY2VSZWNvcmRTZXRzJyxcbiAgICAgICAgXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbJ2Fybjphd3M6cm91dGU1Mzo6OmNoYW5nZS8qJ10uY29uY2F0KHByb3BzLmhvc3RlZFpvbmVzKSxcbiAgICAgIH0pLFxuICAgIF0sXG4gIH0pKTtcblxuICBwcm9wcy5yb2xlLmFkZE1hbmFnZWRQb2xpY3kobmV3IGlhbS5NYW5hZ2VkUG9saWN5KHNjb3BlLCAnYWNtUG9saWN5Jywge1xuICAgIGRlc2NyaXB0aW9uOiAnQWxsb3cgdGhlIENlcnRib3QgZnVuY3Rpb24gdG8gaW1wb3J0IGFuZCBsaXN0IGNlcnRpZmljYXRlcy4nLFxuICAgIHN0YXRlbWVudHM6IFtcbiAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgZWZmZWN0OiBpYW0uRWZmZWN0LkFMTE9XLFxuICAgICAgICBhY3Rpb25zOiBbXG4gICAgICAgICAgJ2FjbTpMaXN0Q2VydGlmaWNhdGVzJyxcbiAgICAgICAgICAnYWNtOkltcG9ydENlcnRpZmljYXRlJyxcbiAgICAgICAgXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgIH0pLFxuICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBlZmZlY3Q6IGlhbS5FZmZlY3QuQUxMT1csXG4gICAgICAgIGFjdGlvbnM6IFsnYWNtOkRlc2NyaWJlQ2VydGlmaWNhdGUnXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbJ2Fybjphd3M6YWNtOicgKyBTdGFjay5vZihzY29wZSkucmVnaW9uICsgJzonICsgU3RhY2sub2Yoc2NvcGUpLmFjY291bnQgKyAnOmNlcnRpZmljYXRlLyonXSxcbiAgICAgIH0pLFxuICAgIF0sXG4gIH0pKTtcbn07Il19