"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configureSSMStorage = exports.configureSecretsManagerStorage = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
;
function configureSecretsManagerStorage(scope, props) {
    const keyAlias = props.kmsKeyAlias || 'alias/aws/secretsmanager';
    const keyArn = aws_cdk_lib_1.aws_kms.Alias.fromAliasName(scope, 'kmsKeyAlias', keyAlias).keyArn;
    props.role.addManagedPolicy(new aws_cdk_lib_1.aws_iam.ManagedPolicy(scope, 'secretsManagerPolicy', {
        statements: [
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                actions: [
                    'secretsmanager:CreateSecret',
                    'secretsmanager:DeleteSecret',
                    'secretsmanager:DescribeSecret',
                    'secretsmanager:GetSecretValue',
                    'secretsmanager:ListSecrets',
                    'secretsmanager:PutSecretValue',
                    'secretsmanager:UpdateSecret',
                ],
                resources: [
                    `arn:aws:secretsmanager:${aws_cdk_lib_1.Stack.of(scope).region}:${aws_cdk_lib_1.Stack.of(scope).account}:secret:${props.secretsManagerPath}*`,
                ],
            }),
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                actions: [
                    'kms:Decrypt',
                    'kms:Encrypt',
                ],
                resources: [
                    keyArn,
                ],
            }),
        ],
    }));
}
exports.configureSecretsManagerStorage = configureSecretsManagerStorage;
;
function configureSSMStorage(scope, props) {
    const keyAlias = props.kmsKeyAlias || 'alias/aws/ssm';
    const keyArn = aws_cdk_lib_1.aws_kms.Alias.fromAliasName(scope, 'kmsKeyAlias', keyAlias).keyArn;
    props.role.addManagedPolicy(new aws_cdk_lib_1.aws_iam.ManagedPolicy(scope, 'ssmPolicy', {
        statements: [
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                actions: [
                    'ssm:PutParameter',
                ],
                resources: [
                    `arn:aws:ssm:${aws_cdk_lib_1.Stack.of(scope).region}:${aws_cdk_lib_1.Stack.of(scope).account}:parameter${props.parameterStorePath}*`,
                ],
            }),
            new aws_cdk_lib_1.aws_iam.PolicyStatement({
                actions: [
                    'kms:Decrypt',
                    'kms:Encrypt',
                ],
                resources: [
                    keyArn,
                ],
            }),
        ],
    }));
}
exports.configureSSMStorage = configureSSMStorage;
//# sourceMappingURL=data:application/json;base64,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