"""
Copyright 2019 Cognitive Scale, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import os
import tempfile

from cortex_builders.utils.docker_utils import DockerUtils

BASE_IMAGE = 'c12e/cortex-python36:7552534'
CORTEX_SDK_VERSION = '6.4.0'
SOURCE_ARCHIVE = None


def test_DockerUtils_create_docker_file__function():
    temp_dir = tempfile.mkdtemp()
    action_type = 'function'
    DockerUtils.create_docker_file(temp_dir, action_type, CORTEX_SDK_VERSION, SOURCE_ARCHIVE, BASE_IMAGE)

    with open(temp_dir + '/Dockerfile', 'r') as f:
        content = f.read()
    assert '# Auto-generated by the Cortex Python SDK' in content
    assert BASE_IMAGE in content
    assert CORTEX_SDK_VERSION in content
    assert action_type in content


def test_DockerUtils_create_docker_file__job():
    temp_dir = tempfile.mkdtemp()
    action_type = 'job'
    DockerUtils.create_docker_file(temp_dir, action_type, CORTEX_SDK_VERSION, SOURCE_ARCHIVE, BASE_IMAGE)

    with open(temp_dir + '/Dockerfile', 'r') as f:
        content = f.read()
    assert '# Auto-generated by the Cortex Python SDK' in content
    assert BASE_IMAGE in content
    assert CORTEX_SDK_VERSION in content
    assert action_type in content


def test_DockerUtils_create_docker_file__daemon():
    temp_dir = tempfile.mkdtemp()
    action_type = 'daemon'
    DockerUtils.create_docker_file(temp_dir, action_type, CORTEX_SDK_VERSION, SOURCE_ARCHIVE, BASE_IMAGE)

    with open(temp_dir + '/Dockerfile', 'r') as f:
        content = f.read()
    assert '# Auto-generated by the Cortex Python SDK' in content
    assert BASE_IMAGE in content
    assert CORTEX_SDK_VERSION in content
    assert 'app' in content
    assert 'gunicorn' in content


def test_DockerUtils_create_build_context_with_deps():
    source = """
    def foo(params):
        print(params)
    """
    func_name = 'foofunc'
    global_code = """"""
    requirements = ['requests']
    conda_requirements = ['pydash']
    
    temp_dir = tempfile.mkdtemp()
    d = DockerUtils.create_build_context(temp_dir, 'function', source, func_name, global_code, CORTEX_SDK_VERSION, SOURCE_ARCHIVE, BASE_IMAGE, requirements, conda_requirements)
    for root, dirs, files in os.walk(d):
        assert set(['Dockerfile', 'action.py', 'conda_requirements.txt', 'requirements.txt']) == set(files)
        assert dirs == []


def test_DockerUtils_create_build_context_no_deps():
    source = """
    def foo(params):
        print(params)
    """
    func_name = 'foofunc'
    global_code = """"""
    
    temp_dir = tempfile.mkdtemp()
    d = DockerUtils.create_build_context(temp_dir, 'function', source, func_name, global_code, CORTEX_SDK_VERSION, SOURCE_ARCHIVE, BASE_IMAGE)
    for root, dirs, files in os.walk(d):
        assert set(['Dockerfile', 'action.py']) == set(files)
        assert dirs == []


# def test_DockerUtils_build_and_push():
#     build_dir = os.path.dirname(os.path.abspath(__file__))  + '/data'
#     name = 'fooname'
#     repository = 'private-registry.cortex-dev.insights.ai/vadancs/foo'
#     r = DockerUtils.build_and_push(build_dir, name, repository)
#     print(r)
