"use strict";
/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const metadata_common_1 = require("@elyra/metadata-common");
const react_1 = __importDefault(require("react"));
const PipelineService_1 = require("./PipelineService");
exports.RUNTIMES_NAMESPACE = 'runtimes';
exports.KFP_SCHEMA = 'kfp';
/**
 * A React Component for displaying the runtimes list.
 */
class RuntimesDisplay extends metadata_common_1.MetadataDisplay {
    renderExpandableContent(metadata) {
        const apiEndpoint = metadata.metadata.api_endpoint.endsWith('/')
            ? metadata.metadata.api_endpoint
            : metadata.metadata.api_endpoint + '/';
        return (react_1.default.createElement("div", null,
            react_1.default.createElement("h6", null, "Runtime History:"),
            react_1.default.createElement("a", { href: apiEndpoint, target: "_blank", rel: "noreferrer noopener" }, apiEndpoint),
            react_1.default.createElement("br", null),
            react_1.default.createElement("br", null),
            react_1.default.createElement("h6", null, "Cloud Object Storage:"),
            react_1.default.createElement("a", { href: metadata.metadata.cos_endpoint, target: "_blank", rel: "noreferrer noopener" }, metadata.metadata.cos_endpoint)));
    }
}
/**
 * A widget for displaying runtimes.
 */
class RuntimesWidget extends metadata_common_1.MetadataWidget {
    constructor(props) {
        super(props);
    }
    fetchMetadata() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield PipelineService_1.PipelineService.getRuntimes();
        });
    }
    renderDisplay(metadata) {
        return (react_1.default.createElement(RuntimesDisplay, { metadata: metadata, updateMetadata: this.updateMetadata, openMetadataEditor: this.openMetadataEditor, namespace: exports.RUNTIMES_NAMESPACE, schema: exports.KFP_SCHEMA }));
    }
}
exports.RuntimesWidget = RuntimesWidget;
//# sourceMappingURL=RuntimesWidget.js.map