# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbSystemShapesResult',
    'AwaitableGetDbSystemShapesResult',
    'get_db_system_shapes',
    'get_db_system_shapes_output',
]

@pulumi.output_type
class GetDbSystemShapesResult:
    """
    A collection of values returned by getDbSystemShapes.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, db_system_shapes=None, filters=None, id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_system_shapes and not isinstance(db_system_shapes, list):
            raise TypeError("Expected argument 'db_system_shapes' to be a list")
        pulumi.set(__self__, "db_system_shapes", db_system_shapes)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbSystemShapes")
    def db_system_shapes(self) -> Sequence['outputs.GetDbSystemShapesDbSystemShapeResult']:
        """
        The list of db_system_shapes.
        """
        return pulumi.get(self, "db_system_shapes")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbSystemShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDbSystemShapesResult(GetDbSystemShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemShapesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            db_system_shapes=self.db_system_shapes,
            filters=self.filters,
            id=self.id)


def get_db_system_shapes(availability_domain: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetDbSystemShapesFilterArgs']]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemShapesResult:
    """
    This data source provides the list of Db System Shapes in Oracle Cloud Infrastructure Database service.

    Gets a list of the shapes that can be used to launch a new DB system. The shape determines resources to allocate to the DB system - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_shapes = oci.Database.get_db_system_shapes(compartment_id=var["compartment_id"],
        availability_domain=var["db_system_shape_availability_domain"])
    ```


    :param str availability_domain: The name of the Availability Domain.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbSystemShapes:getDbSystemShapes', __args__, opts=opts, typ=GetDbSystemShapesResult).value

    return AwaitableGetDbSystemShapesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_system_shapes=pulumi.get(__ret__, 'db_system_shapes'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_db_system_shapes)
def get_db_system_shapes_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                                compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDbSystemShapesFilterArgs']]]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbSystemShapesResult]:
    """
    This data source provides the list of Db System Shapes in Oracle Cloud Infrastructure Database service.

    Gets a list of the shapes that can be used to launch a new DB system. The shape determines resources to allocate to the DB system - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_shapes = oci.Database.get_db_system_shapes(compartment_id=var["compartment_id"],
        availability_domain=var["db_system_shape_availability_domain"])
    ```


    :param str availability_domain: The name of the Availability Domain.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
