# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MediaWorkflowJobArgs', 'MediaWorkflowJob']

@pulumi.input_type
class MediaWorkflowJobArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 workflow_identifier_type: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 media_workflow_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 media_workflow_id: Optional[pulumi.Input[str]] = None,
                 media_workflow_name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MediaWorkflowJob resource.
        :param pulumi.Input[str] compartment_id: (Updatable) ID of the compartment in which the job should be created.
        :param pulumi.Input[str] workflow_identifier_type: Discriminate identification of a workflow by name versus a workflow by ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_workflow_configuration_ids: Configurations to be applied to this run of the workflow.
        :param pulumi.Input[str] media_workflow_id: OCID of the MediaWorkflow that should be run.
        :param pulumi.Input[str] media_workflow_name: Name of the system MediaWorkflow that should be run.
        :param pulumi.Input[str] parameters: Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON. The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "workflow_identifier_type", workflow_identifier_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if media_workflow_configuration_ids is not None:
            pulumi.set(__self__, "media_workflow_configuration_ids", media_workflow_configuration_ids)
        if media_workflow_id is not None:
            pulumi.set(__self__, "media_workflow_id", media_workflow_id)
        if media_workflow_name is not None:
            pulumi.set(__self__, "media_workflow_name", media_workflow_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) ID of the compartment in which the job should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="workflowIdentifierType")
    def workflow_identifier_type(self) -> pulumi.Input[str]:
        """
        Discriminate identification of a workflow by name versus a workflow by ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workflow_identifier_type")

    @workflow_identifier_type.setter
    def workflow_identifier_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "workflow_identifier_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="mediaWorkflowConfigurationIds")
    def media_workflow_configuration_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Configurations to be applied to this run of the workflow.
        """
        return pulumi.get(self, "media_workflow_configuration_ids")

    @media_workflow_configuration_ids.setter
    def media_workflow_configuration_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "media_workflow_configuration_ids", value)

    @property
    @pulumi.getter(name="mediaWorkflowId")
    def media_workflow_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the MediaWorkflow that should be run.
        """
        return pulumi.get(self, "media_workflow_id")

    @media_workflow_id.setter
    def media_workflow_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_workflow_id", value)

    @property
    @pulumi.getter(name="mediaWorkflowName")
    def media_workflow_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the system MediaWorkflow that should be run.
        """
        return pulumi.get(self, "media_workflow_name")

    @media_workflow_name.setter
    def media_workflow_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_workflow_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON. The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _MediaWorkflowJobState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 media_workflow_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 media_workflow_id: Optional[pulumi.Input[str]] = None,
                 media_workflow_name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobOutputArgs']]]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 runnable: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 task_lifecycle_states: Optional[pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobTaskLifecycleStateArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_ended: Optional[pulumi.Input[str]] = None,
                 time_started: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 workflow_identifier_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MediaWorkflowJob resources.
        :param pulumi.Input[str] compartment_id: (Updatable) ID of the compartment in which the job should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: The lifecycle details of MediaWorkflowJob task.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_workflow_configuration_ids: Configurations to be applied to this run of the workflow.
        :param pulumi.Input[str] media_workflow_id: OCID of the MediaWorkflow that should be run.
        :param pulumi.Input[str] media_workflow_name: Name of the system MediaWorkflow that should be run.
        :param pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobOutputArgs']]] outputs: A list of JobOutput for the workflowJob.
        :param pulumi.Input[str] parameters: Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON. The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        :param pulumi.Input[str] runnable: A JSON representation of the job as it will be run by the system. All the task declarations, configurations and parameters are merged. Parameter values are all fully resolved.
        :param pulumi.Input[str] state: The current state of the MediaWorkflowJob task.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobTaskLifecycleStateArgs']]] task_lifecycle_states: Status of each task.
        :param pulumi.Input[str] time_created: Creation time of the job. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_ended: Time when the job finished. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_started: Time when the job started to execute. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: Updated time of the job. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] workflow_identifier_type: Discriminate identification of a workflow by name versus a workflow by ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if media_workflow_configuration_ids is not None:
            pulumi.set(__self__, "media_workflow_configuration_ids", media_workflow_configuration_ids)
        if media_workflow_id is not None:
            pulumi.set(__self__, "media_workflow_id", media_workflow_id)
        if media_workflow_name is not None:
            pulumi.set(__self__, "media_workflow_name", media_workflow_name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if runnable is not None:
            pulumi.set(__self__, "runnable", runnable)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if task_lifecycle_states is not None:
            pulumi.set(__self__, "task_lifecycle_states", task_lifecycle_states)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if workflow_identifier_type is not None:
            pulumi.set(__self__, "workflow_identifier_type", workflow_identifier_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) ID of the compartment in which the job should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        The lifecycle details of MediaWorkflowJob task.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="mediaWorkflowConfigurationIds")
    def media_workflow_configuration_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Configurations to be applied to this run of the workflow.
        """
        return pulumi.get(self, "media_workflow_configuration_ids")

    @media_workflow_configuration_ids.setter
    def media_workflow_configuration_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "media_workflow_configuration_ids", value)

    @property
    @pulumi.getter(name="mediaWorkflowId")
    def media_workflow_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the MediaWorkflow that should be run.
        """
        return pulumi.get(self, "media_workflow_id")

    @media_workflow_id.setter
    def media_workflow_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_workflow_id", value)

    @property
    @pulumi.getter(name="mediaWorkflowName")
    def media_workflow_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the system MediaWorkflow that should be run.
        """
        return pulumi.get(self, "media_workflow_name")

    @media_workflow_name.setter
    def media_workflow_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_workflow_name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobOutputArgs']]]]:
        """
        A list of JobOutput for the workflowJob.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON. The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def runnable(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON representation of the job as it will be run by the system. All the task declarations, configurations and parameters are merged. Parameter values are all fully resolved.
        """
        return pulumi.get(self, "runnable")

    @runnable.setter
    def runnable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runnable", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the MediaWorkflowJob task.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="taskLifecycleStates")
    def task_lifecycle_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobTaskLifecycleStateArgs']]]]:
        """
        Status of each task.
        """
        return pulumi.get(self, "task_lifecycle_states")

    @task_lifecycle_states.setter
    def task_lifecycle_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MediaWorkflowJobTaskLifecycleStateArgs']]]]):
        pulumi.set(self, "task_lifecycle_states", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of the job. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the job finished. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_ended", value)

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the job started to execute. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_started", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Updated time of the job. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="workflowIdentifierType")
    def workflow_identifier_type(self) -> Optional[pulumi.Input[str]]:
        """
        Discriminate identification of a workflow by name versus a workflow by ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workflow_identifier_type")

    @workflow_identifier_type.setter
    def workflow_identifier_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workflow_identifier_type", value)


class MediaWorkflowJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 media_workflow_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 media_workflow_id: Optional[pulumi.Input[str]] = None,
                 media_workflow_name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 workflow_identifier_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Media Workflow Job resource in Oracle Cloud Infrastructure Media Services service.

        Run the MediaWorkflow according to the given mediaWorkflow definition and configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_media_workflow_job = oci.media_services.MediaWorkflowJob("testMediaWorkflowJob",
            compartment_id=var["compartment_id"],
            workflow_identifier_type=var["media_workflow_job_workflow_identifier_type"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["media_workflow_job_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            media_workflow_configuration_ids=var["media_workflow_job_media_workflow_configuration_ids"],
            media_workflow_id=oci_media_services_media_workflow["test_media_workflow"]["id"],
            media_workflow_name=oci_media_services_media_workflow["test_media_workflow"]["name"],
            parameters=var["media_workflow_job_parameters"])
        ```

        ## Import

        MediaWorkflowJobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:MediaServices/mediaWorkflowJob:MediaWorkflowJob test_media_workflow_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) ID of the compartment in which the job should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_workflow_configuration_ids: Configurations to be applied to this run of the workflow.
        :param pulumi.Input[str] media_workflow_id: OCID of the MediaWorkflow that should be run.
        :param pulumi.Input[str] media_workflow_name: Name of the system MediaWorkflow that should be run.
        :param pulumi.Input[str] parameters: Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON. The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        :param pulumi.Input[str] workflow_identifier_type: Discriminate identification of a workflow by name versus a workflow by ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MediaWorkflowJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Media Workflow Job resource in Oracle Cloud Infrastructure Media Services service.

        Run the MediaWorkflow according to the given mediaWorkflow definition and configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_media_workflow_job = oci.media_services.MediaWorkflowJob("testMediaWorkflowJob",
            compartment_id=var["compartment_id"],
            workflow_identifier_type=var["media_workflow_job_workflow_identifier_type"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["media_workflow_job_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            media_workflow_configuration_ids=var["media_workflow_job_media_workflow_configuration_ids"],
            media_workflow_id=oci_media_services_media_workflow["test_media_workflow"]["id"],
            media_workflow_name=oci_media_services_media_workflow["test_media_workflow"]["name"],
            parameters=var["media_workflow_job_parameters"])
        ```

        ## Import

        MediaWorkflowJobs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:MediaServices/mediaWorkflowJob:MediaWorkflowJob test_media_workflow_job "id"
        ```

        :param str resource_name: The name of the resource.
        :param MediaWorkflowJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MediaWorkflowJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 media_workflow_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 media_workflow_id: Optional[pulumi.Input[str]] = None,
                 media_workflow_name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 workflow_identifier_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MediaWorkflowJobArgs.__new__(MediaWorkflowJobArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["media_workflow_configuration_ids"] = media_workflow_configuration_ids
            __props__.__dict__["media_workflow_id"] = media_workflow_id
            __props__.__dict__["media_workflow_name"] = media_workflow_name
            __props__.__dict__["parameters"] = parameters
            if workflow_identifier_type is None and not opts.urn:
                raise TypeError("Missing required property 'workflow_identifier_type'")
            __props__.__dict__["workflow_identifier_type"] = workflow_identifier_type
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["outputs"] = None
            __props__.__dict__["runnable"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["task_lifecycle_states"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["time_updated"] = None
        super(MediaWorkflowJob, __self__).__init__(
            'oci:MediaServices/mediaWorkflowJob:MediaWorkflowJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            media_workflow_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            media_workflow_id: Optional[pulumi.Input[str]] = None,
            media_workflow_name: Optional[pulumi.Input[str]] = None,
            outputs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MediaWorkflowJobOutputArgs']]]]] = None,
            parameters: Optional[pulumi.Input[str]] = None,
            runnable: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            task_lifecycle_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MediaWorkflowJobTaskLifecycleStateArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_ended: Optional[pulumi.Input[str]] = None,
            time_started: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            workflow_identifier_type: Optional[pulumi.Input[str]] = None) -> 'MediaWorkflowJob':
        """
        Get an existing MediaWorkflowJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) ID of the compartment in which the job should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: The lifecycle details of MediaWorkflowJob task.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_workflow_configuration_ids: Configurations to be applied to this run of the workflow.
        :param pulumi.Input[str] media_workflow_id: OCID of the MediaWorkflow that should be run.
        :param pulumi.Input[str] media_workflow_name: Name of the system MediaWorkflow that should be run.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MediaWorkflowJobOutputArgs']]]] outputs: A list of JobOutput for the workflowJob.
        :param pulumi.Input[str] parameters: Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON. The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        :param pulumi.Input[str] runnable: A JSON representation of the job as it will be run by the system. All the task declarations, configurations and parameters are merged. Parameter values are all fully resolved.
        :param pulumi.Input[str] state: The current state of the MediaWorkflowJob task.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MediaWorkflowJobTaskLifecycleStateArgs']]]] task_lifecycle_states: Status of each task.
        :param pulumi.Input[str] time_created: Creation time of the job. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_ended: Time when the job finished. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_started: Time when the job started to execute. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: Updated time of the job. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] workflow_identifier_type: Discriminate identification of a workflow by name versus a workflow by ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MediaWorkflowJobState.__new__(_MediaWorkflowJobState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["media_workflow_configuration_ids"] = media_workflow_configuration_ids
        __props__.__dict__["media_workflow_id"] = media_workflow_id
        __props__.__dict__["media_workflow_name"] = media_workflow_name
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["runnable"] = runnable
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["task_lifecycle_states"] = task_lifecycle_states
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["workflow_identifier_type"] = workflow_identifier_type
        return MediaWorkflowJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) ID of the compartment in which the job should be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        The lifecycle details of MediaWorkflowJob task.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="mediaWorkflowConfigurationIds")
    def media_workflow_configuration_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Configurations to be applied to this run of the workflow.
        """
        return pulumi.get(self, "media_workflow_configuration_ids")

    @property
    @pulumi.getter(name="mediaWorkflowId")
    def media_workflow_id(self) -> pulumi.Output[str]:
        """
        OCID of the MediaWorkflow that should be run.
        """
        return pulumi.get(self, "media_workflow_id")

    @property
    @pulumi.getter(name="mediaWorkflowName")
    def media_workflow_name(self) -> pulumi.Output[str]:
        """
        Name of the system MediaWorkflow that should be run.
        """
        return pulumi.get(self, "media_workflow_name")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Sequence['outputs.MediaWorkflowJobOutput']]:
        """
        A list of JobOutput for the workflowJob.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[str]:
        """
        Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON. The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def runnable(self) -> pulumi.Output[str]:
        """
        A JSON representation of the job as it will be run by the system. All the task declarations, configurations and parameters are merged. Parameter values are all fully resolved.
        """
        return pulumi.get(self, "runnable")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the MediaWorkflowJob task.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="taskLifecycleStates")
    def task_lifecycle_states(self) -> pulumi.Output[Sequence['outputs.MediaWorkflowJobTaskLifecycleState']]:
        """
        Status of each task.
        """
        return pulumi.get(self, "task_lifecycle_states")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Creation time of the job. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[str]:
        """
        Time when the job finished. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[str]:
        """
        Time when the job started to execute. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Updated time of the job. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="workflowIdentifierType")
    def workflow_identifier_type(self) -> pulumi.Output[str]:
        """
        Discriminate identification of a workflow by name versus a workflow by ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workflow_identifier_type")

