# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSoftwareSourceSoftwarePackageResult',
    'AwaitableGetSoftwareSourceSoftwarePackageResult',
    'get_software_source_software_package',
    'get_software_source_software_package_output',
]

@pulumi.output_type
class GetSoftwareSourceSoftwarePackageResult:
    """
    A collection of values returned by getSoftwareSourceSoftwarePackage.
    """
    def __init__(__self__, architecture=None, checksum=None, checksum_type=None, dependencies=None, description=None, display_name=None, files=None, id=None, is_latest=None, last_modified_date=None, name=None, size_in_bytes=None, software_package_name=None, software_source_id=None, software_sources=None, type=None, version=None):
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if checksum_type and not isinstance(checksum_type, str):
            raise TypeError("Expected argument 'checksum_type' to be a str")
        pulumi.set(__self__, "checksum_type", checksum_type)
        if dependencies and not isinstance(dependencies, list):
            raise TypeError("Expected argument 'dependencies' to be a list")
        pulumi.set(__self__, "dependencies", dependencies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if files and not isinstance(files, list):
            raise TypeError("Expected argument 'files' to be a list")
        pulumi.set(__self__, "files", files)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if last_modified_date and not isinstance(last_modified_date, str):
            raise TypeError("Expected argument 'last_modified_date' to be a str")
        pulumi.set(__self__, "last_modified_date", last_modified_date)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if size_in_bytes and not isinstance(size_in_bytes, str):
            raise TypeError("Expected argument 'size_in_bytes' to be a str")
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if software_package_name and not isinstance(software_package_name, str):
            raise TypeError("Expected argument 'software_package_name' to be a str")
        pulumi.set(__self__, "software_package_name", software_package_name)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if software_sources and not isinstance(software_sources, list):
            raise TypeError("Expected argument 'software_sources' to be a list")
        pulumi.set(__self__, "software_sources", software_sources)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The architecture for which this software was built
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Checksum of the file.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> str:
        """
        Type of the checksum.
        """
        return pulumi.get(self, "checksum_type")

    @property
    @pulumi.getter
    def dependencies(self) -> Sequence['outputs.GetSoftwareSourceSoftwarePackageDependencyResult']:
        """
        List of dependencies for the software package.
        """
        return pulumi.get(self, "dependencies")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Software source description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def files(self) -> Sequence['outputs.GetSoftwareSourceSoftwarePackageFileResult']:
        """
        List of files for the software package.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> bool:
        """
        Indicates whether this package is the latest version.
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> str:
        """
        Date of the last update to the package.
        """
        return pulumi.get(self, "last_modified_date")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for the package. NOTE - This is not an OCID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        """
        Size of the package in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="softwarePackageName")
    def software_package_name(self) -> str:
        return pulumi.get(self, "software_package_name")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> str:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Sequence['outputs.GetSoftwareSourceSoftwarePackageSoftwareSourceResult']:
        """
        List of software sources that provide the software package.
        """
        return pulumi.get(self, "software_sources")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the package.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the package.
        """
        return pulumi.get(self, "version")


class AwaitableGetSoftwareSourceSoftwarePackageResult(GetSoftwareSourceSoftwarePackageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceSoftwarePackageResult(
            architecture=self.architecture,
            checksum=self.checksum,
            checksum_type=self.checksum_type,
            dependencies=self.dependencies,
            description=self.description,
            display_name=self.display_name,
            files=self.files,
            id=self.id,
            is_latest=self.is_latest,
            last_modified_date=self.last_modified_date,
            name=self.name,
            size_in_bytes=self.size_in_bytes,
            software_package_name=self.software_package_name,
            software_source_id=self.software_source_id,
            software_sources=self.software_sources,
            type=self.type,
            version=self.version)


def get_software_source_software_package(software_package_name: Optional[str] = None,
                                         software_source_id: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceSoftwarePackageResult:
    """
    This data source provides details about a specific Software Source Software Package resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified software package.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_software_package = oci.OsManagementHub.get_software_source_software_package(software_package_name=var["software_source_software_package_software_package_name"],
        software_source_id=oci_os_management_hub_software_source["test_software_source"]["id"])
    ```


    :param str software_package_name: The name of the software package.
    :param str software_source_id: The software source OCID.
    """
    __args__ = dict()
    __args__['softwarePackageName'] = software_package_name
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSourceSoftwarePackage:getSoftwareSourceSoftwarePackage', __args__, opts=opts, typ=GetSoftwareSourceSoftwarePackageResult).value

    return AwaitableGetSoftwareSourceSoftwarePackageResult(
        architecture=pulumi.get(__ret__, 'architecture'),
        checksum=pulumi.get(__ret__, 'checksum'),
        checksum_type=pulumi.get(__ret__, 'checksum_type'),
        dependencies=pulumi.get(__ret__, 'dependencies'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        files=pulumi.get(__ret__, 'files'),
        id=pulumi.get(__ret__, 'id'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        last_modified_date=pulumi.get(__ret__, 'last_modified_date'),
        name=pulumi.get(__ret__, 'name'),
        size_in_bytes=pulumi.get(__ret__, 'size_in_bytes'),
        software_package_name=pulumi.get(__ret__, 'software_package_name'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        software_sources=pulumi.get(__ret__, 'software_sources'),
        type=pulumi.get(__ret__, 'type'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_software_source_software_package)
def get_software_source_software_package_output(software_package_name: Optional[pulumi.Input[str]] = None,
                                                software_source_id: Optional[pulumi.Input[str]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSoftwareSourceSoftwarePackageResult]:
    """
    This data source provides details about a specific Software Source Software Package resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified software package.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_software_package = oci.OsManagementHub.get_software_source_software_package(software_package_name=var["software_source_software_package_software_package_name"],
        software_source_id=oci_os_management_hub_software_source["test_software_source"]["id"])
    ```


    :param str software_package_name: The name of the software package.
    :param str software_source_id: The software source OCID.
    """
    ...
