# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetComputeGlobalImageCapabilitySchemaResult',
    'AwaitableGetComputeGlobalImageCapabilitySchemaResult',
    'get_compute_global_image_capability_schema',
    'get_compute_global_image_capability_schema_output',
]

@pulumi.output_type
class GetComputeGlobalImageCapabilitySchemaResult:
    """
    A collection of values returned by getComputeGlobalImageCapabilitySchema.
    """
    def __init__(__self__, compartment_id=None, compute_global_image_capability_schema_id=None, current_version_name=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_global_image_capability_schema_id and not isinstance(compute_global_image_capability_schema_id, str):
            raise TypeError("Expected argument 'compute_global_image_capability_schema_id' to be a str")
        pulumi.set(__self__, "compute_global_image_capability_schema_id", compute_global_image_capability_schema_id)
        if current_version_name and not isinstance(current_version_name, str):
            raise TypeError("Expected argument 'current_version_name' to be a str")
        pulumi.set(__self__, "current_version_name", current_version_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the compute global image capability schema
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeGlobalImageCapabilitySchemaId")
    def compute_global_image_capability_schema_id(self) -> str:
        return pulumi.get(self, "compute_global_image_capability_schema_id")

    @property
    @pulumi.getter(name="currentVersionName")
    def current_version_name(self) -> str:
        """
        The name of the global capabilities version resource that is considered the current version.
        """
        return pulumi.get(self, "current_version_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the compute global image capability schema was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetComputeGlobalImageCapabilitySchemaResult(GetComputeGlobalImageCapabilitySchemaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeGlobalImageCapabilitySchemaResult(
            compartment_id=self.compartment_id,
            compute_global_image_capability_schema_id=self.compute_global_image_capability_schema_id,
            current_version_name=self.current_version_name,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            time_created=self.time_created)


def get_compute_global_image_capability_schema(compute_global_image_capability_schema_id: Optional[str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeGlobalImageCapabilitySchemaResult:
    """
    This data source provides details about a specific Compute Global Image Capability Schema resource in Oracle Cloud Infrastructure Core service.

    Gets the specified Compute Global Image Capability Schema

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_global_image_capability_schema = oci.Core.get_compute_global_image_capability_schema(compute_global_image_capability_schema_id=oci_core_compute_global_image_capability_schema["test_compute_global_image_capability_schema"]["id"])
    ```


    :param str compute_global_image_capability_schema_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute global image capability schema
    """
    __args__ = dict()
    __args__['computeGlobalImageCapabilitySchemaId'] = compute_global_image_capability_schema_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeGlobalImageCapabilitySchema:getComputeGlobalImageCapabilitySchema', __args__, opts=opts, typ=GetComputeGlobalImageCapabilitySchemaResult).value

    return AwaitableGetComputeGlobalImageCapabilitySchemaResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_global_image_capability_schema_id=pulumi.get(__ret__, 'compute_global_image_capability_schema_id'),
        current_version_name=pulumi.get(__ret__, 'current_version_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_compute_global_image_capability_schema)
def get_compute_global_image_capability_schema_output(compute_global_image_capability_schema_id: Optional[pulumi.Input[str]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetComputeGlobalImageCapabilitySchemaResult]:
    """
    This data source provides details about a specific Compute Global Image Capability Schema resource in Oracle Cloud Infrastructure Core service.

    Gets the specified Compute Global Image Capability Schema

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_global_image_capability_schema = oci.Core.get_compute_global_image_capability_schema(compute_global_image_capability_schema_id=oci_core_compute_global_image_capability_schema["test_compute_global_image_capability_schema"]["id"])
    ```


    :param str compute_global_image_capability_schema_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute global image capability schema
    """
    ...
