# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LogAnalyticsEntityArgs', 'LogAnalyticsEntity']

@pulumi.input_type
class LogAnalyticsEntityArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 entity_type_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 cloud_resource_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 timezone_region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LogAnalyticsEntity resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] entity_type_name: Log analytics entity type name.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[str] cloud_resource_id: The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] hostname: (Updatable) The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        :param pulumi.Input[str] management_agent_id: (Updatable) The OCID of the Management Agent.
        :param pulumi.Input[str] name: (Updatable) Log analytics entity name.
        :param pulumi.Input[Mapping[str, Any]] properties: (Updatable) The name/value pairs for parameter values to be used in file patterns specified in log sources.
        :param pulumi.Input[str] source_id: This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        :param pulumi.Input[str] timezone_region: (Updatable) The timezone region of the log analytics entity. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "entity_type_name", entity_type_name)
        pulumi.set(__self__, "namespace", namespace)
        if cloud_resource_id is not None:
            pulumi.set(__self__, "cloud_resource_id", cloud_resource_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if timezone_region is not None:
            pulumi.set(__self__, "timezone_region", timezone_region)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="entityTypeName")
    def entity_type_name(self) -> pulumi.Input[str]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "entity_type_name")

    @entity_type_name.setter
    def entity_type_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_type_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="cloudResourceId")
    def cloud_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        """
        return pulumi.get(self, "cloud_resource_id")

    @cloud_resource_id.setter
    def cloud_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_resource_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Management Agent.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_agent_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Log analytics entity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The name/value pairs for parameter values to be used in file patterns specified in log sources.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="timezoneRegion")
    def timezone_region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The timezone region of the log analytics entity. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone_region")

    @timezone_region.setter
    def timezone_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone_region", value)


@pulumi.input_type
class _LogAnalyticsEntityState:
    def __init__(__self__, *,
                 are_logs_collected: Optional[pulumi.Input[bool]] = None,
                 cloud_resource_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 entity_type_internal_name: Optional[pulumi.Input[str]] = None,
                 entity_type_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 management_agent_compartment_id: Optional[pulumi.Input[str]] = None,
                 management_agent_display_name: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 timezone_region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogAnalyticsEntity resources.
        :param pulumi.Input[bool] are_logs_collected: The Boolean flag to indicate if logs are collected for an entity for log analytics usage.
        :param pulumi.Input[str] cloud_resource_id: The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] entity_type_internal_name: Internal name for the log analytics entity type.
        :param pulumi.Input[str] entity_type_name: Log analytics entity type name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] hostname: (Updatable) The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        :param pulumi.Input[str] lifecycle_details: lifecycleDetails has additional information regarding substeps such as management agent plugin deployment.
        :param pulumi.Input[str] management_agent_compartment_id: Management agent (management-agents resource kind) compartment OCID
        :param pulumi.Input[str] management_agent_display_name: Management agent (management-agents resource kind) display name
        :param pulumi.Input[str] management_agent_id: (Updatable) The OCID of the Management Agent.
        :param pulumi.Input[str] name: (Updatable) Log analytics entity name.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Mapping[str, Any]] properties: (Updatable) The name/value pairs for parameter values to be used in file patterns specified in log sources.
        :param pulumi.Input[str] source_id: This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        :param pulumi.Input[str] state: The current state of the log analytics entity.
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the resource was last updated, in the format defined by RFC3339.
        :param pulumi.Input[str] timezone_region: (Updatable) The timezone region of the log analytics entity. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if are_logs_collected is not None:
            pulumi.set(__self__, "are_logs_collected", are_logs_collected)
        if cloud_resource_id is not None:
            pulumi.set(__self__, "cloud_resource_id", cloud_resource_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if entity_type_internal_name is not None:
            pulumi.set(__self__, "entity_type_internal_name", entity_type_internal_name)
        if entity_type_name is not None:
            pulumi.set(__self__, "entity_type_name", entity_type_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if management_agent_compartment_id is not None:
            pulumi.set(__self__, "management_agent_compartment_id", management_agent_compartment_id)
        if management_agent_display_name is not None:
            pulumi.set(__self__, "management_agent_display_name", management_agent_display_name)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timezone_region is not None:
            pulumi.set(__self__, "timezone_region", timezone_region)

    @property
    @pulumi.getter(name="areLogsCollected")
    def are_logs_collected(self) -> Optional[pulumi.Input[bool]]:
        """
        The Boolean flag to indicate if logs are collected for an entity for log analytics usage.
        """
        return pulumi.get(self, "are_logs_collected")

    @are_logs_collected.setter
    def are_logs_collected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "are_logs_collected", value)

    @property
    @pulumi.getter(name="cloudResourceId")
    def cloud_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        """
        return pulumi.get(self, "cloud_resource_id")

    @cloud_resource_id.setter
    def cloud_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_resource_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="entityTypeInternalName")
    def entity_type_internal_name(self) -> Optional[pulumi.Input[str]]:
        """
        Internal name for the log analytics entity type.
        """
        return pulumi.get(self, "entity_type_internal_name")

    @entity_type_internal_name.setter
    def entity_type_internal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type_internal_name", value)

    @property
    @pulumi.getter(name="entityTypeName")
    def entity_type_name(self) -> Optional[pulumi.Input[str]]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "entity_type_name")

    @entity_type_name.setter
    def entity_type_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        lifecycleDetails has additional information regarding substeps such as management agent plugin deployment.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="managementAgentCompartmentId")
    def management_agent_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Management agent (management-agents resource kind) compartment OCID
        """
        return pulumi.get(self, "management_agent_compartment_id")

    @management_agent_compartment_id.setter
    def management_agent_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_agent_compartment_id", value)

    @property
    @pulumi.getter(name="managementAgentDisplayName")
    def management_agent_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Management agent (management-agents resource kind) display name
        """
        return pulumi.get(self, "management_agent_display_name")

    @management_agent_display_name.setter
    def management_agent_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_agent_display_name", value)

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Management Agent.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_agent_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Log analytics entity name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) The name/value pairs for parameter values to be used in file patterns specified in log sources.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[str]]:
        """
        This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the log analytics entity.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="timezoneRegion")
    def timezone_region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The timezone region of the log analytics entity. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone_region")

    @timezone_region.setter
    def timezone_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone_region", value)


class LogAnalyticsEntity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_resource_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 entity_type_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 timezone_region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Log Analytics Entity resource in Oracle Cloud Infrastructure Log Analytics service.

        Create a new log analytics entity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_entity = oci.log_analytics.LogAnalyticsEntity("testLogAnalyticsEntity",
            compartment_id=var["compartment_id"],
            entity_type_name=var["log_analytics_entity_entity_type_name"],
            namespace=var["log_analytics_entity_namespace"],
            cloud_resource_id=oci_log_analytics_cloud_resource["test_cloud_resource"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            hostname=var["log_analytics_entity_hostname"],
            management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"],
            properties=var["log_analytics_entity_properties"],
            source_id=oci_log_analytics_source["test_source"]["id"],
            timezone_region=var["log_analytics_entity_timezone_region"])
        ```

        ## Import

        LogAnalyticsEntities can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:LogAnalytics/logAnalyticsEntity:LogAnalyticsEntity test_log_analytics_entity "namespaces/{namespaceName}/logAnalyticsEntities/{logAnalyticsEntityId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_resource_id: The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] entity_type_name: Log analytics entity type name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] hostname: (Updatable) The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        :param pulumi.Input[str] management_agent_id: (Updatable) The OCID of the Management Agent.
        :param pulumi.Input[str] name: (Updatable) Log analytics entity name.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Mapping[str, Any]] properties: (Updatable) The name/value pairs for parameter values to be used in file patterns specified in log sources.
        :param pulumi.Input[str] source_id: This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        :param pulumi.Input[str] timezone_region: (Updatable) The timezone region of the log analytics entity. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAnalyticsEntityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Log Analytics Entity resource in Oracle Cloud Infrastructure Log Analytics service.

        Create a new log analytics entity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_entity = oci.log_analytics.LogAnalyticsEntity("testLogAnalyticsEntity",
            compartment_id=var["compartment_id"],
            entity_type_name=var["log_analytics_entity_entity_type_name"],
            namespace=var["log_analytics_entity_namespace"],
            cloud_resource_id=oci_log_analytics_cloud_resource["test_cloud_resource"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            hostname=var["log_analytics_entity_hostname"],
            management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"],
            properties=var["log_analytics_entity_properties"],
            source_id=oci_log_analytics_source["test_source"]["id"],
            timezone_region=var["log_analytics_entity_timezone_region"])
        ```

        ## Import

        LogAnalyticsEntities can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:LogAnalytics/logAnalyticsEntity:LogAnalyticsEntity test_log_analytics_entity "namespaces/{namespaceName}/logAnalyticsEntities/{logAnalyticsEntityId}"
        ```

        :param str resource_name: The name of the resource.
        :param LogAnalyticsEntityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAnalyticsEntityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_resource_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 entity_type_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 source_id: Optional[pulumi.Input[str]] = None,
                 timezone_region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAnalyticsEntityArgs.__new__(LogAnalyticsEntityArgs)

            __props__.__dict__["cloud_resource_id"] = cloud_resource_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if entity_type_name is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type_name'")
            __props__.__dict__["entity_type_name"] = entity_type_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["properties"] = properties
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["timezone_region"] = timezone_region
            __props__.__dict__["are_logs_collected"] = None
            __props__.__dict__["entity_type_internal_name"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["management_agent_compartment_id"] = None
            __props__.__dict__["management_agent_display_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(LogAnalyticsEntity, __self__).__init__(
            'oci:LogAnalytics/logAnalyticsEntity:LogAnalyticsEntity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            are_logs_collected: Optional[pulumi.Input[bool]] = None,
            cloud_resource_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            entity_type_internal_name: Optional[pulumi.Input[str]] = None,
            entity_type_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            management_agent_compartment_id: Optional[pulumi.Input[str]] = None,
            management_agent_display_name: Optional[pulumi.Input[str]] = None,
            management_agent_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            source_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            timezone_region: Optional[pulumi.Input[str]] = None) -> 'LogAnalyticsEntity':
        """
        Get an existing LogAnalyticsEntity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] are_logs_collected: The Boolean flag to indicate if logs are collected for an entity for log analytics usage.
        :param pulumi.Input[str] cloud_resource_id: The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] entity_type_internal_name: Internal name for the log analytics entity type.
        :param pulumi.Input[str] entity_type_name: Log analytics entity type name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] hostname: (Updatable) The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        :param pulumi.Input[str] lifecycle_details: lifecycleDetails has additional information regarding substeps such as management agent plugin deployment.
        :param pulumi.Input[str] management_agent_compartment_id: Management agent (management-agents resource kind) compartment OCID
        :param pulumi.Input[str] management_agent_display_name: Management agent (management-agents resource kind) display name
        :param pulumi.Input[str] management_agent_id: (Updatable) The OCID of the Management Agent.
        :param pulumi.Input[str] name: (Updatable) Log analytics entity name.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Mapping[str, Any]] properties: (Updatable) The name/value pairs for parameter values to be used in file patterns specified in log sources.
        :param pulumi.Input[str] source_id: This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        :param pulumi.Input[str] state: The current state of the log analytics entity.
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the resource was last updated, in the format defined by RFC3339.
        :param pulumi.Input[str] timezone_region: (Updatable) The timezone region of the log analytics entity. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAnalyticsEntityState.__new__(_LogAnalyticsEntityState)

        __props__.__dict__["are_logs_collected"] = are_logs_collected
        __props__.__dict__["cloud_resource_id"] = cloud_resource_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["entity_type_internal_name"] = entity_type_internal_name
        __props__.__dict__["entity_type_name"] = entity_type_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["management_agent_compartment_id"] = management_agent_compartment_id
        __props__.__dict__["management_agent_display_name"] = management_agent_display_name
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["properties"] = properties
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timezone_region"] = timezone_region
        return LogAnalyticsEntity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="areLogsCollected")
    def are_logs_collected(self) -> pulumi.Output[bool]:
        """
        The Boolean flag to indicate if logs are collected for an entity for log analytics usage.
        """
        return pulumi.get(self, "are_logs_collected")

    @property
    @pulumi.getter(name="cloudResourceId")
    def cloud_resource_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        """
        return pulumi.get(self, "cloud_resource_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="entityTypeInternalName")
    def entity_type_internal_name(self) -> pulumi.Output[str]:
        """
        Internal name for the log analytics entity type.
        """
        return pulumi.get(self, "entity_type_internal_name")

    @property
    @pulumi.getter(name="entityTypeName")
    def entity_type_name(self) -> pulumi.Output[str]:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "entity_type_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        (Updatable) The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        lifecycleDetails has additional information regarding substeps such as management agent plugin deployment.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managementAgentCompartmentId")
    def management_agent_compartment_id(self) -> pulumi.Output[str]:
        """
        Management agent (management-agents resource kind) compartment OCID
        """
        return pulumi.get(self, "management_agent_compartment_id")

    @property
    @pulumi.getter(name="managementAgentDisplayName")
    def management_agent_display_name(self) -> pulumi.Output[str]:
        """
        Management agent (management-agents resource kind) display name
        """
        return pulumi.get(self, "management_agent_display_name")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Management Agent.
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) Log analytics entity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) The name/value pairs for parameter values to be used in file patterns specified in log sources.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[str]:
        """
        This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the log analytics entity.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timezoneRegion")
    def timezone_region(self) -> pulumi.Output[str]:
        """
        (Updatable) The timezone region of the log analytics entity. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone_region")

