# coding: utf-8

"""
    DotAAS Part 2 | HTTP/REST | Entire API Collection

    All APIs of the Specification of the [Specification of the Asset Administration Shell: Part 2](http://industrialdigitaltwin.org/en/content-hub) in one collection. Please not that this API is not intended to generate productive code but only for overview purposes.   Publisher: Industrial Digital Twin Association (IDTA) 2023\"  # noqa: E501

    OpenAPI spec version: V3.0.1
    Contact: info@idtwin.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from aas_python_http_client.api_client import ApiClient


class SubmodelRepositoryAPIApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_file_by_path_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_by_path_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def delete_file_by_path_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes file content of an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `delete_file_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `delete_file_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_submodel_by_id(self, submodel_identifier, **kwargs):  # noqa: E501
        """Deletes a Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_by_id(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_submodel_by_id_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_submodel_by_id_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def delete_submodel_by_id_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Deletes a Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_by_id_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_submodel_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `delete_submodel_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_submodel_element_by_path_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes a submodel element at a specified path within the submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_element_by_path_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_submodel_element_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_submodel_element_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def delete_submodel_element_by_path_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Deletes a submodel element at a specified path within the submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submodel_element_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_submodel_element_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `delete_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `delete_submodel_element_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_metadata_submodel_repository(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the metadata attributes of all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_metadata_submodel_repository(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelElementsMetadataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_metadata_submodel_repository_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_metadata_submodel_repository_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_metadata_submodel_repository_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the metadata attributes of all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_metadata_submodel_repository_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelElementsMetadataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_metadata_submodel_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_metadata_submodel_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/$metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelElementsMetadataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_path_submodel_repo(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_path_submodel_repo(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetPathItemsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_path_submodel_repo_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_path_submodel_repo_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_path_submodel_repo_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_path_submodel_repo_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetPathItemsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/$path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetPathItemsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_reference_submodel_repo(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the References of all submodel elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_reference_submodel_repo(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_reference_submodel_repo_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_reference_submodel_repo_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_reference_submodel_repo_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the References of all submodel elements  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_reference_submodel_repo_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_reference_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_reference_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReferencesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_submodel_repository(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_submodel_repository(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelElementsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_submodel_repository_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_submodel_repository_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_submodel_repository_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_submodel_repository_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelElementsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'limit', 'cursor', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_submodel_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_submodel_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelElementsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodel_elements_value_only_submodel_repo(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_value_only_submodel_repo(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelElementsValueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodel_elements_value_only_submodel_repo_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodel_elements_value_only_submodel_repo_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_all_submodel_elements_value_only_submodel_repo_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns all submodel elements including their hierarchy in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodel_elements_value_only_submodel_repo_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelElementsValueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'limit', 'cursor', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodel_elements_value_only_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_all_submodel_elements_value_only_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelElementsValueResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodels(self, **kwargs):  # noqa: E501
        """Returns all Submodels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodels_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodels_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_submodels_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all Submodels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['semantic_id', 'id_short', 'limit', 'cursor', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodels" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'semantic_id' in params:
            query_params.append(('semanticId', params['semantic_id']))  # noqa: E501
        if 'id_short' in params:
            query_params.append(('idShort', params['id_short']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodels_metadata(self, **kwargs):  # noqa: E501
        """Returns the metadata attributes of all Submodels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_metadata(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelsMetadataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodels_metadata_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodels_metadata_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_submodels_metadata_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the metadata attributes of all Submodels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_metadata_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetSubmodelsMetadataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['semantic_id', 'id_short', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodels_metadata" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'semantic_id' in params:
            query_params.append(('semanticId', params['semantic_id']))  # noqa: E501
        if 'id_short' in params:
            query_params.append(('idShort', params['id_short']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/$metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelsMetadataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodels_path(self, **kwargs):  # noqa: E501
        """Returns all Submodels in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_path(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetPathItemsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodels_path_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodels_path_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_submodels_path_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all Submodels in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_path_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetPathItemsResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['semantic_id', 'id_short', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodels_path" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'semantic_id' in params:
            query_params.append(('semanticId', params['semantic_id']))  # noqa: E501
        if 'id_short' in params:
            query_params.append(('idShort', params['id_short']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/$path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetPathItemsResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodels_reference(self, **kwargs):  # noqa: E501
        """Returns the References for all Submodels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_reference(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodels_reference_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodels_reference_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_submodels_reference_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the References for all Submodels  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_reference_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :return: GetReferencesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['semantic_id', 'id_short', 'limit', 'cursor', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodels_reference" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'semantic_id' in params:
            query_params.append(('semanticId', params['semantic_id']))  # noqa: E501
        if 'id_short' in params:
            query_params.append(('idShort', params['id_short']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetReferencesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_submodels_value_only(self, **kwargs):  # noqa: E501
        """Returns all Submodels in their ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_value_only(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelsValueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_submodels_value_only_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_submodels_value_only_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_submodels_value_only_with_http_info(self, **kwargs):  # noqa: E501
        """Returns all Submodels in their ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_submodels_value_only_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str semantic_id: The value of the semantic id reference (BASE64-URL-encoded)
        :param str id_short: The Asset Administration Shell’s IdShort
        :param int limit: The maximum number of elements in the response array
        :param str cursor: A server-generated identifier retrieved from pagingMetadata that specifies from which position the result listing should continue
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: GetSubmodelsValueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['semantic_id', 'id_short', 'limit', 'cursor', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_submodels_value_only" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'semantic_id' in params:
            query_params.append(('semanticId', params['semantic_id']))  # noqa: E501
        if 'id_short' in params:
            query_params.append(('idShort', params['id_short']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSubmodelsValueResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_by_path_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Downloads file content from a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_by_path_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_file_by_path_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Downloads file content from a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_file_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_file_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_operation_async_result_submodel_repo(self, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_submodel_repo(submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_operation_async_result_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_operation_async_result_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
            return data

    def get_operation_async_result_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'handle_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_operation_async_result_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_operation_async_result_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_operation_async_result_submodel_repo`")  # noqa: E501
        # verify the required parameter 'handle_id' is set
        if ('handle_id' not in params or
                params['handle_id'] is None):
            raise ValueError("Missing the required parameter `handle_id` when calling `get_operation_async_result_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501
        if 'handle_id' in params:
            path_params['handleId'] = params['handle_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_operation_async_result_value_only_submodel_repo(self, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_value_only_submodel_repo(submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_operation_async_result_value_only_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_operation_async_result_value_only_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
            return data

    def get_operation_async_result_value_only_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation result of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_result_value_only_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'handle_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_operation_async_result_value_only_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_operation_async_result_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_operation_async_result_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'handle_id' is set
        if ('handle_id' not in params or
                params['handle_id'] is None):
            raise ValueError("Missing the required parameter `handle_id` when calling `get_operation_async_result_value_only_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501
        if 'handle_id' in params:
            path_params['handleId'] = params['handle_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-results/{handleId}/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResultValueOnly',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_operation_async_status_submodel_repo(self, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation status of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_status_submodel_repo(submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_operation_async_status_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_operation_async_status_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, **kwargs)  # noqa: E501
            return data

    def get_operation_async_status_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, handle_id, **kwargs):  # noqa: E501
        """Returns the Operation status of an asynchronous invoked Operation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_operation_async_status_submodel_repo_with_http_info(submodel_identifier, id_short_path, handle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str handle_id: The returned handle id of an operation’s asynchronous invocation used to request the current state of the operation’s execution (UTF8-BASE64-URL-encoded) (required)
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'handle_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_operation_async_status_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_operation_async_status_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_operation_async_status_submodel_repo`")  # noqa: E501
        # verify the required parameter 'handle_id' is set
        if ('handle_id' not in params or
                params['handle_id'] is None):
            raise ValueError("Missing the required parameter `handle_id` when calling `get_operation_async_status_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501
        if 'handle_id' in params:
            path_params['handleId'] = params['handle_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/operation-status/{handleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns a specific Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: Submodel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns a specific Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: Submodel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Submodel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_metadata(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the metadata attributes of a specific Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_metadata(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_metadata_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_metadata_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_metadata_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the metadata attributes of a specific Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_metadata_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/$metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_path(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns a specific Submodel in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_path(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: list[PathItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_path_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_path_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_path_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns a specific Submodel in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_path_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: list[PathItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/$path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PathItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_reference(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Reference of a specific Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_reference(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_reference_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_reference_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_reference_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns the Reference of a specific Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_reference_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_reference" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_reference`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Reference',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_by_id_value_only(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns a specific Submodel in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_value_only(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_by_id_value_only_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_by_id_value_only_with_http_info(submodel_identifier, **kwargs)  # noqa: E501
            return data

    def get_submodel_by_id_value_only_with_http_info(self, submodel_identifier, **kwargs):  # noqa: E501
        """Returns a specific Submodel in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_by_id_value_only_with_http_info(submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_by_id_value_only" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_by_id_value_only`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_metadata_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the matadata attributes of a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_metadata_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelElementMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_metadata_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_metadata_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_metadata_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the matadata attributes of a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_metadata_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: SubmodelElementMetadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_metadata_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_metadata_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_metadata_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElementMetadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_path_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_path_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: list[PathItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_path_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the Path notation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: list[PathItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$path', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PathItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_reference_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the Referene of a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_reference_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_reference_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_reference_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_reference_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns the Referene of a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_reference_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: Reference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_reference_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_reference_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_reference_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$reference', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Reference',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submodel_element_by_path_value_only_submodel_repo(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_value_only_submodel_repo(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElementValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submodel_element_by_path_value_only_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submodel_element_by_path_value_only_submodel_repo_with_http_info(submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def get_submodel_element_by_path_value_only_submodel_repo_with_http_info(self, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Returns a specific submodel element from the Submodel at a specified path in the ValueOnly representation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submodel_element_by_path_value_only_submodel_repo_with_http_info(submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :param str extent: Determines to which extent the resource is being serialized
        :return: SubmodelElementValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['submodel_identifier', 'id_short_path', 'level', 'extent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submodel_element_by_path_value_only_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `get_submodel_element_by_path_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `get_submodel_element_by_path_value_only_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'extent' in params:
            query_params.append(('extent', params['extent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElementValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_async_submodel_repo(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_submodel_repo(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_async_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_async_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_async_submodel_repo_with_http_info(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_async_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_async_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_async_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_async_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_async_value_only_submodel_repo(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_value_only_submodel_repo(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_async_value_only_submodel_repo_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_async_value_only_submodel_repo_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_async_value_only_submodel_repo_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Asynchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_async_value_only_submodel_repo_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_async_value_only_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_async_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `invoke_operation_async_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_async_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_async_value_only_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke-async/$value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_submodel_repo(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_submodel_repo(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param bool _async: Determines whether an operation invocation is performed asynchronously or synchronously
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_submodel_repo_with_http_info(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequest body: Operation request object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param bool _async: Determines whether an operation invocation is performed asynchronously or synchronously
        :return: OperationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'id_short_path', '_async']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if '_async' in params:
            query_params.append(('async', params['_async']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def invoke_operation_value_only_submodel_repo(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_value_only_submodel_repo(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param bool _async: Determines whether an operation invocation is performed asynchronously or synchronously
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.invoke_operation_value_only_submodel_repo_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.invoke_operation_value_only_submodel_repo_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def invoke_operation_value_only_submodel_repo_with_http_info(self, body, aas_identifier, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Synchronously invokes an Operation at a specified path  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invoke_operation_value_only_submodel_repo_with_http_info(body, aas_identifier, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OperationRequestValueOnly body: Operation request object (required)
        :param str aas_identifier: The Asset Administration Shell’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param bool _async: Determines whether an operation invocation is performed asynchronously or synchronously
        :return: OperationResultValueOnly
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'aas_identifier', 'submodel_identifier', 'id_short_path', '_async']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_operation_value_only_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `invoke_operation_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'aas_identifier' is set
        if ('aas_identifier' not in params or
                params['aas_identifier'] is None):
            raise ValueError("Missing the required parameter `aas_identifier` when calling `invoke_operation_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `invoke_operation_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `invoke_operation_value_only_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'aas_identifier' in params:
            path_params['aasIdentifier'] = params['aas_identifier']  # noqa: E501
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if '_async' in params:
            query_params.append(('async', params['_async']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/invoke/$value', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperationResultValueOnly',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_by_id(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_by_id_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_by_id_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def patch_submodel_by_id_with_http_info(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_with_http_info(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_by_id`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_by_id_metadata(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the metadata attributes of an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_metadata(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelMetadata body: The metadata attributes of the Submodel object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_by_id_metadata_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_by_id_metadata_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def patch_submodel_by_id_metadata_with_http_info(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the metadata attributes of an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_metadata_with_http_info(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelMetadata body: The metadata attributes of the Submodel object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_by_id_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_by_id_metadata`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_by_id_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/$metadata', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_by_id_value_only(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the values of an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_value_only(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelValue body: Submodel object in its ValueOnly representation (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_by_id_value_only_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_by_id_value_only_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def patch_submodel_by_id_value_only_with_http_info(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates the values of an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_by_id_value_only_with_http_info(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelValue body: Submodel object in its ValueOnly representation (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_by_id_value_only" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_by_id_value_only`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_by_id_value_only`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/$value', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_element_by_path_metadata_submodel_repo(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the metadata attributes an existing SubmodelElement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_by_path_metadata_submodel_repo(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementMetadata body: Metadata attributes of the SubmodelElement (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_element_by_path_metadata_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_element_by_path_metadata_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def patch_submodel_element_by_path_metadata_submodel_repo_with_http_info(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the metadata attributes an existing SubmodelElement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_by_path_metadata_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementMetadata body: Metadata attributes of the SubmodelElement (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_element_by_path_metadata_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_element_by_path_metadata_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_element_by_path_metadata_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `patch_submodel_element_by_path_metadata_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$metadata', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_element_by_path_submodel_repo(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing SubmodelElement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_by_path_submodel_repo(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: SubmodelElement object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def patch_submodel_element_by_path_submodel_repo_with_http_info(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing SubmodelElement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: SubmodelElement object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_element_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `patch_submodel_element_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_submodel_element_by_path_value_only_submodel_repo(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the value of an existing SubmodelElement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_by_path_value_only_submodel_repo(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementValue body: The SubmodelElement in its ValueOnly representation (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_submodel_element_by_path_value_only_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_submodel_element_by_path_value_only_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def patch_submodel_element_by_path_value_only_submodel_repo_with_http_info(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates the value of an existing SubmodelElement  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_submodel_element_by_path_value_only_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElementValue body: The SubmodelElement in its ValueOnly representation (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_submodel_element_by_path_value_only_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_submodel_element_by_path_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `patch_submodel_element_by_path_value_only_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `patch_submodel_element_by_path_value_only_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/$value', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submodel(self, body, **kwargs):  # noqa: E501
        """Creates a new Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :return: Submodel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_submodel_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_submodel_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_submodel_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :return: Submodel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submodel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_submodel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Submodel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submodel_element_by_path_submodel_repo(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Creates a new submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_by_path_submodel_repo(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.post_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def post_submodel_element_by_path_submodel_repo_with_http_info(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Creates a new submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submodel_element_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `post_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `post_submodel_element_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submodel_element_submodel_repository(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Creates a new submodel element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_submodel_repository(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_submodel_element_submodel_repository_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.post_submodel_element_submodel_repository_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def post_submodel_element_submodel_repository_with_http_info(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Creates a new submodel element  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submodel_element_submodel_repository_with_http_info(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: SubmodelElement
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submodel_element_submodel_repository" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_submodel_element_submodel_repository`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `post_submodel_element_submodel_repository`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubmodelElement',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_file_by_path_submodel_repo(self, file_name, file, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_file_by_path_submodel_repo(file_name, file, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: (required)
        :param str file: (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_file_by_path_submodel_repo_with_http_info(file_name, file, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.put_file_by_path_submodel_repo_with_http_info(file_name, file, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def put_file_by_path_submodel_repo_with_http_info(self, file_name, file, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Uploads file content to an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_file_by_path_submodel_repo_with_http_info(file_name, file, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: (required)
        :param str file: (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_name', 'file', 'submodel_identifier', 'id_short_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_file_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `put_file_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `put_file_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `put_file_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `put_file_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file_name' in params:
            form_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}/attachment', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_submodel_by_id(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_by_id(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_submodel_by_id_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_submodel_by_id_with_http_info(body, submodel_identifier, **kwargs)  # noqa: E501
            return data

    def put_submodel_by_id_with_http_info(self, body, submodel_identifier, **kwargs):  # noqa: E501
        """Updates an existing Submodel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_by_id_with_http_info(body, submodel_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Submodel body: Submodel object (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_submodel_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_submodel_by_id`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `put_submodel_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_submodel_element_by_path_submodel_repo(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_element_by_path_submodel_repo(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
        else:
            (data) = self.put_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, **kwargs)  # noqa: E501
            return data

    def put_submodel_element_by_path_submodel_repo_with_http_info(self, body, submodel_identifier, id_short_path, **kwargs):  # noqa: E501
        """Updates an existing submodel element at a specified path within submodel elements hierarchy  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_submodel_element_by_path_submodel_repo_with_http_info(body, submodel_identifier, id_short_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubmodelElement body: Requested submodel element (required)
        :param str submodel_identifier: The Submodel’s unique id (UTF8-BASE64-URL-encoded) (required)
        :param str id_short_path: IdShort path to the submodel element (dot-separated) (required)
        :param str level: Determines the structural depth of the respective resource content
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'submodel_identifier', 'id_short_path', 'level']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_submodel_element_by_path_submodel_repo" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'submodel_identifier' is set
        if ('submodel_identifier' not in params or
                params['submodel_identifier'] is None):
            raise ValueError("Missing the required parameter `submodel_identifier` when calling `put_submodel_element_by_path_submodel_repo`")  # noqa: E501
        # verify the required parameter 'id_short_path' is set
        if ('id_short_path' not in params or
                params['id_short_path'] is None):
            raise ValueError("Missing the required parameter `id_short_path` when calling `put_submodel_element_by_path_submodel_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'submodel_identifier' in params:
            path_params['submodelIdentifier'] = params['submodel_identifier']  # noqa: E501
        if 'id_short_path' in params:
            path_params['idShortPath'] = params['id_short_path']  # noqa: E501

        query_params = []
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/submodels/{submodelIdentifier}/submodel-elements/{idShortPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
