import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [application-autoscaling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationautoscaling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ApplicationAutoscaling extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to delete a scaling policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScalingPolicy.html
     */
    toDeleteScalingPolicy(): this;
    /**
     * Grants permission to delete a scheduled action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScheduledAction.html
     */
    toDeleteScheduledAction(): this;
    /**
     * Grants permission to deregister a scalable target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html
     */
    toDeregisterScalableTarget(): this;
    /**
     * Grants permission to describe one or more scalable targets in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html
     */
    toDescribeScalableTargets(): this;
    /**
     * Grants permission to describe a set of scaling activities or all scaling activities in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingActivities.html
     */
    toDescribeScalingActivities(): this;
    /**
     * Grants permission to describe a set of scaling policies or all scaling policies in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingPolicies.html
     */
    toDescribeScalingPolicies(): this;
    /**
     * Grants permission to describe a set of scheduled actions or all scheduled actions in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScheduledActions.html
     */
    toDescribeScheduledActions(): this;
    /**
     * Grants permission to create and update a scaling policy for a scalable target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html
     */
    toPutScalingPolicy(): this;
    /**
     * Grants permission to create and update a scheduled action for a scalable target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html
     */
    toPutScheduledAction(): this;
    /**
     * Grants permission to register AWS or custom resources as scalable targets with Application Auto Scaling and to update configuration parameters used to manage a scalable target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html
     */
    toRegisterScalableTarget(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [application-autoscaling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationautoscaling.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
