"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Billingconductor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [billingconductor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingconductor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Billingconductor extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [billingconductor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingconductor.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'billingconductor';
        this.accessLevelList = {
            Write: [
                'AssociateAccounts',
                'AssociatePricingRules',
                'BatchAssociateResourcesToCustomLineItem',
                'BatchDisassociateResourcesFromCustomLineItem',
                'CreateBillingGroup',
                'CreateCustomLineItem',
                'CreatePricingPlan',
                'CreatePricingRule',
                'DeleteBillingGroup',
                'DeleteCustomLineItem',
                'DeletePricingPlan',
                'DeletePricingRule',
                'DisassociateAccounts',
                'DisassociatePricingRules',
                'UpdateBillingGroup',
                'UpdateCustomLineItem',
                'UpdatePricingPlan',
                'UpdatePricingRule'
            ],
            List: [
                'ListAccountAssociations',
                'ListPricingPlansAssociatedWithPricingRule',
                'ListPricingRulesAssociatedToPricingPlan',
                'ListResourcesAssociatedToCustomLineItem'
            ],
            Read: [
                'ListBillingGroupCostReports',
                'ListBillingGroups',
                'ListCustomLineItems',
                'ListPricingPlans',
                'ListPricingRules',
                'ListTagsResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate between one and 30 accounts to a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_AssociateAccounts.html
     */
    toAssociateAccounts() {
        return this.to('AssociateAccounts');
    }
    /**
     * Grants permission to associate pricing rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_AssociatePricingRules.html
     */
    toAssociatePricingRules() {
        return this.to('AssociatePricingRules');
    }
    /**
     * Grants permission to batch associate resources to a percentage custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_BatchAssociateResourcesToCustomLineItem.html
     */
    toBatchAssociateResourcesToCustomLineItem() {
        return this.to('BatchAssociateResourcesToCustomLineItem');
    }
    /**
     * Grants permission to batch disassociate resources from a percentage custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_BatchDisassociateResourcesFromCustomLineItem.html
     */
    toBatchDisassociateResourcesFromCustomLineItem() {
        return this.to('BatchDisassociateResourcesFromCustomLineItem');
    }
    /**
     * Grants permission to create a billing group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreateBillingGroup.html
     */
    toCreateBillingGroup() {
        return this.to('CreateBillingGroup');
    }
    /**
     * Grants permission to create a custom line item
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreateCustomLineItem.html
     */
    toCreateCustomLineItem() {
        return this.to('CreateCustomLineItem');
    }
    /**
     * Grants permission to create a pricing plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreatePricingPlan.html
     */
    toCreatePricingPlan() {
        return this.to('CreatePricingPlan');
    }
    /**
     * Grants permission to create a pricing rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_CreatePricingRule.html
     */
    toCreatePricingRule() {
        return this.to('CreatePricingRule');
    }
    /**
     * Grants permission to delete a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeleteBillingGroup.html
     */
    toDeleteBillingGroup() {
        return this.to('DeleteBillingGroup');
    }
    /**
     * Grants permission to delete a custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeleteCustomLineItem.html
     */
    toDeleteCustomLineItem() {
        return this.to('DeleteCustomLineItem');
    }
    /**
     * Grants permission to delete a pricing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeletePricingPlan.html
     */
    toDeletePricingPlan() {
        return this.to('DeletePricingPlan');
    }
    /**
     * Grants permission to delete a pricing rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DeletePricingRule.html
     */
    toDeletePricingRule() {
        return this.to('DeletePricingRule');
    }
    /**
     * Grants permission to detach between one and 30 accounts from a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DisassociateAccounts.html
     */
    toDisassociateAccounts() {
        return this.to('DisassociateAccounts');
    }
    /**
     * Grants permission to disassociate pricing rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_DisassociatePricingRules.html
     */
    toDisassociatePricingRules() {
        return this.to('DisassociatePricingRules');
    }
    /**
     * Grants permission to list the linked accounts of the payer account for the given billing period while also providing the billing group the linked accounts belong to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListAccountAssociations.html
     */
    toListAccountAssociations() {
        return this.to('ListAccountAssociations');
    }
    /**
     * Grants permission to view the billing group cost report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListBillingGroupCostReports.html
     */
    toListBillingGroupCostReports() {
        return this.to('ListBillingGroupCostReports');
    }
    /**
     * Grants permission to view the details of billing groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListBillingGroups.html
     */
    toListBillingGroups() {
        return this.to('ListBillingGroups');
    }
    /**
     * Grants permission to view custom line item details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListCustomLineItems.html
     */
    toListCustomLineItems() {
        return this.to('ListCustomLineItems');
    }
    /**
     * Grants permission to view the pricing plans details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingPlans.html
     */
    toListPricingPlans() {
        return this.to('ListPricingPlans');
    }
    /**
     * Grants permission to list pricing plans associated with a pricing rule
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingPlansAssociatedWithPricingRule.html
     */
    toListPricingPlansAssociatedWithPricingRule() {
        return this.to('ListPricingPlansAssociatedWithPricingRule');
    }
    /**
     * Grants permission to view pricing rules details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingRules.html
     */
    toListPricingRules() {
        return this.to('ListPricingRules');
    }
    /**
     * Grants permission to list pricing rules associated to a pricing plan
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListPricingRulesAssociatedToPricingPlan.html
     */
    toListPricingRulesAssociatedToPricingPlan() {
        return this.to('ListPricingRulesAssociatedToPricingPlan');
    }
    /**
     * Grants permission to list resources associated to a percentage custom line item
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListResourcesAssociatedToCustomLineItem.html
     */
    toListResourcesAssociatedToCustomLineItem() {
        return this.to('ListResourcesAssociatedToCustomLineItem');
    }
    /**
     * Grants permission to list tags of a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsResource() {
        return this.to('ListTagsResource');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a billing group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdateBillingGroup.html
     */
    toUpdateBillingGroup() {
        return this.to('UpdateBillingGroup');
    }
    /**
     * Grants permission to update a custom line item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdateCustomLineItem.html
     */
    toUpdateCustomLineItem() {
        return this.to('UpdateCustomLineItem');
    }
    /**
     * Grants permission to update a pricing plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdatePricingPlan.html
     */
    toUpdatePricingPlan() {
        return this.to('UpdatePricingPlan');
    }
    /**
     * Grants permission to update a pricing rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/billingconductor/latest/APIReference/API_UpdatePricingRule.html
     */
    toUpdatePricingRule() {
        return this.to('UpdatePricingRule');
    }
    /**
     * Adds a resource of type billingGroup to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBillingGroup(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:billinggroup/${resourceId}`);
    }
    /**
     * Adds a resource of type pricingPlan to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPricingPlan(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:pricingplan/${resourceId}`);
    }
    /**
     * Adds a resource of type pricingRule to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPricingRule(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:pricingrule/${resourceId}`);
    }
    /**
     * Adds a resource of type customLineItem to the statement
     *
     * https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomLineItem(resourceId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:billingconductor::${account || '*'}:customlineitem/${resourceId}`);
    }
}
exports.Billingconductor = Billingconductor;
_a = JSII_RTTI_SYMBOL_1;
Billingconductor[_a] = { fqn: "cdk-iam-floyd.Billingconductor", version: "0.343.0" };
//# sourceMappingURL=data:application/json;base64,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