"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplace extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplace.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Write: [
                'AcceptAgreementApprovalRequest',
                'CancelAgreementRequest',
                'RejectAgreementApprovalRequest',
                'Subscribe',
                'Unsubscribe',
                'UpdateAgreementApprovalRequest'
            ],
            Read: [
                'DescribeAgreement',
                'GetAgreementApprovalRequest',
                'GetAgreementRequest'
            ],
            List: [
                'GetAgreementTerms',
                'ListAgreementApprovalRequests',
                'ListAgreementRequests',
                'SearchAgreements',
                'ViewSubscriptions'
            ]
        };
    }
    /**
     * Grants permission to users to approve an incoming subscription request (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toAcceptAgreementApprovalRequest() {
        return this.to('AcceptAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to cancel pending subscription requests for products that require subscription verification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toCancelAgreementRequest() {
        return this.to('CancelAgreementRequest');
    }
    /**
     * Grants permission to users to describe the metadata about the agreement
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toDescribeAgreement() {
        return this.to('DescribeAgreement');
    }
    /**
     * Grants permission to users to view the details of their incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toGetAgreementApprovalRequest() {
        return this.to('GetAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to view the details of their subscription requests for data products that require subscription verification
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toGetAgreementRequest() {
        return this.to('GetAgreementRequest');
    }
    /**
     * Grants permission to users to get a list of terms for an agreement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toGetAgreementTerms() {
        return this.to('GetAgreementTerms');
    }
    /**
     * Grants permission to users to list their incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toListAgreementApprovalRequests() {
        return this.to('ListAgreementApprovalRequests');
    }
    /**
     * Grants permission to users to list their subscription requests for products that require subscription verification
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toListAgreementRequests() {
        return this.to('ListAgreementRequests');
    }
    /**
     * Grants permission to users to decline an incoming subscription requests (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toRejectAgreementApprovalRequest() {
        return this.to('RejectAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to search their agreements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toSearchAgreements() {
        return this.to('SearchAgreements');
    }
    /**
     * Grants permission to users to subscribe to AWS Marketplace products. Includes the ability to send a subscription request for products that require subscription verification. Includes the ability to enable auto-renewal for an existing subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toSubscribe() {
        return this.to('Subscribe');
    }
    /**
     * Grants permission to users to remove subscriptions to AWS Marketplace products. Includes the ability to disable auto-renewal for an existing subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toUnsubscribe() {
        return this.to('Unsubscribe');
    }
    /**
     * Grants permission to users to make changes to an incoming subscription request, including the ability to delete the prospective subscriber's information (for providers who provide products that require subscription verification)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toUpdateAgreementApprovalRequest() {
        return this.to('UpdateAgreementApprovalRequest');
    }
    /**
     * Grants permission to users to see their account's subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-iam-users-groups-policies.htmlControllingAccessToAWSMarketplaceSubscriptions.html#SummaryOfAWSMarketplaceSubscriptionsPermissions
     */
    toViewSubscriptions() {
        return this.to('ViewSubscriptions');
    }
    /**
     * Filters access by the type of the agreement.
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAgreementType(value, operator) {
        return this.if(`AgreementType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the party type of the agreement.
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPartyType(value, operator) {
        return this.if(`PartyType`, value, operator || 'StringLike');
    }
    /**
     * Filters access to AWS Marketplace RedHat OpenShift products in the RedHat console, based on the ProductID of the product. Note: This condition key only applies to the RedHat console, and using it will not allow access to products in AWS Marketplace.
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProductId(value, operator) {
        return this.if(`ProductId`, value, operator || 'StringLike');
    }
}
exports.AwsMarketplace = AwsMarketplace;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplace[_a] = { fqn: "cdk-iam-floyd.AwsMarketplace", version: "0.343.0" };
//# sourceMappingURL=data:application/json;base64,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