import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [route53-recovery-readiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoveryreadiness.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Route53RecoveryReadiness extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a new cell
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells.html
     */
    toCreateCell(): this;
    /**
     * Grants permission to create a cross account authorization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/crossaccountauthorizations.html
     */
    toCreateCrossAccountAuthorization(): this;
    /**
     * Grants permission to create a readiness check
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     */
    toCreateReadinessCheck(): this;
    /**
     * Grants permission to create a recovery group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups.html
     */
    toCreateRecoveryGroup(): this;
    /**
     * Grants permission to create a resource set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets.html
     */
    toCreateResourceSet(): this;
    /**
     * Grants permission to delete a cell
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     */
    toDeleteCell(): this;
    /**
     * Grants permission to delete a cross account authorization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/crossaccountauthorizations-crossaccountauthorization.html
     */
    toDeleteCrossAccountAuthorization(): this;
    /**
     * Grants permission to delete a readiness check
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     */
    toDeleteReadinessCheck(): this;
    /**
     * Grants permission to delete a recovery group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     */
    toDeleteRecoveryGroup(): this;
    /**
     * Grants permission to delete a resource set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     */
    toDeleteResourceSet(): this;
    /**
     * Grants permission to get architecture recommendations for a recovery group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname-architecturerecommendations.html
     */
    toGetArchitectureRecommendations(): this;
    /**
     * Grants permission to get information about a cell
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     */
    toGetCell(): this;
    /**
     * Grants permission to get a readiness summary for a cell
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cellreadiness-cellname.html
     */
    toGetCellReadinessSummary(): this;
    /**
     * Grants permission to get information about a readiness check
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     */
    toGetReadinessCheck(): this;
    /**
     * Grants permission to get the readiness status for an individual resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname-resource-resourceidentifier-status.html
     */
    toGetReadinessCheckResourceStatus(): this;
    /**
     * Grants permission to get the status of a readiness check (for a resource set)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname-status.html
     */
    toGetReadinessCheckStatus(): this;
    /**
     * Grants permission to get information about a recovery group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     */
    toGetRecoveryGroup(): this;
    /**
     * Grants permission to get a readiness summary for a recovery group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroupreadiness-recoverygroupname.html
     */
    toGetRecoveryGroupReadinessSummary(): this;
    /**
     * Grants permission to get information about a resource set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     */
    toGetResourceSet(): this;
    /**
     * Grants permission to list cells
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells.html
     */
    toListCells(): this;
    /**
     * Grants permission to list cross account authorizations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     */
    toListCrossAccountAuthorizations(): this;
    /**
     * Grants permission to list readiness checks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     */
    toListReadinessChecks(): this;
    /**
     * Grants permission to list recovery groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups.html
     */
    toListRecoveryGroups(): this;
    /**
     * Grants permission to list resource sets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets.html
     */
    toListResourceSets(): this;
    /**
     * Grants permission to list readiness rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/rules.html
     */
    toListRules(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     */
    toListTagsForResources(): this;
    /**
     * Grants permission to add a tag to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a cell
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     */
    toUpdateCell(): this;
    /**
     * Grants permission to update a readiness check
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     */
    toUpdateReadinessCheck(): this;
    /**
     * Grants permission to update a recovery group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     */
    toUpdateRecoveryGroup(): this;
    /**
     * Grants permission to update a resource set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     */
    toUpdateResourceSet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type readinesscheck to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.readiness-checks.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReadinesscheck(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type resourceset to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.readiness-checks.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onResourceset(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type cell to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.recovery-groups.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCell(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type recoverygroup to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.recovery-groups.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRecoverygroup(resourceId: string, account?: string, partition?: string): this;
    /**
     * Statement provider for service [route53-recovery-readiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoveryreadiness.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
