# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationGroupArgs', 'ConfigurationGroup']

@pulumi.input_type
class ConfigurationGroupArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 solution: pulumi.Input[str],
                 feature_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 topology_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]]] = None,
                 topology_site_devices: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ConfigurationGroup resource.
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]] feature_profiles: List of feature profiles
        :param pulumi.Input[str] name: The name of the configuration group
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]] topology_devices: List of topology device types
        :param pulumi.Input[int] topology_site_devices: Number of devices per site - Range: `1`-`20`
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "solution", solution)
        if feature_profiles is not None:
            pulumi.set(__self__, "feature_profiles", feature_profiles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if topology_devices is not None:
            pulumi.set(__self__, "topology_devices", topology_devices)
        if topology_site_devices is not None:
            pulumi.set(__self__, "topology_site_devices", topology_site_devices)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def solution(self) -> pulumi.Input[str]:
        """
        Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        return pulumi.get(self, "solution")

    @solution.setter
    def solution(self, value: pulumi.Input[str]):
        pulumi.set(self, "solution", value)

    @property
    @pulumi.getter(name="featureProfiles")
    def feature_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]]]:
        """
        List of feature profiles
        """
        return pulumi.get(self, "feature_profiles")

    @feature_profiles.setter
    def feature_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]]]):
        pulumi.set(self, "feature_profiles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the configuration group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="topologyDevices")
    def topology_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]]]:
        """
        List of topology device types
        """
        return pulumi.get(self, "topology_devices")

    @topology_devices.setter
    def topology_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]]]):
        pulumi.set(self, "topology_devices", value)

    @property
    @pulumi.getter(name="topologySiteDevices")
    def topology_site_devices(self) -> Optional[pulumi.Input[int]]:
        """
        Number of devices per site - Range: `1`-`20`
        """
        return pulumi.get(self, "topology_site_devices")

    @topology_site_devices.setter
    def topology_site_devices(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "topology_site_devices", value)


@pulumi.input_type
class _ConfigurationGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 solution: Optional[pulumi.Input[str]] = None,
                 topology_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]]] = None,
                 topology_site_devices: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ConfigurationGroup resources.
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]] feature_profiles: List of feature profiles
        :param pulumi.Input[str] name: The name of the configuration group
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]] topology_devices: List of topology device types
        :param pulumi.Input[int] topology_site_devices: Number of devices per site - Range: `1`-`20`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profiles is not None:
            pulumi.set(__self__, "feature_profiles", feature_profiles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if solution is not None:
            pulumi.set(__self__, "solution", solution)
        if topology_devices is not None:
            pulumi.set(__self__, "topology_devices", topology_devices)
        if topology_site_devices is not None:
            pulumi.set(__self__, "topology_site_devices", topology_site_devices)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfiles")
    def feature_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]]]:
        """
        List of feature profiles
        """
        return pulumi.get(self, "feature_profiles")

    @feature_profiles.setter
    def feature_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupFeatureProfileArgs']]]]):
        pulumi.set(self, "feature_profiles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the configuration group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def solution(self) -> Optional[pulumi.Input[str]]:
        """
        Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        return pulumi.get(self, "solution")

    @solution.setter
    def solution(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "solution", value)

    @property
    @pulumi.getter(name="topologyDevices")
    def topology_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]]]:
        """
        List of topology device types
        """
        return pulumi.get(self, "topology_devices")

    @topology_devices.setter
    def topology_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationGroupTopologyDeviceArgs']]]]):
        pulumi.set(self, "topology_devices", value)

    @property
    @pulumi.getter(name="topologySiteDevices")
    def topology_site_devices(self) -> Optional[pulumi.Input[int]]:
        """
        Number of devices per site - Range: `1`-`20`
        """
        return pulumi.get(self, "topology_site_devices")

    @topology_site_devices.setter
    def topology_site_devices(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "topology_site_devices", value)


class ConfigurationGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupFeatureProfileArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 solution: Optional[pulumi.Input[str]] = None,
                 topology_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupTopologyDeviceArgs']]]]] = None,
                 topology_site_devices: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource can manage a Configuration Group .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ConfigurationGroup("example",
            name="CG_1",
            description="My config group 1",
            solution="sdwan",
            feature_profiles=[sdwan.ConfigurationGroupFeatureProfileArgs(
                id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/configurationGroup:ConfigurationGroup example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupFeatureProfileArgs']]]] feature_profiles: List of feature profiles
        :param pulumi.Input[str] name: The name of the configuration group
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupTopologyDeviceArgs']]]] topology_devices: List of topology device types
        :param pulumi.Input[int] topology_site_devices: Number of devices per site - Range: `1`-`20`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Configuration Group .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ConfigurationGroup("example",
            name="CG_1",
            description="My config group 1",
            solution="sdwan",
            feature_profiles=[sdwan.ConfigurationGroupFeatureProfileArgs(
                id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/configurationGroup:ConfigurationGroup example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupFeatureProfileArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 solution: Optional[pulumi.Input[str]] = None,
                 topology_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupTopologyDeviceArgs']]]]] = None,
                 topology_site_devices: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationGroupArgs.__new__(ConfigurationGroupArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["feature_profiles"] = feature_profiles
            __props__.__dict__["name"] = name
            if solution is None and not opts.urn:
                raise TypeError("Missing required property 'solution'")
            __props__.__dict__["solution"] = solution
            __props__.__dict__["topology_devices"] = topology_devices
            __props__.__dict__["topology_site_devices"] = topology_site_devices
        super(ConfigurationGroup, __self__).__init__(
            'sdwan:index/configurationGroup:ConfigurationGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupFeatureProfileArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            solution: Optional[pulumi.Input[str]] = None,
            topology_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupTopologyDeviceArgs']]]]] = None,
            topology_site_devices: Optional[pulumi.Input[int]] = None) -> 'ConfigurationGroup':
        """
        Get an existing ConfigurationGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupFeatureProfileArgs']]]] feature_profiles: List of feature profiles
        :param pulumi.Input[str] name: The name of the configuration group
        :param pulumi.Input[str] solution: Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigurationGroupTopologyDeviceArgs']]]] topology_devices: List of topology device types
        :param pulumi.Input[int] topology_site_devices: Number of devices per site - Range: `1`-`20`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationGroupState.__new__(_ConfigurationGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profiles"] = feature_profiles
        __props__.__dict__["name"] = name
        __props__.__dict__["solution"] = solution
        __props__.__dict__["topology_devices"] = topology_devices
        __props__.__dict__["topology_site_devices"] = topology_site_devices
        return ConfigurationGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfiles")
    def feature_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationGroupFeatureProfile']]]:
        """
        List of feature profiles
        """
        return pulumi.get(self, "feature_profiles")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the configuration group
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def solution(self) -> pulumi.Output[str]:
        """
        Type of solution - Choices: `mobility`, `sdwan`, `nfvirtual`
        """
        return pulumi.get(self, "solution")

    @property
    @pulumi.getter(name="topologyDevices")
    def topology_devices(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationGroupTopologyDevice']]]:
        """
        List of topology device types
        """
        return pulumi.get(self, "topology_devices")

    @property
    @pulumi.getter(name="topologySiteDevices")
    def topology_site_devices(self) -> pulumi.Output[Optional[int]]:
        """
        Number of devices per site - Range: `1`-`20`
        """
        return pulumi.get(self, "topology_site_devices")

