# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetCellularControllerFeatureTemplateResult',
    'AwaitableGetCellularControllerFeatureTemplateResult',
    'get_cellular_controller_feature_template',
    'get_cellular_controller_feature_template_output',
]

@pulumi.output_type
class GetCellularControllerFeatureTemplateResult:
    """
    A collection of values returned by getCellularControllerFeatureTemplate.
    """
    def __init__(__self__, cellular_interface_id=None, cellular_interface_id_variable=None, data_profiles=None, description=None, device_types=None, firmware_auto_sim=None, firmware_auto_sim_variable=None, id=None, name=None, primary_sim_slot=None, primary_sim_slot_variable=None, sim_failover_retries=None, sim_failover_retries_variable=None, sim_failover_timeout=None, sim_failover_timeout_variable=None, template_type=None, version=None):
        if cellular_interface_id and not isinstance(cellular_interface_id, str):
            raise TypeError("Expected argument 'cellular_interface_id' to be a str")
        pulumi.set(__self__, "cellular_interface_id", cellular_interface_id)
        if cellular_interface_id_variable and not isinstance(cellular_interface_id_variable, str):
            raise TypeError("Expected argument 'cellular_interface_id_variable' to be a str")
        pulumi.set(__self__, "cellular_interface_id_variable", cellular_interface_id_variable)
        if data_profiles and not isinstance(data_profiles, list):
            raise TypeError("Expected argument 'data_profiles' to be a list")
        pulumi.set(__self__, "data_profiles", data_profiles)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if firmware_auto_sim and not isinstance(firmware_auto_sim, bool):
            raise TypeError("Expected argument 'firmware_auto_sim' to be a bool")
        pulumi.set(__self__, "firmware_auto_sim", firmware_auto_sim)
        if firmware_auto_sim_variable and not isinstance(firmware_auto_sim_variable, str):
            raise TypeError("Expected argument 'firmware_auto_sim_variable' to be a str")
        pulumi.set(__self__, "firmware_auto_sim_variable", firmware_auto_sim_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_sim_slot and not isinstance(primary_sim_slot, int):
            raise TypeError("Expected argument 'primary_sim_slot' to be a int")
        pulumi.set(__self__, "primary_sim_slot", primary_sim_slot)
        if primary_sim_slot_variable and not isinstance(primary_sim_slot_variable, str):
            raise TypeError("Expected argument 'primary_sim_slot_variable' to be a str")
        pulumi.set(__self__, "primary_sim_slot_variable", primary_sim_slot_variable)
        if sim_failover_retries and not isinstance(sim_failover_retries, int):
            raise TypeError("Expected argument 'sim_failover_retries' to be a int")
        pulumi.set(__self__, "sim_failover_retries", sim_failover_retries)
        if sim_failover_retries_variable and not isinstance(sim_failover_retries_variable, str):
            raise TypeError("Expected argument 'sim_failover_retries_variable' to be a str")
        pulumi.set(__self__, "sim_failover_retries_variable", sim_failover_retries_variable)
        if sim_failover_timeout and not isinstance(sim_failover_timeout, int):
            raise TypeError("Expected argument 'sim_failover_timeout' to be a int")
        pulumi.set(__self__, "sim_failover_timeout", sim_failover_timeout)
        if sim_failover_timeout_variable and not isinstance(sim_failover_timeout_variable, str):
            raise TypeError("Expected argument 'sim_failover_timeout_variable' to be a str")
        pulumi.set(__self__, "sim_failover_timeout_variable", sim_failover_timeout_variable)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cellularInterfaceId")
    def cellular_interface_id(self) -> str:
        """
        Cellular interface name
        """
        return pulumi.get(self, "cellular_interface_id")

    @property
    @pulumi.getter(name="cellularInterfaceIdVariable")
    def cellular_interface_id_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "cellular_interface_id_variable")

    @property
    @pulumi.getter(name="dataProfiles")
    def data_profiles(self) -> Sequence['outputs.GetCellularControllerFeatureTemplateDataProfileResult']:
        """
        Data Profile List
        """
        return pulumi.get(self, "data_profiles")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="firmwareAutoSim")
    def firmware_auto_sim(self) -> bool:
        """
        Enable/Disable Firmware Auto Sim
        """
        return pulumi.get(self, "firmware_auto_sim")

    @property
    @pulumi.getter(name="firmwareAutoSimVariable")
    def firmware_auto_sim_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "firmware_auto_sim_variable")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primarySimSlot")
    def primary_sim_slot(self) -> int:
        """
        Set primary SIM slot
        """
        return pulumi.get(self, "primary_sim_slot")

    @property
    @pulumi.getter(name="primarySimSlotVariable")
    def primary_sim_slot_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "primary_sim_slot_variable")

    @property
    @pulumi.getter(name="simFailoverRetries")
    def sim_failover_retries(self) -> int:
        """
        Set SIM failover retries
        """
        return pulumi.get(self, "sim_failover_retries")

    @property
    @pulumi.getter(name="simFailoverRetriesVariable")
    def sim_failover_retries_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_retries_variable")

    @property
    @pulumi.getter(name="simFailoverTimeout")
    def sim_failover_timeout(self) -> int:
        """
        Set SIM failover timeout in minutes
        """
        return pulumi.get(self, "sim_failover_timeout")

    @property
    @pulumi.getter(name="simFailoverTimeoutVariable")
    def sim_failover_timeout_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "sim_failover_timeout_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCellularControllerFeatureTemplateResult(GetCellularControllerFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCellularControllerFeatureTemplateResult(
            cellular_interface_id=self.cellular_interface_id,
            cellular_interface_id_variable=self.cellular_interface_id_variable,
            data_profiles=self.data_profiles,
            description=self.description,
            device_types=self.device_types,
            firmware_auto_sim=self.firmware_auto_sim,
            firmware_auto_sim_variable=self.firmware_auto_sim_variable,
            id=self.id,
            name=self.name,
            primary_sim_slot=self.primary_sim_slot,
            primary_sim_slot_variable=self.primary_sim_slot_variable,
            sim_failover_retries=self.sim_failover_retries,
            sim_failover_retries_variable=self.sim_failover_retries_variable,
            sim_failover_timeout=self.sim_failover_timeout,
            sim_failover_timeout_variable=self.sim_failover_timeout_variable,
            template_type=self.template_type,
            version=self.version)


def get_cellular_controller_feature_template(id: Optional[str] = None,
                                             name: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCellularControllerFeatureTemplateResult:
    """
    This data source can read the Cellular Controller feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cellular_controller_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCellularControllerFeatureTemplate:getCellularControllerFeatureTemplate', __args__, opts=opts, typ=GetCellularControllerFeatureTemplateResult).value

    return AwaitableGetCellularControllerFeatureTemplateResult(
        cellular_interface_id=pulumi.get(__ret__, 'cellular_interface_id'),
        cellular_interface_id_variable=pulumi.get(__ret__, 'cellular_interface_id_variable'),
        data_profiles=pulumi.get(__ret__, 'data_profiles'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        firmware_auto_sim=pulumi.get(__ret__, 'firmware_auto_sim'),
        firmware_auto_sim_variable=pulumi.get(__ret__, 'firmware_auto_sim_variable'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        primary_sim_slot=pulumi.get(__ret__, 'primary_sim_slot'),
        primary_sim_slot_variable=pulumi.get(__ret__, 'primary_sim_slot_variable'),
        sim_failover_retries=pulumi.get(__ret__, 'sim_failover_retries'),
        sim_failover_retries_variable=pulumi.get(__ret__, 'sim_failover_retries_variable'),
        sim_failover_timeout=pulumi.get(__ret__, 'sim_failover_timeout'),
        sim_failover_timeout_variable=pulumi.get(__ret__, 'sim_failover_timeout_variable'),
        template_type=pulumi.get(__ret__, 'template_type'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_cellular_controller_feature_template)
def get_cellular_controller_feature_template_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                                    name: Optional[pulumi.Input[Optional[str]]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCellularControllerFeatureTemplateResult]:
    """
    This data source can read the Cellular Controller feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cellular_controller_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    ...
