# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetDnsSecurityPolicyDefinitionResult',
    'AwaitableGetDnsSecurityPolicyDefinitionResult',
    'get_dns_security_policy_definition',
    'get_dns_security_policy_definition_output',
]

@pulumi.output_type
class GetDnsSecurityPolicyDefinitionResult:
    """
    A collection of values returned by getDnsSecurityPolicyDefinition.
    """
    def __init__(__self__, cisco_sig_credentials_feature_template_id=None, cisco_sig_credentials_feature_template_version=None, custom_dns_server_ip=None, description=None, dnscrypt=None, domain_list_id=None, domain_list_version=None, id=None, local_domain_bypass_enabled=None, match_all_vpn=None, name=None, target_vpns=None, umbrella_dns_default=None, version=None):
        if cisco_sig_credentials_feature_template_id and not isinstance(cisco_sig_credentials_feature_template_id, str):
            raise TypeError("Expected argument 'cisco_sig_credentials_feature_template_id' to be a str")
        pulumi.set(__self__, "cisco_sig_credentials_feature_template_id", cisco_sig_credentials_feature_template_id)
        if cisco_sig_credentials_feature_template_version and not isinstance(cisco_sig_credentials_feature_template_version, int):
            raise TypeError("Expected argument 'cisco_sig_credentials_feature_template_version' to be a int")
        pulumi.set(__self__, "cisco_sig_credentials_feature_template_version", cisco_sig_credentials_feature_template_version)
        if custom_dns_server_ip and not isinstance(custom_dns_server_ip, str):
            raise TypeError("Expected argument 'custom_dns_server_ip' to be a str")
        pulumi.set(__self__, "custom_dns_server_ip", custom_dns_server_ip)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dnscrypt and not isinstance(dnscrypt, bool):
            raise TypeError("Expected argument 'dnscrypt' to be a bool")
        pulumi.set(__self__, "dnscrypt", dnscrypt)
        if domain_list_id and not isinstance(domain_list_id, str):
            raise TypeError("Expected argument 'domain_list_id' to be a str")
        pulumi.set(__self__, "domain_list_id", domain_list_id)
        if domain_list_version and not isinstance(domain_list_version, int):
            raise TypeError("Expected argument 'domain_list_version' to be a int")
        pulumi.set(__self__, "domain_list_version", domain_list_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_domain_bypass_enabled and not isinstance(local_domain_bypass_enabled, bool):
            raise TypeError("Expected argument 'local_domain_bypass_enabled' to be a bool")
        pulumi.set(__self__, "local_domain_bypass_enabled", local_domain_bypass_enabled)
        if match_all_vpn and not isinstance(match_all_vpn, bool):
            raise TypeError("Expected argument 'match_all_vpn' to be a bool")
        pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if target_vpns and not isinstance(target_vpns, list):
            raise TypeError("Expected argument 'target_vpns' to be a list")
        pulumi.set(__self__, "target_vpns", target_vpns)
        if umbrella_dns_default and not isinstance(umbrella_dns_default, bool):
            raise TypeError("Expected argument 'umbrella_dns_default' to be a bool")
        pulumi.set(__self__, "umbrella_dns_default", umbrella_dns_default)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateId")
    def cisco_sig_credentials_feature_template_id(self) -> str:
        """
        Credentials feature template ID
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_id")

    @property
    @pulumi.getter(name="ciscoSigCredentialsFeatureTemplateVersion")
    def cisco_sig_credentials_feature_template_version(self) -> int:
        """
        Credentials feature template version
        """
        return pulumi.get(self, "cisco_sig_credentials_feature_template_version")

    @property
    @pulumi.getter(name="customDnsServerIp")
    def custom_dns_server_ip(self) -> str:
        """
        Only relevant when `umbrella_dns_default` is `false`
        """
        return pulumi.get(self, "custom_dns_server_ip")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the policy definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dnscrypt(self) -> bool:
        """
        Should DNSCrypt be enabled
        """
        return pulumi.get(self, "dnscrypt")

    @property
    @pulumi.getter(name="domainListId")
    def domain_list_id(self) -> str:
        """
        Local domain bypass list ID
        """
        return pulumi.get(self, "domain_list_id")

    @property
    @pulumi.getter(name="domainListVersion")
    def domain_list_version(self) -> int:
        """
        Local domain bypass list version
        """
        return pulumi.get(self, "domain_list_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the object
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> bool:
        """
        Should the local domain bypass list be enabled
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> bool:
        """
        Should use match all VPN
        """
        return pulumi.get(self, "match_all_vpn")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the policy definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Sequence['outputs.GetDnsSecurityPolicyDefinitionTargetVpnResult']:
        """
        Only relevant when `match_all_vpn` is `false`
        """
        return pulumi.get(self, "target_vpns")

    @property
    @pulumi.getter(name="umbrellaDnsDefault")
    def umbrella_dns_default(self) -> bool:
        """
        Should use umbrella as DNS Server
        """
        return pulumi.get(self, "umbrella_dns_default")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the object
        """
        return pulumi.get(self, "version")


class AwaitableGetDnsSecurityPolicyDefinitionResult(GetDnsSecurityPolicyDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsSecurityPolicyDefinitionResult(
            cisco_sig_credentials_feature_template_id=self.cisco_sig_credentials_feature_template_id,
            cisco_sig_credentials_feature_template_version=self.cisco_sig_credentials_feature_template_version,
            custom_dns_server_ip=self.custom_dns_server_ip,
            description=self.description,
            dnscrypt=self.dnscrypt,
            domain_list_id=self.domain_list_id,
            domain_list_version=self.domain_list_version,
            id=self.id,
            local_domain_bypass_enabled=self.local_domain_bypass_enabled,
            match_all_vpn=self.match_all_vpn,
            name=self.name,
            target_vpns=self.target_vpns,
            umbrella_dns_default=self.umbrella_dns_default,
            version=self.version)


def get_dns_security_policy_definition(id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsSecurityPolicyDefinitionResult:
    """
    This data source can read the DNS Security Policy Definition .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_dns_security_policy_definition(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the object
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getDnsSecurityPolicyDefinition:getDnsSecurityPolicyDefinition', __args__, opts=opts, typ=GetDnsSecurityPolicyDefinitionResult).value

    return AwaitableGetDnsSecurityPolicyDefinitionResult(
        cisco_sig_credentials_feature_template_id=pulumi.get(__ret__, 'cisco_sig_credentials_feature_template_id'),
        cisco_sig_credentials_feature_template_version=pulumi.get(__ret__, 'cisco_sig_credentials_feature_template_version'),
        custom_dns_server_ip=pulumi.get(__ret__, 'custom_dns_server_ip'),
        description=pulumi.get(__ret__, 'description'),
        dnscrypt=pulumi.get(__ret__, 'dnscrypt'),
        domain_list_id=pulumi.get(__ret__, 'domain_list_id'),
        domain_list_version=pulumi.get(__ret__, 'domain_list_version'),
        id=pulumi.get(__ret__, 'id'),
        local_domain_bypass_enabled=pulumi.get(__ret__, 'local_domain_bypass_enabled'),
        match_all_vpn=pulumi.get(__ret__, 'match_all_vpn'),
        name=pulumi.get(__ret__, 'name'),
        target_vpns=pulumi.get(__ret__, 'target_vpns'),
        umbrella_dns_default=pulumi.get(__ret__, 'umbrella_dns_default'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_dns_security_policy_definition)
def get_dns_security_policy_definition_output(id: Optional[pulumi.Input[str]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDnsSecurityPolicyDefinitionResult]:
    """
    This data source can read the DNS Security Policy Definition .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_dns_security_policy_definition(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the object
    """
    ...
