# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetSwitchportFeatureTemplateResult',
    'AwaitableGetSwitchportFeatureTemplateResult',
    'get_switchport_feature_template',
    'get_switchport_feature_template_output',
]

@pulumi.output_type
class GetSwitchportFeatureTemplateResult:
    """
    A collection of values returned by getSwitchportFeatureTemplate.
    """
    def __init__(__self__, age_out_time=None, age_out_time_variable=None, description=None, device_types=None, id=None, interfaces=None, module_type=None, name=None, slot=None, static_mac_addresses=None, sub_slot=None, template_type=None, version=None):
        if age_out_time and not isinstance(age_out_time, int):
            raise TypeError("Expected argument 'age_out_time' to be a int")
        pulumi.set(__self__, "age_out_time", age_out_time)
        if age_out_time_variable and not isinstance(age_out_time_variable, str):
            raise TypeError("Expected argument 'age_out_time_variable' to be a str")
        pulumi.set(__self__, "age_out_time_variable", age_out_time_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interfaces and not isinstance(interfaces, list):
            raise TypeError("Expected argument 'interfaces' to be a list")
        pulumi.set(__self__, "interfaces", interfaces)
        if module_type and not isinstance(module_type, str):
            raise TypeError("Expected argument 'module_type' to be a str")
        pulumi.set(__self__, "module_type", module_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if slot and not isinstance(slot, int):
            raise TypeError("Expected argument 'slot' to be a int")
        pulumi.set(__self__, "slot", slot)
        if static_mac_addresses and not isinstance(static_mac_addresses, list):
            raise TypeError("Expected argument 'static_mac_addresses' to be a list")
        pulumi.set(__self__, "static_mac_addresses", static_mac_addresses)
        if sub_slot and not isinstance(sub_slot, int):
            raise TypeError("Expected argument 'sub_slot' to be a int")
        pulumi.set(__self__, "sub_slot", sub_slot)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> int:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise)
        """
        return pulumi.get(self, "age_out_time")

    @property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> str:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetSwitchportFeatureTemplateInterfaceResult']:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter(name="moduleType")
    def module_type(self) -> str:
        """
        Module type
        """
        return pulumi.get(self, "module_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slot(self) -> int:
        """
        Number of Slots
        """
        return pulumi.get(self, "slot")

    @property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> Sequence['outputs.GetSwitchportFeatureTemplateStaticMacAddressResult']:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @property
    @pulumi.getter(name="subSlot")
    def sub_slot(self) -> int:
        """
        Number of Sub-Slots
        """
        return pulumi.get(self, "sub_slot")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetSwitchportFeatureTemplateResult(GetSwitchportFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwitchportFeatureTemplateResult(
            age_out_time=self.age_out_time,
            age_out_time_variable=self.age_out_time_variable,
            description=self.description,
            device_types=self.device_types,
            id=self.id,
            interfaces=self.interfaces,
            module_type=self.module_type,
            name=self.name,
            slot=self.slot,
            static_mac_addresses=self.static_mac_addresses,
            sub_slot=self.sub_slot,
            template_type=self.template_type,
            version=self.version)


def get_switchport_feature_template(id: Optional[str] = None,
                                    name: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwitchportFeatureTemplateResult:
    """
    This data source can read the Switchport feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_switchport_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getSwitchportFeatureTemplate:getSwitchportFeatureTemplate', __args__, opts=opts, typ=GetSwitchportFeatureTemplateResult).value

    return AwaitableGetSwitchportFeatureTemplateResult(
        age_out_time=pulumi.get(__ret__, 'age_out_time'),
        age_out_time_variable=pulumi.get(__ret__, 'age_out_time_variable'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        id=pulumi.get(__ret__, 'id'),
        interfaces=pulumi.get(__ret__, 'interfaces'),
        module_type=pulumi.get(__ret__, 'module_type'),
        name=pulumi.get(__ret__, 'name'),
        slot=pulumi.get(__ret__, 'slot'),
        static_mac_addresses=pulumi.get(__ret__, 'static_mac_addresses'),
        sub_slot=pulumi.get(__ret__, 'sub_slot'),
        template_type=pulumi.get(__ret__, 'template_type'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_switchport_feature_template)
def get_switchport_feature_template_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                           name: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSwitchportFeatureTemplateResult]:
    """
    This data source can read the Switchport feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_switchport_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param str id: The id of the feature template
    :param str name: The name of the feature template
    """
    ...
