/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AnalyzeMappingFunction;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.ProcessRegexMatchInstruction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.ARegexIterator;
import net.sf.saxon.regex.RECompiler;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class AnalyzeStringFn
extends CompileTimeFunction {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression[] args = this.getArguments();
        Configuration config = visitor.getConfiguration();
        boolean schemaAware = visitor.getStaticContext().isSchemaAware();
        if (schemaAware) {
            config.addSchemaForBuiltInNamespace("http://www.w3.org/2005/xpath-functions");
        }
        NamePool namePool = config.getNamePool();
        FixedElement onMatch = this.createInstr(namePool, 3, "fn", "http://www.w3.org/2005/xpath-functions", "match", new ProcessRegexMatchInstruction(namePool));
        FixedElement onNonMatch = this.createInstr(namePool, 3, "fn", "http://www.w3.org/2005/xpath-functions", "non-match", new ContextItemExpression());
        AnalyzeString inst = new AnalyzeString(args[0], args[1], args.length > 2 ? args[2] : new StringLiteral(StringValue.EMPTY_STRING, this.getContainer()), onMatch, onNonMatch, null);
        inst.setUseXsltErrorCodes(false);
        return this.createInstr(namePool, schemaAware ? 1 : 4, "fn", "http://www.w3.org/2005/xpath-functions", "analyze-string-result", inst);
    }

    FixedElement createInstr(NamePool namePool, int validation, String prefix, String uri, String name, Expression content) {
        NamespaceBinding[] nscodes = NamespaceBinding.EMPTY_ARRAY;
        FingerprintedQName instrQN = new FingerprintedQName(prefix, uri, name);
        instrQN.allocateNameCode(namePool);
        FixedElement instr = new FixedElement(instrQN, nscodes, true, true, null, validation);
        instr.setContentExpression(content);
        return instr;
    }

    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        REFlags reFlags;
        CharSequence input = arguments[0].head().getStringValueCS();
        CharSequence pattern = arguments[1].head().getStringValueCS();
        String flags = "";
        if (arguments.length == 3) {
            flags = arguments[2].head().getStringValue();
        }
        try {
            reFlags = new REFlags(flags, "XP30");
        }
        catch (RESyntaxException err) {
            throw new XPathException(err.getMessage(), "FORX0001");
        }
        UnicodeString rawPattern = UnicodeString.makeUnicodeString(pattern);
        RECompiler comp2 = new RECompiler();
        comp2.setFlags(reFlags);
        REProgram regex = comp2.compile(rawPattern);
        ARegexIterator iter = new ARegexIterator(UnicodeString.makeUnicodeString(input), rawPattern, new REMatcher(regex));
        boolean schemaAware = context.getController().getExecutable().isSchemaAware();
        if (schemaAware) {
            context.getConfiguration().addSchemaForBuiltInNamespace("http://www.w3.org/2005/xpath-functions");
        }
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(new FocusTrackingIterator(iter));
        c2.setCurrentRegexIterator(iter);
        NamePool namePool = context.getConfiguration().getNamePool();
        FingerprintedQName resultQN = new FingerprintedQName("fn", "http://www.w3.org/2005/xpath-functions", "analyze-string-result");
        resultQN.allocateNameCode(namePool);
        FixedElement onMatch = this.createInstr(namePool, 3, "fn", "http://www.w3.org/2005/xpath-functions", "match", new ProcessRegexMatchInstruction(namePool));
        FixedElement onNonMatch = this.createInstr(namePool, 3, "fn", "http://www.w3.org/2005/xpath-functions", "non-match", new ContextItemExpression());
        AnalyzeMappingFunction fn = new AnalyzeMappingFunction(iter, c2, onNonMatch, onMatch);
        ContextMappingIterator itr = new ContextMappingIterator(fn, c2);
        GroundedValue extent = SequenceExtent.makeSequenceExtent(itr);
        int validation = schemaAware ? 1 : 4;
        FixedElement result = this.createInstr(namePool, validation, "fn", "http://www.w3.org/2005/xpath-functions", "analyze-string-result", null);
        result.setContentExpression(Literal.makeLiteral(extent, this.getContainer()));
        return (NodeInfo)result.evaluateItem(context);
    }
}

