# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TlsActivationArgs', 'TlsActivation']

@pulumi.input_type
class TlsActivationArgs:
    def __init__(__self__, *,
                 certificate_id: pulumi.Input[str],
                 domain: pulumi.Input[str],
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 mutual_authentication_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TlsActivation resource.
        :param pulumi.Input[str] certificate_id: ID of certificate to use. Must have the `domain` specified in the certificate's Subject Alternative Names.
        :param pulumi.Input[str] domain: Domain to enable TLS on. Must be assigned to an existing Fastly Service.
        :param pulumi.Input[str] configuration_id: ID of TLS configuration to be used to terminate TLS traffic, or use the default one if missing.
        :param pulumi.Input[str] mutual_authentication_id: An alphanumeric string identifying a mutual authentication.
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "domain", domain)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if mutual_authentication_id is not None:
            pulumi.set(__self__, "mutual_authentication_id", mutual_authentication_id)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[str]:
        """
        ID of certificate to use. Must have the `domain` specified in the certificate's Subject Alternative Names.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        Domain to enable TLS on. Must be assigned to an existing Fastly Service.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of TLS configuration to be used to terminate TLS traffic, or use the default one if missing.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="mutualAuthenticationId")
    def mutual_authentication_id(self) -> Optional[pulumi.Input[str]]:
        """
        An alphanumeric string identifying a mutual authentication.
        """
        return pulumi.get(self, "mutual_authentication_id")

    @mutual_authentication_id.setter
    def mutual_authentication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mutual_authentication_id", value)


@pulumi.input_type
class _TlsActivationState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 mutual_authentication_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TlsActivation resources.
        :param pulumi.Input[str] certificate_id: ID of certificate to use. Must have the `domain` specified in the certificate's Subject Alternative Names.
        :param pulumi.Input[str] configuration_id: ID of TLS configuration to be used to terminate TLS traffic, or use the default one if missing.
        :param pulumi.Input[str] created_at: Time-stamp (GMT) when TLS was enabled.
        :param pulumi.Input[str] domain: Domain to enable TLS on. Must be assigned to an existing Fastly Service.
        :param pulumi.Input[str] mutual_authentication_id: An alphanumeric string identifying a mutual authentication.
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if mutual_authentication_id is not None:
            pulumi.set(__self__, "mutual_authentication_id", mutual_authentication_id)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of certificate to use. Must have the `domain` specified in the certificate's Subject Alternative Names.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of TLS configuration to be used to terminate TLS traffic, or use the default one if missing.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time-stamp (GMT) when TLS was enabled.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain to enable TLS on. Must be assigned to an existing Fastly Service.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="mutualAuthenticationId")
    def mutual_authentication_id(self) -> Optional[pulumi.Input[str]]:
        """
        An alphanumeric string identifying a mutual authentication.
        """
        return pulumi.get(self, "mutual_authentication_id")

    @mutual_authentication_id.setter
    def mutual_authentication_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mutual_authentication_id", value)


class TlsActivation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 mutual_authentication_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Enables TLS on a domain using a specified custom TLS certificate.

        > **Note:** The Fastly service must be provisioned _prior_ to enabling TLS on it. This can be achieved in Pulumi using `depends_on`.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_service_vcl = fastly.ServiceVcl("demoServiceVcl",
            domains=[fastly.ServiceVclDomainArgs(
                name="example.com",
            )],
            backends=[fastly.ServiceVclBackendArgs(
                address="127.0.0.1",
                name="localhost",
            )],
            force_destroy=True)
        demo_tls_private_key = fastly.TlsPrivateKey("demoTlsPrivateKey", key_pem="...")
        demo_tls_certificate = fastly.TlsCertificate("demoTlsCertificate", certificate_body="...",
        opts=pulumi.ResourceOptions(depends_on=[demo_tls_private_key]))
        test = fastly.TlsActivation("test",
            certificate_id=demo_tls_certificate.id,
            domain="example.com",
            opts=pulumi.ResourceOptions(depends_on=[demo_service_vcl]))
        ```

        > **Warning:** Updating the `TlsPrivateKey`/`TlsCertificate` resources should be done in multiple plan/apply steps to avoid potential downtime. The new certificate and associated private key must first be created so they exist alongside the currently active resources. Once the new resources have been created, then the `TlsActivation` can be updated to point to the new certificate. Finally, the original key/certificate resources can be deleted.

        ## Import

        A TLS activation can be imported using its ID, e.g.

        ```sh
        $ pulumi import fastly:index/tlsActivation:TlsActivation demo xxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: ID of certificate to use. Must have the `domain` specified in the certificate's Subject Alternative Names.
        :param pulumi.Input[str] configuration_id: ID of TLS configuration to be used to terminate TLS traffic, or use the default one if missing.
        :param pulumi.Input[str] domain: Domain to enable TLS on. Must be assigned to an existing Fastly Service.
        :param pulumi.Input[str] mutual_authentication_id: An alphanumeric string identifying a mutual authentication.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsActivationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enables TLS on a domain using a specified custom TLS certificate.

        > **Note:** The Fastly service must be provisioned _prior_ to enabling TLS on it. This can be achieved in Pulumi using `depends_on`.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_service_vcl = fastly.ServiceVcl("demoServiceVcl",
            domains=[fastly.ServiceVclDomainArgs(
                name="example.com",
            )],
            backends=[fastly.ServiceVclBackendArgs(
                address="127.0.0.1",
                name="localhost",
            )],
            force_destroy=True)
        demo_tls_private_key = fastly.TlsPrivateKey("demoTlsPrivateKey", key_pem="...")
        demo_tls_certificate = fastly.TlsCertificate("demoTlsCertificate", certificate_body="...",
        opts=pulumi.ResourceOptions(depends_on=[demo_tls_private_key]))
        test = fastly.TlsActivation("test",
            certificate_id=demo_tls_certificate.id,
            domain="example.com",
            opts=pulumi.ResourceOptions(depends_on=[demo_service_vcl]))
        ```

        > **Warning:** Updating the `TlsPrivateKey`/`TlsCertificate` resources should be done in multiple plan/apply steps to avoid potential downtime. The new certificate and associated private key must first be created so they exist alongside the currently active resources. Once the new resources have been created, then the `TlsActivation` can be updated to point to the new certificate. Finally, the original key/certificate resources can be deleted.

        ## Import

        A TLS activation can be imported using its ID, e.g.

        ```sh
        $ pulumi import fastly:index/tlsActivation:TlsActivation demo xxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param TlsActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 mutual_authentication_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsActivationArgs.__new__(TlsActivationArgs)

            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["configuration_id"] = configuration_id
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["mutual_authentication_id"] = mutual_authentication_id
            __props__.__dict__["created_at"] = None
        super(TlsActivation, __self__).__init__(
            'fastly:index/tlsActivation:TlsActivation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            configuration_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            mutual_authentication_id: Optional[pulumi.Input[str]] = None) -> 'TlsActivation':
        """
        Get an existing TlsActivation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: ID of certificate to use. Must have the `domain` specified in the certificate's Subject Alternative Names.
        :param pulumi.Input[str] configuration_id: ID of TLS configuration to be used to terminate TLS traffic, or use the default one if missing.
        :param pulumi.Input[str] created_at: Time-stamp (GMT) when TLS was enabled.
        :param pulumi.Input[str] domain: Domain to enable TLS on. Must be assigned to an existing Fastly Service.
        :param pulumi.Input[str] mutual_authentication_id: An alphanumeric string identifying a mutual authentication.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsActivationState.__new__(_TlsActivationState)

        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["domain"] = domain
        __props__.__dict__["mutual_authentication_id"] = mutual_authentication_id
        return TlsActivation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[str]:
        """
        ID of certificate to use. Must have the `domain` specified in the certificate's Subject Alternative Names.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[str]:
        """
        ID of TLS configuration to be used to terminate TLS traffic, or use the default one if missing.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time-stamp (GMT) when TLS was enabled.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Domain to enable TLS on. Must be assigned to an existing Fastly Service.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="mutualAuthenticationId")
    def mutual_authentication_id(self) -> pulumi.Output[Optional[str]]:
        """
        An alphanumeric string identifying a mutual authentication.
        """
        return pulumi.get(self, "mutual_authentication_id")

