import os
import random

from pydub import AudioSegment
from pydub.playback import play
from InquirerPy import inquirer
from InquirerPy.base.control import Choice
from InquirerPy.validator import EmptyInputValidator



def shuffle_play(mix_path):
    FORMATS = [
        Choice(name="MP3", value="mp3"),
        Choice(name="WAV", value="wav"),
        Choice(name="FLAC", value="flac"),
    ]
    audio_format = inquirer.select(
        message="Set audio engine >> ",
        choices=FORMATS,
        default=FORMATS[-1],
        validate=EmptyInputValidator(message="Invalid choice.")
    ).execute()

    mix = [f for f in os.list_dir(mix_path) if f.endswith(f'.{audio_format}')]
    random.shuffle(mix)

    for idx, title in enumerate(mix):
        trackno = idx + 1
        os.system('clear')
        header = 'NOW PLAYING'
        header = f'{"="*len(header)}{header}{"-"*len(header)}'
        print(header)
        print(f"Track {idx}: {title.replace(f'.{audio_format}', '')}")
        
        audio = AudioSegment.from_file(os.path.join(mix_path, title), format=audio_format)
        while True:
            try:
                play(audio)
            except KeyboardInterrupt:
                choices = [
                    Choice(name='Next song', value='next'),
                    Choice(name='Stop mix', value=None),
                ]
                next_opt = inquirer.select(
                    message="Would you like to skip this song or stop playback altogetherd? >> ",
                    choices=choices,
                    default=choices[0]
                ).execute()
                if next_opt is None:
                    return None
                break
        
