# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from vrt_lss_studio.models.time_window import TimeWindow

class AssignedTransport(BaseModel):
    """
    Transport's shift assigned to the specified time (`shift_time`).
    """
    transport_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Transport key, unique identifier.")
    shift_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Transport's shift key.")
    shift_time: Optional[TimeWindow] = Field(...)
    __properties = ["transport_key", "shift_key", "shift_time"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AssignedTransport:
        """Create an instance of AssignedTransport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of shift_time
        if self.shift_time:
            _dict['shift_time'] = self.shift_time.to_dict()
        # set to None if shift_time (nullable) is None
        # and __fields_set__ contains the field
        if self.shift_time is None and "shift_time" in self.__fields_set__:
            _dict['shift_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AssignedTransport:
        """Create an instance of AssignedTransport from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AssignedTransport.parse_obj(obj)

        _obj = AssignedTransport.parse_obj({
            "transport_key": obj.get("transport_key"),
            "shift_key": obj.get("shift_key"),
            "shift_time": TimeWindow.from_dict(obj.get("shift_time")) if obj.get("shift_time") is not None else None
        })
        return _obj

