# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, confloat, conint, conlist, constr

class BoxCompatibilities(BaseModel):
    """
    A transport box [compatibilities](#section/Description/Compatibilities). 
    """
    width: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Width in meters.")
    height: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Height in meters.")
    length: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Length in meters.")
    box_features: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Box features list that determines compatibility with the cargo. ")
    __properties = ["width", "height", "length", "box_features"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BoxCompatibilities:
        """Create an instance of BoxCompatibilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BoxCompatibilities:
        """Create an instance of BoxCompatibilities from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BoxCompatibilities.parse_obj(obj)

        _obj = BoxCompatibilities.parse_obj({
            "width": obj.get("width") if obj.get("width") is not None else 0,
            "height": obj.get("height") if obj.get("height") is not None else 0,
            "length": obj.get("length") if obj.get("length") is not None else 0,
            "box_features": obj.get("box_features")
        })
        return _obj

