# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, confloat, conint, conlist, constr
from vrt_lss_studio.models.cargo_rotation_type import CargoRotationType

class CargoCompatibilities(BaseModel):
    """
    Cargo [compatibilities](#section/Description/Compatibilities). 
    """
    width: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Width in meters, used to check the transport box capacity.")
    height: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Height in meters, used to check the transport box capacity.")
    length: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Length in meters, used to check the transport box capacity.")
    rotation: Optional[conlist(CargoRotationType, max_items=4, min_items=0, unique_items=True)] = Field(None, description="List of possibilities of a object rotations (90 degree step):   * `ALL` - can rotate by any axis   * `YAW` - can yaw   * `PITCH` - can pitch   * `ROLL` - can roll  Empty list means object rotations is prohibited.  More about [cargo placement](#section/Description/Cargo-placement).")
    box_restrictions: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="List of necessary restrictions for a transport's box. ")
    cargo_features: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Cargo's features list. Used to check whether the cargo is compatible with other cargos. ")
    cargo_restrictions: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Requirements list for the cargo. Used to check whether the cargo is compatible with other cargos. ")
    __properties = ["width", "height", "length", "rotation", "box_restrictions", "cargo_features", "cargo_restrictions"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CargoCompatibilities:
        """Create an instance of CargoCompatibilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CargoCompatibilities:
        """Create an instance of CargoCompatibilities from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CargoCompatibilities.parse_obj(obj)

        _obj = CargoCompatibilities.parse_obj({
            "width": obj.get("width") if obj.get("width") is not None else 0,
            "height": obj.get("height") if obj.get("height") is not None else 0,
            "length": obj.get("length") if obj.get("length") is not None else 0,
            "rotation": obj.get("rotation"),
            "box_restrictions": obj.get("box_restrictions"),
            "cargo_features": obj.get("cargo_features"),
            "cargo_restrictions": obj.get("cargo_restrictions")
        })
        return _obj

