# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr

class ExperimentSpecification(BaseModel):
    """
    Experiment description.
    """
    name: constr(strict=True, max_length=100, min_length=1) = Field(..., description="Experiment name.")
    comment: Optional[constr(strict=True, max_length=10000, min_length=0)] = Field(..., description="Experiment comment.")
    folder_key: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Key, unique identifier.")
    __properties = ["name", "comment", "folder_key"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExperimentSpecification:
        """Create an instance of ExperimentSpecification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExperimentSpecification:
        """Create an instance of ExperimentSpecification from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExperimentSpecification.parse_obj(obj)

        _obj = ExperimentSpecification.parse_obj({
            "name": obj.get("name"),
            "comment": obj.get("comment"),
            "folder_key": obj.get("folder_key")
        })
        return _obj

