# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_studio.models.statistics import Statistics
from vrt_lss_studio.models.table_data_stats import TableDataStats
from vrt_lss_studio.models.unplanned_items import UnplannedItems

class ExperimentStatistics(BaseModel):
    """
    Experiment statistics.
    """
    indicators: conlist(constr(strict=True, max_length=256, min_length=2), max_items=100, min_items=0) = Field(..., description="A list of indicators.")
    total_statistics: Statistics = Field(...)
    data_statistics: TableDataStats = Field(...)
    unplanned_items: Optional[UnplannedItems] = None
    __properties = ["indicators", "total_statistics", "data_statistics", "unplanned_items"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExperimentStatistics:
        """Create an instance of ExperimentStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of total_statistics
        if self.total_statistics:
            _dict['total_statistics'] = self.total_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_statistics
        if self.data_statistics:
            _dict['data_statistics'] = self.data_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unplanned_items
        if self.unplanned_items:
            _dict['unplanned_items'] = self.unplanned_items.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExperimentStatistics:
        """Create an instance of ExperimentStatistics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExperimentStatistics.parse_obj(obj)

        _obj = ExperimentStatistics.parse_obj({
            "indicators": obj.get("indicators"),
            "total_statistics": Statistics.from_dict(obj.get("total_statistics")) if obj.get("total_statistics") is not None else None,
            "data_statistics": TableDataStats.from_dict(obj.get("data_statistics")) if obj.get("data_statistics") is not None else None,
            "unplanned_items": UnplannedItems.from_dict(obj.get("unplanned_items")) if obj.get("unplanned_items") is not None else None
        })
        return _obj

