# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_studio.models.folder_stats import FolderStats
from vrt_lss_studio.models.folder_type import FolderType

class Filesystem(BaseModel):
    """
    File system.  Only one object can be of type ROOT. 
    """
    key: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Key, unique identifier.")
    type: FolderType = Field(...)
    name: constr(strict=True, max_length=100, min_length=1) = Field(..., description="Folder name.")
    statistics: FolderStats = Field(...)
    elements: Optional[conlist(Filesystem, max_items=101, min_items=0)] = Field(None, description="A list of child's elements.")
    __properties = ["key", "type", "name", "statistics", "elements"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Filesystem:
        """Create an instance of Filesystem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "elements",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in elements (list)
        _items = []
        if self.elements:
            for _item in self.elements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['elements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Filesystem:
        """Create an instance of Filesystem from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Filesystem.parse_obj(obj)

        _obj = Filesystem.parse_obj({
            "key": obj.get("key"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "statistics": FolderStats.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None,
            "elements": [Filesystem.from_dict(_item) for _item in obj.get("elements")] if obj.get("elements") is not None else None
        })
        return _obj

