# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator

class LinkedEssence(BaseModel):
    """
    Link to essence.
    """
    essence_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(..., description="Key, unique identifier.")
    essence_type: StrictStr = Field(..., description="Essence type.")
    __properties = ["essence_key", "essence_type"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, v):
        if v not in ('LOCATION', 'ORDER', 'PERFORMER', 'TRANSPORT', 'HARDLINK', 'TRIP', 'FACT'):
            raise ValueError("must be one of enum values ('LOCATION', 'ORDER', 'PERFORMER', 'TRANSPORT', 'HARDLINK', 'TRIP', 'FACT')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LinkedEssence:
        """Create an instance of LinkedEssence from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LinkedEssence:
        """Create an instance of LinkedEssence from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return LinkedEssence.parse_obj(obj)

        _obj = LinkedEssence.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type")
        })
        return _obj

