# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.performer_compatibilities import PerformerCompatibilities
from vrt_lss_studio.models.performer_limits import PerformerLimits
from vrt_lss_studio.models.performer_shift import PerformerShift
from vrt_lss_studio.models.transport_type import TransportType

class Performer(BaseModel):
    """
    Performer. Fulfills orders using transport. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Performer's key, unique identifier.")
    shifts: conlist(PerformerShift, max_items=15001, min_items=1, unique_items=True) = Field(..., description="List of working shifts of performer.")
    own_transport_type: Optional[TransportType] = None
    compatibilities: Optional[PerformerCompatibilities] = None
    limits: Optional[PerformerLimits] = None
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "shifts", "own_transport_type", "compatibilities", "limits", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Performer:
        """Create an instance of Performer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in shifts (list)
        _items = []
        if self.shifts:
            for _item in self.shifts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['shifts'] = _items
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of limits
        if self.limits:
            _dict['limits'] = self.limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if compatibilities (nullable) is None
        # and __fields_set__ contains the field
        if self.compatibilities is None and "compatibilities" in self.__fields_set__:
            _dict['compatibilities'] = None

        # set to None if limits (nullable) is None
        # and __fields_set__ contains the field
        if self.limits is None and "limits" in self.__fields_set__:
            _dict['limits'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Performer:
        """Create an instance of Performer from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Performer.parse_obj(obj)

        _obj = Performer.parse_obj({
            "key": obj.get("key"),
            "shifts": [PerformerShift.from_dict(_item) for _item in obj.get("shifts")] if obj.get("shifts") is not None else None,
            "own_transport_type": obj.get("own_transport_type"),
            "compatibilities": PerformerCompatibilities.from_dict(obj.get("compatibilities")) if obj.get("compatibilities") is not None else None,
            "limits": PerformerLimits.from_dict(obj.get("limits")) if obj.get("limits") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

