# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from vrt_lss_studio.models.routing_matrix import RoutingMatrix
from vrt_lss_studio.models.transport_type import TransportType

class RoutingTransportMatrix(BaseModel):
    """
    Time-distance matrix for a specific transport type.
    """
    transport_type: TransportType = Field(...)
    matrix: RoutingMatrix = Field(...)
    __properties = ["transport_type", "matrix"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RoutingTransportMatrix:
        """Create an instance of RoutingTransportMatrix from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of matrix
        if self.matrix:
            _dict['matrix'] = self.matrix.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RoutingTransportMatrix:
        """Create an instance of RoutingTransportMatrix from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RoutingTransportMatrix.parse_obj(obj)

        _obj = RoutingTransportMatrix.parse_obj({
            "transport_type": obj.get("transport_type"),
            "matrix": RoutingMatrix.from_dict(obj.get("matrix")) if obj.get("matrix") is not None else None
        })
        return _obj

