# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictBool, conint

class TableDataStats(BaseModel):
    """
    Data statistics.
    """
    locations: conint(strict=True, le=15001, ge=0) = Field(..., description="Locations count.")
    orders: conint(strict=True, le=15001, ge=0) = Field(..., description="Orders count.")
    performers: conint(strict=True, le=15001, ge=0) = Field(..., description="Performers count.")
    transports: conint(strict=True, le=15001, ge=0) = Field(..., description="Transports count.")
    hardlinks: conint(strict=True, le=15001, ge=0) = Field(..., description="Hardlinks count.")
    trips: conint(strict=True, le=15001, ge=0) = Field(..., description="Trips count.")
    external_routing: StrictBool = Field(..., description="Using external routing.")
    __properties = ["locations", "orders", "performers", "transports", "hardlinks", "trips", "external_routing"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableDataStats:
        """Create an instance of TableDataStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableDataStats:
        """Create an instance of TableDataStats from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableDataStats.parse_obj(obj)

        _obj = TableDataStats.parse_obj({
            "locations": obj.get("locations"),
            "orders": obj.get("orders"),
            "performers": obj.get("performers"),
            "transports": obj.get("transports"),
            "hardlinks": obj.get("hardlinks"),
            "trips": obj.get("trips"),
            "external_routing": obj.get("external_routing")
        })
        return _obj

