# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, constr, validator

class TableHardlinkFields(BaseModel):
    """
    Hardlink and element fields for table.
    """
    essence_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Key, unique identifier.")
    essence_type: Optional[StrictStr] = Field('HARDLINK', description="Essence type.")
    enabled: Optional[StrictBool] = Field(True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    element_type: Optional[StrictStr] = Field('HARDLINK', description="Element type.")
    elements_count: Optional[conint(strict=True, le=15001, ge=0)] = Field(0, description="Elements count.")
    trip_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Key, unique identifier.")
    trip_name: Optional[constr(strict=True, max_length=64, min_length=0)] = Field('', description="Trip name.")
    __properties = ["essence_key", "essence_type", "enabled", "pristine", "element_type", "elements_count", "trip_key", "trip_name"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ('HARDLINK', 'ELEMENT'):
            raise ValueError("must be one of enum values ('HARDLINK', 'ELEMENT')")
        return v

    @validator('element_type')
    def element_type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ('HARDLINK', 'ORDER', 'PERFORMER_SHIFT', 'TRANSPORT_SHIFT'):
            raise ValueError("must be one of enum values ('HARDLINK', 'ORDER', 'PERFORMER_SHIFT', 'TRANSPORT_SHIFT')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableHardlinkFields:
        """Create an instance of TableHardlinkFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "pristine",
                          },
                          exclude_none=True)
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        # set to None if trip_key (nullable) is None
        # and __fields_set__ contains the field
        if self.trip_key is None and "trip_key" in self.__fields_set__:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableHardlinkFields:
        """Create an instance of TableHardlinkFields from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableHardlinkFields.parse_obj(obj)

        _obj = TableHardlinkFields.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'HARDLINK',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "element_type": obj.get("element_type") if obj.get("element_type") is not None else 'HARDLINK',
            "elements_count": obj.get("elements_count") if obj.get("elements_count") is not None else 0,
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else ''
        })
        return _obj

