# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint
from vrt_lss_studio.models.capacity import Capacity

class TransportLoad(BaseModel):
    """
    Transport utilization by load.
    """
    count: conint(strict=True, le=15001, ge=0) = Field(..., description="Number of orders.")
    capacity: Optional[Capacity] = Field(...)
    __properties = ["count", "capacity"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransportLoad:
        """Create an instance of TransportLoad from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of capacity
        if self.capacity:
            _dict['capacity'] = self.capacity.to_dict()
        # set to None if capacity (nullable) is None
        # and __fields_set__ contains the field
        if self.capacity is None and "capacity" in self.__fields_set__:
            _dict['capacity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransportLoad:
        """Create an instance of TransportLoad from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransportLoad.parse_obj(obj)

        _obj = TransportLoad.parse_obj({
            "count": obj.get("count"),
            "capacity": Capacity.from_dict(obj.get("capacity")) if obj.get("capacity") is not None else None
        })
        return _obj

