# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, confloat, conint, conlist
from vrt_lss_studio.models.capacity import Capacity
from vrt_lss_studio.models.transport_tariff_constraint import TransportTariffConstraint

class TransportTariff(BaseModel):
    """
    The tariff determines the cost of transport operation and restrictions on mileage per shift.
    """
    cost_per_shift: Optional[Union[confloat(le=1000000, ge=0.001, strict=True), conint(le=1000000, ge=1, strict=True)]] = Field(0.001, description="Price for using the shift, monetary unit.")
    constraints: Optional[conlist(TransportTariffConstraint, max_items=100, min_items=1)] = Field(None, description="List of components of the tariff.")
    transportation_cost: Optional[Capacity] = None
    max_penalty_cost: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Max sum of penalties for transport using this shift, monetary unit. ")
    __properties = ["cost_per_shift", "constraints", "transportation_cost", "max_penalty_cost"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransportTariff:
        """Create an instance of TransportTariff from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in constraints (list)
        _items = []
        if self.constraints:
            for _item in self.constraints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['constraints'] = _items
        # override the default output from pydantic by calling `to_dict()` of transportation_cost
        if self.transportation_cost:
            _dict['transportation_cost'] = self.transportation_cost.to_dict()
        # set to None if transportation_cost (nullable) is None
        # and __fields_set__ contains the field
        if self.transportation_cost is None and "transportation_cost" in self.__fields_set__:
            _dict['transportation_cost'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransportTariff:
        """Create an instance of TransportTariff from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransportTariff.parse_obj(obj)

        _obj = TransportTariff.parse_obj({
            "cost_per_shift": obj.get("cost_per_shift") if obj.get("cost_per_shift") is not None else 0.001,
            "constraints": [TransportTariffConstraint.from_dict(_item) for _item in obj.get("constraints")] if obj.get("constraints") is not None else None,
            "transportation_cost": Capacity.from_dict(obj.get("transportation_cost")) if obj.get("transportation_cost") is not None else None,
            "max_penalty_cost": obj.get("max_penalty_cost") if obj.get("max_penalty_cost") is not None else 0
        })
        return _obj

