from enum import Enum
from typing import Any, Dict, List, Optional, overload
from uuid import UUID

from .conditions import RuleCondition
from .util._codegen import BaseParameters


class CollectorConfig(BaseParameters):

    class Type(Enum):
        ...

    def validate_condition(self, conditions: List[RuleCondition]): ...

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]

class AcceptanceRate(CollectorConfig):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]

class AnswerCount(CollectorConfig):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]

class AssignmentsAssessment(CollectorConfig):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]

class AssignmentSubmitTime(CollectorConfig):

    class Parameters(BaseParameters.Parameters):

        def __repr__(self): ...

        def __str__(self): ...

        def __eq__(self, other): ...

        def __ne__(self, other): ...

        def __lt__(self, other): ...

        def __le__(self, other): ...

        def __gt__(self, other): ...

        def __ge__(self, other): ...

        def __init__(
            self,*,
            fast_submit_threshold_seconds: Optional[int] = ...,
            history_size: Optional[int] = ...
        ) -> None: ...

        _unexpected: Optional[Dict[str, Any]]
        fast_submit_threshold_seconds: Optional[int]
        history_size: Optional[int]

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        fast_submit_threshold_seconds: Optional[int] = ...,
        history_size: Optional[int] = ...
    ) -> None: ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        parameters: Optional[Parameters] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    uuid: Optional[UUID]
    parameters: Optional[Parameters]

class Captcha(CollectorConfig):

    class Parameters(BaseParameters.Parameters):

        def __repr__(self): ...

        def __str__(self): ...

        def __eq__(self, other): ...

        def __ne__(self, other): ...

        def __lt__(self, other): ...

        def __le__(self, other): ...

        def __gt__(self, other): ...

        def __ge__(self, other): ...

        def __init__(self, *, history_size: Optional[int] = ...) -> None: ...

        _unexpected: Optional[Dict[str, Any]]
        history_size: Optional[int]

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        history_size: Optional[int] = ...
    ) -> None: ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        parameters: Optional[Parameters] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    uuid: Optional[UUID]
    parameters: Optional[Parameters]

class GoldenSet(CollectorConfig):

    class Parameters(BaseParameters.Parameters):

        def __repr__(self): ...

        def __str__(self): ...

        def __eq__(self, other): ...

        def __ne__(self, other): ...

        def __lt__(self, other): ...

        def __le__(self, other): ...

        def __gt__(self, other): ...

        def __ge__(self, other): ...

        def __init__(self, *, history_size: Optional[int] = ...) -> None: ...

        _unexpected: Optional[Dict[str, Any]]
        history_size: Optional[int]

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        history_size: Optional[int] = ...
    ) -> None: ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        parameters: Optional[Parameters] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    uuid: Optional[UUID]
    parameters: Optional[Parameters]

class Income(CollectorConfig):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]

class MajorityVote(CollectorConfig):
    """Majority vote is a quality control method based on coinciding responses from the majority of users who are

    performing the same task. The response chosen by the majority is considered correct, and other responses are
    considered incorrect. Depending on the percentage of correct responses, you can either increase the user's
    skill value, or ban the user from tasks.
    Attributes:
        _compatible_conditions: ClassVar[FrozenSet[RuleConditionKey]]
        parameters: Parameters
    """

    class Parameters(BaseParameters.Parameters):
        """Atributes:

        answer_threshold: The number of users considered the majority (for example, 3 out of 5).
        history_size: The maximum number of the user's recent responses in the project to use for calculating
            the percentage of correct responses.
            If this field is omitted, the calculation is based on all the user's responses in the pool.
        """

        def __repr__(self): ...

        def __str__(self): ...

        def __eq__(self, other): ...

        def __ne__(self, other): ...

        def __lt__(self, other): ...

        def __le__(self, other): ...

        def __gt__(self, other): ...

        def __ge__(self, other): ...

        def __init__(
            self,*,
            answer_threshold: Optional[int] = ...,
            history_size: Optional[int] = ...
        ) -> None: ...

        _unexpected: Optional[Dict[str, Any]]
        answer_threshold: Optional[int]
        history_size: Optional[int]

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        answer_threshold: Optional[int] = ...,
        history_size: Optional[int] = ...
    ) -> None: ...

    @overload
    def __init__(
        self,*,
        uuid: Optional[UUID] = ...,
        parameters: Optional[Parameters] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    uuid: Optional[UUID]
    parameters: Optional[Parameters]

class SkippedInRowAssignments(CollectorConfig):
    """Skipping tasks is considered an indirect indicator of the quality of responses.

    You can block access to a pool or project if a user skips multiple task suites in a row.
    Attributes:
        _compatible_conditions: ClassVar[FrozenSet[RuleConditionKey]]
    """

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]

class Training(CollectorConfig):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]

class UsersAssessment(CollectorConfig):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    @overload
    def __init__(self, *, uuid: Optional[UUID] = ...) -> None: ...

    @overload
    def __init__(
        self,*,
        parameters: Optional[BaseParameters.Parameters] = ...,
        uuid: Optional[UUID] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    parameters: Optional[BaseParameters.Parameters]
    uuid: Optional[UUID]
