from enum import Enum
from typing import Any, Dict, Optional

from .primitives.base import BaseTolokaObject
from .primitives.operators import (
    ComparableConditionMixin,
    CompareOperator,
    IdentityConditionMixin,
    IdentityOperator
)


class RuleConditionKey(Enum):
    ...

class RuleCondition(BaseTolokaObject):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        operator: Optional[Any] = ...,
        value: Optional[Any] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: Optional[Any]
    value: Optional[Any]

class ComparableRuleCondition(RuleCondition, ComparableConditionMixin):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,*,
        value: Optional[Any] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    value: Optional[Any]
    operator: CompareOperator

class IdentityRuleCondition(RuleCondition, IdentityConditionMixin):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: IdentityOperator,*,
        value: Optional[Any] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    value: Optional[Any]
    operator: IdentityOperator

class AcceptedAssignmentsCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class AcceptedAssignmentsRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class AssessmentEvent(IdentityRuleCondition):

    class Type(Enum):
        ...

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: IdentityOperator,
        value: Optional[Type] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: IdentityOperator
    value: Optional[Type]

class AssignmentsAcceptedCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class CorrectAnswersRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class FailRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class FastSubmittedCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class GoldenSetAnswersCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class GoldenSetCorrectAnswersRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class GoldenSetIncorrectAnswersRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class IncomeSumForLast24Hours(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class IncorrectAnswersRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class NextAssignmentAvailable(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[bool] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[bool]

class PendingAssignmentsCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class PoolAccessRevokedReason(IdentityRuleCondition):

    class Type(Enum):
        ...

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: IdentityOperator,
        value: Optional[Type] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: IdentityOperator
    value: Optional[Type]

class RejectedAssignmentsCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class RejectedAssignmentsRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class SkillId(IdentityRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: IdentityOperator,
        value: Optional[str] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: IdentityOperator
    value: Optional[str]

class SkippedInRowCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class StoredResultsCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class SubmittedAssignmentsCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class SuccessRate(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[float]

class TotalAnswersCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class TotalAssignmentsCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]

class TotalSubmittedCount(ComparableRuleCondition):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,
        operator: CompareOperator,
        value: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    operator: CompareOperator
    value: Optional[int]
