from enum import Enum
from typing import Any, Dict, List, Optional

from ..primitives.base import BaseTolokaObject


class FieldType(Enum):
    ...

class FieldSpec(BaseTolokaObject):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]

class BooleanSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        allowed_values: Optional[List[bool]] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    allowed_values: Optional[List[bool]]

class StringSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_length: Optional[int] = ...,
        max_length: Optional[int] = ...,
        allowed_values: Optional[List[str]] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_length: Optional[int]
    max_length: Optional[int]
    allowed_values: Optional[List[str]]

class IntegerSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_value: Optional[int] = ...,
        max_value: Optional[int] = ...,
        allowed_values: Optional[List[int]] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_value: Optional[int]
    max_value: Optional[int]
    allowed_values: Optional[List[int]]

class FloatSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_value: Optional[float] = ...,
        max_value: Optional[float] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_value: Optional[float]
    max_value: Optional[float]

class UrlSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]

class FileSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]

class CoordinatesSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        currentLocation: Optional[bool] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    currentLocation: Optional[bool]

class JsonSpec(FieldSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]

class ArrayBooleanSpec(BooleanSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        allowed_values: Optional[List[bool]] = ...,
        min_size: Optional[int] = ...,
        max_size: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    allowed_values: Optional[List[bool]]
    min_size: Optional[int]
    max_size: Optional[int]

class ArrayStringSpec(StringSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_length: Optional[int] = ...,
        max_length: Optional[int] = ...,
        allowed_values: Optional[List[str]] = ...,
        min_size: Optional[int] = ...,
        max_size: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_length: Optional[int]
    max_length: Optional[int]
    allowed_values: Optional[List[str]]
    min_size: Optional[int]
    max_size: Optional[int]

class ArrayIntegerSpec(IntegerSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_value: Optional[int] = ...,
        max_value: Optional[int] = ...,
        allowed_values: Optional[List[int]] = ...,
        min_size: Optional[int] = ...,
        max_size: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_value: Optional[int]
    max_value: Optional[int]
    allowed_values: Optional[List[int]]
    min_size: Optional[int]
    max_size: Optional[int]

class ArrayFloatSpec(FloatSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_value: Optional[float] = ...,
        max_value: Optional[float] = ...,
        min_size: Optional[int] = ...,
        max_size: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_value: Optional[float]
    max_value: Optional[float]
    min_size: Optional[int]
    max_size: Optional[int]

class ArrayUrlSpec(UrlSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_size: Optional[int] = ...,
        max_size: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_size: Optional[int]
    max_size: Optional[int]

class ArrayFileSpec(FileSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        min_size: Optional[int] = ...,
        max_size: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    min_size: Optional[int]
    max_size: Optional[int]

class ArrayCoordinatesSpec(CoordinatesSpec):

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        required: Optional[bool] = ...,
        hidden: Optional[bool] = ...,
        currentLocation: Optional[bool] = ...,
        min_size: Optional[int] = ...,
        max_size: Optional[int] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    required: Optional[bool]
    hidden: Optional[bool]
    currentLocation: Optional[bool]
    min_size: Optional[int]
    max_size: Optional[int]
