from enum import Enum
from typing import Any, Dict, List, Optional

from .actions import RuleAction
from .collectors import CollectorConfig
from .conditions import RuleCondition
from .primitives.base import BaseTolokaObject
from .task_distribution_function import TaskDistributionFunction


class QualityControl(BaseTolokaObject):

    class TrainingRequirement(BaseTolokaObject):

        def __repr__(self): ...

        def __str__(self): ...

        def __eq__(self, other): ...

        def __ne__(self, other): ...

        def __lt__(self, other): ...

        def __le__(self, other): ...

        def __gt__(self, other): ...

        def __ge__(self, other): ...

        def __init__(
            self,*,
            training_pool_id: Optional[str] = ...,
            training_passing_skill_value: Optional[int] = ...
        ) -> None: ...

        _unexpected: Optional[Dict[str, Any]]
        training_pool_id: Optional[str]
        training_passing_skill_value: Optional[int]

    class CaptchaFrequency(Enum):
        ...

    class CheckpointsConfig(BaseTolokaObject):

        class Settings(BaseTolokaObject):

            def __repr__(self): ...

            def __str__(self): ...

            def __eq__(self, other): ...

            def __ne__(self, other): ...

            def __lt__(self, other): ...

            def __le__(self, other): ...

            def __gt__(self, other): ...

            def __ge__(self, other): ...

            def __init__(
                self,*,
                target_overlap: Optional[int] = ...,
                task_distribution_function: Optional[TaskDistributionFunction] = ...
            ) -> None: ...

            _unexpected: Optional[Dict[str, Any]]
            target_overlap: Optional[int]
            task_distribution_function: Optional[TaskDistributionFunction]

        def __repr__(self): ...

        def __str__(self): ...

        def __eq__(self, other): ...

        def __ne__(self, other): ...

        def __lt__(self, other): ...

        def __le__(self, other): ...

        def __gt__(self, other): ...

        def __ge__(self, other): ...

        def __init__(
            self,*,
            real_settings: Optional[Settings] = ...,
            golden_settings: Optional[Settings] = ...,
            training_settings: Optional[Settings] = ...
        ) -> None: ...

        _unexpected: Optional[Dict[str, Any]]
        real_settings: Optional[Settings]
        golden_settings: Optional[Settings]
        training_settings: Optional[Settings]

    class QualityControlConfig(BaseTolokaObject):

        class RuleConfig(BaseTolokaObject):

            def __repr__(self): ...

            def __str__(self): ...

            def __eq__(self, other): ...

            def __ne__(self, other): ...

            def __lt__(self, other): ...

            def __le__(self, other): ...

            def __gt__(self, other): ...

            def __ge__(self, other): ...

            def __init__(
                self,*,
                action: Optional[RuleAction] = ...,
                conditions: Optional[List[RuleCondition]] = ...
            ) -> None: ...

            _unexpected: Optional[Dict[str, Any]]
            action: Optional[RuleAction]
            conditions: Optional[List[RuleCondition]]

        def __repr__(self): ...

        def __str__(self): ...

        def __eq__(self, other): ...

        def __ne__(self, other): ...

        def __lt__(self, other): ...

        def __le__(self, other): ...

        def __gt__(self, other): ...

        def __ge__(self, other): ...

        def __init__(
            self,*,
            rules: Optional[List[RuleConfig]] = ...,
            collector_config: Optional[CollectorConfig] = ...
        ) -> None: ...

        _unexpected: Optional[Dict[str, Any]]
        rules: Optional[List[RuleConfig]]
        collector_config: Optional[CollectorConfig]

    def add_action(
        self,
        collector: CollectorConfig,
        action: RuleAction,
        conditions: List[RuleCondition]
    ): ...

    def __repr__(self): ...

    def __str__(self): ...

    def __eq__(self, other): ...

    def __ne__(self, other): ...

    def __lt__(self, other): ...

    def __le__(self, other): ...

    def __gt__(self, other): ...

    def __ge__(self, other): ...

    def __init__(
        self,*,
        training_requirement: Optional[TrainingRequirement] = ...,
        captcha_frequency: Optional[CaptchaFrequency] = ...,
        configs: Optional[List[QualityControlConfig]] = ...,
        checkpoints_config: Optional[CheckpointsConfig] = ...
    ) -> None: ...

    _unexpected: Optional[Dict[str, Any]]
    training_requirement: Optional[TrainingRequirement]
    captcha_frequency: Optional[CaptchaFrequency]
    configs: Optional[List[QualityControlConfig]]
    checkpoints_config: Optional[CheckpointsConfig]
